/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring;

import java.util.List;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.monitoring.MetricPublisherSupplierFactory;
import org.apache.phoenix.util.InstanceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricServiceResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricServiceResolver.class);
    private MetricPublisherSupplierFactory metricSupplier = null;

    public MetricPublisherSupplierFactory instantiate(String classString) {
        Preconditions.checkNotNull((Object)classString);
        if (this.metricSupplier == null) {
            try {
                Class<?> clazz = Class.forName(classString);
                List factoryList = InstanceResolver.get(MetricPublisherSupplierFactory.class, null);
                for (MetricPublisherSupplierFactory factory : factoryList) {
                    if (!clazz.isInstance(factory)) continue;
                    this.metricSupplier = factory;
                    LOGGER.info(String.format("Sucessfully loaded class for MetricPublishFactory of type: %s", classString));
                    break;
                }
                if (this.metricSupplier == null) {
                    String msg = String.format("Could not load/instantiate class %s", classString);
                    LOGGER.error(msg);
                }
            }
            catch (ClassNotFoundException e) {
                LOGGER.error(String.format("Could not load/instantiate class %s", classString), (Throwable)e);
            }
        }
        return this.metricSupplier;
    }
}

