/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.monitoring.HTableThreadPoolHistograms;
import org.apache.phoenix.monitoring.HistogramDistribution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTableThreadPoolMetricsManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(HTableThreadPoolMetricsManager.class);
    private static final ConcurrentHashMap<String, HTableThreadPoolHistograms> THREAD_POOL_HISTOGRAMS_MAP = new ConcurrentHashMap();

    private HTableThreadPoolMetricsManager() {
    }

    public static Map<String, List<HistogramDistribution>> getHistogramsForAllThreadPools() {
        HashMap<String, List<HistogramDistribution>> map = new HashMap<String, List<HistogramDistribution>>();
        for (Map.Entry<String, HTableThreadPoolHistograms> entry : THREAD_POOL_HISTOGRAMS_MAP.entrySet()) {
            HTableThreadPoolHistograms hTableThreadPoolHistograms = entry.getValue();
            map.put(entry.getKey(), hTableThreadPoolHistograms.getThreadPoolHistogramsDistribution());
        }
        return map;
    }

    private static HTableThreadPoolHistograms getThreadPoolHistograms(String histogramKey, Supplier<HTableThreadPoolHistograms> supplier) {
        if (supplier == null) {
            return null;
        }
        return THREAD_POOL_HISTOGRAMS_MAP.computeIfAbsent(histogramKey, k -> (HTableThreadPoolHistograms)supplier.get());
    }

    public static void updateActiveThreads(String histogramKey, int activeThreads, Supplier<HTableThreadPoolHistograms> supplier) {
        HTableThreadPoolHistograms hTableThreadPoolHistograms = HTableThreadPoolMetricsManager.getThreadPoolHistograms(histogramKey, supplier);
        if (hTableThreadPoolHistograms != null) {
            hTableThreadPoolHistograms.updateActiveThreads(activeThreads);
        } else {
            HTableThreadPoolMetricsManager.logWarningForNullSupplier(histogramKey);
        }
    }

    public static void updateQueueSize(String histogramKey, int queueSize, Supplier<HTableThreadPoolHistograms> supplier) {
        HTableThreadPoolHistograms hTableThreadPoolHistograms = HTableThreadPoolMetricsManager.getThreadPoolHistograms(histogramKey, supplier);
        if (hTableThreadPoolHistograms != null) {
            hTableThreadPoolHistograms.updateQueuedSize(queueSize);
        } else {
            HTableThreadPoolMetricsManager.logWarningForNullSupplier(histogramKey);
        }
    }

    private static void logWarningForNullSupplier(String threadPoolName) {
        LOGGER.warn("No HTable thread pool histograms created for thread pool {}", (Object)threadPoolName);
    }

    @VisibleForTesting
    public static void clearHTableThreadPoolHistograms() {
        THREAD_POOL_HISTOGRAMS_MAP.clear();
    }
}

