/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring;

import java.util.List;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.phoenix.monitoring.HistogramDistribution;
import org.apache.phoenix.monitoring.UtilizationHistogram;

public class HTableThreadPoolHistograms {
    private final UtilizationHistogram activeThreadsHisto;
    private final UtilizationHistogram queuedSizeHisto;

    public HTableThreadPoolHistograms(long maxThreadPoolSize, long maxQueueSize) {
        this.activeThreadsHisto = new UtilizationHistogram(maxThreadPoolSize, HistogramName.ActiveThreadsCount.name());
        this.queuedSizeHisto = new UtilizationHistogram(maxQueueSize, HistogramName.QueueSize.name());
    }

    public void updateActiveThreads(long activeThreads) {
        this.activeThreadsHisto.addValue(activeThreads);
    }

    public void updateQueuedSize(long queuedSize) {
        this.queuedSizeHisto.addValue(queuedSize);
    }

    public void addServerTag(String value) {
        this.addTag(Tag.servers.name(), value);
    }

    public void addCqsiNameTag(String value) {
        this.addTag(Tag.cqsiName.name(), value);
    }

    public void addTag(String key, String value) {
        this.activeThreadsHisto.addTag(key, value);
        this.queuedSizeHisto.addTag(key, value);
    }

    public List<HistogramDistribution> getThreadPoolHistogramsDistribution() {
        return ImmutableList.of((Object)this.activeThreadsHisto.getPercentileHistogramDistribution(), (Object)this.queuedSizeHisto.getPercentileHistogramDistribution());
    }

    public static enum HistogramName {
        ActiveThreadsCount,
        QueueSize;

    }

    public static enum Tag {
        servers,
        cqsiName;

    }
}

