/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring;

import org.apache.phoenix.monitoring.Metric;
import org.apache.phoenix.monitoring.MetricType;

public interface CombinableMetric
extends Metric {
    public String getPublishString();

    public CombinableMetric combine(CombinableMetric var1);

    public CombinableMetric clone();

    public static class NoOpRequestMetric
    implements CombinableMetric,
    Cloneable {
        public static final NoOpRequestMetric INSTANCE = new NoOpRequestMetric();
        private static final String EMPTY_STRING = "";

        @Override
        public MetricType getMetricType() {
            return MetricType.NO_OP_METRIC;
        }

        @Override
        public long getValue() {
            return 0L;
        }

        @Override
        public void change(long delta) {
        }

        @Override
        public void increment() {
        }

        @Override
        public String getCurrentMetricState() {
            return EMPTY_STRING;
        }

        @Override
        public void reset() {
        }

        @Override
        public void set(long value) {
        }

        @Override
        public String getPublishString() {
            return EMPTY_STRING;
        }

        @Override
        public CombinableMetric combine(CombinableMetric metric) {
            return INSTANCE;
        }

        @Override
        public void decrement() {
        }

        @Override
        public CombinableMetric clone() {
            return INSTANCE;
        }
    }
}

