/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.log;

import java.lang.ref.WeakReference;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.log.ActivityLogInfo;
import org.apache.phoenix.log.LogLevel;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.thirdparty.com.google.common.base.Strings;
import org.apache.phoenix.util.EnvironmentEdgeManager;

public class ConnectionActivityLogger {
    private LogLevel logLevel;
    private boolean isInternalConnection;
    private UUID connectionID;
    private WeakReference<PhoenixConnection> connectionReference;
    List<String> activityList = Stream.of(ActivityLogInfo.values()).map(f -> "").collect(Collectors.toList());
    public static final ConnectionActivityLogger NO_OP_LOGGER = new ConnectionActivityLogger(){

        @Override
        public void log(ActivityLogInfo ActivityLogInfo2, String info) {
        }

        @Override
        public boolean isDebugEnabled() {
            return false;
        }

        @Override
        public boolean isInfoEnabled() {
            return false;
        }

        @Override
        public boolean isLevelEnabled(LogLevel logLevel) {
            return false;
        }

        @Override
        public boolean isInternalConnection() {
            return false;
        }

        @Override
        public PhoenixConnection getConnection() {
            return null;
        }

        @Override
        public String getActivityLog() {
            return "";
        }

        @Override
        public String getConnectionID() {
            return "";
        }
    };

    public ConnectionActivityLogger(PhoenixConnection connection, LogLevel level) {
        this.logLevel = level;
        this.isInternalConnection = connection.isInternalConnection();
        this.connectionID = connection.getUniqueID();
        this.connectionReference = new WeakReference<PhoenixConnection>(connection);
        connection.setActivityLogger(this);
        this.log(ActivityLogInfo.START_TIME, String.valueOf(EnvironmentEdgeManager.currentTimeMillis()));
        PName tenantName = connection.getTenantId();
        if (tenantName != null) {
            this.log(ActivityLogInfo.TENANT_ID, tenantName.getString());
        }
    }

    public ConnectionActivityLogger() {
        this.logLevel = LogLevel.OFF;
    }

    public String getConnectionID() {
        return this.connectionID.toString();
    }

    public boolean isInternalConnection() {
        return this.isInternalConnection;
    }

    public PhoenixConnection getConnection() {
        return (PhoenixConnection)this.connectionReference.get();
    }

    public void log(ActivityLogInfo activity, String info) {
        if (this.logLevel == LogLevel.OFF) {
            return;
        }
        this.activityList.set(activity.ordinal(), info);
    }

    public String getActivityLog() {
        return IntStream.range(0, ActivityLogInfo.values().length).filter(i -> !Strings.isNullOrEmpty((String)this.activityList.get(i)) && this.isLevelEnabled(ActivityLogInfo.values()[i].getLogLevel())).mapToObj(i -> ActivityLogInfo.values()[i].shortName + "=" + this.activityList.get(i)).collect(Collectors.joining(", "));
    }

    public boolean isInfoEnabled() {
        return this.isLevelEnabled(LogLevel.INFO);
    }

    public boolean isDebugEnabled() {
        return this.isLevelEnabled(LogLevel.DEBUG);
    }

    public boolean isLevelEnabled(LogLevel logLevel) {
        return this.logLevel != null && logLevel != LogLevel.OFF ? logLevel.ordinal() <= this.logLevel.ordinal() : false;
    }

    public String getExplainPlanInfo() {
        return this.isLevelEnabled(ActivityLogInfo.EXPLAIN_PLAN.getLogLevel()) ? this.activityList.get(ActivityLogInfo.EXPLAIN_PLAN.ordinal()) : null;
    }
}

