/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.log;

import java.sql.SQLException;
import javax.annotation.concurrent.GuardedBy;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.log.ConnectionLimiter;
import org.apache.phoenix.monitoring.GlobalClientMetrics;
import org.apache.phoenix.monitoring.MetricType;
import org.apache.phoenix.monitoring.connectionqueryservice.ConnectionQueryServicesMetricsManager;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;

public abstract class BaseConnectionLimiter
implements ConnectionLimiter {
    protected int connectionCount = 0;
    protected int internalConnectionCount = 0;
    protected int connectionThrottledCounter = 0;
    protected String profileName;
    protected int maxConnectionsAllowed;
    protected int maxInternalConnectionsAllowed;
    protected boolean shouldThrottleNumConnections;

    protected BaseConnectionLimiter(String profileName, boolean shouldThrottleNumConnections, int maxConnectionsAllowed, int maxInternalConnectionsAllowed) {
        this.profileName = profileName;
        this.shouldThrottleNumConnections = shouldThrottleNumConnections;
        this.maxConnectionsAllowed = maxConnectionsAllowed;
        this.maxInternalConnectionsAllowed = maxInternalConnectionsAllowed;
    }

    @Override
    @GuardedBy(value="ConnectionQueryServicesImpl.connectionCountLock")
    public void acquireConnection(PhoenixConnection connection) throws SQLException {
        Preconditions.checkNotNull((Object)connection.getUniqueID(), (Object)"Got null UUID for Phoenix Connection!");
        if (this.shouldThrottleNumConnections) {
            int allowedConnections;
            int futureConnections = 1 + (connection.isInternalConnection() ? this.internalConnectionCount : this.connectionCount);
            int n = allowedConnections = connection.isInternalConnection() ? this.maxInternalConnectionsAllowed : this.maxConnectionsAllowed;
            if (allowedConnections != 0 && futureConnections > allowedConnections && this.onSweep(connection.isInternalConnection()) == 0) {
                GlobalClientMetrics.GLOBAL_PHOENIX_CONNECTIONS_THROTTLED_COUNTER.increment();
                ++this.connectionThrottledCounter;
                String connectionQueryServiceName = connection.getQueryServices().getConfiguration().get("phoenix.query.services.name");
                ConnectionQueryServicesMetricsManager.updateMetrics(connectionQueryServiceName, MetricType.PHOENIX_CONNECTIONS_THROTTLED_COUNTER, this.connectionThrottledCounter);
                SQLException connectionThrottledException = connection.isInternalConnection() ? new SQLExceptionInfo.Builder(SQLExceptionCode.NEW_INTERNAL_CONNECTION_THROTTLED).build().buildException() : new SQLExceptionInfo.Builder(SQLExceptionCode.NEW_CONNECTION_THROTTLED).build().buildException();
                throw connectionThrottledException;
            }
        }
        if (connection.isInternalConnection()) {
            ++this.internalConnectionCount;
        } else {
            ++this.connectionCount;
        }
    }

    @Override
    @GuardedBy(value="ConnectionQueryServicesImpl.connectionCountLock")
    public void returnConnection(PhoenixConnection connection) {
        if (connection.isInternalConnection() && this.internalConnectionCount > 0) {
            --this.internalConnectionCount;
        } else if (!connection.isInternalConnection() && this.connectionCount > 0) {
            --this.connectionCount;
        }
    }

    @Override
    @GuardedBy(value="ConnectionQueryServicesImpl.connectionCountLock")
    public boolean isLastConnection() {
        return this.connectionCount + this.internalConnectionCount - 1 <= 0;
    }

    @Override
    public boolean isShouldThrottleNumConnections() {
        return this.shouldThrottleNumConnections;
    }

    @Override
    @VisibleForTesting
    @GuardedBy(value="ConnectionQueryServicesImpl.connectionCountLock")
    public int getConnectionCount() {
        return this.connectionCount;
    }

    @Override
    public int onSweep(boolean internal) {
        return 0;
    }

    @Override
    @VisibleForTesting
    @GuardedBy(value="ConnectionQueryServicesImpl.connectionCountLock")
    public int getInternalConnectionCount() {
        return this.internalConnectionCount;
    }

    public int getMaxConnectionsAllowed() {
        return this.maxConnectionsAllowed;
    }

    public int getMaxInternalConnectionsAllowed() {
        return this.maxInternalConnectionsAllowed;
    }
}

