/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.security.User;
import org.apache.hbase.thirdparty.com.google.common.base.Strings;
import org.apache.phoenix.jdbc.AbstractRPCConnectionInfo;
import org.apache.phoenix.jdbc.ConnectionInfo;
import org.apache.phoenix.util.ReadOnlyProps;

public class RPCConnectionInfo
extends AbstractRPCConnectionInfo {
    public static final String BOOTSTRAP_NODES = "hbase.client.bootstrap.servers";
    private static final String RPC_REGISTRY_CLASS_NAME = "org.apache.hadoop.hbase.client.RpcConnectionRegistry";

    protected RPCConnectionInfo(boolean isConnectionless, String principal, String keytab, User user, String haGroup, String bootstrapServers, ConnectionInfo.ConnectionType connectionType) {
        super(isConnectionless, principal, keytab, user, haGroup, connectionType);
        this.bootstrapServers = bootstrapServers;
    }

    @Override
    public ReadOnlyProps asProps() {
        if (this.isConnectionless) {
            return ReadOnlyProps.EMPTY_PROPS;
        }
        Map<String, String> connectionProps = this.getCommonProps();
        connectionProps.put("hbase.client.registry.impl", RPC_REGISTRY_CLASS_NAME);
        if (this.getBoostrapServers() != null) {
            connectionProps.put(BOOTSTRAP_NODES, this.bootstrapServers);
        }
        return connectionProps.isEmpty() ? ReadOnlyProps.EMPTY_PROPS : new ReadOnlyProps(connectionProps.entrySet().iterator());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bootstrapServers == null ? 0 : this.bootstrapServers.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        RPCConnectionInfo other = (RPCConnectionInfo)obj;
        return !(this.bootstrapServers == null ? other.bootstrapServers != null : !this.bootstrapServers.equals(other.bootstrapServers));
    }

    @Override
    public String toUrl() {
        return "jdbc:phoenix+rpc:" + this.toString();
    }

    @Override
    public ConnectionInfo withPrincipal(String principal) {
        return new RPCConnectionInfo(this.isConnectionless, principal, this.keytab, this.user, this.haGroup, this.bootstrapServers, this.connectionType);
    }

    protected static class Builder
    extends AbstractRPCConnectionInfo.Builder {
        public Builder(String url, Configuration config, ReadOnlyProps props, Properties info) throws SQLException {
            super(url, config, props, info);
            if (!ConnectionInfo.HAS_RPC_REGISTRY) {
                throw ConnectionInfo.getMalFormedUrlException("Hbase version does not support Master registry for: " + url);
            }
        }

        @Override
        protected void normalize() throws SQLException {
            if (this.hostsList != null && this.hostsList.isEmpty()) {
                this.hostsList = null;
            }
            if (this.portString != null && this.portString.isEmpty()) {
                this.portString = null;
            }
            boolean noServerListinURL = false;
            if (this.hostsList == null) {
                this.hostsList = this.getBootstrapServerAddr();
                noServerListinURL = true;
                if (this.hostsList == null) {
                    this.normalizeMaster();
                    return;
                }
            } else {
                this.hostsList = this.hostsList.replaceAll("=", ":");
            }
            this.isConnectionless = "none".equals(this.hostsList);
            if (this.portString != null) {
                try {
                    this.port = Integer.parseInt(this.portString);
                    if (this.port < 0) {
                        throw new Exception();
                    }
                }
                catch (Exception e) {
                    throw ConnectionInfo.getMalFormedUrlException(this.url);
                }
            }
            if (this.isConnectionless) {
                if (this.port != null) {
                    throw ConnectionInfo.getMalFormedUrlException(this.url);
                }
                return;
            }
            if (this.port != null && !noServerListinURL) {
                this.hostsList = this.normalizeHostsList(this.hostsList, this.port);
            }
        }

        public String getBootstrapServerAddr() {
            String configuredBootstrapNodes = this.get(RPCConnectionInfo.BOOTSTRAP_NODES);
            if (!Strings.isNullOrEmpty((String)configuredBootstrapNodes)) {
                return configuredBootstrapNodes;
            }
            return null;
        }

        @Override
        protected ConnectionInfo build() {
            return new RPCConnectionInfo(this.isConnectionless, this.principal, this.keytab, this.user, this.haGroup, this.hostsList, this.connectionType);
        }

        public static boolean isRPC(Configuration config, ReadOnlyProps props, Properties info) {
            return config != null && RPCConnectionInfo.RPC_REGISTRY_CLASS_NAME.equals(Builder.get("hbase.client.registry.impl", config, props, info));
        }
    }
}

