/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.io.FileReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.phoenix.jdbc.ClusterRoleRecord;
import org.apache.phoenix.jdbc.PhoenixHAAdmin;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.CommandLine;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.HelpFormatter;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.Option;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.Options;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.PosixParser;
import org.apache.phoenix.util.JacksonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixHAAdminTool
extends Configured
implements Tool {
    public static final int RET_SUCCESS = 0;
    public static final int RET_ARGUMENT_ERROR = 1;
    public static final int RET_SYNC_ERROR = 2;
    public static final int RET_REPAIR_FOUND_INCONSISTENCIES = 3;
    private static final Logger LOG = LoggerFactory.getLogger(PhoenixHAAdminTool.class);
    private static final Option HELP_OPT = new Option("h", "help", false, "Show this help");
    private static final Option FORCEFUL_OPT = new Option("F", "forceful", false, "Forceful writing cluster role records ignoring errors on other clusters");
    private static final Option MANIFEST_OPT = new Option("m", "manifest", true, "Manifest file containing cluster role records");
    private static final Option LIST_OPT = new Option("l", "list", false, "List all HA groups stored on this ZK cluster");
    private static final Option REPAIR_OPT = new Option("r", "repair", false, "Verify all HA groups stored on this ZK cluster and repair if inconsistency found");
    @VisibleForTesting
    static final Options OPTIONS = new Options().addOption(HELP_OPT).addOption(FORCEFUL_OPT).addOption(MANIFEST_OPT).addOption(LIST_OPT).addOption(REPAIR_OPT);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int run(String[] args) throws Exception {
        CommandLine commandLine;
        try {
            commandLine = this.parseOptions(args);
        }
        catch (Exception e) {
            System.err.println("ERROR: Unable to parse command-line arguments " + Arrays.toString(args) + " due to: " + e);
            this.printUsageMessage();
            return 1;
        }
        try {
            if (commandLine.hasOption(HELP_OPT.getOpt())) {
                this.printUsageMessage();
                return 0;
            }
            String zkUrl = PhoenixHAAdmin.getLocalZkUrl(this.getConf());
            if (commandLine.hasOption(LIST_OPT.getOpt())) {
                try (PhoenixHAAdmin admin = new PhoenixHAAdmin(zkUrl, this.getConf(), PhoenixHAAdmin.HighAvailibilityCuratorProvider.INSTANCE);){
                    List<ClusterRoleRecord> records = admin.listAllClusterRoleRecordsOnZookeeper();
                    JacksonUtil.getObjectWriterPretty().writeValue((OutputStream)System.out, records);
                    return 0;
                }
            }
            if (commandLine.hasOption(MANIFEST_OPT.getOpt())) {
                String fileName = commandLine.getOptionValue(MANIFEST_OPT.getOpt());
                List<ClusterRoleRecord> records = this.readRecordsFromFile(fileName);
                boolean forceful = commandLine.hasOption(FORCEFUL_OPT.getOpt());
                try (PhoenixHAAdmin admin = new PhoenixHAAdmin(zkUrl, this.getConf(), PhoenixHAAdmin.HighAvailibilityCuratorProvider.INSTANCE);){
                    Map<String, List<String>> failedHaGroups = admin.syncClusterRoleRecords(records, forceful);
                    if (failedHaGroups.isEmpty()) return 0;
                    System.out.println("Found following HA groups are failing to write the clusters:");
                    failedHaGroups.forEach((k, v) -> System.out.printf("%s -> [%s]\n", k, String.join((CharSequence)",", v)));
                    int n = 2;
                    return n;
                }
            }
            if (!commandLine.hasOption(REPAIR_OPT.getOpt())) return 0;
            try (PhoenixHAAdmin admin = new PhoenixHAAdmin(zkUrl, this.getConf(), PhoenixHAAdmin.HighAvailibilityCuratorProvider.INSTANCE);){
                List<String> inconsistentRecord = admin.verifyAndRepairWithRemoteZnode();
                if (inconsistentRecord.isEmpty()) return 0;
                System.out.println("Found following inconsistent cluster role records: ");
                System.out.print(String.join((CharSequence)",", inconsistentRecord));
                int n = 3;
                return n;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    @VisibleForTesting
    List<ClusterRoleRecord> readRecordsFromFile(String file) throws Exception {
        String fileType;
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)file) ? 1 : 0) != 0);
        switch (fileType = FilenameUtils.getExtension((String)file)) {
            case "json": {
                try (FileReader reader = new FileReader(file);){
                    ClusterRoleRecord[] records = (ClusterRoleRecord[])JacksonUtil.getObjectReader(ClusterRoleRecord[].class).readValue((Reader)reader);
                    List<ClusterRoleRecord> list = Arrays.asList(records);
                    return list;
                }
            }
            case "yaml": {
                LOG.error("YAML file is not yet supported. See W-8274533");
            }
        }
        throw new Exception("Can not read cluster role records from file '" + file + "' reason: unsupported file type");
    }

    @VisibleForTesting
    CommandLine parseOptions(String[] args) throws Exception {
        PosixParser parser = new PosixParser();
        CommandLine cmdLine = parser.parse(OPTIONS, args);
        assert (cmdLine != null);
        if (cmdLine.hasOption(REPAIR_OPT.getOpt()) && cmdLine.hasOption(MANIFEST_OPT.getOpt()) || cmdLine.hasOption(LIST_OPT.getOpt()) && cmdLine.hasOption(REPAIR_OPT.getOpt()) || cmdLine.hasOption(LIST_OPT.getOpt()) && cmdLine.hasOption(MANIFEST_OPT.getOpt())) {
            String msg = "--list, --manifest and --repair options are mutually exclusive";
            LOG.error(msg + " User provided args: {}", (Object[])args);
            throw new IllegalArgumentException(msg);
        }
        if (cmdLine.hasOption(FORCEFUL_OPT.getOpt()) && !cmdLine.hasOption(MANIFEST_OPT.getOpt())) {
            String msg = "--forceful option only works with --manifest option";
            LOG.error(msg + " User provided args: {}", (Object[])args);
            throw new IllegalArgumentException(msg);
        }
        return cmdLine;
    }

    private void printUsageMessage() {
        GenericOptionsParser.printGenericCommandUsage((PrintStream)System.out);
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("help", OPTIONS);
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        int retCode = ToolRunner.run((Configuration)conf, (Tool)new PhoenixHAAdminTool(), (String[])args);
        System.exit(retCode);
    }
}

