/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.recipes.atomic.AtomicValue;
import org.apache.curator.framework.recipes.atomic.DistributedAtomicValue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.util.PairOfSameType;
import org.apache.phoenix.jdbc.ClusterRoleRecord;
import org.apache.phoenix.jdbc.HighAvailabilityGroup;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.util.JDBCUtil;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixHAAdmin
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(PhoenixHAAdmin.class);
    private final String zkUrl;
    private final Configuration conf;
    private final Properties properties = new Properties();
    private final HighAvailibilityCuratorProvider highAvailibilityCuratorProvider;

    public PhoenixHAAdmin(Configuration conf) {
        this(PhoenixHAAdmin.getLocalZkUrl(conf), conf, HighAvailibilityCuratorProvider.INSTANCE);
    }

    public PhoenixHAAdmin(String zkUrl, Configuration conf) {
        this(zkUrl, conf, HighAvailibilityCuratorProvider.INSTANCE);
    }

    public PhoenixHAAdmin(String zkUrl, Configuration conf, HighAvailibilityCuratorProvider highAvailibilityCuratorProvider) {
        Preconditions.checkNotNull((Object)zkUrl);
        Preconditions.checkNotNull((Object)conf);
        Preconditions.checkNotNull((Object)highAvailibilityCuratorProvider);
        this.zkUrl = JDBCUtil.formatUrl(zkUrl);
        this.conf = conf;
        conf.iterator().forEachRemaining(k -> this.properties.setProperty((String)k.getKey(), (String)k.getValue()));
        this.highAvailibilityCuratorProvider = highAvailibilityCuratorProvider;
    }

    public static String getLocalZkUrl(Configuration conf) {
        String localZkQuorum = conf.get("hbase.zookeeper.quorum");
        if (StringUtils.isEmpty((CharSequence)localZkQuorum)) {
            String msg = "ZK quorum not found by looking up key hbase.zookeeper.quorum";
            LOG.error(msg);
            throw new IllegalArgumentException(msg);
        }
        String portStr = conf.get("hbase.zookeeper.property.clientPort");
        int port = 2181;
        if (portStr != null) {
            try {
                port = Integer.parseInt(portStr);
            }
            catch (NumberFormatException e) {
                String msg = String.format("Unrecognized ZK port '%s' in ZK quorum '%s'", portStr, localZkQuorum);
                LOG.error(msg, (Throwable)e);
                throw new IllegalArgumentException(msg, e);
            }
        }
        String localZkRoot = conf.get("zookeeper.znode.parent", "/hbase");
        return String.format("%s:%d:%s", localZkQuorum, port, localZkRoot);
    }

    public CuratorFramework getCurator() throws IOException {
        return this.highAvailibilityCuratorProvider.getCurator(this.zkUrl, this.properties);
    }

    boolean isCurrentActiveCluster(String haGroupName) {
        try {
            byte[] data = (byte[])this.getCurator().getData().forPath(PhoenixHAAdmin.toPath(haGroupName));
            Optional<ClusterRoleRecord> record = ClusterRoleRecord.fromJson(data);
            return record.isPresent() && record.get().getRole(this.zkUrl) == ClusterRoleRecord.ClusterRole.ACTIVE;
        }
        catch (KeeperException.NoNodeException ne) {
            LOG.info("No role record found for HA group {} on '{}', assuming it is not active", (Object)haGroupName, (Object)this.zkUrl);
            return false;
        }
        catch (Exception e) {
            LOG.warn("Got exception when reading record for {} on cluster {}", new Object[]{haGroupName, this.zkUrl, e});
            return false;
        }
    }

    public List<ClusterRoleRecord> listAllClusterRoleRecordsOnZookeeper() throws IOException {
        List haGroupNames;
        try {
            haGroupNames = (List)this.getCurator().getChildren().forPath("/");
        }
        catch (Exception e) {
            String msg = String.format("Got exception when listing all HA groups in %s", this.zkUrl);
            LOG.error(msg);
            throw new IOException(msg, e);
        }
        ArrayList<ClusterRoleRecord> records = new ArrayList<ClusterRoleRecord>();
        ArrayList<String> failedHaGroups = new ArrayList<String>();
        for (String haGroupName : haGroupNames) {
            try {
                byte[] data = (byte[])this.getCurator().getData().forPath("/" + haGroupName);
                Optional<ClusterRoleRecord> record = ClusterRoleRecord.fromJson(data);
                if (record.isPresent()) {
                    records.add(record.get());
                    continue;
                }
                failedHaGroups.add(haGroupName);
            }
            catch (Exception e) {
                LOG.warn("Got exception when reading data for HA group {}", (Object)haGroupName, (Object)e);
                failedHaGroups.add(haGroupName);
            }
        }
        if (!failedHaGroups.isEmpty()) {
            String msg = String.format("Found following HA groups: %s. Fail to read cluster role records for following HA groups: %s", String.join((CharSequence)",", haGroupNames), String.join((CharSequence)",", failedHaGroups));
            LOG.error(msg);
            throw new IOException(msg);
        }
        return records;
    }

    /*
     * Loose catch block
     */
    public Map<String, List<String>> syncClusterRoleRecords(List<ClusterRoleRecord> records, boolean forceful) throws IOException {
        HashMap<String, List<String>> failedHaGroups = new HashMap<String, List<String>>();
        for (ClusterRoleRecord record : records) {
            PairOfSameType pair;
            PhoenixHAAdmin admin2;
            PhoenixHAAdmin admin1;
            String haGroupName;
            block17: {
                haGroupName = record.getHaGroupName();
                admin1 = new PhoenixHAAdmin(record.getUrl1(), this.conf, HighAvailibilityCuratorProvider.INSTANCE);
                admin2 = new PhoenixHAAdmin(record.getUrl2(), this.conf, HighAvailibilityCuratorProvider.INSTANCE);
                pair = admin1.isCurrentActiveCluster(haGroupName) ? new PairOfSameType((Object)admin1, (Object)admin2) : (admin2.isCurrentActiveCluster(haGroupName) ? new PairOfSameType((Object)admin2, (Object)admin1) : (record.getRole(admin1.getZkUrl()) == ClusterRoleRecord.ClusterRole.STANDBY ? new PairOfSameType((Object)admin1, (Object)admin2) : new PairOfSameType((Object)admin2, (Object)admin1)));
                try {
                    ((PhoenixHAAdmin)pair.getFirst()).createOrUpdateDataOnZookeeper(record);
                }
                catch (IOException e) {
                    LOG.error("Error to create or update data on Zookeeper, cluster={}, record={}", pair.getFirst(), (Object)record);
                    failedHaGroups.computeIfAbsent(haGroupName, k -> new ArrayList()).add(((PhoenixHAAdmin)pair.getFirst()).getZkUrl());
                    if (forceful) break block17;
                    LOG.error("-forceful option is not enabled by command line options, skip writing record {} to ZK clusters", (Object)record);
                    failedHaGroups.computeIfAbsent(haGroupName, k -> new ArrayList()).add(((PhoenixHAAdmin)pair.getSecond()).getZkUrl());
                    admin2.close();
                    admin1.close();
                    continue;
                }
            }
            try {
                try {
                    ((PhoenixHAAdmin)pair.getSecond()).createOrUpdateDataOnZookeeper(record);
                }
                catch (IOException e) {
                    LOG.error("Error to create or update data on Zookeeper, cluster={}, record={}", pair.getFirst(), (Object)record);
                    failedHaGroups.computeIfAbsent(haGroupName, k -> new ArrayList()).add(((PhoenixHAAdmin)pair.getSecond()).getZkUrl());
                }
                continue;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                finally {
                    admin2.close();
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                admin1.close();
            }
        }
        return failedHaGroups;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    List<String> verifyAndRepairWithRemoteZnode() throws Exception {
        ArrayList<String> inconsistentHaGroups = new ArrayList<String>();
        Iterator<ClusterRoleRecord> iterator = this.listAllClusterRoleRecordsOnZookeeper().iterator();
        while (iterator.hasNext()) {
            ClusterRoleRecord remoteRecord;
            Optional<ClusterRoleRecord> recordOptional;
            ClusterRoleRecord record = iterator.next();
            if (record.getRole(this.zkUrl) == ClusterRoleRecord.ClusterRole.UNKNOWN) {
                LOG.warn("Unknown cluster role for cluster '{}' in record {}", (Object)this.zkUrl, (Object)record);
                continue;
            }
            String remoteZkUrl = record.getUrl1().equals(this.zkUrl) ? record.getUrl2() : record.getUrl1();
            PhoenixHAAdmin remoteAdmin = new PhoenixHAAdmin(remoteZkUrl, this.conf, HighAvailibilityCuratorProvider.INSTANCE);
            try {
                String zPath = PhoenixHAAdmin.toPath(record.getHaGroupName());
                byte[] data = (byte[])remoteAdmin.getCurator().getData().forPath(zPath);
                recordOptional = ClusterRoleRecord.fromJson(data);
                if (!recordOptional.isPresent()) {
                    remoteAdmin.createOrUpdateDataOnZookeeper(record);
                    remoteAdmin.close();
                    continue;
                }
            }
            catch (KeeperException.NoNodeException ne) {
                LOG.warn("No record znode yet, creating for HA group {} on {}", (Object)record.getHaGroupName(), (Object)remoteAdmin);
                remoteAdmin.createDataOnZookeeper(record);
                LOG.info("Created znode on cluster {} with record {}", (Object)remoteAdmin, (Object)record);
                remoteAdmin.close();
                continue;
            }
            catch (Exception e) {
                try {
                    LOG.error("Error to get data on remote cluster {} for HA group {}", new Object[]{remoteAdmin, record.getHaGroupName(), e});
                    continue;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    remoteAdmin.close();
                    continue;
                }
            }
            {
                remoteRecord = recordOptional.get();
            }
            {
                if (!record.getHaGroupName().equals(remoteRecord.getHaGroupName())) {
                    inconsistentHaGroups.add(record.getHaGroupName());
                    LOG.error("INTERNAL ERROR: got cluster role record for different HA groups. Local record: {}, remote record: {}", (Object)record, (Object)remoteRecord);
                } else if (remoteRecord.isNewerThan(record)) {
                    this.createOrUpdateDataOnZookeeper(remoteRecord);
                } else if (record.isNewerThan(remoteRecord)) {
                    remoteAdmin.createOrUpdateDataOnZookeeper(record);
                } else if (record.equals(remoteRecord)) {
                    LOG.info("Cluster role record {} is consistent", (Object)record);
                } else {
                    inconsistentHaGroups.add(record.getHaGroupName());
                    LOG.error("Cluster role record for HA group {} is inconsistent. On cluster {} the record is {}; on cluster {} the record is {}", new Object[]{record.getHaGroupName(), this, record, remoteAdmin, remoteRecord});
                }
                remoteAdmin.close();
            }
        }
        return inconsistentHaGroups;
    }

    public boolean createOrUpdateDataOnZookeeper(ClusterRoleRecord record) throws IOException {
        byte[] data;
        String haGroupName = record.getHaGroupName();
        try {
            data = (byte[])this.getCurator().getData().forPath(PhoenixHAAdmin.toPath(haGroupName));
        }
        catch (KeeperException.NoNodeException ne) {
            LOG.info("No record znode yet, creating for HA group {} on {}", (Object)haGroupName, (Object)this.zkUrl);
            this.createDataOnZookeeper(record);
            LOG.info("Created znode for HA group {} with record data {} on {}", new Object[]{haGroupName, record, this.zkUrl});
            return true;
        }
        catch (Exception e) {
            String msg = String.format("Fail to read cluster role record data for HA group %s on cluster '%s'", haGroupName, this.zkUrl);
            LOG.error(msg, (Throwable)e);
            throw new IOException(msg, e);
        }
        Optional<ClusterRoleRecord> existingRecordOptional = ClusterRoleRecord.fromJson(data);
        if (!existingRecordOptional.isPresent()) {
            String msg = String.format("Fail to parse existing cluster role record data for HA group %s", haGroupName);
            LOG.error(msg);
            throw new IOException(msg);
        }
        ClusterRoleRecord existingRecord = existingRecordOptional.get();
        if (record.getVersion() < existingRecord.getVersion()) {
            String msg = String.format("Invalid new cluster role record for HA group '%s' because new record's version V%d is smaller than existing V%d. Existing role record: %s. New role record fail to save: %s", haGroupName, record.getVersion(), existingRecord.getVersion(), existingRecord, record);
            LOG.warn(msg);
            return false;
        }
        if (record.getVersion() == existingRecord.getVersion()) {
            if (record.equals(existingRecord)) {
                LOG.debug("Cluster role does not change since last update on ZK.");
                return false;
            }
            String msg = String.format("Invalid new cluster role record for HA group '%s' because it has the same version V%d but inconsistent data. Existing role record: %s. New role record fail to save: %s", haGroupName, record.getVersion(), existingRecord, record);
            LOG.error(msg);
            throw new IOException(msg);
        }
        return this.updateDataOnZookeeper(existingRecord, record);
    }

    private void createDataOnZookeeper(ClusterRoleRecord record) throws IOException {
        String haGroupName = record.getHaGroupName();
        String haGroupPath = PhoenixHAAdmin.toPath(haGroupName);
        try {
            ((ACLBackgroundPathAndBytesable)this.getCurator().create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).forPath(haGroupPath, ClusterRoleRecord.toJson(record));
        }
        catch (KeeperException.NodeExistsException nee) {
            LOG.warn("Znode for HA group {} already exists. ", (Object)haGroupPath, (Object)nee);
        }
        catch (Exception e) {
            LOG.error("Fail to initialize the znode for HA group {} with record data {}", new Object[]{haGroupPath, record, e});
            throw new IOException("Fail to initialize znode for HA group " + haGroupPath, e);
        }
    }

    private boolean updateDataOnZookeeper(ClusterRoleRecord oldRecord, ClusterRoleRecord newRecord) throws IOException {
        String haGroupPath = PhoenixHAAdmin.toPath(newRecord.getHaGroupName());
        RetryPolicy retryPolicy = HighAvailabilityGroup.createRetryPolicy(this.properties);
        try {
            DistributedAtomicValue v = new DistributedAtomicValue(this.getCurator(), haGroupPath, retryPolicy);
            AtomicValue result = v.compareAndSet(ClusterRoleRecord.toJson(oldRecord), ClusterRoleRecord.toJson(newRecord));
            LOG.info("Updated cluster role record ({}->{}) for HA group {} on cluster '{}': {}", new Object[]{oldRecord.getVersion(), newRecord.getVersion(), newRecord.getHaGroupName(), this.zkUrl, result.succeeded() ? "succeeded" : "failed"});
            LOG.debug("Old DistributedAtomicValue: {}, New DistributedAtomicValue: {},", (Object)new String((byte[])result.preValue(), StandardCharsets.UTF_8), (Object)new String((byte[])result.postValue(), StandardCharsets.UTF_8));
            return result.succeeded();
        }
        catch (Exception e) {
            String msg = String.format("Fail to update cluster role record to ZK for the HA group %s due to '%s'.Existing role record: %s. New role record fail to save: %s", haGroupPath, e.getMessage(), oldRecord, newRecord);
            LOG.error(msg, (Throwable)e);
            throw new IOException(msg, e);
        }
    }

    public static String toPath(String haGroupName) {
        return "/" + haGroupName;
    }

    public String getZkUrl() {
        return this.zkUrl;
    }

    @Override
    public void close() {
        LOG.debug("PhoenixHAAdmin for {} is now closed.", (Object)this.zkUrl);
    }

    public String toString() {
        return this.zkUrl;
    }

    public static class HighAvailibilityCuratorProvider {
        public static final HighAvailibilityCuratorProvider INSTANCE = new HighAvailibilityCuratorProvider();

        public CuratorFramework getCurator(String zkUrl, Properties properties) throws IOException {
            return HighAvailabilityGroup.getCurator(zkUrl, properties);
        }
    }
}

