/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.io.EOFException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.text.Format;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.htrace.Sampler;
import org.apache.htrace.TraceScope;
import org.apache.phoenix.call.CallRunner;
import org.apache.phoenix.coprocessorclient.MetaDataProtocol;
import org.apache.phoenix.exception.FailoverSQLException;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.expression.function.FunctionArgumentType;
import org.apache.phoenix.hbase.index.util.KeyValueBuilder;
import org.apache.phoenix.iterate.DefaultTableResultIteratorFactory;
import org.apache.phoenix.iterate.ParallelIteratorFactory;
import org.apache.phoenix.iterate.TableResultIterator;
import org.apache.phoenix.iterate.TableResultIteratorFactory;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.jdbc.PhoenixMonitoredConnection;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.jdbc.PhoenixStatementFactory;
import org.apache.phoenix.log.ActivityLogInfo;
import org.apache.phoenix.log.ConnectionActivityLogger;
import org.apache.phoenix.log.LogLevel;
import org.apache.phoenix.monitoring.GlobalClientMetrics;
import org.apache.phoenix.monitoring.MetricType;
import org.apache.phoenix.monitoring.TableMetricsManager;
import org.apache.phoenix.monitoring.connectionqueryservice.ConnectionQueryServicesMetricsManager;
import org.apache.phoenix.parse.PFunction;
import org.apache.phoenix.parse.PSchema;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.DelegateConnectionQueryServices;
import org.apache.phoenix.query.MetaDataMutated;
import org.apache.phoenix.query.PropertyPolicyProvider;
import org.apache.phoenix.query.QueryServicesOptions;
import org.apache.phoenix.schema.ConnectionProperty;
import org.apache.phoenix.schema.FunctionNotFoundException;
import org.apache.phoenix.schema.MetaDataClient;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PMetaData;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.PTableRef;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.SchemaNotFoundException;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.schema.types.PArrayDataType;
import org.apache.phoenix.schema.types.PBinary;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PTime;
import org.apache.phoenix.schema.types.PTimestamp;
import org.apache.phoenix.schema.types.PUnsignedDate;
import org.apache.phoenix.schema.types.PUnsignedTime;
import org.apache.phoenix.schema.types.PUnsignedTimestamp;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.thirdparty.com.google.common.base.Objects;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.thirdparty.com.google.common.base.Strings;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.phoenix.trace.util.Tracing;
import org.apache.phoenix.transaction.PhoenixTransactionContext;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.DateUtil;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.JDBCUtil;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SQLCloseable;
import org.apache.phoenix.util.SQLCloseables;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.VarBinaryFormatter;

public class PhoenixConnection
implements MetaDataMutated,
SQLCloseable,
PhoenixMonitoredConnection {
    private final String url;
    private String schema;
    private final ConnectionQueryServices services;
    private final Properties info;
    private final Map<PDataType<?>, Format> formatters = new HashMap();
    private final int mutateBatchSize;
    private final long mutateBatchSizeBytes;
    private final Long scn;
    private final boolean buildingIndex;
    private MutationState mutationState;
    private HashSet<PhoenixStatement> statements = new HashSet();
    private boolean isAutoFlush = false;
    private boolean isAutoCommit = false;
    private final PName tenantId;
    private final String dateFormatTimeZoneId;
    private final String datePattern;
    private final String timePattern;
    private final String timestampPattern;
    private int statementExecutionCounter;
    private TraceScope traceScope = null;
    private volatile boolean isClosed = false;
    private volatile boolean isClosing = false;
    private Sampler<?> sampler;
    private boolean readOnly = false;
    private Consistency consistency = Consistency.STRONG;
    private Map<String, String> customTracingAnnotations = Collections.emptyMap();
    private final boolean isRequestLevelMetricsEnabled;
    private final boolean isDescVarLengthRowKeyUpgrade;
    private ParallelIteratorFactory parallelIteratorFactory;
    private final LinkedBlockingQueue<WeakReference<TableResultIterator>> scannerQueue;
    private TableResultIteratorFactory tableResultIteratorFactory;
    private boolean isRunningUpgrade;
    private LogLevel logLevel;
    private LogLevel auditLogLevel;
    private Double logSamplingRate;
    private String sourceOfOperation;
    private volatile SQLException reasonForClose;
    private static final String[] CONNECTION_PROPERTIES;
    private final ConcurrentLinkedQueue<PhoenixConnection> childConnections = new ConcurrentLinkedQueue();
    private final boolean isInternalConnection;
    private boolean isApplyTimeZoneDisplacement;
    private final UUID uniqueID;
    private ConnectionActivityLogger connectionActivityLogger = ConnectionActivityLogger.NO_OP_LOGGER;

    private static Properties newPropsWithSCN(long scn, Properties props) {
        props = new Properties(props);
        props.setProperty("CurrentSCN", Long.toString(scn));
        return props;
    }

    public PhoenixConnection(PhoenixConnection connection, boolean isDescRowKeyOrderUpgrade, boolean isRunningUpgrade) throws SQLException {
        this(connection.getQueryServices(), connection.getURL(), connection.getClientInfo(), connection.getMutationState(), isDescRowKeyOrderUpgrade, isRunningUpgrade, connection.buildingIndex, true);
        this.isAutoCommit = connection.isAutoCommit;
        this.isAutoFlush = connection.isAutoFlush;
        this.sampler = connection.sampler;
        this.statementExecutionCounter = connection.statementExecutionCounter;
    }

    public PhoenixConnection(PhoenixConnection connection) throws SQLException {
        this(connection, connection.isDescVarLengthRowKeyUpgrade(), connection.isRunningUpgrade());
    }

    public PhoenixConnection(PhoenixConnection connection, MutationState mutationState) throws SQLException {
        this(connection.getQueryServices(), connection.getURL(), connection.getClientInfo(), mutationState, connection.isDescVarLengthRowKeyUpgrade(), connection.isRunningUpgrade(), connection.buildingIndex, true);
    }

    public PhoenixConnection(PhoenixConnection connection, long scn) throws SQLException {
        this(connection, PhoenixConnection.newPropsWithSCN(scn, connection.getClientInfo()));
    }

    public PhoenixConnection(PhoenixConnection connection, Properties props) throws SQLException {
        this(connection.getQueryServices(), connection.getURL(), props, connection.getMutationState(), connection.isDescVarLengthRowKeyUpgrade(), connection.isRunningUpgrade(), connection.buildingIndex, true);
        this.isAutoCommit = connection.isAutoCommit;
        this.isAutoFlush = connection.isAutoFlush;
        this.sampler = connection.sampler;
        this.statementExecutionCounter = connection.statementExecutionCounter;
    }

    public PhoenixConnection(ConnectionQueryServices services, String url, Properties info) throws SQLException {
        this(services, url, info, null, false, false, false, false);
    }

    public PhoenixConnection(PhoenixConnection connection, ConnectionQueryServices services, Properties info) throws SQLException {
        this(services, connection.url, info, null, connection.isDescVarLengthRowKeyUpgrade(), connection.isRunningUpgrade(), connection.buildingIndex, true);
    }

    private PhoenixConnection(ConnectionQueryServices services, String url, Properties info, MutationState mutationState, boolean isDescVarLengthRowKeyUpgrade, boolean isRunningUpgrade, boolean buildingIndex, boolean isInternalConnection) throws SQLException {
        this.url = url;
        this.isDescVarLengthRowKeyUpgrade = isDescVarLengthRowKeyUpgrade;
        this.isInternalConnection = isInternalConnection;
        if (Boolean.valueOf(info.getProperty("phoenix.property.policy.provider.enabled", String.valueOf(true))).booleanValue()) {
            PropertyPolicyProvider.getPropertyPolicy().evaluate(info);
        }
        this.info = PropertiesUtil.deepCopy(info);
        PName tenantId = JDBCUtil.getTenantId(url, info);
        if (this.info.isEmpty() && tenantId == null) {
            this.services = services;
        } else {
            ReadOnlyProps currentProps;
            ReadOnlyProps augmentedProps;
            if (tenantId != null) {
                services = services.getChildQueryServices(tenantId.getBytesPtr());
            }
            this.services = (augmentedProps = (currentProps = services.getProps()).addAll(PhoenixConnection.filterKnownNonProperties(this.info))) == currentProps ? services : new DelegateConnectionQueryServices(services){

                @Override
                public ReadOnlyProps getProps() {
                    return augmentedProps;
                }
            };
        }
        Long scnParam = JDBCUtil.getCurrentSCN(url, this.info);
        PhoenixConnection.checkScn(scnParam);
        Long buildIndexAtParam = JDBCUtil.getBuildIndexSCN(url, this.info);
        PhoenixConnection.checkBuildIndexAt(buildIndexAtParam);
        PhoenixConnection.checkScnAndBuildIndexAtEquality(scnParam, buildIndexAtParam);
        this.scn = scnParam != null ? scnParam : buildIndexAtParam;
        this.buildingIndex = buildingIndex || buildIndexAtParam != null;
        this.isAutoFlush = this.services.getProps().getBoolean("phoenix.transactions.enabled", false) && this.services.getProps().getBoolean("phoenix.transactions.autoFlush", false);
        this.isAutoCommit = JDBCUtil.getAutoCommit(url, this.info, this.services.getProps().getBoolean("phoenix.connection.autoCommit", false));
        this.consistency = JDBCUtil.getConsistencyLevel(url, this.info, this.services.getProps().get("phoenix.connection.consistency", QueryServicesOptions.DEFAULT_CONSISTENCY_LEVEL));
        this.schema = JDBCUtil.getSchema(url, this.info, this.services.getProps().get("phoenix.connection.schema", QueryServicesOptions.DEFAULT_SCHEMA));
        this.tenantId = tenantId;
        this.mutateBatchSize = JDBCUtil.getMutateBatchSize(url, this.info, this.services.getProps());
        this.mutateBatchSizeBytes = JDBCUtil.getMutateBatchSizeBytes(url, this.info, this.services.getProps());
        this.datePattern = this.services.getProps().get("phoenix.query.dateFormat", "yyyy-MM-dd HH:mm:ss.SSS");
        this.timePattern = this.services.getProps().get("phoenix.query.timeFormat", "yyyy-MM-dd HH:mm:ss.SSS");
        this.timestampPattern = this.services.getProps().get("phoenix.query.timestampFormat", "yyyy-MM-dd HH:mm:ss.SSS");
        String numberPattern = this.services.getProps().get("phoenix.query.numberFormat", "#,##0.###");
        int maxSize = this.services.getProps().getInt("phoenix.mutate.maxSize", 500000);
        long maxSizeBytes = this.services.getProps().getLongBytes("phoenix.mutate.maxSizeBytes", 0x6400000L);
        this.isApplyTimeZoneDisplacement = this.services.getProps().getBoolean("phoenix.query.applyTimeZoneDisplacement", false);
        this.dateFormatTimeZoneId = this.services.getProps().get("phoenix.query.dateFormatTimeZone", "GMT");
        Format dateFormat = DateUtil.getDateFormatter(this.datePattern, this.dateFormatTimeZoneId);
        Format timeFormat = DateUtil.getDateFormatter(this.timePattern, this.dateFormatTimeZoneId);
        Format timestampFormat = DateUtil.getDateFormatter(this.timestampPattern, this.dateFormatTimeZoneId);
        this.formatters.put(PDate.INSTANCE, dateFormat);
        this.formatters.put(PTime.INSTANCE, timeFormat);
        this.formatters.put(PTimestamp.INSTANCE, timestampFormat);
        this.formatters.put(PUnsignedDate.INSTANCE, dateFormat);
        this.formatters.put(PUnsignedTime.INSTANCE, timeFormat);
        this.formatters.put(PUnsignedTimestamp.INSTANCE, timestampFormat);
        this.formatters.put(PDecimal.INSTANCE, FunctionArgumentType.NUMERIC.getFormatter(numberPattern));
        this.formatters.put(PVarbinary.INSTANCE, VarBinaryFormatter.INSTANCE);
        this.formatters.put(PBinary.INSTANCE, VarBinaryFormatter.INSTANCE);
        this.logLevel = LogLevel.valueOf(this.services.getProps().get("phoenix.log.level", QueryServicesOptions.DEFAULT_LOGGING_LEVEL));
        this.auditLogLevel = LogLevel.valueOf(this.services.getProps().get("phoenix.audit.log.level", QueryServicesOptions.DEFAULT_AUDIT_LOGGING_LEVEL));
        this.isRequestLevelMetricsEnabled = JDBCUtil.isCollectingRequestLevelMetricsEnabled(url, info, this.services.getProps());
        this.mutationState = mutationState == null ? this.newMutationState(maxSize, maxSizeBytes) : new MutationState(mutationState, this);
        this.uniqueID = UUID.randomUUID();
        this.services.addConnection(this);
        this.sampler = Tracing.getConfiguredSampler(this);
        this.customTracingAnnotations = this.getImmutableCustomTracingAnnotations();
        this.scannerQueue = new LinkedBlockingQueue();
        this.tableResultIteratorFactory = new DefaultTableResultIteratorFactory();
        this.isRunningUpgrade = isRunningUpgrade;
        this.logSamplingRate = Double.parseDouble(this.services.getProps().get("phoenix.log.sample.rate", "1.0"));
        String connectionQueryServiceName = this.services.getConfiguration().get("phoenix.query.services.name");
        if (isInternalConnection) {
            GlobalClientMetrics.GLOBAL_OPEN_INTERNAL_PHOENIX_CONNECTIONS.increment();
            long currentInternalConnectionCount = this.getQueryServices().getConnectionCount(isInternalConnection);
            ConnectionQueryServicesMetricsManager.updateMetrics(connectionQueryServiceName, MetricType.OPEN_INTERNAL_PHOENIX_CONNECTIONS_COUNTER, currentInternalConnectionCount);
            ConnectionQueryServicesMetricsManager.updateConnectionQueryServiceOpenInternalConnectionHistogram(currentInternalConnectionCount, connectionQueryServiceName);
        } else {
            GlobalClientMetrics.GLOBAL_OPEN_PHOENIX_CONNECTIONS.increment();
            long currentConnectionCount = this.getQueryServices().getConnectionCount(isInternalConnection);
            ConnectionQueryServicesMetricsManager.updateMetrics(connectionQueryServiceName, MetricType.OPEN_PHOENIX_CONNECTIONS_COUNTER, currentConnectionCount);
            ConnectionQueryServicesMetricsManager.updateConnectionQueryServiceOpenConnectionHistogram(currentConnectionCount, connectionQueryServiceName);
        }
        this.sourceOfOperation = this.services.getProps().get("phoenix.source.operation", null);
    }

    private static void checkScn(Long scnParam) throws SQLException {
        if (scnParam != null && scnParam < 0L) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.INVALID_SCN).build().buildException();
        }
    }

    private static void checkBuildIndexAt(Long replayAtParam) throws SQLException {
        if (replayAtParam != null && replayAtParam < 0L) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.INVALID_REPLAY_AT).build().buildException();
        }
    }

    private static void checkScnAndBuildIndexAtEquality(Long scnParam, Long replayAt) throws SQLException {
        if (scnParam != null && replayAt != null && !scnParam.equals(replayAt)) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.UNEQUAL_SCN_AND_BUILD_INDEX_AT).build().buildException();
        }
    }

    private static Properties filterKnownNonProperties(Properties info) {
        Properties prunedProperties = info;
        for (String property : CONNECTION_PROPERTIES) {
            if (!info.containsKey(property)) continue;
            if (prunedProperties == info) {
                prunedProperties = PropertiesUtil.deepCopy(info);
            }
            prunedProperties.remove(property);
        }
        return prunedProperties;
    }

    private ImmutableMap<String, String> getImmutableCustomTracingAnnotations() {
        ImmutableMap.Builder result = ImmutableMap.builder();
        result.putAll(JDBCUtil.getAnnotations(this.url, this.info));
        if (this.getSCN() != null) {
            result.put((Object)"CurrentSCN", (Object)this.getSCN().toString());
        }
        if (this.getTenantId() != null) {
            result.put((Object)"TenantId", (Object)this.getTenantId().getString());
        }
        return result.build();
    }

    public boolean isInternalConnection() {
        return this.isInternalConnection;
    }

    public void addChildConnection(PhoenixConnection connection) {
        this.childConnections.add(connection);
    }

    public void removeChildConnection(PhoenixConnection connection) {
        this.childConnections.remove(connection);
    }

    @VisibleForTesting
    public int getChildConnectionsCount() {
        return this.childConnections.size();
    }

    public Sampler<?> getSampler() {
        return this.sampler;
    }

    public void setSampler(Sampler<?> sampler) throws SQLException {
        this.sampler = sampler;
    }

    public Map<String, String> getCustomTracingAnnotations() {
        return this.customTracingAnnotations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public int executeStatements(Reader reader, List<Object> binds, PrintStream out) throws IOException, SQLException {
        bindsOffset = 0;
        nStatements = 0;
        parser = new PhoenixStatement.PhoenixStatementParser(reader);
        try {
            while (true) lbl-1000:
            // 3 sources

            {
                stmt = null;
                try {
                    stmt = new PhoenixPreparedStatement(this, parser);
                    paramMetaData = stmt.getParameterMetaData();
                    for (i = 0; i < paramMetaData.getParameterCount(); ++i) {
                        stmt.setObject(i + 1, binds.get(bindsOffset + i));
                    }
                    start = EnvironmentEdgeManager.currentTimeMillis();
                    isQuery = stmt.execute();
                    if (isQuery) {
                        rs = stmt.getResultSet();
                        if (!rs.next()) {
                            if (out != null) {
                                out.println("no rows selected");
                            }
                        } else {
                            columnCount = 0;
                            if (out != null) {
                                md = rs.getMetaData();
                                columnCount = md.getColumnCount();
                                for (i = 1; i <= columnCount; ++i) {
                                    displayWidth = md.getColumnDisplaySize(i);
                                    label = md.getColumnLabel(i);
                                    if (md.isSigned(i)) {
                                        out.print(displayWidth < label.length() ? label.substring(0, displayWidth) : Strings.padStart((String)label, (int)displayWidth, (char)' '));
                                        out.print(' ');
                                        continue;
                                    }
                                    out.print(displayWidth < label.length() ? label.substring(0, displayWidth) : Strings.padEnd((String)md.getColumnLabel(i), (int)displayWidth, (char)' '));
                                    out.print(' ');
                                }
                                out.println();
                                for (i = 1; i <= columnCount; ++i) {
                                    displayWidth = md.getColumnDisplaySize(i);
                                    out.print(Strings.padStart((String)"", (int)displayWidth, (char)'-'));
                                    out.print(' ');
                                }
                                out.println();
                            }
                            do {
                                if (out == null) continue;
                                md = rs.getMetaData();
                                for (i = 1; i <= columnCount; ++i) {
                                    displayWidth = md.getColumnDisplaySize(i);
                                    value = rs.getString(i);
                                    v0 = valueString = value == null ? "<null>" : value;
                                    if (md.isSigned(i)) {
                                        out.print(Strings.padStart((String)valueString, (int)displayWidth, (char)' '));
                                    } else {
                                        out.print(Strings.padEnd((String)valueString, (int)displayWidth, (char)' '));
                                    }
                                    out.print(' ');
                                }
                                out.println();
                            } while (rs.next());
                        }
                    } else if (out != null && (updateCount = stmt.getUpdateCount()) >= 0) {
                        out.println((Serializable)(updateCount == 0 ? "no" : Integer.valueOf(updateCount)) + (updateCount == 1 ? " row " : " rows ") + stmt.getUpdateOperation().toString());
                    }
                    bindsOffset += paramMetaData.getParameterCount();
                    elapsedDuration = (double)(EnvironmentEdgeManager.currentTimeMillis() - start) / 1000.0;
                    out.println("Time: " + elapsedDuration + " sec(s)\n");
                    ++nStatements;
                }
                finally {
                    if (stmt == null) continue;
                    stmt.close();
                    continue;
                }
                break;
            }
        }
        catch (EOFException var7_8) {
            return nStatements;
        }
        ** GOTO lbl-1000
    }

    @Nullable
    public PName getTenantId() {
        return this.tenantId;
    }

    public Long getSCN() {
        return this.scn;
    }

    public boolean isBuildingIndex() {
        return this.buildingIndex;
    }

    public int getMutateBatchSize() {
        return this.mutateBatchSize;
    }

    public long getMutateBatchSizeBytes() {
        return this.mutateBatchSizeBytes;
    }

    public PMetaData getMetaDataCache() {
        return this.getQueryServices().getMetaDataCache();
    }

    private boolean prune(PTable table) {
        long maxTimestamp = this.scn == null ? Long.MAX_VALUE : this.scn;
        return table.getType() != PTableType.SYSTEM && (table.getTimeStamp() >= maxTimestamp || table.getTenantId() != null && !Objects.equal((Object)this.tenantId, (Object)table.getTenantId()));
    }

    public PTable getTable(String tenantId, String fullTableName) throws SQLException {
        return this.getTable(tenantId, fullTableName, Long.MAX_VALUE);
    }

    public PTable getTable(@Nullable String tenantId, String fullTableName, @Nullable Long timestamp) throws SQLException {
        PTable table;
        Preconditions.checkNotNull((Object)fullTableName);
        if (timestamp != null) {
            Preconditions.checkArgument((timestamp >= 0L ? 1 : 0) != 0);
        }
        PName pTenantId = tenantId == null ? null : PNameFactory.newName(tenantId);
        try {
            PTableRef tableref = this.getTableRef(new PTableKey(pTenantId, fullTableName));
            if (timestamp != null && (tableref == null || tableref.getResolvedTimeStamp() != timestamp.longValue())) {
                throw new TableNotFoundException(fullTableName);
            }
            table = tableref.getTable();
        }
        catch (TableNotFoundException e) {
            table = this.getTableNoCache(pTenantId, fullTableName, timestamp);
        }
        return table;
    }

    public PTable getTableNoCache(PName tenantId, String name, long timestamp) throws SQLException {
        String tableName;
        String schemaName = SchemaUtil.getSchemaNameFromFullName(name);
        MetaDataProtocol.MetaDataMutationResult result = new MetaDataClient(this).updateCache(tenantId, schemaName, tableName = SchemaUtil.getTableNameFromFullName(name), false, timestamp);
        if (result.getMutationCode() != MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS) {
            throw new TableNotFoundException(schemaName, tableName);
        }
        return result.getTable();
    }

    public PTable getTableNoCache(PName tenantId, String name) throws SQLException {
        String tableName;
        String schemaName = SchemaUtil.getSchemaNameFromFullName(name);
        MetaDataProtocol.MetaDataMutationResult result = new MetaDataClient(this).updateCache(tenantId, schemaName, tableName = SchemaUtil.getTableNameFromFullName(name), true);
        if (result.getMutationCode() != MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS) {
            throw new TableNotFoundException(schemaName, tableName);
        }
        return result.getTable();
    }

    @VisibleForTesting
    public PTable getTableNoCache(String name) throws SQLException {
        return this.getTableNoCache(this.getTenantId(), name);
    }

    public PTable getTableFromServerNoCache(byte[] schemaName, byte[] tableName) throws SQLException {
        MetaDataProtocol.MetaDataMutationResult result;
        if (schemaName == null) {
            schemaName = ByteUtil.EMPTY_BYTE_ARRAY;
        }
        if ((result = this.getQueryServices().getTable(this.getTenantId(), schemaName, tableName, Long.MAX_VALUE, Long.MAX_VALUE)).getMutationCode() != MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS) {
            throw new TableNotFoundException(new String(schemaName), new String(tableName));
        }
        return result.getTable();
    }

    public PTable getTable(String name) throws SQLException {
        return this.getTable(new PTableKey(this.getTenantId(), name));
    }

    public PTable getTable(PTableKey key) throws SQLException {
        PTable table;
        try {
            table = this.getTableRef(key).getTable();
        }
        catch (TableNotFoundException e) {
            table = this.getTableNoCache(key.getName());
        }
        return table;
    }

    public PTableRef getTableRef(PTableKey key) throws TableNotFoundException {
        PTableRef tableRef = this.getQueryServices().getMetaDataCache().getTableRef(key);
        if (this.prune(tableRef.getTable())) {
            throw new TableNotFoundException(key.getName());
        }
        return tableRef;
    }

    public boolean prune(PFunction function) {
        long maxTimestamp = this.scn == null ? Long.MAX_VALUE : this.scn;
        return function.getTimeStamp() >= maxTimestamp || function.getTenantId() != null && !Objects.equal((Object)this.tenantId, (Object)function.getTenantId());
    }

    public PFunction getFunction(PTableKey key) throws FunctionNotFoundException {
        PFunction function = this.getQueryServices().getMetaDataCache().getFunction(key);
        return this.prune(function) ? null : function;
    }

    protected MutationState newMutationState(int maxSize, long maxSizeBytes) {
        return new MutationState(maxSize, maxSizeBytes, this);
    }

    public MutationState getMutationState() {
        return this.mutationState;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public String getTimePattern() {
        return this.timePattern;
    }

    public String getTimestampPattern() {
        return this.timestampPattern;
    }

    public Format getFormatter(PDataType type) {
        return this.formatters.get(type);
    }

    public String getURL() {
        return this.url;
    }

    public ConnectionQueryServices getQueryServices() {
        return this.services;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeStatements() throws SQLException {
        try {
            this.mutationState.rollback();
        }
        catch (SQLException statementsCopy) {
            try {
                HashSet<PhoenixStatement> statementsCopy2 = new HashSet<PhoenixStatement>(this.statements);
                SQLCloseables.closeAll(statementsCopy2);
            }
            finally {
                this.statements.clear();
            }
        }
        finally {
            try {
                HashSet<PhoenixStatement> statementsCopy = new HashSet<PhoenixStatement>(this.statements);
                SQLCloseables.closeAll(statementsCopy);
            }
            finally {
                this.statements.clear();
            }
        }
    }

    void checkOpen() throws SQLException {
        if (this.isClosed || this.isClosing) {
            throw this.reasonForClose != null ? this.reasonForClose : new SQLExceptionInfo.Builder(SQLExceptionCode.CONNECTION_CLOSED).build().buildException();
        }
    }

    public void close(SQLException reasonForClose) throws SQLException {
        if (this.isClosed || this.isClosing) {
            return;
        }
        this.reasonForClose = reasonForClose;
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws SQLException {
        if (this.isClosed || this.isClosing) {
            return;
        }
        String connectionQueryServiceName = this.services.getConfiguration().get("phoenix.query.services.name");
        try {
            this.isClosing = true;
            TableMetricsManager.pushMetricsFromConnInstanceMethod(this.getMutationMetrics());
            if (!(this.reasonForClose instanceof FailoverSQLException)) {
                this.clearMetrics();
            }
            try {
                this.closeStatements();
                if (this.childConnections != null) {
                    SQLCloseables.closeAllQuietly(this.childConnections);
                }
                if (this.traceScope != null) {
                    this.traceScope.close();
                }
            }
            finally {
                this.services.removeConnection(this);
            }
        }
        finally {
            this.isClosing = false;
            this.isClosed = true;
            if (this.isInternalConnection()) {
                GlobalClientMetrics.GLOBAL_OPEN_INTERNAL_PHOENIX_CONNECTIONS.decrement();
                long currentInternalConnectionCount = this.getQueryServices().getConnectionCount(this.isInternalConnection());
                ConnectionQueryServicesMetricsManager.updateMetrics(connectionQueryServiceName, MetricType.OPEN_INTERNAL_PHOENIX_CONNECTIONS_COUNTER, currentInternalConnectionCount);
                ConnectionQueryServicesMetricsManager.updateConnectionQueryServiceOpenInternalConnectionHistogram(currentInternalConnectionCount, connectionQueryServiceName);
            } else {
                GlobalClientMetrics.GLOBAL_OPEN_PHOENIX_CONNECTIONS.decrement();
                long currentConnectionCount = this.getQueryServices().getConnectionCount(this.isInternalConnection());
                ConnectionQueryServicesMetricsManager.updateMetrics(connectionQueryServiceName, MetricType.OPEN_PHOENIX_CONNECTIONS_COUNTER, currentConnectionCount);
                ConnectionQueryServicesMetricsManager.updateConnectionQueryServiceOpenConnectionHistogram(currentConnectionCount, connectionQueryServiceName);
            }
        }
    }

    @Override
    public void commit() throws SQLException {
        CallRunner.run(new CallRunner.CallableThrowable<Void, SQLException>(){

            @Override
            public Void call() throws SQLException {
                PhoenixConnection.this.checkOpen();
                try {
                    PhoenixConnection.this.mutationState.commit();
                }
                finally {
                    PhoenixConnection.this.mutationState.resetExecuteMutationTimeMap();
                }
                return null;
            }
        }, Tracing.withTracing(this, "committing mutations"));
        this.statementExecutionCounter = 0;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.checkOpen();
        PDataType arrayPrimitiveType = PDataType.fromSqlTypeName(typeName);
        return PArrayDataType.instantiatePhoenixArray(arrayPrimitiveType, elements);
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkOpen();
        PhoenixStatement statement = new PhoenixStatement(this);
        this.statements.add(statement);
        return statement;
    }

    public PhoenixStatement createStatement(PhoenixStatementFactory statementFactory) throws SQLException {
        PhoenixStatement statement = statementFactory.newStatement(this);
        this.statements.add(statement);
        return statement;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkOpen();
        if (resultSetType != 1003 || resultSetConcurrency != 1007) {
            throw new SQLFeatureNotSupportedException();
        }
        return this.createStatement();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkOpen();
        if (resultSetHoldability != 2) {
            throw new SQLFeatureNotSupportedException();
        }
        return this.createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.isAutoCommit;
    }

    public boolean getAutoFlush() {
        return this.isAutoFlush;
    }

    public void setAutoFlush(boolean autoFlush) throws SQLException {
        if (autoFlush && !this.services.getProps().getBoolean("phoenix.transactions.enabled", false)) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.TX_MUST_BE_ENABLED_TO_SET_AUTO_FLUSH).build().buildException();
        }
        this.isAutoFlush = autoFlush;
    }

    public void flush() throws SQLException {
        this.mutationState.sendUncommitted();
    }

    public void setTransactionContext(PhoenixTransactionContext txContext) throws SQLException {
        if (!this.services.getProps().getBoolean("phoenix.transactions.enabled", false)) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.TX_MUST_BE_ENABLED_TO_SET_TX_CONTEXT).build().buildException();
        }
        this.mutationState.rollback();
        this.mutationState = new MutationState(this.mutationState.getMaxSize(), this.mutationState.getMaxSizeBytes(), this, txContext);
        this.setAutoFlush(true);
    }

    public Consistency getConsistency() {
        return this.consistency;
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.tenantId == null ? "" : this.tenantId.getString();
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return new Properties(this.info);
    }

    @Override
    public String getClientInfo(String name) {
        return this.info.getProperty(name);
    }

    @Override
    public int getHoldability() throws SQLException {
        return 2;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkOpen();
        return new PhoenixDatabaseMetaData(this);
    }

    public UUID getUniqueID() {
        return this.uniqueID;
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        boolean transactionsEnabled = this.getQueryServices().getProps().getBoolean("phoenix.transactions.enabled", false);
        return transactionsEnabled ? 4 : 2;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return Collections.emptyMap();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    public boolean isClosing() throws SQLException {
        return this.isClosing;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.readOnly;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return !this.isClosed && !this.isClosing;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkOpen();
        PhoenixPreparedStatement statement = new PhoenixPreparedStatement(this, sql);
        this.statements.add(statement);
        return statement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkOpen();
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkOpen();
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkOpen();
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkOpen();
        if (resultSetType != 1003 || resultSetConcurrency != 1007) {
            throw new SQLFeatureNotSupportedException();
        }
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkOpen();
        if (resultSetHoldability != 2) {
            throw new SQLFeatureNotSupportedException();
        }
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void rollback() throws SQLException {
        CallRunner.run(new CallRunner.CallableThrowable<Void, SQLException>(){

            @Override
            public Void call() throws SQLException {
                PhoenixConnection.this.checkOpen();
                PhoenixConnection.this.mutationState.rollback();
                return null;
            }
        }, Tracing.withTracing(this, "rolling back"));
        this.statementExecutionCounter = 0;
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setAutoCommit(boolean isAutoCommit) throws SQLException {
        this.checkOpen();
        this.isAutoCommit = isAutoCommit;
    }

    public void setConsistency(Consistency val) {
        this.consistency = val;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkOpen();
        if (!this.getCatalog().equalsIgnoreCase(catalog)) {
            throw new SQLFeatureNotSupportedException();
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkOpen();
        this.readOnly = readOnly;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkOpen();
        boolean transactionsEnabled = this.getQueryServices().getProps().getBoolean("phoenix.transactions.enabled", false);
        if (level == 8) {
            throw new SQLFeatureNotSupportedException();
        }
        if (!transactionsEnabled && level == 4) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.TX_MUST_BE_ENABLED_TO_SET_ISOLATION_LEVEL).build().buildException();
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!iface.isInstance(this)) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CLASS_NOT_UNWRAPPABLE).setMessage(this.getClass().getName() + " not unwrappable from " + iface.getName()).build().buildException();
        }
        return (T)this;
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.checkOpen();
        this.schema = schema;
    }

    @Override
    public String getSchema() throws SQLException {
        return SchemaUtil.normalizeIdentifier(this.schema);
    }

    public PSchema getSchema(PTableKey key) throws SchemaNotFoundException {
        return this.getQueryServices().getMetaDataCache().getSchema(key);
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.checkOpen();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.checkOpen();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return 0;
    }

    private boolean useMetaDataCache(PTable table) {
        return table.getType() == PTableType.SYSTEM || table.getUpdateCacheFrequency() != 0L || (Long)ConnectionProperty.UPDATE_CACHE_FREQUENCY.getValue(this.getQueryServices().getProps().get("phoenix.default.update.cache.frequency")) != 0L;
    }

    @Override
    public void addTable(PTable table, long resolvedTime) throws SQLException {
        this.getQueryServices().addTable(table, resolvedTime);
    }

    @Override
    public void updateResolvedTimestamp(PTable table, long resolvedTime) throws SQLException {
        this.getQueryServices().updateResolvedTimestamp(table, resolvedTime);
    }

    @Override
    public void addFunction(PFunction function) throws SQLException {
        this.getQueryServices().addFunction(function);
    }

    @Override
    public void addSchema(PSchema schema) throws SQLException {
        this.getQueryServices().addSchema(schema);
    }

    @Override
    public void removeTable(PName tenantId, String tableName, String parentTableName, long tableTimeStamp) throws SQLException {
        this.getQueryServices().removeTable(tenantId, tableName, parentTableName, tableTimeStamp);
    }

    @Override
    public void removeFunction(PName tenantId, String functionName, long tableTimeStamp) throws SQLException {
        this.getQueryServices().removeFunction(tenantId, functionName, tableTimeStamp);
    }

    @Override
    public void removeColumn(PName tenantId, String tableName, List<PColumn> columnsToRemove, long tableTimeStamp, long tableSeqNum, long resolvedTime) throws SQLException {
        this.getQueryServices().removeColumn(tenantId, tableName, columnsToRemove, tableTimeStamp, tableSeqNum, resolvedTime);
    }

    protected boolean removeStatement(PhoenixStatement statement) throws SQLException {
        return this.statements.remove(statement);
    }

    public KeyValueBuilder getKeyValueBuilder() {
        return this.services.getKeyValueBuilder();
    }

    public int getStatementExecutionCounter() {
        return this.statementExecutionCounter;
    }

    public void incrementStatementExecutionCounter() {
        ++this.statementExecutionCounter;
        if (this.connectionActivityLogger.isLevelEnabled(ActivityLogInfo.OP_STMTS.getLogLevel())) {
            this.connectionActivityLogger.log(ActivityLogInfo.OP_STMTS, String.valueOf(this.statementExecutionCounter));
        }
    }

    public TraceScope getTraceScope() {
        return this.traceScope;
    }

    public void setTraceScope(TraceScope traceScope) {
        this.traceScope = traceScope;
    }

    @Override
    public Map<String, Map<MetricType, Long>> getMutationMetrics() {
        return this.mutationState.getMutationMetricQueue().aggregate();
    }

    @Override
    public Map<String, Map<MetricType, Long>> getReadMetrics() {
        return this.mutationState.getReadMetricQueue() != null ? this.mutationState.getReadMetricQueue().aggregate() : Collections.emptyMap();
    }

    @Override
    public boolean isRequestLevelMetricsEnabled() {
        return this.isRequestLevelMetricsEnabled;
    }

    @Override
    public void clearMetrics() {
        this.mutationState.getMutationMetricQueue().clearMetrics();
        if (this.mutationState.getReadMetricQueue() != null) {
            this.mutationState.getReadMetricQueue().clearMetrics();
        }
    }

    public boolean isDescVarLengthRowKeyUpgrade() {
        return this.isDescVarLengthRowKeyUpgrade;
    }

    public ParallelIteratorFactory getIteratorFactory() {
        return this.parallelIteratorFactory;
    }

    public void setIteratorFactory(ParallelIteratorFactory parallelIteratorFactory) {
        this.parallelIteratorFactory = parallelIteratorFactory;
    }

    public void addIteratorForLeaseRenewal(@Nonnull TableResultIterator itr) {
        if (this.services.isRenewingLeasesEnabled()) {
            Preconditions.checkNotNull((Object)itr);
            this.scannerQueue.add(new WeakReference<TableResultIterator>(itr));
        }
    }

    public LinkedBlockingQueue<WeakReference<TableResultIterator>> getScanners() {
        return this.scannerQueue;
    }

    @Nonnull
    @VisibleForTesting
    public TableResultIteratorFactory getTableResultIteratorFactory() {
        return this.tableResultIteratorFactory;
    }

    @VisibleForTesting
    public void setTableResultIteratorFactory(TableResultIteratorFactory factory) {
        Preconditions.checkNotNull((Object)factory);
        this.tableResultIteratorFactory = factory;
    }

    @VisibleForTesting
    public void setIsClosing(boolean imitateIsClosing) {
        this.isClosing = imitateIsClosing;
    }

    @Override
    public void removeSchema(PSchema schema, long schemaTimeStamp) {
        this.getQueryServices().removeSchema(schema, schemaTimeStamp);
    }

    public boolean isRunningUpgrade() {
        return this.isRunningUpgrade;
    }

    public void setRunningUpgrade(boolean isRunningUpgrade) {
        this.isRunningUpgrade = isRunningUpgrade;
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public LogLevel getAuditLogLevel() {
        return this.auditLogLevel;
    }

    public Double getLogSamplingRate() {
        return this.logSamplingRate;
    }

    public String getSourceOfOperation() {
        return this.sourceOfOperation;
    }

    public String getDateFormatTimeZoneId() {
        return this.dateFormatTimeZoneId;
    }

    public boolean isApplyTimeZoneDisplacement() {
        return this.isApplyTimeZoneDisplacement;
    }

    public String getActivityLog() {
        return this.getActivityLogger().getActivityLog();
    }

    public ConnectionActivityLogger getActivityLogger() {
        return this.connectionActivityLogger;
    }

    public void setActivityLogger(ConnectionActivityLogger connectionActivityLogger) {
        this.connectionActivityLogger = connectionActivityLogger;
    }

    static {
        Tracing.addTraceMetricsSource();
        CONNECTION_PROPERTIES = PhoenixRuntime.getConnectionProperties();
    }
}

