/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Function;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.jdbc.DelegateResultSet;
import org.apache.phoenix.jdbc.ParallelPhoenixContext;
import org.apache.phoenix.jdbc.ParallelPhoenixUtil;
import org.apache.phoenix.jdbc.PhoenixMonitoredResultSet;
import org.apache.phoenix.jdbc.PhoenixResultSet;
import org.apache.phoenix.monitoring.MetricType;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;

public class ParallelPhoenixResultSet
extends DelegateResultSet
implements PhoenixMonitoredResultSet {
    private final ParallelPhoenixContext context;
    private final CompletableFuture<ResultSet> rs1;
    private final CompletableFuture<ResultSet> rs2;

    public ParallelPhoenixResultSet(ParallelPhoenixContext context, CompletableFuture<ResultSet> rs1, CompletableFuture<ResultSet> rs2) {
        super(null);
        this.context = context;
        this.rs = null;
        this.rs1 = rs1;
        this.rs2 = rs2;
    }

    @Override
    public boolean next() throws SQLException {
        this.context.checkOpen();
        if (this.rs == null) {
            Function<ResultSet, Boolean> function = T -> {
                try {
                    return T.next();
                }
                catch (SQLException exception) {
                    throw new CompletionException(exception);
                }
            };
            List futures = ParallelPhoenixUtil.INSTANCE.applyFunctionToFutures(function, this.rs1, this.rs2, this.context, false);
            Preconditions.checkState((futures.size() == 2 ? 1 : 0) != 0);
            CompletableFuture<Boolean> next1 = futures.get(0);
            CompletableFuture<Boolean> next2 = futures.get(1);
            ParallelPhoenixUtil.INSTANCE.runFutures(futures, this.context, true);
            try {
                if (next1.isDone() && !next1.isCompletedExceptionally()) {
                    this.rs = this.rs1.get();
                    return next1.get();
                }
                this.rs = this.rs2.get();
                return next2.get();
            }
            catch (Exception e) {
                throw new SQLException("Unknown Error happened while processing initial next.", e);
            }
        }
        return this.rs.next();
    }

    @VisibleForTesting
    CompletableFuture<ResultSet> getResultSetFuture1() {
        return this.rs1;
    }

    @VisibleForTesting
    CompletableFuture<ResultSet> getResultSetFuture2() {
        return this.rs2;
    }

    @VisibleForTesting
    void setResultSet(ResultSet rs) {
        this.rs = rs;
    }

    @VisibleForTesting
    ResultSet getResultSet() {
        return this.rs;
    }

    @Override
    public Map<String, Map<MetricType, Long>> getReadMetrics() {
        Map<Object, Object> metrics = this.rs != null ? ((PhoenixMonitoredResultSet)this.rs).getReadMetrics() : new HashMap();
        this.context.decorateMetrics(metrics);
        return metrics;
    }

    @Override
    public Map<MetricType, Long> getOverAllRequestReadMetrics() {
        Map<MetricType, Long> metrics = this.rs != null ? ((PhoenixResultSet)this.rs).getOverAllRequestReadMetrics() : this.context.getContextMetrics();
        return metrics;
    }

    @Override
    public void resetMetrics() {
        if (this.rs != null) {
            ((PhoenixResultSet)this.rs).resetMetrics();
        }
        this.context.resetMetrics();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return (T)this;
        }
        throw new SQLExceptionInfo.Builder(SQLExceptionCode.CLASS_NOT_UNWRAPPABLE).build().buildException();
    }
}

