/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.jdbc.DelegateResultSet;
import org.apache.phoenix.jdbc.ParallelPhoenixContext;
import org.apache.phoenix.jdbc.ParallelPhoenixUtil;
import org.apache.phoenix.jdbc.PhoenixMonitoredResultSet;
import org.apache.phoenix.jdbc.PhoenixResultSet;
import org.apache.phoenix.monitoring.MetricType;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelPhoenixNullComparingResultSet
extends DelegateResultSet
implements PhoenixMonitoredResultSet {
    public static final String ERROR_ON_SINGLE_NULL_ATTRIB = "phoenix.parallel.nullComparingRs.errorOnSingleNull";
    public static final String DEFAULT_ERROR_ON_SINGLE_NULL = "false";
    private static final Logger LOG = LoggerFactory.getLogger(ParallelPhoenixNullComparingResultSet.class);
    private final CompletableFuture<ResultSet> rs1;
    private final CompletableFuture<ResultSet> rs2;
    private final ParallelPhoenixContext context;
    private boolean errorOnSingleNull = true;

    public ParallelPhoenixNullComparingResultSet(ParallelPhoenixContext context, CompletableFuture<ResultSet> rs1, CompletableFuture<ResultSet> rs2) {
        super(null);
        this.rs1 = rs1;
        this.rs2 = rs2;
        this.context = context;
        this.errorOnSingleNull = Boolean.valueOf(context.getProperties().getProperty(ERROR_ON_SINGLE_NULL_ATTRIB, DEFAULT_ERROR_ON_SINGLE_NULL));
    }

    @Override
    public boolean next() throws SQLException {
        this.context.checkOpen();
        if (this.rs == null) {
            Function<ResultSet, Boolean> function = T -> {
                try {
                    return T.next();
                }
                catch (SQLException exception) {
                    throw new CompletionException(exception);
                }
            };
            CompletableFuture<Boolean> candidate1 = ParallelPhoenixUtil.INSTANCE.getFutureAndChainOnContext(function, this.rs1, this.context::chainOnConn1, this.context.getParallelPhoenixMetrics().getActiveClusterOperationCount(), this.context.getParallelPhoenixMetrics().getActiveClusterFailedOperationCount());
            CompletableFuture<Boolean> candidate2 = ParallelPhoenixUtil.INSTANCE.getFutureAndChainOnContext(function, this.rs2, this.context::chainOnConn2, this.context.getParallelPhoenixMetrics().getStandbyClusterOperationCount(), this.context.getParallelPhoenixMetrics().getStandbyClusterFailedOperationCount());
            ArrayList<CompletableFuture<? extends Object>> candidates = new ArrayList<CompletableFuture<? extends Object>>();
            candidates.add(candidate1);
            candidates.add(candidate2);
            boolean notEmpty = (Boolean)ParallelPhoenixUtil.INSTANCE.getAnyOfNonExceptionally(candidates, this.context);
            CandidateResult<Boolean> candidateResult1 = new CandidateResult<Boolean>(candidate1, this.rs1, true);
            CandidateResult<Boolean> candidateResult2 = new CandidateResult<Boolean>(candidate2, this.rs2, false);
            try {
                boolean secondResult;
                if (notEmpty) {
                    this.bindToNonEmptyCompletedResultSet(candidateResult1, candidateResult2);
                    return true;
                }
                Pair<CandidateResult<Boolean>, CandidateResult<Boolean>> candidateResultPair = this.findFirstNonExceptionallyCompletedCandidateResult(candidateResult1, candidateResult2);
                boolean firstResult = (Boolean)((CandidateResult)candidateResultPair.getFirst()).getCandidate().get();
                if (firstResult) {
                    this.rs = ((CandidateResult)candidateResultPair.getFirst()).getRs().get();
                    this.logIfTraceEnabled((CandidateResult)candidateResultPair.getFirst());
                    this.incrementClusterUsedCount((CandidateResult)candidateResultPair.getFirst());
                    return true;
                }
                try {
                    secondResult = (Boolean)ParallelPhoenixUtil.INSTANCE.getFutureNoRetry(((CandidateResult)candidateResultPair.getSecond()).getCandidate(), this.context);
                }
                catch (Exception e) {
                    LOG.warn("Exception while trying to read from other cluster after getting empty result from one cluster, errorOnSingleNull: " + this.errorOnSingleNull, (Throwable)e);
                    if (this.errorOnSingleNull) {
                        this.context.setError();
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.HA_READ_FROM_CLUSTER_FAILED_ON_NULL).setRootCause(e).setHaGroupInfo(this.context.getHaGroup().getGroupInfo().toString()).build().buildException();
                    }
                    this.rs = ((CandidateResult)candidateResultPair.getFirst()).getRs().get();
                    this.logIfTraceEnabled((CandidateResult)candidateResultPair.getFirst());
                    this.incrementClusterUsedCount((CandidateResult)candidateResultPair.getFirst());
                    return false;
                }
                this.rs = ((CandidateResult)candidateResultPair.getSecond()).getRs().get();
                this.logIfTraceEnabled((CandidateResult)candidateResultPair.getSecond());
                this.incrementClusterUsedCount((CandidateResult)candidateResultPair.getSecond());
                return secondResult;
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.error("Unexpected exception:", (Throwable)e);
                this.context.setError();
                throw new SQLException(e);
            }
        }
        return this.rs.next();
    }

    private Object runOnResultSets(Function<ResultSet, ?> function) throws SQLException {
        return ParallelPhoenixUtil.INSTANCE.runFutures(function, this.rs1, this.rs2, this.context, true);
    }

    private void bindToNonEmptyCompletedResultSet(CandidateResult<Boolean> candidateResult1, CandidateResult<Boolean> candidateResult2) throws InterruptedException, ExecutionException, SQLException {
        CompletableFuture<Boolean> candidate1 = candidateResult1.getCandidate();
        CompletableFuture<Boolean> candidate2 = candidateResult2.getCandidate();
        if (candidate1.isDone() && !candidate1.isCompletedExceptionally() && candidate1.get().booleanValue()) {
            this.rs = candidateResult1.getRs().get();
            this.logIfTraceEnabled(candidateResult1);
            this.incrementClusterUsedCount(candidateResult1);
        } else if (candidate2.isDone() && !candidate2.isCompletedExceptionally() && candidate2.get().booleanValue()) {
            this.rs = candidateResult2.getRs().get();
            this.logIfTraceEnabled(candidateResult2);
            this.incrementClusterUsedCount(candidateResult2);
        } else {
            throw new SQLException("Unexpected exception, one of the RS should've completed successfully");
        }
    }

    private <T> Pair<CandidateResult<T>, CandidateResult<T>> findFirstNonExceptionallyCompletedCandidateResult(CandidateResult<T> candidateResult1, CandidateResult<T> candidateResult2) throws SQLException {
        Pair pair = new Pair();
        CompletableFuture<T> candidate1 = candidateResult1.getCandidate();
        CompletableFuture<T> candidate2 = candidateResult2.getCandidate();
        if (candidate1.isDone() && !candidate1.isCompletedExceptionally()) {
            pair.setFirst(candidateResult1);
            pair.setSecond(candidateResult2);
        } else if (candidate2.isDone() && !candidate2.isCompletedExceptionally()) {
            pair.setFirst(candidateResult2);
            pair.setSecond(candidateResult1);
        } else {
            throw new SQLException("Unexpected exception, one of the RS should've completed successfully");
        }
        return pair;
    }

    @Override
    public void close() throws SQLException {
        Function<ResultSet, Void> function = T -> {
            try {
                T.close();
                return null;
            }
            catch (SQLException exception) {
                throw new CompletionException(exception);
            }
        };
        this.runOnResultSets(function);
    }

    @VisibleForTesting
    ResultSet getResultSet() {
        return this.rs;
    }

    @Override
    public Map<String, Map<MetricType, Long>> getReadMetrics() {
        Map<Object, Object> metrics = this.rs != null ? ((PhoenixMonitoredResultSet)this.rs).getReadMetrics() : new HashMap();
        this.context.decorateMetrics(metrics);
        return metrics;
    }

    @Override
    public Map<MetricType, Long> getOverAllRequestReadMetrics() {
        Map<MetricType, Long> metrics = this.rs != null ? ((PhoenixMonitoredResultSet)this.rs).getOverAllRequestReadMetrics() : this.context.getContextMetrics();
        return metrics;
    }

    @Override
    public void resetMetrics() {
        if (this.rs != null) {
            ((PhoenixResultSet)this.rs).resetMetrics();
        }
        this.context.resetMetrics();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return (T)this;
        }
        throw new SQLExceptionInfo.Builder(SQLExceptionCode.CLASS_NOT_UNWRAPPABLE).build().buildException();
    }

    private void logIfTraceEnabled(CandidateResult<Boolean> bindingCandidateResult) throws InterruptedException, ExecutionException {
        if (LOG.isTraceEnabled()) {
            boolean isNull = bindingCandidateResult.getCandidate().get();
            boolean belongsToActiveCluster = bindingCandidateResult.belongsToActiveCluster();
            LOG.trace(String.format("ParallelPhoenixNullComparingResultSet binding to ResultSet with attributes: isEmpty:%s belongsToActiveCluster:%s", isNull, belongsToActiveCluster));
        }
    }

    private <T> void incrementClusterUsedCount(CandidateResult<T> candidateResult) {
        if (candidateResult.belongsToActiveCluster()) {
            this.context.getParallelPhoenixMetrics().getActiveClusterUsedCount().increment();
        } else {
            this.context.getParallelPhoenixMetrics().getStandbyClusterUsedCount().increment();
        }
    }

    private static class CandidateResult<T> {
        private final CompletableFuture<T> candidate;
        private final CompletableFuture<ResultSet> rs;
        private final boolean belongsToActiveCluster;

        CandidateResult(CompletableFuture<T> candidate, CompletableFuture<ResultSet> rs, boolean belongsToActiveCluster) {
            this.candidate = candidate;
            this.rs = rs;
            this.belongsToActiveCluster = belongsToActiveCluster;
        }

        public CompletableFuture<T> getCandidate() {
            return this.candidate;
        }

        public CompletableFuture<ResultSet> getRs() {
            return this.rs;
        }

        public boolean belongsToActiveCluster() {
            return this.belongsToActiveCluster;
        }
    }
}

