/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.jdbc.HAURLInfo;
import org.apache.phoenix.jdbc.HighAvailabilityGroup;
import org.apache.phoenix.jdbc.ParallelPhoenixMetrics;
import org.apache.phoenix.jdbc.PhoenixHAExecutorServiceProvider;
import org.apache.phoenix.monitoring.GlobalClientMetrics;
import org.apache.phoenix.monitoring.Metric;
import org.apache.phoenix.monitoring.MetricType;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelPhoenixContext {
    private static final Logger LOG = LoggerFactory.getLogger(ParallelPhoenixContext.class);
    public static String PARALLEL_PHOENIX_METRICS = "parallel_phoenix_metrics";
    private final ParallelPhoenixClusterContext cluster1Context;
    private final ParallelPhoenixClusterContext cluster2Context;
    private final Properties properties;
    private final HighAvailabilityGroup haGroup;
    private final HAURLInfo haurlInfo;
    private final long operationTimeoutMs;
    private volatile boolean isClosed = false;
    private volatile boolean isErrored = false;
    private ParallelPhoenixMetrics parallelPhoenixMetrics;

    ParallelPhoenixContext(Properties properties, HighAvailabilityGroup haGroup, List<PhoenixHAExecutorServiceProvider.PhoenixHAClusterExecutorServices> executors, List<Boolean> executorCapacities, HAURLInfo haurlInfo) {
        Preconditions.checkNotNull(executors);
        Preconditions.checkArgument((executors.size() >= 2 ? 1 : 0) != 0, (Object)"Expected 2 executor pairs, one for each connection with a normal/close executor");
        GlobalClientMetrics.GLOBAL_HA_PARALLEL_CONNECTION_CREATED_COUNTER.increment();
        this.properties = properties;
        this.haGroup = haGroup;
        this.haurlInfo = haurlInfo;
        this.parallelPhoenixMetrics = new ParallelPhoenixMetrics();
        this.operationTimeoutMs = this.getOperationTimeoutMs(properties);
        this.cluster1Context = new ParallelPhoenixClusterContext(1, executors.get(0).getExecutorService(), executors.get(0).getCloseExecutorService());
        this.cluster2Context = new ParallelPhoenixClusterContext(2, executors.get(1).getExecutorService(), executors.get(1).getCloseExecutorService());
        if (executorCapacities == null) {
            return;
        }
        Preconditions.checkArgument((executorCapacities.size() >= 2 ? 1 : 0) != 0, (Object)"Expected 2 executorCapacities values for each threadpool");
        if (!executorCapacities.get(0).booleanValue()) {
            this.disableChainOnConn(this.cluster1Context, this.haGroup.getGroupInfo().getUrl1());
        }
        if (!executorCapacities.get(1).booleanValue()) {
            this.disableChainOnConn(this.cluster2Context, this.haGroup.getGroupInfo().getUrl2());
        }
    }

    public ParallelPhoenixMetrics getParallelPhoenixMetrics() {
        return this.parallelPhoenixMetrics;
    }

    private void disableChainOnConn(ParallelPhoenixClusterContext context, String url) {
        CompletableFuture chainOnConn = new CompletableFuture();
        chainOnConn.completeExceptionally(new SQLException("No capacity available for connection " + context.clusterIndex + " for cluster " + url));
        LOG.debug("No capacity available for connection " + context.clusterIndex + " for cluster {}", (Object)url);
        context.setChainOnConn(chainOnConn);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public HighAvailabilityGroup getHaGroup() {
        return this.haGroup;
    }

    public HAURLInfo getHaurlInfo() {
        return this.haurlInfo;
    }

    public boolean isAutoCommit() {
        return Boolean.valueOf((String)this.properties.getOrDefault((Object)"phoenix.connection.autoCommit", "false"));
    }

    public <T> CompletableFuture<T> chainOnConn1(Supplier<T> s) {
        return this.chainOnConnClusterContext(s, this.cluster1Context);
    }

    public <T> void setConnection1Tail(CompletableFuture<T> future) {
        this.cluster1Context.setChainOnConn(future);
    }

    public <T> CompletableFuture<T> chainOnConn2(Supplier<T> s) {
        return this.chainOnConnClusterContext(s, this.cluster2Context);
    }

    public <T> void setConnection2Tail(CompletableFuture<T> future) {
        this.cluster2Context.setChainOnConn(future);
    }

    private <T> CompletableFuture<T> chainOnConnClusterContext(Supplier<T> s, ParallelPhoenixClusterContext context) {
        CompletionStage chainedFuture = context.getChainOnConn().thenApplyAsync(f -> s.get(), (Executor)context.getExecutorForCluster());
        context.setChainOnConn((CompletableFuture)chainedFuture);
        return chainedFuture;
    }

    public void close() {
        this.isClosed = true;
        if (this.isErrored) {
            GlobalClientMetrics.GLOBAL_HA_PARALLEL_CONNECTION_ERROR_COUNTER.increment();
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void setError() {
        this.isErrored = true;
    }

    public void checkOpen() throws SQLException {
        if (this.isClosed) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CONNECTION_CLOSED).build().buildException();
        }
    }

    public Map<MetricType, Long> getContextMetrics() {
        return this.parallelPhoenixMetrics.getAllMetrics().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, t -> ((Metric)t.getValue()).getValue()));
    }

    public void resetMetrics() {
        this.parallelPhoenixMetrics = new ParallelPhoenixMetrics();
    }

    public void decorateMetrics(Map<String, Map<MetricType, Long>> initialMetrics) {
        initialMetrics.put(PARALLEL_PHOENIX_METRICS, this.getContextMetrics());
    }

    public long getOperationTimeout() {
        return this.operationTimeoutMs;
    }

    CompletableFuture<?> getChainOnConn1() {
        return this.cluster1Context.getChainOnConn();
    }

    CompletableFuture<?> getChainOnConn2() {
        return this.cluster2Context.getChainOnConn();
    }

    ExecutorService getCloseConnection1ExecutorService() {
        return this.cluster1Context.getConnectionCloseExecutor();
    }

    ExecutorService getCloseConnection2ExecutorService() {
        return this.cluster2Context.getConnectionCloseExecutor();
    }

    private long getOperationTimeoutMs(Properties properties) {
        long operationTimeoutMs = properties.getProperty("phoenix.ha.parallel.operation.timeout.ms") != null ? Long.parseLong(properties.getProperty("phoenix.ha.parallel.operation.timeout.ms")) : Long.parseLong(properties.getProperty("phoenix.query.timeoutMs", Long.toString(600000L)));
        Preconditions.checkArgument((operationTimeoutMs >= 0L ? 1 : 0) != 0);
        return operationTimeoutMs;
    }

    private static class ParallelPhoenixClusterContext {
        private final int clusterIndex;
        private final ExecutorService executorForCluster;
        private final ExecutorService connectionCloseExecutor;
        private CompletableFuture chainOnConn = CompletableFuture.completedFuture(new Object());

        public ParallelPhoenixClusterContext(int clusterIndex, ExecutorService executorForCluster, ExecutorService connectionCloseExecutor) {
            this.clusterIndex = clusterIndex;
            this.executorForCluster = executorForCluster;
            this.connectionCloseExecutor = connectionCloseExecutor;
        }

        public ExecutorService getExecutorForCluster() {
            return this.executorForCluster;
        }

        public ExecutorService getConnectionCloseExecutor() {
            return this.connectionCloseExecutor;
        }

        public CompletableFuture getChainOnConn() {
            return this.chainOnConn;
        }

        public void setChainOnConn(CompletableFuture chainOnConn) {
            this.chainOnConn = chainOnConn;
        }
    }
}

