/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.hadoop.hbase.util.PairOfSameType;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.jdbc.HAURLInfo;
import org.apache.phoenix.jdbc.HighAvailabilityGroup;
import org.apache.phoenix.jdbc.ParallelPhoenixContext;
import org.apache.phoenix.jdbc.ParallelPhoenixPreparedStatement;
import org.apache.phoenix.jdbc.ParallelPhoenixStatement;
import org.apache.phoenix.jdbc.ParallelPhoenixUtil;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixMonitoredConnection;
import org.apache.phoenix.jdbc.PhoenixMonitoredPreparedStatement;
import org.apache.phoenix.jdbc.PhoenixMonitoredStatement;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.monitoring.MetricType;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelPhoenixConnection
implements PhoenixMonitoredConnection {
    private static final Logger LOG = LoggerFactory.getLogger(ParallelPhoenixConnection.class);
    private final ParallelPhoenixContext context;
    CompletableFuture<PhoenixConnection> futureConnection1;
    CompletableFuture<PhoenixConnection> futureConnection2;

    public ParallelPhoenixConnection(ParallelPhoenixContext context) throws SQLException {
        this.context = context;
        LOG.trace("First Url: {} Second Url: {}", (Object)context.getHaGroup().getRoleRecord().getUrl1(), (Object)context.getHaGroup().getRoleRecord().getUrl2());
        this.futureConnection1 = context.chainOnConn1(() -> ParallelPhoenixConnection.getConnection(context.getHaGroup(), context.getHaGroup().getRoleRecord().getUrl1(), context.getProperties(), context.getHaurlInfo()));
        this.futureConnection2 = context.chainOnConn2(() -> ParallelPhoenixConnection.getConnection(context.getHaGroup(), context.getHaGroup().getRoleRecord().getUrl2(), context.getProperties(), context.getHaurlInfo()));
        ParallelPhoenixUtil.INSTANCE.runFutures(Arrays.asList(this.futureConnection1, this.futureConnection2), context, false);
    }

    @VisibleForTesting
    ParallelPhoenixConnection(ParallelPhoenixContext context, CompletableFuture<PhoenixConnection> futureConnection1, CompletableFuture<PhoenixConnection> futureConnection2) throws SQLException {
        this.context = context;
        this.futureConnection1 = futureConnection1;
        this.futureConnection2 = futureConnection2;
        ParallelPhoenixUtil.INSTANCE.runFutures(Arrays.asList(futureConnection1, futureConnection2), context, false);
    }

    private static PhoenixConnection getConnection(HighAvailabilityGroup haGroup, String url, Properties properties, HAURLInfo haurlInfo) {
        try {
            return haGroup.connectToOneCluster(url, properties, haurlInfo);
        }
        catch (SQLException exception) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(String.format("Failed to get a connection for haGroup %s to %s", haGroup.toString(), url), (Throwable)exception);
            }
            throw new CompletionException(exception);
        }
    }

    public CompletableFuture<PhoenixConnection> getFutureConnection1() {
        return this.futureConnection1;
    }

    public CompletableFuture<PhoenixConnection> getFutureConnection2() {
        return this.futureConnection2;
    }

    @VisibleForTesting
    ParallelPhoenixContext getContext() {
        return this.context;
    }

    Object runOnConnections(Function<PhoenixConnection, ?> function, boolean useMetrics) throws SQLException {
        return ParallelPhoenixUtil.INSTANCE.runFutures(function, this.futureConnection1, this.futureConnection2, this.context, useMetrics);
    }

    PairOfSameType<Object> runOnConnectionsGetAll(Function<PhoenixConnection, ?> function, boolean useMetrics) throws SQLException {
        return ParallelPhoenixUtil.INSTANCE.runOnFuturesGetAll(function, this.futureConnection1, this.futureConnection2, this.context, useMetrics);
    }

    @Override
    public ParallelPhoenixStatement createStatement() throws SQLException {
        this.context.checkOpen();
        Function<PhoenixConnection, PhoenixMonitoredStatement> function = T -> {
            try {
                return (PhoenixStatement)T.createStatement();
            }
            catch (SQLException exception) {
                throw new CompletionException(exception);
            }
        };
        List futures = ParallelPhoenixUtil.INSTANCE.applyFunctionToFutures(function, this.futureConnection1, this.futureConnection2, this.context, true);
        Preconditions.checkState((futures.size() == 2 ? 1 : 0) != 0);
        CompletableFuture<PhoenixMonitoredStatement> statement1 = futures.get(0);
        CompletableFuture<PhoenixMonitoredStatement> statement2 = futures.get(1);
        ParallelPhoenixUtil.INSTANCE.runFutures(futures, this.context, true);
        return new ParallelPhoenixStatement(this.context, statement1, statement2);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.context.checkOpen();
        Function<PhoenixConnection, PhoenixMonitoredPreparedStatement> function = T -> {
            try {
                return (PhoenixMonitoredPreparedStatement)T.prepareStatement(sql);
            }
            catch (SQLException exception) {
                throw new CompletionException(exception);
            }
        };
        List futures = ParallelPhoenixUtil.INSTANCE.applyFunctionToFutures(function, this.futureConnection1, this.futureConnection2, this.context, true);
        Preconditions.checkState((futures.size() == 2 ? 1 : 0) != 0);
        CompletableFuture<PhoenixMonitoredPreparedStatement> statement1 = futures.get(0);
        CompletableFuture<PhoenixMonitoredPreparedStatement> statement2 = futures.get(1);
        ParallelPhoenixUtil.INSTANCE.runFutures(futures, this.context, true);
        return new ParallelPhoenixPreparedStatement(this.context, statement1, statement2);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return null;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return null;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        Function<PhoenixConnection, Boolean> function = T -> {
            try {
                return T.getAutoCommit();
            }
            catch (SQLException exception) {
                throw new CompletionException(exception);
            }
        };
        return (Boolean)this.runOnConnections(function, true);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        Function<PhoenixConnection, Void> function = T -> {
            try {
                T.setAutoCommit(autoCommit);
                return null;
            }
            catch (SQLException exception) {
                throw new CompletionException(exception);
            }
        };
        this.runOnConnections(function, true);
    }

    @Override
    public void commit() throws SQLException {
        Function<PhoenixConnection, Void> function = T -> {
            try {
                T.commit();
                return null;
            }
            catch (SQLException exception) {
                throw new CompletionException(exception);
            }
        };
        this.runOnConnections(function, true);
    }

    @Override
    public void rollback() throws SQLException {
    }

    @Override
    public void close() throws SQLException {
        this.context.close();
        SQLException closeExp = null;
        ArrayList<CompletableFuture<? extends Object>> futures = new ArrayList<CompletableFuture<? extends Object>>();
        CompletionStage closeFuture1 = null;
        CompletionStage closeFuture2 = null;
        try {
            Supplier<Boolean> closeSupplier1 = this.getCloseSupplier(this.futureConnection1);
            closeFuture1 = ((CompletableFuture)this.futureConnection1.handle((obj, e) -> CompletableFuture.supplyAsync(closeSupplier1, this.context.getCloseConnection1ExecutorService()))).thenApply(t -> new ParallelPhoenixUtil.FutureResult<CompletableFuture>((CompletableFuture)t, 0));
            futures.add((CompletableFuture<? extends Object>)closeFuture1);
        }
        catch (Exception e2) {
            LOG.error("Unknow error happened preparing to close connection 1.", (Throwable)e2);
        }
        try {
            Supplier<Boolean> closeSupplier2 = this.getCloseSupplier(this.futureConnection2);
            closeFuture2 = ((CompletableFuture)this.futureConnection2.handle((obj, e) -> CompletableFuture.supplyAsync(closeSupplier2, this.context.getCloseConnection2ExecutorService()))).thenApply(t -> new ParallelPhoenixUtil.FutureResult<CompletableFuture>((CompletableFuture)t, 1));
            futures.add((CompletableFuture<? extends Object>)closeFuture2);
        }
        catch (Exception e3) {
            LOG.error("Unknow error happened preparing to close connection 2.", (Throwable)e3);
        }
        ParallelPhoenixUtil.FutureResult result = (ParallelPhoenixUtil.FutureResult)ParallelPhoenixUtil.INSTANCE.getAnyOfNonExceptionally(futures, this.context);
        try {
            ParallelPhoenixUtil.INSTANCE.getFutureNoRetry((CompletableFuture)result.getResult(), this.context);
            return;
        }
        catch (Exception e4) {
            CompletionStage otherFuture;
            closeExp = new SQLException(e4);
            CompletionStage completionStage = otherFuture = result.getIndex() == 0 ? closeFuture2 : closeFuture1;
            if (otherFuture != null) {
                try {
                    ParallelPhoenixUtil.FutureResult otherResult = (ParallelPhoenixUtil.FutureResult)ParallelPhoenixUtil.INSTANCE.getFutureNoRetry(otherFuture, this.context);
                    ParallelPhoenixUtil.INSTANCE.getFutureNoRetry((CompletableFuture)otherResult.getResult(), this.context);
                }
                catch (Exception e5) {
                    closeExp.addSuppressed(e5);
                    LOG.error("Failed closing both underlying connections within time limits", (Throwable)closeExp);
                    throw closeExp;
                }
            }
            return;
        }
    }

    private Supplier<Boolean> getCloseSupplier(CompletableFuture<PhoenixConnection> conn) {
        return () -> {
            try {
                this.getConnectionAndTryClose(conn);
            }
            catch (Exception exp) {
                throw new CompletionException(exp);
            }
            return true;
        };
    }

    private void getConnectionAndTryClose(CompletableFuture<PhoenixConnection> futureConn) throws SQLException {
        try {
            futureConn.get().close();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.context.isClosed();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        Function<PhoenixConnection, DatabaseMetaData> function = T -> {
            try {
                return T.getMetaData();
            }
            catch (SQLException exception) {
                throw new CompletionException(exception);
            }
        };
        return (DatabaseMetaData)this.runOnConnections(function, true);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String getCatalog() throws SQLException {
        Function<PhoenixConnection, String> function = T -> {
            try {
                return T.getCatalog();
            }
            catch (SQLException exception) {
                throw new CompletionException(exception);
            }
        };
        return (String)this.runOnConnections(function, true);
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        Function<PhoenixConnection, Void> function = T -> {
            try {
                T.getCatalog();
                return null;
            }
            catch (SQLException exception) {
                throw new CompletionException(exception);
            }
        };
        this.runOnConnections(function, true);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        Function<PhoenixConnection, Integer> function = T -> {
            try {
                return T.getTransactionIsolation();
            }
            catch (SQLException exception) {
                throw new CompletionException(exception);
            }
        };
        return (Integer)this.runOnConnections(function, true);
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        Function<PhoenixConnection, Void> function = T -> {
            try {
                T.setTransactionIsolation(level);
                return null;
            }
            catch (SQLException exception) {
                throw new CompletionException(exception);
            }
        };
        this.runOnConnections(function, true);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        Function<PhoenixConnection, SQLWarning> function = T -> {
            try {
                return T.getWarnings();
            }
            catch (SQLException exception) {
                throw new CompletionException(exception);
            }
        };
        try {
            PairOfSameType<Object> pair = this.runOnConnectionsGetAll(function, true);
            SQLWarning warning1 = (SQLWarning)pair.getFirst();
            SQLWarning warning2 = (SQLWarning)pair.getSecond();
            if (warning1 != null && warning2 != null) {
                SQLWarning warning = new SQLWarning("Warnings on multiple connections.");
                warning.setNextWarning(warning1);
                warning.setNextWarning(warning2);
                return warning;
            }
            return Stream.of(warning1, warning2).filter(Objects::nonNull).findFirst().orElse(null);
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        Function<PhoenixConnection, Void> function = T -> {
            try {
                T.clearWarnings();
                return null;
            }
            catch (SQLException exception) {
                throw new CompletionException(exception);
            }
        };
        this.runOnConnectionsGetAll(function, true);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return null;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return null;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return null;
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        throw new SQLClientInfoException();
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.context.getProperties() != null ? this.context.getProperties().getProperty(name) : null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.context.getProperties();
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        throw new SQLClientInfoException();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String getSchema() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return (T)this;
        }
        throw new SQLExceptionInfo.Builder(SQLExceptionCode.CLASS_NOT_UNWRAPPABLE).build().buildException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public Map<String, Map<MetricType, Long>> getMutationMetrics() {
        HashMap<String, Map<MetricType, Long>> metrics = new HashMap<String, Map<MetricType, Long>>();
        try {
            Map winningMetrics = (Map)this.runOnConnections(PhoenixConnection::getMutationMetrics, false);
            metrics.putAll(winningMetrics);
            this.context.decorateMetrics(metrics);
            return metrics;
        }
        catch (SQLException e) {
            LOG.error("Unexpected error while getting mutation metrics.", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    @Override
    public Map<String, Map<MetricType, Long>> getReadMetrics() {
        HashMap<String, Map<MetricType, Long>> metrics = new HashMap<String, Map<MetricType, Long>>();
        try {
            Map winningMetrics = (Map)this.runOnConnections(PhoenixConnection::getReadMetrics, false);
            metrics.putAll(winningMetrics);
            this.context.decorateMetrics(metrics);
            return metrics;
        }
        catch (SQLException e) {
            LOG.error("Unexpected error while getting read metrics.", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    @Override
    public boolean isRequestLevelMetricsEnabled() {
        return true;
    }

    @Override
    public void clearMetrics() {
        Function<PhoenixConnection, Void> function = T -> {
            T.clearMetrics();
            return null;
        };
        try {
            this.runOnConnections(function, false);
        }
        catch (SQLException exception) {
            LOG.error("Unexpected exception while clearning metrics.", (Throwable)exception);
        }
        this.context.resetMetrics();
    }
}

