/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.recipes.cache.NodeCache;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.hadoop.hbase.util.PairOfSameType;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.jdbc.ClusterRoleRecord;
import org.apache.phoenix.jdbc.HAURLInfo;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixEmbeddedDriver;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.thirdparty.com.google.common.cache.Cache;
import org.apache.phoenix.thirdparty.com.google.common.cache.CacheBuilder;
import org.apache.phoenix.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.phoenix.util.JDBCUtil;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HighAvailabilityGroup {
    public static final String PHOENIX_HA_ATTR_PREFIX = "phoenix.ha.";
    public static final String PHOENIX_HA_GROUP_ATTR = "phoenix.ha.group.name";
    public static final String PHOENIX_HA_SHOULD_FALLBACK_WHEN_MISSING_CRR_KEY = "phoenix.ha.fallback.enabled";
    public static final String PHOENIX_HA_SHOULD_FALLBACK_WHEN_MISSING_CRR_DEFAULT = String.valueOf(Boolean.TRUE);
    public static final String PHOENIX_HA_FALLBACK_CLUSTER_KEY = "phoenix.ha.fallback.cluster";
    public static final String PHOENIX_HA_ZOOKEEPER_ZNODE_NAMESPACE = "phoenix/ha";
    public static final String PHOENIX_HA_ZK_CONNECTION_TIMEOUT_MS_KEY = "phoenix.ha.zk.connection.timeout.ms";
    public static final int PHOENIX_HA_ZK_CONNECTION_TIMEOUT_MS_DEFAULT = 4000;
    public static final String PHOENIX_HA_ZK_SESSION_TIMEOUT_MS_KEY = "phoenix.ha.zk.session.timeout.ms";
    public static final int PHOENIX_HA_ZK_SESSION_TIMEOUT_MS_DEFAULT = 4000;
    public static final String PHOENIX_HA_ZK_RETRY_BASE_SLEEP_MS_KEY = "phoenix.ha.zk.retry.base.sleep.ms";
    public static final int PHOENIX_HA_ZK_RETRY_BASE_SLEEP_MS_DEFAULT = 1000;
    public static final String PHOENIX_HA_ZK_RETRY_MAX_KEY = "phoenix.ha.zk.retry.max";
    public static final int PHOENIX_HA_ZK_RETRY_MAX_DEFAULT = 5;
    public static final String PHOENIX_HA_ZK_RETRY_MAX_SLEEP_MS_KEY = "phoenix.ha.zk.retry.max.sleep.ms";
    public static final int PHOENIX_HA_ZK_RETRY_MAX_SLEEP_MS_DEFAULT = 10000;
    public static final RetryPolicy RETRY_POLICY = new ExponentialBackoffRetry(1000, 5, 10000);
    public static final String PHOENIX_HA_TRANSITION_TIMEOUT_MS_KEY = "phoenix.ha.transition.timeout.ms";
    public static final long PHOENIX_HA_TRANSITION_TIMEOUT_MS_DEFAULT = 300000L;
    static final Logger LOG = LoggerFactory.getLogger(HighAvailabilityGroup.class);
    @VisibleForTesting
    static final Map<HAGroupInfo, HighAvailabilityGroup> GROUPS = new ConcurrentHashMap<HAGroupInfo, HighAvailabilityGroup>();
    static final Map<HAGroupInfo, Set<HAURLInfo>> URLS = new ConcurrentHashMap<HAGroupInfo, Set<HAURLInfo>>();
    @VisibleForTesting
    static final Cache<HAGroupInfo, Boolean> MISSING_CRR_GROUPS_CACHE = CacheBuilder.newBuilder().expireAfterWrite(300000L, TimeUnit.MILLISECONDS).build();
    @VisibleForTesting
    static final Cache<String, CuratorFramework> CURATOR_CACHE = CacheBuilder.newBuilder().expireAfterAccess(86400000L, TimeUnit.MILLISECONDS).removalListener(notification -> ((CuratorFramework)Objects.requireNonNull(notification.getValue())).close()).build();
    private final HAGroupInfo info;
    private final Properties properties;
    private final ExecutorService roleManagerExecutor = Executors.newFixedThreadPool(2, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("phoenixHAGroup-%d").build());
    private final CountDownLatch roleManagerLatch = new CountDownLatch(1);
    private final AtomicReference<PairOfSameType<HAClusterRoleManager>> roleManagers = new AtomicReference();
    private final ExecutorService nodeChangedExecutor = Executors.newFixedThreadPool(1);
    private volatile ClusterRoleRecord roleRecord;
    private volatile State state = State.UNINITIALIZED;

    private HighAvailabilityGroup(HAGroupInfo info, Properties properties) {
        this.info = info;
        this.properties = properties;
    }

    @VisibleForTesting
    HighAvailabilityGroup(HAGroupInfo info, Properties properties, ClusterRoleRecord record, State state) {
        this.info = info;
        this.properties = properties;
        this.roleRecord = record;
        this.state = state;
    }

    public static HAURLInfo getUrlInfo(String url, Properties properties) throws SQLException {
        url = HighAvailabilityGroup.checkUrl(url);
        String principal = null;
        String additionalJDBCParams = null;
        int idx = url.indexOf("]");
        int extraIdx = url.indexOf(58, idx + 1);
        if (extraIdx != -1) {
            if (extraIdx != idx + 1) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.MALFORMED_CONNECTION_URL).setMessage(String.format("URL %s is not a valid HA connection string", url)).build().buildException();
            }
            additionalJDBCParams = url.substring(extraIdx + 1);
            if ((extraIdx = additionalJDBCParams.indexOf(58)) != -1) {
                if (extraIdx != 0) {
                    principal = additionalJDBCParams.substring(0, extraIdx);
                }
                additionalJDBCParams = additionalJDBCParams.substring(extraIdx + 1);
            } else {
                extraIdx = additionalJDBCParams.indexOf(59);
                if (extraIdx != -1) {
                    principal = additionalJDBCParams.substring(0, extraIdx);
                    additionalJDBCParams = String.valueOf(';');
                } else {
                    principal = additionalJDBCParams;
                    additionalJDBCParams = null;
                }
            }
        } else {
            extraIdx = url.indexOf(59, idx + 1);
            if (extraIdx != -1) {
                if (extraIdx != idx + 1) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.MALFORMED_CONNECTION_URL).setMessage(String.format("URL %s is not a valid HA connection string", url)).build().buildException();
                }
                additionalJDBCParams = url.substring(extraIdx);
            }
        }
        additionalJDBCParams = additionalJDBCParams != null ? (additionalJDBCParams.equals(String.valueOf(';')) ? null : additionalJDBCParams) : null;
        String name = properties.getProperty(PHOENIX_HA_GROUP_ATTR);
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.HA_INVALID_PROPERTIES).setMessage(String.format("HA group name can not be empty for HA URL %s", url)).build().buildException();
        }
        HAURLInfo haurlInfo = new HAURLInfo(name, principal, additionalJDBCParams);
        HAGroupInfo info = HighAvailabilityGroup.getHAGroupInfo(url, properties);
        URLS.computeIfAbsent(info, haGroupInfo -> new HashSet()).add(haurlInfo);
        return haurlInfo;
    }

    private static HAGroupInfo getHAGroupInfo(String url, Properties properties) throws SQLException {
        url = HighAvailabilityGroup.checkUrl(url);
        url = url.substring(url.indexOf("[") + 1, url.indexOf("]"));
        String[] urls = url.split("\\|");
        String name = properties.getProperty(PHOENIX_HA_GROUP_ATTR);
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.HA_INVALID_PROPERTIES).setMessage(String.format("HA group name can not be empty for HA URL %s", url)).build().buildException();
        }
        return new HAGroupInfo(name, urls[0], urls[1]);
    }

    private static String checkUrl(String url) throws SQLException {
        if (url.startsWith("jdbc:phoenix")) {
            url = url.substring("jdbc:phoenix".length() + 1);
        }
        if (!(url.contains("[") && url.contains("|") && url.contains("]"))) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.MALFORMED_CONNECTION_URL).setMessage(String.format("URL %s is not a valid HA connection string", url)).build().buildException();
        }
        return url;
    }

    public static Optional<HighAvailabilityGroup> get(String url, Properties properties) throws SQLException {
        HAGroupInfo info = HighAvailabilityGroup.getHAGroupInfo(url, properties);
        if (MISSING_CRR_GROUPS_CACHE.getIfPresent((Object)info) != null) {
            return Optional.empty();
        }
        HighAvailabilityGroup haGroup = GROUPS.computeIfAbsent(info, haGroupInfo -> new HighAvailabilityGroup((HAGroupInfo)haGroupInfo, properties));
        try {
            haGroup.init();
        }
        catch (Exception e) {
            GROUPS.remove(info);
            haGroup.close();
            try {
                CuratorFramework curator1 = (CuratorFramework)CURATOR_CACHE.getIfPresent((Object)info.getUrl1());
                CuratorFramework curator2 = (CuratorFramework)CURATOR_CACHE.getIfPresent((Object)info.getUrl2());
                if (curator1 != null && curator2 != null) {
                    Stat node1 = (Stat)curator1.checkExists().forPath(info.getZkPath());
                    Stat node2 = (Stat)curator2.checkExists().forPath(info.getZkPath());
                    if (node1 == null && node2 == null) {
                        MISSING_CRR_GROUPS_CACHE.put((Object)info, (Object)true);
                        return Optional.empty();
                    }
                }
            }
            catch (Exception e2) {
                LOG.error("HA group {} failed to initialized. Got exception when checking if znode exists on the two ZK clusters.", (Object)info, (Object)e2);
            }
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_ESTABLISH_CONNECTION).setMessage(String.format("Cannot start HA group %s for URL %s", haGroup, url)).setRootCause(e).build().buildException();
        }
        return Optional.of(haGroup);
    }

    static Optional<String> getFallbackCluster(String url, Properties properties) throws SQLException {
        HAGroupInfo haGroupInfo = HighAvailabilityGroup.getHAGroupInfo(url, properties);
        String fallback = properties.getProperty(PHOENIX_HA_SHOULD_FALLBACK_WHEN_MISSING_CRR_KEY, PHOENIX_HA_SHOULD_FALLBACK_WHEN_MISSING_CRR_DEFAULT);
        if (!Boolean.parseBoolean(fallback)) {
            LOG.info("Fallback to single cluster not enabled for the HA group {} per configuration. HA url: '{}'.", (Object)haGroupInfo.getName(), (Object)url);
            return Optional.empty();
        }
        Object fallbackCluster = properties.getProperty(PHOENIX_HA_FALLBACK_CLUSTER_KEY);
        if (StringUtils.isEmpty((CharSequence)fallbackCluster)) {
            LOG.error("Fallback to single cluster is enabled for the HA group {} but cluster key isempty per configuration 'phoenix.ha.fallback.cluster', and boostrap url cannot be used as fallback cluster as it can be different that urls present inClusterRoleRecords which are source of truth. HA url: '{}'.", (Object)haGroupInfo.getName(), (Object)url);
            return Optional.empty();
        }
        if (!((String)fallbackCluster).startsWith("jdbc:phoenix+zk")) {
            fallbackCluster = "jdbc:phoenix+zk:" + (String)fallbackCluster;
        }
        LOG.info("Falling back to single cluster '{}' for the HA group {} to serve HA connection request against url '{}'.", new Object[]{fallbackCluster, haGroupInfo.getName(), url});
        return Optional.of(fallbackCluster);
    }

    public static CuratorFramework getCurator(String jdbcUrl, Properties properties) throws IOException {
        try {
            return (CuratorFramework)CURATOR_CACHE.get((Object)jdbcUrl, () -> {
                CuratorFramework curator = HighAvailabilityGroup.createCurator(jdbcUrl, properties);
                try {
                    if (!curator.blockUntilConnected(4000, TimeUnit.MILLISECONDS)) {
                        throw new RuntimeException("Failed to connect to the CuratorFramework in timeout 4000 ms");
                    }
                }
                catch (Exception e) {
                    LOG.warn("HA cluster role manager getCurator thread for '{}' is interrupted, closing CuratorFramework", (Object)jdbcUrl, (Object)e);
                    curator.close();
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    throw e;
                }
                return curator;
            });
        }
        catch (Exception e) {
            LOG.error("Fail to get an active curator for url {}", (Object)jdbcUrl, (Object)e);
            CURATOR_CACHE.invalidate((Object)jdbcUrl);
            throw new IOException(e);
        }
    }

    private static CuratorFramework createCurator(String jdbcUrl, Properties properties) {
        if (jdbcUrl.startsWith("jdbc:phoenix")) {
            jdbcUrl = jdbcUrl.substring("jdbc:phoenix".length() + 1);
        }
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)jdbcUrl) ? 1 : 0) != 0, (Object)"JDBC url is empty!");
        jdbcUrl = jdbcUrl.replaceAll("\\\\:", "=");
        String[] parts = jdbcUrl.split(":");
        if (parts.length == 0 || parts.length > 3) {
            throw new IllegalArgumentException("Invalid JDBC url!" + jdbcUrl);
        }
        String zkUrl = parts[0].replaceAll("=", ":");
        String connectionTimeoutMsProp = properties.getProperty(PHOENIX_HA_ZK_CONNECTION_TIMEOUT_MS_KEY);
        int connectionTimeoutMs = !StringUtils.isEmpty((CharSequence)connectionTimeoutMsProp) ? Integer.parseInt(connectionTimeoutMsProp) : 4000;
        String sessionTimeoutMsProps = properties.getProperty(PHOENIX_HA_ZK_SESSION_TIMEOUT_MS_KEY);
        int sessionTimeoutMs = !StringUtils.isEmpty((CharSequence)sessionTimeoutMsProps) ? Integer.parseInt(sessionTimeoutMsProps) : 4000;
        RetryPolicy retryPolicy = HighAvailabilityGroup.createRetryPolicy(properties);
        CuratorFramework curator = CuratorFrameworkFactory.builder().connectString(zkUrl).namespace(PHOENIX_HA_ZOOKEEPER_ZNODE_NAMESPACE).connectionTimeoutMs(connectionTimeoutMs).sessionTimeoutMs(sessionTimeoutMs).retryPolicy(retryPolicy).canBeReadOnly(true).build();
        curator.start();
        return curator;
    }

    public static RetryPolicy createRetryPolicy(Properties properties) {
        if (properties == null) {
            return RETRY_POLICY;
        }
        String baseSleepTimeMsProp = properties.getProperty(PHOENIX_HA_ZK_RETRY_BASE_SLEEP_MS_KEY);
        int baseSleepTimeMs = StringUtils.isNotEmpty((CharSequence)baseSleepTimeMsProp) ? Integer.parseInt(baseSleepTimeMsProp) : 1000;
        String maxRetriesProp = properties.getProperty(PHOENIX_HA_ZK_RETRY_MAX_KEY);
        int maxRetries = StringUtils.isNotEmpty((CharSequence)maxRetriesProp) ? Integer.parseInt(maxRetriesProp) : 5;
        String maxSleepTimeMsProp = properties.getProperty(PHOENIX_HA_ZK_RETRY_MAX_SLEEP_MS_KEY);
        int maxSleepTimeMs = StringUtils.isNotEmpty((CharSequence)maxSleepTimeMsProp) ? Integer.parseInt(maxSleepTimeMsProp) : 10000;
        return new ExponentialBackoffRetry(baseSleepTimeMs, maxRetries, maxSleepTimeMs);
    }

    public void init() throws IOException {
        if (this.state != State.UNINITIALIZED) {
            return;
        }
        PairOfSameType newRoleManagers = new PairOfSameType((Object)new HAClusterRoleManager((String)this.info.urls.getFirst(), this.properties), (Object)new HAClusterRoleManager((String)this.info.urls.getSecond(), this.properties));
        if (!this.roleManagers.compareAndSet(null, (PairOfSameType<HAClusterRoleManager>)newRoleManagers)) {
            LOG.info("Someone already started role managers; waiting for that one...");
            this.waitForInitialization(this.properties);
            return;
        }
        Future<?> f1 = this.roleManagerExecutor.submit((Runnable)newRoleManagers.getFirst());
        Future<?> f2 = this.roleManagerExecutor.submit((Runnable)newRoleManagers.getSecond());
        try {
            this.waitForInitialization(this.properties);
        }
        catch (IOException e) {
            f1.cancel(true);
            f2.cancel(true);
            throw e;
        }
        assert (this.roleRecord != null);
        LOG.info("Initial cluster role for HA group {} is {}", (Object)this.info, (Object)this.roleRecord);
    }

    private void waitForInitialization(Properties properties) throws IOException {
        String connectionTimeoutMsProp = properties.getProperty(PHOENIX_HA_ZK_CONNECTION_TIMEOUT_MS_KEY);
        int timeout = !StringUtils.isEmpty((CharSequence)connectionTimeoutMsProp) ? Integer.parseInt(connectionTimeoutMsProp) : 4000;
        boolean started = false;
        try {
            started = this.roleManagerLatch.await(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            LOG.warn("Got interrupted when waiting for cluster role managers to start", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        if (!started) {
            LOG.warn("Timed out {}ms waiting for HA group '{}' to be initialized.", (Object)timeout, (Object)this.info);
            throw new IOException("Fail to initialize HA group " + this.info);
        }
    }

    public Connection connect(Properties properties, HAURLInfo haurlInfo) throws SQLException {
        if (this.state != State.READY) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_ESTABLISH_CONNECTION).setMessage("HA group is not ready!").setHaGroupInfo(this.info.toString()).build().buildException();
        }
        return this.roleRecord.getPolicy().provide(this, properties, haurlInfo);
    }

    PhoenixConnection connectActive(Properties properties, HAURLInfo haurlInfo) throws SQLException {
        try {
            Optional<String> url = this.roleRecord.getActiveUrl();
            if (this.state == State.READY && url.isPresent()) {
                boolean isActive;
                PhoenixConnection conn = this.connectToOneCluster(url.get(), properties, haurlInfo);
                try {
                    isActive = this.isActive(conn);
                }
                catch (Exception e) {
                    conn.close();
                    throw e;
                }
                if (this.state == State.READY && isActive) {
                    return conn;
                }
                conn.close();
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.HA_CLOSED_AFTER_FAILOVER).setMessage("Cluster is not active any more in HA group. Please retry.").setHaGroupInfo(this.info.toString()).build().buildException();
            }
            LOG.error("Not able to connect to active cluster, state: {}, active exist: {}", (Object)this.state, (Object)url.isPresent());
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.HA_NO_ACTIVE_CLUSTER).setMessage("Cannot connect to HA group because it has no active cluster").setHaGroupInfo(this.info.toString()).build().buildException();
        }
        catch (SQLException e) {
            LOG.error("Failed to connect to active cluster in HA group {}, record: {}", new Object[]{this.info, this.roleRecord, e});
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_ESTABLISH_CONNECTION).setMessage("Failed to connect to active cluster in HA group").setHaGroupInfo(this.info.toString()).setRootCause(e).build().buildException();
        }
    }

    boolean isActive(PhoenixConnection connection) {
        if (this.state != State.READY || connection == null) {
            return false;
        }
        return this.roleRecord.getActiveUrl().equals(Optional.of(JDBCUtil.formatUrl(connection.getURL())));
    }

    PhoenixConnection connectToOneCluster(String url, Properties properties, HAURLInfo haurlInfo) throws SQLException {
        Preconditions.checkNotNull((Object)url);
        if (url.startsWith("jdbc:phoenix")) {
            Preconditions.checkArgument((url.length() > "jdbc:phoenix".length() ? 1 : 0) != 0, (Object)("The URL '" + url + "' is not a valid Phoenix connection string"));
        }
        url = JDBCUtil.formatUrl(url, this.roleRecord.getRegistryType());
        String jdbcString = HighAvailabilityGroup.getJDBCUrl(url, haurlInfo, this.roleRecord.getRegistryType());
        ClusterRoleRecord.ClusterRole role = this.roleRecord.getRole(url);
        if (!role.canConnect()) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.HA_CLUSTER_CAN_NOT_CONNECT).setMessage("Can not connect to cluster '" + url + "' in '" + role + "' role").build().buildException();
        }
        Driver driver = DriverManager.getDriver(jdbcString);
        Preconditions.checkArgument((boolean)(driver instanceof PhoenixEmbeddedDriver), (Object)"No JDBC driver is registered for Phoenix high availability (HA) framework");
        return ((PhoenixEmbeddedDriver)driver).getConnectionQueryServices(jdbcString, properties).connect(jdbcString, properties);
    }

    @VisibleForTesting
    HAGroupInfo getGroupInfo() {
        return this.info;
    }

    Properties getProperties() {
        return this.properties;
    }

    public ClusterRoleRecord getRoleRecord() {
        return this.roleRecord;
    }

    void close() {
        this.roleManagerExecutor.shutdownNow();
        try {
            if (!this.roleManagerExecutor.awaitTermination(4000L, TimeUnit.MILLISECONDS)) {
                LOG.error("Fail to shut down role managers service for HA group: {}", (Object)this.info);
            }
        }
        catch (InterruptedException e) {
            LOG.warn("HA group {} close() got interrupted when closing role managers", (Object)this.info, (Object)e);
            this.roleManagerExecutor.shutdownNow();
            Thread.currentThread().interrupt();
        }
        this.state = State.CLOSED;
    }

    public String toString() {
        return this.roleRecord == null ? "HighAvailabilityGroup{roleRecord=null, info=" + this.info + ", state=" + this.state + "}" : "HighAvailabilityGroup{roleRecord=" + this.roleRecord + ", state=" + this.state + "}";
    }

    private synchronized boolean applyClusterRoleRecord(@NonNull ClusterRoleRecord newRoleRecord) {
        if (this.roleRecord == null) {
            this.roleRecord = newRoleRecord;
            this.state = State.READY;
            LOG.info("HA group {} is now in {} state after getting initial V{} role record: {}", new Object[]{this.info, this.state, this.roleRecord.getVersion(), this.roleRecord});
            LOG.debug("HA group {} is ready", (Object)this);
            return true;
        }
        if (!newRoleRecord.isNewerThan(this.roleRecord)) {
            LOG.warn("Does not apply new cluster role record as it does not have higher version. Existing record: {}, new record: {}", (Object)this.roleRecord, (Object)newRoleRecord);
            return false;
        }
        if (!this.roleRecord.hasSameInfo(newRoleRecord)) {
            LOG.error("New record {} has different HA group information from old record {}", (Object)newRoleRecord, (Object)this.roleRecord);
            return false;
        }
        ClusterRoleRecord oldRecord = this.roleRecord;
        this.state = State.IN_TRANSITION;
        LOG.info("HA group {} is in {} to set V{} record", new Object[]{this.info, this.state, newRoleRecord.getVersion()});
        Future<?> future = this.nodeChangedExecutor.submit(() -> {
            try {
                this.roleRecord.getPolicy().transitClusterRoleRecord(this, this.roleRecord, newRoleRecord);
            }
            catch (SQLException e) {
                throw new CompletionException(e);
            }
        });
        String transitionTimeoutProp = this.properties.getProperty(PHOENIX_HA_TRANSITION_TIMEOUT_MS_KEY);
        long maxTransitionTimeMs = StringUtils.isNotEmpty((CharSequence)transitionTimeoutProp) ? Long.parseLong(transitionTimeoutProp) : 300000L;
        try {
            future.get(maxTransitionTimeMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ie) {
            LOG.error("Got interrupted when transiting cluster roles for HA group {}", (Object)this.info, (Object)ie);
            future.cancel(true);
            Thread.currentThread().interrupt();
            return false;
        }
        catch (ExecutionException | TimeoutException e) {
            LOG.error("HA group {} failed to transit cluster roles per policy {} to new record {}", new Object[]{this.info, this.roleRecord.getPolicy(), newRoleRecord, e});
        }
        this.roleRecord = newRoleRecord;
        this.state = State.READY;
        LOG.info("HA group {} is in {} state after applying V{} role record. Old: {}, new: {}", new Object[]{this.info, this.state, this.roleRecord.getVersion(), oldRecord, this.roleRecord});
        LOG.debug("HA group is ready: {}", (Object)this);
        return true;
    }

    public static String getJDBCUrl(String url, HAURLInfo haURLInfo, ClusterRoleRecord.RegistryType type) {
        boolean extraSeparator = false;
        StringBuilder sb = new StringBuilder();
        switch (type) {
            case ZK: {
                sb.append("jdbc:phoenix+zk");
                break;
            }
            case RPC: {
                sb.append("jdbc:phoenix+rpc");
                extraSeparator = true;
                break;
            }
            case MASTER: {
                sb.append("jdbc:phoenix+master");
                extraSeparator = true;
                break;
            }
            default: {
                sb.append("jdbc:phoenix");
            }
        }
        sb.append(':');
        sb.append(url);
        if (haURLInfo != null) {
            if (ObjectUtils.anyNotNull((Object[])new Object[]{haURLInfo.getPrincipal(), haURLInfo.getAdditionalJDBCParams()})) {
                if (extraSeparator) {
                    sb.append(':').append(':');
                }
                sb.append(haURLInfo.getPrincipal() == null ? Character.valueOf(':') : ":" + haURLInfo.getPrincipal());
            }
            if (ObjectUtils.anyNotNull((Object[])new Object[]{haURLInfo.getAdditionalJDBCParams()})) {
                sb.append(':').append(haURLInfo.getAdditionalJDBCParams());
            }
        }
        return sb.toString();
    }

    static enum State {
        UNINITIALIZED,
        READY,
        IN_TRANSITION,
        CLOSED;

    }

    @VisibleForTesting
    static final class HAGroupInfo {
        private final String name;
        private final PairOfSameType<String> urls;

        HAGroupInfo(String name, String url1, String url2) {
            Preconditions.checkNotNull((Object)name);
            Preconditions.checkNotNull((Object)url1);
            Preconditions.checkNotNull((Object)url2);
            this.name = name;
            url1 = JDBCUtil.formatUrl(url1, ClusterRoleRecord.RegistryType.ZK);
            url2 = JDBCUtil.formatUrl(url2, ClusterRoleRecord.RegistryType.ZK);
            Preconditions.checkArgument((!url1.equals(url2) ? 1 : 0) != 0, (Object)"Two clusters have the same ZK!");
            this.urls = url1.compareTo(url2) > 0 ? new PairOfSameType((Object)url2, (Object)url1) : new PairOfSameType((Object)url1, (Object)url2);
        }

        public String getName() {
            return this.name;
        }

        public String getUrl1() {
            return (String)this.urls.getFirst();
        }

        public String getUrl2() {
            return (String)this.urls.getSecond();
        }

        public String getJDBCUrl1(HAURLInfo haURLInfo) {
            return HighAvailabilityGroup.getJDBCUrl(this.getUrl1(), haURLInfo, ClusterRoleRecord.RegistryType.ZK);
        }

        public String getJDBCUrl2(HAURLInfo haURLInfo) {
            return HighAvailabilityGroup.getJDBCUrl(this.getUrl2(), haURLInfo, ClusterRoleRecord.RegistryType.ZK);
        }

        String getZkPath() {
            return "/" + this.name;
        }

        public String toString() {
            return String.format("%s[%s|%s]", this.name, this.urls.getFirst(), this.urls.getSecond());
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (other.getClass() != this.getClass()) {
                return false;
            }
            HAGroupInfo otherInfo = (HAGroupInfo)other;
            return new EqualsBuilder().append((Object)this.name, (Object)otherInfo.name).append(this.urls, otherInfo.urls).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append((Object)this.name).append(this.urls).hashCode();
        }
    }

    private final class HAClusterRoleManager
    implements Runnable {
        private final String jdbcUrl;
        private final Properties properties;
        private NodeCache cache;

        HAClusterRoleManager(String jdbcUrl, Properties properties) {
            this.jdbcUrl = jdbcUrl;
            this.properties = properties;
        }

        @Override
        public void run() {
            String zpath = HighAvailabilityGroup.this.info.getZkPath();
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    this.cache = new NodeCache(HighAvailabilityGroup.getCurator(this.jdbcUrl, this.properties), zpath);
                    this.cache.getListenable().addListener(this::nodeChanged);
                    this.cache.start();
                    return;
                }
                catch (InterruptedException e) {
                    LOG.warn("HA cluster role manager thread for '{}' is interrupted, exiting", (Object)this.jdbcUrl, (Object)e);
                    break;
                }
                catch (Throwable t) {
                    LOG.warn("Fail to start node cache on '{}' for '{}'. Retry", new Object[]{this.jdbcUrl, zpath, t});
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        LOG.warn("HA cluster role manager thread for '{}' is interrupted, exiting", (Object)this.jdbcUrl, (Object)e);
                        break;
                    }
                }
            }
        }

        private void nodeChanged() {
            byte[] data = this.cache.getCurrentData().getData();
            Optional<ClusterRoleRecord> newRecordOptional = ClusterRoleRecord.fromJson(data);
            if (!newRecordOptional.isPresent()) {
                LOG.error("Fail to deserialize new record; keep current record {}", (Object)HighAvailabilityGroup.this.roleRecord);
                return;
            }
            ClusterRoleRecord newRecord = newRecordOptional.get();
            LOG.info("HA group {} got a record from cluster {}: {}", new Object[]{HighAvailabilityGroup.this.info.name, this.jdbcUrl, newRecord});
            if (HighAvailabilityGroup.this.applyClusterRoleRecord(newRecord)) {
                LOG.info("Successfully apply new cluster role record from cluster '{}', new record: {}", (Object)this.jdbcUrl, (Object)newRecord);
                HighAvailabilityGroup.this.roleManagerLatch.countDown();
            }
        }
    }
}

