/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;

@VisibleForTesting
public class HAURLInfo {
    private final String name;
    private final String principal;
    private final String additionalJDBCParams;

    HAURLInfo(String name, String principal, String additionalJDBCParams) {
        Preconditions.checkNotNull((Object)name);
        this.name = name;
        this.principal = principal;
        this.additionalJDBCParams = additionalJDBCParams;
    }

    HAURLInfo(String name, String principal) {
        this(name, principal, null);
    }

    HAURLInfo(String name) {
        this(name, null, null);
    }

    public String getName() {
        return this.name;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public String getAdditionalJDBCParams() {
        return this.additionalJDBCParams;
    }

    public String toString() {
        if (this.principal != null) {
            return String.format("%s[%s]", this.name, this.principal);
        }
        return this.name;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        HAURLInfo otherInfo = (HAURLInfo)other;
        return new EqualsBuilder().append((Object)this.name, (Object)otherInfo.name).append((Object)this.principal, (Object)otherInfo.principal).isEquals();
    }

    public int hashCode() {
        if (this.principal != null) {
            return new HashCodeBuilder(7, 47).append((Object)this.name).append((Object)this.principal).hashCode();
        }
        return new HashCodeBuilder(7, 47).append((Object)this.name).hashCode();
    }
}

