/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.phoenix.jdbc.ClusterRoleRecord;
import org.apache.phoenix.jdbc.HAGroupStoreClient;
import org.apache.phoenix.jdbc.PhoenixHAAdmin;
import org.apache.phoenix.query.QueryServicesOptions;

public class HAGroupStoreManager {
    private final boolean mutationBlockEnabled;
    private final Configuration conf;
    private static volatile Map<String, HAGroupStoreManager> INSTANCES = new ConcurrentHashMap<String, HAGroupStoreManager>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HAGroupStoreManager getInstance(Configuration conf) {
        String zkUrl = PhoenixHAAdmin.getLocalZkUrl(conf);
        HAGroupStoreManager result = INSTANCES.get(zkUrl);
        if (result != null) return result;
        Class<HAGroupStoreManager> clazz = HAGroupStoreManager.class;
        synchronized (HAGroupStoreManager.class) {
            result = INSTANCES.get(zkUrl);
            if (result != null) return result;
            result = new HAGroupStoreManager(conf);
            INSTANCES.put(zkUrl, result);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return result;
        }
    }

    private HAGroupStoreManager(Configuration conf) {
        this.mutationBlockEnabled = conf.getBoolean("phoenix.cluster.role.based.mutation.block.enabled", QueryServicesOptions.DEFAULT_CLUSTER_ROLE_BASED_MUTATION_BLOCK_ENABLED.booleanValue());
        this.conf = conf;
    }

    public boolean isMutationBlocked() throws IOException {
        if (this.mutationBlockEnabled) {
            HAGroupStoreClient haGroupStoreClient = HAGroupStoreClient.getInstance(this.conf);
            if (haGroupStoreClient != null) {
                return !haGroupStoreClient.getCRRsByClusterRole(ClusterRoleRecord.ClusterRole.ACTIVE_TO_STANDBY).isEmpty();
            }
            throw new IOException("HAGroupStoreClient is not initialized");
        }
        return false;
    }

    public void invalidateHAGroupStoreClient() throws Exception {
        HAGroupStoreClient haGroupStoreClient = HAGroupStoreClient.getInstance(this.conf);
        if (haGroupStoreClient == null) {
            throw new IOException("HAGroupStoreClient is not initialized");
        }
        haGroupStoreClient.rebuild();
    }
}

