/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.util.KerberosUtil;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.jdbc.MasterConnectionInfo;
import org.apache.phoenix.jdbc.RPCConnectionInfo;
import org.apache.phoenix.jdbc.ZKConnectionInfo;
import org.apache.phoenix.query.HBaseFactoryProvider;
import org.apache.phoenix.util.ReadOnlyProps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConnectionInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionInfo.class);
    protected static final Object KERBEROS_LOGIN_LOCK = new Object();
    protected static final char WINDOWS_SEPARATOR_CHAR = '\\';
    protected static final String REALM_EQUIVALENCY_WARNING_MSG = "Provided principal does not contain a realm and the default realm cannot be determined. Ignoring realm equivalency check.";
    protected static final String TERMINATOR = ";";
    protected static final String DELIMITERS = ";:";
    public static final String CLIENT_CONNECTION_REGISTRY_IMPL_CONF_KEY = "hbase.client.registry.impl";
    protected static final boolean HAS_MASTER_REGISTRY;
    protected static final boolean HAS_RPC_REGISTRY;
    private static volatile Configuration configuration;
    protected final boolean isConnectionless;
    protected final String principal;
    protected final String keytab;
    protected final User user;
    protected final String haGroup;
    protected final ConnectionType connectionType;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Configuration getCachedConfiguration() {
        if (configuration != null) return configuration;
        Class<ConnectionInfo> clazz = ConnectionInfo.class;
        synchronized (ConnectionInfo.class) {
            if (configuration != null) return configuration;
            configuration = HBaseFactoryProvider.getConfigurationFactory().getConfiguration();
            // ** MonitorExit[var0] (shouldn't be in output)
            return configuration;
        }
    }

    protected static SQLException getMalFormedUrlException(String url) {
        return new SQLExceptionInfo.Builder(SQLExceptionCode.MALFORMED_CONNECTION_URL).setMessage(url).build().buildException();
    }

    protected ConnectionInfo(boolean isConnectionless, String principal, String keytab, User user, String haGroup, ConnectionType connectionType) {
        this.isConnectionless = isConnectionless;
        this.principal = principal;
        this.keytab = keytab;
        this.user = user;
        this.haGroup = haGroup;
        this.connectionType = connectionType;
    }

    protected static String unescape(String escaped) {
        return escaped.replaceAll("\\\\:", "=");
    }

    protected static String escapeIPv6Literals(String unescaped) {
        String regex = "(\\[.*?\\])";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(unescaped);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String matchedText = matcher.group(1);
            String modifiedText = matchedText.replace(":", "~");
            matcher.appendReplacement(result, modifiedText);
        }
        matcher.appendTail(result);
        return result.toString();
    }

    public static ConnectionInfo createNoLogin(String url, ReadOnlyProps props, Properties info) throws SQLException {
        return ConnectionInfo.create(url, ConnectionInfo.getCachedConfiguration(), props, info, true);
    }

    public static ConnectionInfo create(String url, ReadOnlyProps props, Properties info) throws SQLException {
        return ConnectionInfo.create(url, ConnectionInfo.getCachedConfiguration(), props, info);
    }

    public static ConnectionInfo createNoLogin(String url, Configuration configuration, ReadOnlyProps props, Properties info) throws SQLException {
        return ConnectionInfo.create(url, configuration, props, info, true);
    }

    public static ConnectionInfo create(String url, Configuration configuration, ReadOnlyProps props, Properties info) throws SQLException {
        return ConnectionInfo.create(url, configuration, props, info, false);
    }

    public static ConnectionInfo create(String url, Configuration configuration, ReadOnlyProps props, Properties info, boolean doNotLogin) throws SQLException {
        Builder builder;
        url = url == null ? "" : url;
        boolean isIPv6 = ((String)url).contains("[") && ((String)url).contains("]");
        Object object = url = isIPv6 ? ConnectionInfo.unescape(ConnectionInfo.escapeIPv6Literals((String)url)) : ConnectionInfo.unescape((String)url);
        if (((String)url).isEmpty()) {
            url = "jdbc:phoenix";
        }
        if (!((String)url).startsWith("jdbc:phoenix")) {
            url = "jdbc:phoenix:" + (String)url;
        }
        if (configuration == null) {
            configuration = HBaseFactoryProvider.getConfigurationFactory().getConfiguration();
        }
        if (((String)url).toLowerCase().startsWith("jdbc:phoenix+zk")) {
            builder = new ZKConnectionInfo.Builder((String)url, configuration, props, info);
        } else if (((String)url).toLowerCase().startsWith("jdbc:phoenix+master")) {
            builder = new MasterConnectionInfo.Builder((String)url, configuration, props, info);
        } else if (((String)url).toLowerCase().startsWith("jdbc:phoenix+rpc")) {
            builder = new RPCConnectionInfo.Builder((String)url, configuration, props, info);
        } else if (((String)url).toLowerCase().startsWith("jdbc:phoenix")) {
            builder = MasterConnectionInfo.Builder.isMaster(configuration, props, info) ? new MasterConnectionInfo.Builder((String)url, configuration, props, info) : (RPCConnectionInfo.Builder.isRPC(configuration, props, info) ? new RPCConnectionInfo.Builder((String)url, configuration, props, info) : (ZKConnectionInfo.Builder.isZK(configuration, props, info) ? new ZKConnectionInfo.Builder((String)url, configuration, props, info) : (VersionInfo.getMajorVersion((String)VersionInfo.getVersion()) >= 3 ? new RPCConnectionInfo.Builder((String)url, configuration, props, info) : new ZKConnectionInfo.Builder((String)url, configuration, props, info))));
        } else {
            throw ConnectionInfo.getMalFormedUrlException((String)url);
        }
        builder.setDoNotLogin(doNotLogin);
        return ((Builder)builder).create();
    }

    protected static List<String> handleWindowsKeytab(String url, List<String> parts) throws SQLException {
        if (parts.size() == 7) {
            if (parts.get(6) != null && parts.get(6).startsWith("\\")) {
                parts.set(5, parts.get(5) + ":" + parts.get(6));
                parts.remove(6);
            } else {
                throw ConnectionInfo.getMalFormedUrlException(url);
            }
        }
        return parts;
    }

    static boolean isSameName(String currentName, String newName) throws IOException {
        return ConnectionInfo.isSameName(currentName, newName, null, ConnectionInfo.getDefaultKerberosRealm());
    }

    static String getDefaultKerberosRealm() {
        try {
            return KerberosUtil.getDefaultRealm();
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(REALM_EQUIVALENCY_WARNING_MSG, (Throwable)e);
            } else {
                LOGGER.warn(REALM_EQUIVALENCY_WARNING_MSG);
            }
            return null;
        }
    }

    static boolean isSameName(String currentName, String newName, String hostname) throws IOException {
        return ConnectionInfo.isSameName(currentName, newName, hostname, ConnectionInfo.getDefaultKerberosRealm());
    }

    static boolean isSameName(String currentName, String newName, String hostname, String defaultRealm) throws IOException {
        boolean newNameContainsRealm;
        boolean bl = newNameContainsRealm = ((String)newName).indexOf(64) != -1;
        if (((String)newName).contains("_HOST")) {
            if (newNameContainsRealm) {
                newName = SecurityUtil.getServerPrincipal((String)newName, (String)hostname);
            } else if (((String)newName).endsWith("/_HOST")) {
                newName = ((String)newName).substring(0, ((String)newName).length() - 5) + hostname;
            }
        }
        if (!newNameContainsRealm && defaultRealm != null) {
            return currentName.equals((String)newName + "@" + defaultRealm);
        }
        return currentName.equals(newName);
    }

    protected static Configuration mergeConfiguration(Configuration configIn, ReadOnlyProps props, Properties info) {
        Configuration config = configIn != null ? new Configuration(configIn) : new Configuration(false);
        if (props != null) {
            for (Map.Entry entry : props) {
                config.set((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (info != null) {
            for (Object key : info.keySet()) {
                config.set((String)key, info.getProperty((String)key));
            }
        }
        return config;
    }

    protected Map<String, String> getCommonProps() {
        HashMap<String, String> connectionProps = new HashMap<String, String>();
        if (this.getPrincipal() != null && this.getKeytab() != null) {
            connectionProps.put("hbase.myclient.principal", this.getPrincipal());
            connectionProps.put("hbase.myclient.keytab", this.getKeytab());
        }
        return connectionProps;
    }

    public abstract ReadOnlyProps asProps();

    public boolean isConnectionless() {
        return this.isConnectionless;
    }

    public String getKeytab() {
        return this.keytab;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public User getUser() {
        return this.user;
    }

    public String getHaGroup() {
        return this.haGroup;
    }

    public abstract String toUrl();

    public abstract String getZookeeperConnectionString();

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConnectionInfo other = (ConnectionInfo)obj;
        if (!other.user.equals((Object)this.user)) {
            return false;
        }
        if (this.principal == null ? other.principal != null : !this.principal.equals(other.principal)) {
            return false;
        }
        if (this.keytab == null ? other.keytab != null : !this.keytab.equals(other.keytab)) {
            return false;
        }
        if (this.haGroup == null ? other.haGroup != null : !this.haGroup.equals(other.haGroup)) {
            return false;
        }
        return this.connectionType.equals((Object)other.connectionType);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.principal == null ? 0 : this.principal.hashCode());
        result = 31 * result + (this.keytab == null ? 0 : this.keytab.hashCode());
        result = 31 * result + (this.haGroup == null ? 0 : this.haGroup.hashCode());
        result = 31 * result + this.user.hashCode();
        result = 31 * result + this.connectionType.hashCode();
        return result;
    }

    protected boolean anyNotNull(Object ... params) {
        for (Object param : params) {
            if (param == null) continue;
            return true;
        }
        return false;
    }

    public abstract ConnectionInfo withPrincipal(String var1);

    static {
        String version = VersionInfo.getVersion();
        if (VersionInfo.getMajorVersion((String)version) >= 3) {
            HAS_MASTER_REGISTRY = true;
            HAS_RPC_REGISTRY = true;
        } else if (VersionInfo.compareVersion((String)VersionInfo.getVersion(), (String)"2.3.0") < 0) {
            HAS_MASTER_REGISTRY = false;
            HAS_RPC_REGISTRY = false;
        } else if (VersionInfo.compareVersion((String)VersionInfo.getVersion(), (String)"2.5.0") < 0) {
            HAS_MASTER_REGISTRY = true;
            HAS_RPC_REGISTRY = false;
        } else {
            HAS_MASTER_REGISTRY = true;
            HAS_RPC_REGISTRY = true;
        }
    }

    public static enum ConnectionType {
        CLIENT,
        SERVER;

    }

    protected static abstract class Builder {
        protected boolean isConnectionless;
        protected String principal;
        protected String keytab;
        protected User user;
        protected String haGroup;
        protected boolean doNotLogin = false;
        protected ConnectionType connectionType;
        protected final String url;
        protected final Configuration config;
        protected final ReadOnlyProps props;
        protected final Properties info;

        public Builder(String url, Configuration config, ReadOnlyProps props, Properties info) {
            this.config = config;
            this.url = url;
            this.props = props;
            this.info = info;
            this.connectionType = ConnectionType.CLIENT;
            if (info != null && Boolean.valueOf(info.getProperty("IS_SERVER_CONNECTION")).booleanValue()) {
                this.connectionType = ConnectionType.SERVER;
            }
        }

        protected abstract ConnectionInfo create() throws SQLException;

        protected abstract void normalize() throws SQLException;

        protected String get(String key, String defValue) {
            String result = null;
            if (this.info != null) {
                result = this.info.getProperty(key);
            }
            if (result == null) {
                if (this.props != null) {
                    result = this.props.get(key);
                }
                if (result == null) {
                    result = this.config.get(key, defValue);
                }
            }
            return result;
        }

        protected String get(String key) {
            return this.get(key, null);
        }

        protected void setHaGroup() {
            if (this.info != null) {
                this.haGroup = this.info.getProperty("phoenix.ha.group.name");
            }
        }

        protected void setDoNotLogin(boolean doNotLogin) {
            this.doNotLogin = doNotLogin;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleKerberosAndLogin() throws SQLException {
            try {
                this.user = User.getCurrent();
            }
            catch (IOException e) {
                throw new RuntimeException("Couldn't get the current user!!", e);
            }
            if (null == this.user) {
                throw new RuntimeException("Acquired null user which should never happen");
            }
            if (this.isConnectionless) {
                return;
            }
            if (this.principal == null) {
                this.principal = this.get("hbase.myclient.principal");
            }
            if (this.keytab == null) {
                this.keytab = this.get("hbase.myclient.keytab");
            }
            if (this.principal == null && this.keytab != null) {
                throw ConnectionInfo.getMalFormedUrlException(this.url);
            }
            if (this.principal != null && this.keytab != null && !this.doNotLogin) {
                try {
                    UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
                    if (!currentUser.hasKerberosCredentials() || !ConnectionInfo.isSameName(currentUser.getUserName(), this.principal)) {
                        Object object = KERBEROS_LOGIN_LOCK;
                        synchronized (object) {
                            currentUser = UserGroupInformation.getCurrentUser();
                            if (!currentUser.hasKerberosCredentials() || !ConnectionInfo.isSameName(currentUser.getUserName(), this.principal)) {
                                LOGGER.info("Trying to connect to a secure cluster as {} with keytab {}", (Object)this.principal, (Object)this.keytab);
                                User.login((String)this.keytab, (String)SecurityUtil.getServerPrincipal((String)this.principal, (String)null));
                                this.user = User.getCurrent();
                                LOGGER.info("Successful login to secure cluster");
                            }
                        }
                    }
                    LOGGER.debug("Already logged in as {}", (Object)currentUser);
                }
                catch (IOException e) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_ESTABLISH_CONNECTION).setRootCause(e).build().buildException();
                }
            } else {
                LOGGER.debug("Principal and keytab not provided, not attempting Kerberos login");
            }
        }

        protected String normalizeHostsList(String quorum, Integer defaultPort) throws SQLException {
            String[] quorumParts = quorum.split(",");
            Object[] normalizedParts = new String[quorumParts.length];
            for (int i = 0; i < quorumParts.length; ++i) {
                CharSequence[] hostAndPort = quorumParts[i].trim().split(":");
                hostAndPort[0] = hostAndPort[0].replace('~', ':');
                if (hostAndPort.length == 1) {
                    normalizedParts[i] = hostAndPort[0].trim().toLowerCase() + ":" + defaultPort;
                    continue;
                }
                if (hostAndPort.length == 2) {
                    normalizedParts[i] = String.join((CharSequence)":", hostAndPort).trim().toLowerCase();
                    continue;
                }
                throw ConnectionInfo.getMalFormedUrlException(this.url);
            }
            Arrays.sort(normalizedParts);
            return String.join((CharSequence)",", (CharSequence[])normalizedParts);
        }

        protected StringTokenizer getTokenizerWithoutProtocol() throws SQLException {
            StringTokenizer tokenizer = new StringTokenizer(this.url, ConnectionInfo.DELIMITERS, true);
            try {
                if (!tokenizer.nextToken().toLowerCase().equals("jdbc")) {
                    throw new Exception();
                }
                if (!tokenizer.nextToken().toLowerCase().equals(":")) {
                    throw new Exception();
                }
                if (!tokenizer.nextToken().toLowerCase().startsWith("phoenix")) {
                    throw new Exception();
                }
            }
            catch (Exception e) {
                throw ConnectionInfo.getMalFormedUrlException(this.url);
            }
            return tokenizer;
        }

        protected static String get(String key, Configuration config, ReadOnlyProps props, Properties info) {
            String result = null;
            if (info != null) {
                result = info.getProperty(key);
            }
            if (result == null) {
                if (props != null) {
                    result = props.get(key);
                }
                if (result == null) {
                    result = config.get(key, null);
                }
            }
            return result;
        }
    }
}

