/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.security.User;
import org.apache.hbase.thirdparty.com.google.common.base.Strings;
import org.apache.phoenix.jdbc.ConnectionInfo;
import org.apache.phoenix.util.ReadOnlyProps;

public abstract class AbstractRPCConnectionInfo
extends ConnectionInfo {
    private static final String MASTER_ADDRS_KEY = "hbase.masters";
    private static final String MASTER_HOSTNAME_KEY = "hbase.master.hostname";
    protected String bootstrapServers;

    public String getBoostrapServers() {
        return this.bootstrapServers;
    }

    protected AbstractRPCConnectionInfo(boolean isConnectionless, String principal, String keytab, User user, String haGroup, ConnectionInfo.ConnectionType connectionType) {
        super(isConnectionless, principal, keytab, user, haGroup, connectionType);
    }

    @Override
    public String getZookeeperConnectionString() {
        throw new UnsupportedOperationException("MasterRegistry/RPCRegistry is used");
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bootstrapServers == null ? 0 : this.bootstrapServers.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        AbstractRPCConnectionInfo other = (AbstractRPCConnectionInfo)obj;
        return !(this.bootstrapServers == null ? other.bootstrapServers != null : !this.bootstrapServers.equals(other.bootstrapServers));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.bootstrapServers.replaceAll(":", "\\\\:"));
        if (this.anyNotNull(this.principal, this.keytab)) {
            sb.append((String)(this.principal == null ? ":::" : ":::" + this.principal));
        }
        if (this.anyNotNull(this.keytab)) {
            sb.append((String)(this.keytab == null ? ":" : ":" + this.keytab));
        }
        return sb.toString();
    }

    protected static abstract class Builder
    extends ConnectionInfo.Builder {
        String hostsList;
        String portString;
        Integer port;

        public Builder(String url, Configuration config, ReadOnlyProps props, Properties info) {
            super(url, config, props, info);
        }

        @Override
        protected ConnectionInfo create() throws SQLException {
            this.parse();
            this.normalize();
            this.handleKerberosAndLogin();
            this.setHaGroup();
            return this.build();
        }

        private void parse() throws SQLException {
            StringTokenizer tokenizer = this.getTokenizerWithoutProtocol();
            boolean wasSeparator = true;
            boolean first = true;
            ArrayList<Object> parts = new ArrayList<Object>(7);
            String token = null;
            while (tokenizer.hasMoreTokens() && !(token = tokenizer.nextToken()).equals(";")) {
                if (";:".contains(token)) {
                    if (wasSeparator && !first) {
                        parts.add(null);
                    }
                    wasSeparator = true;
                } else {
                    parts.add(token);
                    wasSeparator = false;
                }
                first = false;
                if (parts.size() <= 6) continue;
                throw ConnectionInfo.getMalFormedUrlException(this.url);
            }
            if (parts.size() == 6) {
                if (((String)parts.get(5)).startsWith("\\")) {
                    parts.set(4, (String)parts.get(4) + ":" + (String)parts.get(5));
                    parts.remove(5);
                } else {
                    throw ConnectionInfo.getMalFormedUrlException(this.url);
                }
            }
            while (parts.size() < 7) {
                parts.add(null);
            }
            this.hostsList = (String)parts.get(0);
            this.portString = (String)parts.get(1);
            if (this.portString != null) {
                try {
                    this.port = Integer.parseInt((String)parts.get(1));
                    if (this.port < 0) {
                        throw new Exception();
                    }
                }
                catch (Exception e) {
                    throw ConnectionInfo.getMalFormedUrlException(this.url);
                }
            }
            if (parts.get(2) != null && !((String)parts.get(2)).isEmpty()) {
                throw ConnectionInfo.getMalFormedUrlException(this.url);
            }
            this.principal = (String)parts.get(3);
            this.keytab = (String)parts.get(4);
        }

        protected void normalizeMaster() throws SQLException {
            if (this.hostsList != null && this.hostsList.isEmpty()) {
                this.hostsList = null;
            }
            if (this.portString != null && this.portString.isEmpty()) {
                this.portString = null;
            }
            if (this.portString != null) {
                try {
                    this.port = Integer.parseInt(this.portString);
                    if (this.port < 0) {
                        throw new Exception();
                    }
                }
                catch (Exception e) {
                    throw ConnectionInfo.getMalFormedUrlException(this.url);
                }
            }
            if (this.port == null) {
                this.port = this.getDefaultMasterPort();
            }
            this.isConnectionless = "none".equals(this.hostsList);
            if (this.isConnectionless) {
                if (this.port != null) {
                    throw ConnectionInfo.getMalFormedUrlException(this.url);
                }
                return;
            }
            if (this.hostsList == null) {
                this.hostsList = this.getMasterAddr(this.port);
                if (this.hostsList == null) {
                    throw ConnectionInfo.getMalFormedUrlException("Hbase masters are not specified and in URL, and are not set in the configuration files: " + this.url);
                }
            } else {
                this.hostsList = this.hostsList.replaceAll("=", ":");
            }
            this.hostsList = this.normalizeHostsList(this.hostsList, this.port);
        }

        private int getDefaultMasterPort() {
            String portString = this.get("hbase.master.port");
            this.port = portString == null ? Integer.valueOf(16000) : Integer.valueOf(Integer.parseInt(portString));
            if (this.port == 0) {
                return 16000;
            }
            return this.port;
        }

        private String getMasterAddr(int port) {
            String masterAddrFromConf = this.get(AbstractRPCConnectionInfo.MASTER_ADDRS_KEY);
            if (!Strings.isNullOrEmpty((String)masterAddrFromConf)) {
                return masterAddrFromConf;
            }
            String hostname = this.get(AbstractRPCConnectionInfo.MASTER_HOSTNAME_KEY);
            if (hostname != null) {
                return String.format("%s:%d", hostname, port);
            }
            return null;
        }

        protected abstract ConnectionInfo build();
    }
}

