/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.cache.ServerCacheClient;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.iterate.BaseResultIterators;
import org.apache.phoenix.iterate.ParallelIteratorFactory;
import org.apache.phoenix.iterate.ParallelScanGrouper;
import org.apache.phoenix.iterate.PeekingResultIterator;
import org.apache.phoenix.iterate.TableResultIterator;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.job.JobManager;
import org.apache.phoenix.monitoring.ReadMetricQueue;
import org.apache.phoenix.monitoring.ScanMetricsHolder;
import org.apache.phoenix.monitoring.TaskExecutionMetricsHolder;
import org.apache.phoenix.parse.HintNode;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.trace.util.Tracing;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.LogUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.ScanUtil;

public class SerialIterators
extends BaseResultIterators {
    private static final String NAME = "SERIAL";
    private final ParallelIteratorFactory iteratorFactory;
    private final Integer offset;

    public SerialIterators(QueryPlan plan, Integer perScanLimit, Integer offset, ParallelIteratorFactory iteratorFactory, ParallelScanGrouper scanGrouper, Scan scan, Map<ImmutableBytesPtr, ServerCacheClient.ServerCache> caches, QueryPlan dataPlan) throws SQLException {
        super(plan, perScanLimit, offset, scanGrouper, scan, caches, dataPlan);
        this.offset = offset;
        Preconditions.checkArgument((offset != null || perScanLimit != null || plan.getStatement().getHint().hasHint(HintNode.Hint.SERIAL) ? 1 : 0) != 0);
        this.iteratorFactory = iteratorFactory;
    }

    @Override
    protected boolean isSerial() {
        return true;
    }

    @Override
    protected void submitWork(List<List<Scan>> nestedScans, List<List<Pair<Scan, Future<PeekingResultIterator>>>> nestedFutures, Queue<PeekingResultIterator> allIterators, int estFlattenedSize, boolean isReverse, ParallelScanGrouper scanGrouper, final long maxQueryEndTime) {
        ThreadPoolExecutor executor = this.context.getConnection().getQueryServices().getExecutor();
        final String tableName = this.tableRef.getTable().getPhysicalName().getString();
        final TaskExecutionMetricsHolder taskMetrics = new TaskExecutionMetricsHolder(this.context.getReadMetricsQueue(), tableName);
        PhoenixConnection conn = this.context.getConnection();
        final long renewLeaseThreshold = conn.getQueryServices().getRenewLeaseThresholdMilliSeconds();
        int expectedListSize = nestedScans.size() * 10;
        List flattenedScans = Lists.newArrayListWithExpectedSize((int)expectedListSize);
        for (List<Scan> list : nestedScans) {
            flattenedScans.addAll(list);
        }
        if (!flattenedScans.isEmpty()) {
            if (isReverse) {
                flattenedScans = Lists.reverse((List)flattenedScans);
            }
            final ArrayList finalScans = flattenedScans;
            Future<PeekingResultIterator> future = executor.submit(Tracing.wrap(new JobManager.JobCallable<PeekingResultIterator>(){

                @Override
                public PeekingResultIterator call() throws Exception {
                    SerialIterator itr = new SerialIterator(finalScans, tableName, renewLeaseThreshold, SerialIterators.this.offset, SerialIterators.this.caches, maxQueryEndTime);
                    return itr;
                }

                @Override
                public Object getJobId() {
                    return SerialIterators.this;
                }

                @Override
                public TaskExecutionMetricsHolder getTaskExecutionMetric() {
                    return taskMetrics;
                }
            }, "Serial scanner for table: " + this.tableRef.getTable().getPhysicalName().getString()));
            nestedFutures.add(Collections.singletonList(new Pair((Object)((Scan)flattenedScans.get(0)), future)));
        }
    }

    @Override
    protected String getName() {
        return NAME;
    }

    private class SerialIterator
    implements PeekingResultIterator {
        private final List<Scan> scans;
        private final String tableName;
        private final long renewLeaseThreshold;
        private int index;
        private PeekingResultIterator currentIterator;
        private Integer remainingOffset;
        private Map<ImmutableBytesPtr, ServerCacheClient.ServerCache> caches;
        private final long maxQueryEndTime;

        private SerialIterator(List<Scan> flattenedScans, String tableName, long renewLeaseThreshold, Integer offset, Map<ImmutableBytesPtr, ServerCacheClient.ServerCache> caches, long maxQueryEndTime) throws SQLException {
            this.scans = Lists.newArrayListWithExpectedSize((int)flattenedScans.size());
            this.tableName = tableName;
            this.renewLeaseThreshold = renewLeaseThreshold;
            this.scans.addAll(flattenedScans);
            this.remainingOffset = offset;
            this.caches = caches;
            this.maxQueryEndTime = maxQueryEndTime;
            if (this.remainingOffset != null) {
                this.scans.get(this.scans.size() - 1).setAttribute("LAST_SCAN", Bytes.toBytes((boolean)Boolean.TRUE));
            }
        }

        private PeekingResultIterator currentIterator() throws SQLException {
            if (this.currentIterator == null) {
                this.currentIterator = this.nextIterator();
                return this.currentIterator;
            }
            if (this.currentIterator.peek() == null) {
                this.currentIterator.close();
                this.currentIterator = this.nextIterator();
            }
            return this.currentIterator;
        }

        private PeekingResultIterator nextIterator() throws SQLException {
            if (this.index >= this.scans.size()) {
                return EMPTY_ITERATOR;
            }
            ReadMetricQueue readMetrics = SerialIterators.this.context.getReadMetricsQueue();
            while (this.index < this.scans.size()) {
                Scan currentScan = this.scans.get(this.index++);
                if (this.remainingOffset != null) {
                    currentScan.setAttribute("_RowOffset", PInteger.INSTANCE.toBytes(this.remainingOffset));
                }
                ScanMetricsHolder scanMetricsHolder = ScanMetricsHolder.getInstance(readMetrics, this.tableName, currentScan, SerialIterators.this.context.getConnection().getLogLevel());
                TableResultIterator itr = new TableResultIterator(SerialIterators.this.mutationState, currentScan, scanMetricsHolder, this.renewLeaseThreshold, SerialIterators.this.plan, SerialIterators.this.scanGrouper, this.caches, this.maxQueryEndTime);
                PeekingResultIterator peekingItr = SerialIterators.this.iteratorFactory.newIterator(SerialIterators.this.context, itr, currentScan, this.tableName, SerialIterators.this.plan);
                long startTime = EnvironmentEdgeManager.currentTimeMillis();
                Tuple tuple = peekingItr.peek();
                if (BaseResultIterators.LOGGER.isDebugEnabled()) {
                    BaseResultIterators.LOGGER.debug(LogUtil.addCustomAnnotations("Id: " + SerialIterators.this.scanId + ", Time: " + (EnvironmentEdgeManager.currentTimeMillis() - startTime) + "ms, Table: " + this.tableName + ", Scan: " + currentScan, ScanUtil.getCustomAnnotations(currentScan)));
                }
                if (tuple == null) {
                    peekingItr.close();
                    continue;
                }
                this.remainingOffset = QueryUtil.getRemainingOffset(tuple);
                if (this.remainingOffset != null) {
                    peekingItr.next();
                    peekingItr.close();
                    continue;
                }
                SerialIterators.this.context.getConnection().addIteratorForLeaseRenewal(itr);
                return peekingItr;
            }
            return EMPTY_ITERATOR;
        }

        @Override
        public Tuple next() throws SQLException {
            return this.currentIterator().next();
        }

        @Override
        public void explain(List<String> planSteps) {
        }

        @Override
        public void explain(List<String> planSteps, ExplainPlanAttributes.ExplainPlanAttributesBuilder explainPlanAttributesBuilder) {
        }

        @Override
        public void close() throws SQLException {
            if (this.currentIterator != null) {
                this.currentIterator.close();
            }
        }

        @Override
        public Tuple peek() throws SQLException {
            return this.currentIterator().peek();
        }
    }
}

