/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.iterate.ScanningResultPostDummyResultCaller;
import org.apache.phoenix.iterate.ScanningResultPostValidResultCaller;
import org.apache.phoenix.monitoring.CombinableMetric;
import org.apache.phoenix.monitoring.GlobalClientMetrics;
import org.apache.phoenix.monitoring.ScanMetricsHolder;
import org.apache.phoenix.schema.tuple.ResultTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.util.ClientUtil;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.ScanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanningResultIterator
implements ResultIterator {
    private static final Logger LOG = LoggerFactory.getLogger(ScanningResultIterator.class);
    private final ResultScanner scanner;
    private final ScanMetricsHolder scanMetricsHolder;
    boolean scanMetricsUpdated;
    boolean scanMetricsEnabled;
    private StatementContext context;
    private static boolean throwExceptionIfScannerClosedForceFully = false;
    private final boolean isMapReduceContext;
    private final long maxQueryEndTime;
    private long dummyRowCounter = 0L;
    private final ScanningResultPostDummyResultCaller scanningResultPostDummyResultCaller;
    private final ScanningResultPostValidResultCaller scanningResultPostValidResultCaller;

    public ScanningResultIterator(ResultScanner scanner, Scan scan, ScanMetricsHolder scanMetricsHolder, StatementContext context, boolean isMapReduceContext, long maxQueryEndTime) {
        this.scanner = scanner;
        this.scanMetricsHolder = scanMetricsHolder;
        this.context = context;
        this.scanMetricsUpdated = false;
        this.scanMetricsEnabled = scan.isScanMetricsEnabled();
        this.isMapReduceContext = isMapReduceContext;
        this.maxQueryEndTime = maxQueryEndTime;
        Class dummyResultCallerClazz = context.getConnection().getQueryServices().getConfiguration().getClass("phoenix.scanning.result.post.dummy.process", ScanningResultPostDummyResultCaller.class, ScanningResultPostDummyResultCaller.class);
        this.scanningResultPostDummyResultCaller = (ScanningResultPostDummyResultCaller)ReflectionUtils.newInstance((Class)dummyResultCallerClazz, (Configuration)context.getConnection().getQueryServices().getConfiguration());
        Class validResultCallerClazz = context.getConnection().getQueryServices().getConfiguration().getClass("phoenix.scanning.result.post.valid.process", ScanningResultPostValidResultCaller.class, ScanningResultPostValidResultCaller.class);
        this.scanningResultPostValidResultCaller = (ScanningResultPostValidResultCaller)ReflectionUtils.newInstance((Class)validResultCallerClazz, (Configuration)context.getConnection().getQueryServices().getConfiguration());
    }

    @Override
    public void close() throws SQLException {
        this.scanner.close();
        this.updateMetrics();
    }

    private void changeMetric(CombinableMetric metric, Long value) {
        if (value != null) {
            metric.change(value);
        }
    }

    private void changeMetric(GlobalClientMetrics metric, Long value) {
        if (value != null) {
            metric.update(value);
        }
    }

    private void updateMetrics() {
        if (this.scanMetricsEnabled && !this.scanMetricsUpdated) {
            ScanMetrics scanMetrics = this.scanner.getScanMetrics();
            Map scanMetricsMap = scanMetrics.getMetricsMap();
            this.scanMetricsHolder.setScanMetricMap(scanMetricsMap);
            this.changeMetric(this.scanMetricsHolder.getCountOfRPCcalls(), (Long)scanMetricsMap.get("RPC_CALLS"));
            this.changeMetric(this.scanMetricsHolder.getCountOfRemoteRPCcalls(), (Long)scanMetricsMap.get("REMOTE_RPC_CALLS"));
            this.changeMetric(this.scanMetricsHolder.getSumOfMillisSecBetweenNexts(), (Long)scanMetricsMap.get("MILLIS_BETWEEN_NEXTS"));
            this.changeMetric(this.scanMetricsHolder.getCountOfNSRE(), (Long)scanMetricsMap.get("NOT_SERVING_REGION_EXCEPTION"));
            this.changeMetric(this.scanMetricsHolder.getCountOfBytesInResults(), (Long)scanMetricsMap.get("BYTES_IN_RESULTS"));
            this.changeMetric(this.scanMetricsHolder.getCountOfBytesInRemoteResults(), (Long)scanMetricsMap.get("BYTES_IN_REMOTE_RESULTS"));
            this.changeMetric(this.scanMetricsHolder.getCountOfRegions(), (Long)scanMetricsMap.get("REGIONS_SCANNED"));
            this.changeMetric(this.scanMetricsHolder.getCountOfRPCRetries(), (Long)scanMetricsMap.get("RPC_RETRIES"));
            this.changeMetric(this.scanMetricsHolder.getCountOfRemoteRPCRetries(), (Long)scanMetricsMap.get("REMOTE_RPC_RETRIES"));
            this.changeMetric(this.scanMetricsHolder.getCountOfRowsScanned(), (Long)scanMetricsMap.get("ROWS_SCANNED"));
            this.changeMetric(this.scanMetricsHolder.getCountOfRowsFiltered(), (Long)scanMetricsMap.get("ROWS_FILTERED"));
            this.changeMetric(this.scanMetricsHolder.getCountOfBytesScanned(), (Long)scanMetricsMap.get("BYTES_IN_RESULTS"));
            this.changeMetric(this.scanMetricsHolder.getCountOfRowsPaged(), (Long)this.dummyRowCounter);
            this.changeMetric(GlobalClientMetrics.GLOBAL_SCAN_BYTES, (Long)scanMetricsMap.get("BYTES_IN_RESULTS"));
            this.changeMetric(GlobalClientMetrics.GLOBAL_HBASE_COUNT_RPC_CALLS, (Long)scanMetricsMap.get("RPC_CALLS"));
            this.changeMetric(GlobalClientMetrics.GLOBAL_HBASE_COUNT_REMOTE_RPC_CALLS, (Long)scanMetricsMap.get("REMOTE_RPC_CALLS"));
            this.changeMetric(GlobalClientMetrics.GLOBAL_HBASE_COUNT_MILLS_BETWEEN_NEXTS, (Long)scanMetricsMap.get("MILLIS_BETWEEN_NEXTS"));
            this.changeMetric(GlobalClientMetrics.GLOBAL_HBASE_COUNT_NOT_SERVING_REGION_EXCEPTION, (Long)scanMetricsMap.get("NOT_SERVING_REGION_EXCEPTION"));
            this.changeMetric(GlobalClientMetrics.GLOBAL_HBASE_COUNT_BYTES_REGION_SERVER_RESULTS, (Long)scanMetricsMap.get("BYTES_IN_RESULTS"));
            this.changeMetric(GlobalClientMetrics.GLOBAL_HBASE_COUNT_BYTES_IN_REMOTE_RESULTS, (Long)scanMetricsMap.get("BYTES_IN_REMOTE_RESULTS"));
            this.changeMetric(GlobalClientMetrics.GLOBAL_HBASE_COUNT_SCANNED_REGIONS, (Long)scanMetricsMap.get("REGIONS_SCANNED"));
            this.changeMetric(GlobalClientMetrics.GLOBAL_HBASE_COUNT_RPC_RETRIES, (Long)scanMetricsMap.get("RPC_RETRIES"));
            this.changeMetric(GlobalClientMetrics.GLOBAL_HBASE_COUNT_REMOTE_RPC_RETRIES, (Long)scanMetricsMap.get("REMOTE_RPC_RETRIES"));
            this.changeMetric(GlobalClientMetrics.GLOBAL_HBASE_COUNT_ROWS_SCANNED, (Long)scanMetricsMap.get("ROWS_SCANNED"));
            this.changeMetric(GlobalClientMetrics.GLOBAL_HBASE_COUNT_ROWS_FILTERED, (Long)scanMetricsMap.get("ROWS_FILTERED"));
            this.changeMetric(GlobalClientMetrics.GLOBAL_PAGED_ROWS_COUNTER, (Long)this.dummyRowCounter);
            this.scanMetricsUpdated = true;
        }
    }

    @Override
    public Tuple next() throws SQLException {
        try {
            Result result = this.scanner.next();
            while (result != null && (result.isEmpty() || ScanUtil.isDummy(result))) {
                ++this.dummyRowCounter;
                long timeOutForScan = this.maxQueryEndTime - EnvironmentEdgeManager.currentTimeMillis();
                if (!this.context.getHasFirstValidResult() && timeOutForScan < 0L) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.OPERATION_TIMED_OUT).setMessage(". Query couldn't be completed in the allotted time : " + this.context.getStatement().getQueryTimeoutInMillis() + " ms").build().buildException();
                }
                if (!this.isMapReduceContext && (this.context.getConnection().isClosing() || this.context.getConnection().isClosed())) {
                    LOG.warn("Closing ResultScanner as Connection is already closed or in middle of closing");
                    if (throwExceptionIfScannerClosedForceFully) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.FAILED_KNOWINGLY_FOR_TEST).build().buildException();
                    }
                    this.close();
                    return null;
                }
                this.processAfterRetrievingDummyResult();
                result = this.scanner.next();
            }
            if (result == null) {
                this.close();
                return null;
            }
            this.context.setHasFirstValidResult(true);
            this.processAfterRetrievingValidResult();
            return new ResultTuple(result);
        }
        catch (IOException e) {
            throw ClientUtil.parseServerException(e);
        }
    }

    private void processAfterRetrievingDummyResult() {
        this.scanningResultPostDummyResultCaller.postDummyProcess();
    }

    private void processAfterRetrievingValidResult() {
        this.scanningResultPostValidResultCaller.postValidRowProcess();
    }

    @Override
    public void explain(List<String> planSteps) {
    }

    @Override
    public void explain(List<String> planSteps, ExplainPlanAttributes.ExplainPlanAttributesBuilder explainPlanAttributesBuilder) {
    }

    public String toString() {
        return "ScanningResultIterator [scanner=" + this.scanner + "]";
    }

    public ResultScanner getScanner() {
        return this.scanner;
    }

    @VisibleForTesting
    public static void setIsScannerClosedForcefully(boolean throwException) {
        throwExceptionIfScannerClosedForceFully = throwException;
    }
}

