/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.sql.SQLException;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.aggregator.Aggregators;
import org.apache.phoenix.iterate.BaseGroupedAggregatingResultIterator;
import org.apache.phoenix.iterate.PeekingResultIterator;
import org.apache.phoenix.schema.tuple.SingleKeyValueTuple;
import org.apache.phoenix.schema.tuple.Tuple;

public class GroupedAggregatingResultIterator
extends BaseGroupedAggregatingResultIterator {
    public GroupedAggregatingResultIterator(PeekingResultIterator resultIterator, Aggregators aggregators) {
        super(resultIterator, aggregators);
    }

    @Override
    protected ImmutableBytesWritable getGroupingKey(Tuple tuple, ImmutableBytesWritable ptr) throws SQLException {
        tuple.getKey(ptr);
        return ptr;
    }

    @Override
    protected Tuple wrapKeyValueAsResult(Cell keyValue) throws SQLException {
        return new SingleKeyValueTuple(keyValue);
    }

    public String toString() {
        return "GroupedAggregatingResultIterator [resultIterator=" + this.resultIterator + ", aggregators=" + this.aggregators + "]";
    }
}

