/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.compile.GroupByCompiler;
import org.apache.phoenix.compile.OrderByCompiler;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.filter.BooleanExpressionFilter;
import org.apache.phoenix.filter.DistinctPrefixFilter;
import org.apache.phoenix.filter.EmptyColumnOnlyFilter;
import org.apache.phoenix.parse.HintNode;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.RowKeySchema;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExplainTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExplainTable.class);
    private static final List<KeyRange> EVERYTHING = Collections.singletonList(KeyRange.EVERYTHING_RANGE);
    public static final String POINT_LOOKUP_ON_STRING = "POINT LOOKUP ON ";
    public static final String REGION_LOCATIONS = " (region locations = ";
    protected final StatementContext context;
    protected final TableRef tableRef;
    protected final GroupByCompiler.GroupBy groupBy;
    protected final OrderByCompiler.OrderBy orderBy;
    protected final HintNode hint;
    protected final Integer limit;
    protected final Integer offset;

    public ExplainTable(StatementContext context, TableRef table) {
        this(context, table, GroupByCompiler.GroupBy.EMPTY_GROUP_BY, OrderByCompiler.OrderBy.EMPTY_ORDER_BY, HintNode.EMPTY_HINT_NODE, null, null);
    }

    public ExplainTable(StatementContext context, TableRef table, GroupByCompiler.GroupBy groupBy, OrderByCompiler.OrderBy orderBy, HintNode hintNode, Integer limit, Integer offset) {
        this.context = context;
        this.tableRef = table;
        this.groupBy = groupBy;
        this.orderBy = orderBy;
        this.hint = hintNode;
        this.limit = limit;
        this.offset = offset;
    }

    private String explainSkipScan() {
        StringBuilder buf = new StringBuilder();
        ScanRanges scanRanges = this.context.getScanRanges();
        if (scanRanges.isPointLookup()) {
            int keyCount;
            buf.append(POINT_LOOKUP_ON_STRING + keyCount + " KEY" + ((keyCount = scanRanges.getPointLookupCount()) > 1 ? "S " : " "));
        } else if (scanRanges.useSkipScanFilter()) {
            buf.append("SKIP SCAN ");
            int count = 1;
            boolean hasRanges = false;
            int nSlots = scanRanges.getBoundSlotCount();
            for (int i = 0; i < nSlots; ++i) {
                List<KeyRange> ranges = scanRanges.getRanges().get(i);
                count *= ranges.size();
                for (KeyRange range : ranges) {
                    hasRanges |= !range.isSingleKey();
                }
            }
            buf.append("ON ");
            buf.append(count);
            buf.append(hasRanges ? " RANGE" : " KEY");
            buf.append(count > 1 ? "S " : " ");
        } else {
            buf.append("RANGE SCAN ");
        }
        return buf.toString();
    }

    protected void explain(String prefix, List<String> planSteps, ExplainPlanAttributes.ExplainPlanAttributesBuilder explainPlanAttributesBuilder, List<HRegionLocation> regionLocations) {
        Set<PColumn> dataColumns;
        StringBuilder buf = new StringBuilder(prefix);
        ScanRanges scanRanges = this.context.getScanRanges();
        Scan scan = this.context.getScan();
        if (scan.getConsistency() != Consistency.STRONG) {
            buf.append("TIMELINE-CONSISTENCY ");
        }
        if (this.hint.hasHint(HintNode.Hint.SMALL)) {
            buf.append((Object)HintNode.Hint.SMALL).append(" ");
        }
        if (OrderByCompiler.OrderBy.REV_ROW_KEY_ORDER_BY.equals(this.orderBy)) {
            buf.append("REVERSE ");
        }
        String scanTypeDetails = scanRanges.isEverything() ? "FULL SCAN " : this.explainSkipScan();
        buf.append(scanTypeDetails);
        Object tableName = this.tableRef.getTable().getPhysicalName().getString();
        if (this.tableRef.getTable().getIndexType() == PTable.IndexType.LOCAL) {
            String indexName = this.tableRef.getTable().getName().getString();
            if (this.tableRef.getTable().getViewIndexId() != null && indexName.contains("#")) {
                int lastIndexOf = indexName.lastIndexOf("#");
                indexName = indexName.substring(lastIndexOf + 1);
            }
            tableName = indexName + "(" + (String)tableName + ")";
        }
        buf.append("OVER ").append((String)tableName);
        if (!scanRanges.isPointLookup()) {
            buf.append(this.appendKeyRanges());
        }
        planSteps.add(buf.toString());
        if (explainPlanAttributesBuilder != null) {
            explainPlanAttributesBuilder.setConsistency(scan.getConsistency());
            if (this.hint.hasHint(HintNode.Hint.SMALL)) {
                explainPlanAttributesBuilder.setHint(HintNode.Hint.SMALL);
            }
            if (OrderByCompiler.OrderBy.REV_ROW_KEY_ORDER_BY.equals(this.orderBy)) {
                explainPlanAttributesBuilder.setClientSortedBy("REVERSE");
            }
            explainPlanAttributesBuilder.setExplainScanType(scanTypeDetails);
            explainPlanAttributesBuilder.setTableName((String)tableName);
            if (!scanRanges.isPointLookup()) {
                explainPlanAttributesBuilder.setKeyRanges(this.appendKeyRanges());
            }
        }
        if (this.context.getScan() != null && this.tableRef.getTable().getRowTimestampColPos() != -1) {
            TimeRange range = this.context.getScan().getTimeRange();
            planSteps.add("    ROW TIMESTAMP FILTER [" + range.getMin() + ", " + range.getMax() + ")");
            if (explainPlanAttributesBuilder != null) {
                explainPlanAttributesBuilder.setScanTimeRangeMin(range.getMin());
                explainPlanAttributesBuilder.setScanTimeRangeMax(range.getMax());
            }
        }
        PageFilter pageFilter = null;
        FirstKeyOnlyFilter firstKeyOnlyFilter = null;
        EmptyColumnOnlyFilter emptyColumnOnlyFilter = null;
        BooleanExpressionFilter whereFilter = null;
        DistinctPrefixFilter distinctFilter = null;
        Iterator<Filter> filterIterator = ScanUtil.getFilterIterator(scan);
        if (filterIterator.hasNext()) {
            do {
                Filter filter;
                if ((filter = filterIterator.next()) instanceof FirstKeyOnlyFilter) {
                    firstKeyOnlyFilter = (FirstKeyOnlyFilter)filter;
                    continue;
                }
                if (filter instanceof EmptyColumnOnlyFilter) {
                    emptyColumnOnlyFilter = (EmptyColumnOnlyFilter)filter;
                    continue;
                }
                if (filter instanceof PageFilter) {
                    pageFilter = (PageFilter)filter;
                    continue;
                }
                if (filter instanceof BooleanExpressionFilter) {
                    whereFilter = (BooleanExpressionFilter)filter;
                    continue;
                }
                if (!(filter instanceof DistinctPrefixFilter)) continue;
                distinctFilter = (DistinctPrefixFilter)filter;
            } while (filterIterator.hasNext());
        }
        if ((dataColumns = this.context.getDataColumns()) != null && !dataColumns.isEmpty()) {
            planSteps.add("    SERVER MERGE " + dataColumns.toString());
            if (explainPlanAttributesBuilder != null) {
                explainPlanAttributesBuilder.setServerMergeColumns(dataColumns);
            }
        }
        String whereFilterStr = null;
        if (whereFilter != null) {
            whereFilterStr = whereFilter.toString();
        } else {
            byte[] expBytes = scan.getAttribute("_IndexFilterStr");
            if (expBytes == null) {
                expBytes = scan.getAttribute("_LocalIndexFilterStr");
            }
            if (expBytes != null) {
                whereFilterStr = Bytes.toString((byte[])expBytes);
            }
        }
        if (whereFilterStr != null) {
            String serverWhereFilter = "SERVER FILTER BY " + (firstKeyOnlyFilter == null ? "" : "FIRST KEY ONLY AND ") + (emptyColumnOnlyFilter == null ? "" : "EMPTY COLUMN ONLY AND ") + whereFilterStr;
            planSteps.add("    " + serverWhereFilter);
            if (explainPlanAttributesBuilder != null) {
                explainPlanAttributesBuilder.setServerWhereFilter(serverWhereFilter);
            }
        } else if (firstKeyOnlyFilter != null) {
            planSteps.add("    SERVER FILTER BY FIRST KEY ONLY");
            if (explainPlanAttributesBuilder != null) {
                explainPlanAttributesBuilder.setServerWhereFilter("SERVER FILTER BY FIRST KEY ONLY");
            }
        } else if (emptyColumnOnlyFilter != null) {
            planSteps.add("    SERVER FILTER BY EMPTY COLUMN ONLY");
            if (explainPlanAttributesBuilder != null) {
                explainPlanAttributesBuilder.setServerWhereFilter("SERVER FILTER BY EMPTY COLUMN ONLY");
            }
        }
        if (distinctFilter != null) {
            String serverDistinctFilter = "SERVER DISTINCT PREFIX FILTER OVER " + this.groupBy.getExpressions().toString();
            planSteps.add("    " + serverDistinctFilter);
            if (explainPlanAttributesBuilder != null) {
                explainPlanAttributesBuilder.setServerDistinctFilter(serverDistinctFilter);
            }
        }
        if (!this.orderBy.getOrderByExpressions().isEmpty() && this.groupBy.isEmpty()) {
            String orderByExpressions = "SERVER" + (String)(this.limit == null ? "" : " TOP " + this.limit + " ROW" + (this.limit == 1 ? "" : "S")) + " SORTED BY " + this.orderBy.getOrderByExpressions().toString();
            planSteps.add("    " + orderByExpressions);
            if (explainPlanAttributesBuilder != null) {
                if (this.limit != null) {
                    explainPlanAttributesBuilder.setServerRowLimit(this.limit.longValue());
                }
                explainPlanAttributesBuilder.setServerSortedBy(this.orderBy.getOrderByExpressions().toString());
            }
        } else {
            if (this.offset != null) {
                planSteps.add("    SERVER OFFSET " + this.offset);
            }
            Long limit = null;
            if (pageFilter != null) {
                limit = pageFilter.getPageSize();
            } else {
                byte[] limitBytes = scan.getAttribute("_IndexLimit");
                if (limitBytes != null) {
                    limit = Bytes.toLong((byte[])limitBytes);
                }
            }
            if (limit != null) {
                planSteps.add("    SERVER " + limit + " ROW LIMIT");
            }
            if (explainPlanAttributesBuilder != null) {
                explainPlanAttributesBuilder.setServerOffset(this.offset);
                if (pageFilter != null) {
                    explainPlanAttributesBuilder.setServerRowLimit(pageFilter.getPageSize());
                }
            }
        }
        Integer groupByLimit = null;
        byte[] groupByLimitBytes = scan.getAttribute("_GroupByLimit");
        if (groupByLimitBytes != null) {
            groupByLimit = (Integer)PInteger.INSTANCE.toObject(groupByLimitBytes);
        }
        this.getRegionLocations(planSteps, explainPlanAttributesBuilder, regionLocations);
        this.groupBy.explain(planSteps, groupByLimit, explainPlanAttributesBuilder);
        if (scan.getAttribute("_SpecificArrayIndex") != null) {
            planSteps.add("    SERVER ARRAY ELEMENT PROJECTION");
            if (explainPlanAttributesBuilder != null) {
                explainPlanAttributesBuilder.setServerArrayElementProjection(true);
            }
        }
        if (scan.getAttribute("_JsonValueFunction") != null || scan.getAttribute("_JsonQueryFunction") != null) {
            planSteps.add("    SERVER JSON FUNCTION PROJECTION");
        }
    }

    private void getRegionLocations(List<String> planSteps, ExplainPlanAttributes.ExplainPlanAttributesBuilder explainPlanAttributesBuilder, List<HRegionLocation> regionLocations) {
        String regionLocationPlan = this.getRegionLocationsForExplainPlan(explainPlanAttributesBuilder, regionLocations);
        if (regionLocationPlan.length() > 0) {
            planSteps.add(regionLocationPlan);
        }
    }

    private String getRegionLocationsForExplainPlan(ExplainPlanAttributes.ExplainPlanAttributesBuilder explainPlanAttributesBuilder, List<HRegionLocation> regionLocationsFromResultIterator) {
        if (regionLocationsFromResultIterator == null) {
            return "";
        }
        try {
            StringBuilder buf = new StringBuilder().append(REGION_LOCATIONS);
            HashSet<RegionBoundary> regionBoundaries = new HashSet<RegionBoundary>();
            ArrayList<HRegionLocation> regionLocations = new ArrayList<HRegionLocation>();
            for (HRegionLocation regionLocation : regionLocationsFromResultIterator) {
                RegionBoundary regionBoundary = new RegionBoundary(regionLocation.getRegion().getStartKey(), regionLocation.getRegion().getEndKey());
                if (regionBoundaries.contains(regionBoundary)) continue;
                regionLocations.add(regionLocation);
                regionBoundaries.add(regionBoundary);
            }
            int maxLimitRegionLoc = this.context.getConnection().getQueryServices().getConfiguration().getInt("phoenix.max.region.locations.size.explain.plan", 5);
            if (regionLocations.size() > maxLimitRegionLoc) {
                int originalSize = regionLocations.size();
                List trimmedRegionLocations = regionLocations.subList(0, maxLimitRegionLoc);
                if (explainPlanAttributesBuilder != null) {
                    explainPlanAttributesBuilder.setRegionLocations(Collections.unmodifiableList(trimmedRegionLocations));
                }
                buf.append(trimmedRegionLocations);
                buf.append("...total size = ");
                buf.append(originalSize);
            } else {
                buf.append(regionLocations);
                if (explainPlanAttributesBuilder != null) {
                    explainPlanAttributesBuilder.setRegionLocations(Collections.unmodifiableList(regionLocations));
                }
            }
            buf.append(") ");
            return buf.toString();
        }
        catch (Exception e) {
            LOGGER.error("Explain table unable to add region locations.", (Throwable)e);
            return "";
        }
    }

    private void appendPKColumnValue(StringBuilder buf, byte[] range, Boolean isNull, int slotIndex, boolean changeViewIndexId) {
        if (Boolean.TRUE.equals(isNull)) {
            buf.append("null");
            return;
        }
        if (Boolean.FALSE.equals(isNull)) {
            buf.append("not null");
            return;
        }
        if (range.length == 0) {
            buf.append('*');
            return;
        }
        ScanRanges scanRanges = this.context.getScanRanges();
        PDataType type = scanRanges.getSchema().getField(slotIndex).getDataType();
        SortOrder sortOrder = this.tableRef.getTable().getPKColumns().get(slotIndex).getSortOrder();
        if (sortOrder == SortOrder.DESC) {
            buf.append('~');
            ImmutableBytesWritable ptr = new ImmutableBytesWritable(range);
            type.coerceBytes(ptr, type, sortOrder, SortOrder.getDefault());
            range = ptr.get();
        }
        if (changeViewIndexId) {
            buf.append(this.getViewIndexValue(type, range).toString());
        } else {
            Format formatter = this.context.getConnection().getFormatter(type);
            buf.append(type.toStringLiteral(range, formatter));
        }
    }

    private Long getViewIndexValue(PDataType type, byte[] range) {
        boolean useLongViewIndex = MetaDataUtil.getViewIndexIdDataType().equals(type);
        Object s = type.toObject(range);
        return (useLongViewIndex ? (Long)s : (long)((Short)s).shortValue()) + 32767L + 2L;
    }

    private void appendScanRow(StringBuilder buf, KeyRange.Bound bound) {
        ScanRanges scanRanges = this.context.getScanRanges();
        Iterator minMaxIterator = Collections.emptyIterator();
        boolean isLocalIndex = ScanUtil.isLocalIndex(this.context.getScan());
        boolean forceSkipScan = this.hint.hasHint(HintNode.Hint.SKIP_SCAN);
        int nRanges = forceSkipScan ? scanRanges.getRanges().size() : scanRanges.getBoundSlotCount();
        int i = 0;
        int minPos = 0;
        while (minPos < nRanges || minMaxIterator.hasNext()) {
            Boolean isNull;
            List<KeyRange> ranges = minPos >= nRanges ? EVERYTHING : scanRanges.getRanges().get(minPos++);
            KeyRange range = bound == KeyRange.Bound.LOWER ? ranges.get(0) : ranges.get(ranges.size() - 1);
            byte[] b = range.getRange(bound);
            Boolean bl = KeyRange.IS_NULL_RANGE == range ? Boolean.TRUE : (isNull = KeyRange.IS_NOT_NULL_RANGE == range ? Boolean.FALSE : null);
            if (minMaxIterator.hasNext()) {
                byte[] bMinMax = (byte[])minMaxIterator.next();
                int cmp = Bytes.compareTo((byte[])bMinMax, (byte[])b) * (bound == KeyRange.Bound.LOWER ? 1 : -1);
                if (cmp > 0) {
                    minPos = nRanges;
                    b = bMinMax;
                    isNull = null;
                } else if (cmp < 0) {
                    minMaxIterator = Collections.emptyIterator();
                }
            }
            if (isLocalIndex && i == 0) {
                this.appendPKColumnValue(buf, b, isNull, i, true);
            } else {
                this.appendPKColumnValue(buf, b, isNull, i, false);
            }
            buf.append(',');
            ++i;
        }
    }

    private String appendKeyRanges() {
        StringBuilder buf = new StringBuilder();
        ScanRanges scanRanges = this.context.getScanRanges();
        if (scanRanges.isDegenerate() || scanRanges.isEverything()) {
            return "";
        }
        buf.append(" [");
        StringBuilder buf1 = new StringBuilder();
        this.appendScanRow(buf1, KeyRange.Bound.LOWER);
        buf.append((CharSequence)buf1);
        buf.setCharAt(buf.length() - 1, ']');
        StringBuilder buf2 = new StringBuilder();
        this.appendScanRow(buf2, KeyRange.Bound.UPPER);
        if (!StringUtil.equals(buf1, buf2)) {
            buf.append(" - [");
            buf.append((CharSequence)buf2);
        }
        buf.setCharAt(buf.length() - 1, ']');
        return buf.toString();
    }

    private static class RegionBoundary {
        private final byte[] startKey;
        private final byte[] endKey;

        RegionBoundary(byte[] startKey, byte[] endKey) {
            this.startKey = startKey;
            this.endKey = endKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RegionBoundary that = (RegionBoundary)o;
            return Bytes.compareTo((byte[])this.startKey, (byte[])that.startKey) == 0 && Bytes.compareTo((byte[])this.endKey, (byte[])that.endKey) == 0;
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.startKey);
            result = 31 * result + Arrays.hashCode(this.endKey);
            return result;
        }
    }

    private static class RowKeyValueIterator
    implements Iterator<byte[]> {
        private final RowKeySchema schema;
        private ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        private int position = 0;
        private final int maxOffset;
        private byte[] nextValue;

        public RowKeyValueIterator(RowKeySchema schema, byte[] rowKey) {
            this.schema = schema;
            this.maxOffset = schema.iterator(rowKey, this.ptr);
            this.iterate();
        }

        private void iterate() {
            this.nextValue = (byte[])(this.schema.next(this.ptr, this.position++, this.maxOffset) == null ? null : this.ptr.copyBytes());
        }

        @Override
        public boolean hasNext() {
            return this.nextValue != null;
        }

        @Override
        public byte[] next() {
            if (this.nextValue == null) {
                throw new NoSuchElementException();
            }
            byte[] value = this.nextValue;
            this.iterate();
            return value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

