/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.phoenix.compile.ColumnProjector;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.aggregator.Aggregator;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.iterate.AggregatingResultIterator;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.thirdparty.com.google.common.collect.Sets;

public class DistinctAggregatingResultIterator
implements AggregatingResultIterator {
    private final AggregatingResultIterator targetAggregatingResultIterator;
    private final RowProjector rowProjector;
    private final Set<ResultEntry> resultEntries = Sets.newHashSet();

    public DistinctAggregatingResultIterator(AggregatingResultIterator delegate, RowProjector rowProjector) {
        this.targetAggregatingResultIterator = delegate;
        this.rowProjector = rowProjector;
    }

    @Override
    public Tuple next() throws SQLException {
        Tuple nextTuple;
        ResultEntry resultEntry;
        do {
            if ((nextTuple = this.targetAggregatingResultIterator.next()) != null) continue;
            return null;
        } while (this.resultEntries.contains(resultEntry = new ResultEntry(nextTuple)));
        this.resultEntries.add(resultEntry);
        return nextTuple;
    }

    @Override
    public void close() throws SQLException {
        this.targetAggregatingResultIterator.close();
    }

    @Override
    public void explain(List<String> planSteps) {
        this.targetAggregatingResultIterator.explain(planSteps);
        planSteps.add("CLIENT DISTINCT ON " + this.rowProjector.toString());
    }

    @Override
    public void explain(List<String> planSteps, ExplainPlanAttributes.ExplainPlanAttributesBuilder explainPlanAttributesBuilder) {
        this.targetAggregatingResultIterator.explain(planSteps, explainPlanAttributesBuilder);
        explainPlanAttributesBuilder.setClientDistinctFilter(this.rowProjector.toString());
        planSteps.add("CLIENT DISTINCT ON " + this.rowProjector.toString());
    }

    @Override
    public Aggregator[] aggregate(Tuple result) {
        return this.targetAggregatingResultIterator.aggregate(result);
    }

    public String toString() {
        return "DistinctAggregatingResultIterator [targetAggregatingResultIterator=" + this.targetAggregatingResultIterator + ", rowProjector=" + this.rowProjector;
    }

    private class ResultEntry {
        private final int hashCode;
        private final Tuple result;
        private final ImmutableBytesPtr[] columnValues;

        ResultEntry(Tuple result) {
            this.result = result;
            this.columnValues = new ImmutableBytesPtr[DistinctAggregatingResultIterator.this.rowProjector.getColumnCount()];
            int columnIndex = 0;
            for (ColumnProjector columnProjector : DistinctAggregatingResultIterator.this.rowProjector.getColumnProjectors()) {
                ImmutableBytesPtr ptr;
                Expression expression = columnProjector.getExpression();
                this.columnValues[columnIndex] = !expression.evaluate(this.result, ptr = new ImmutableBytesPtr()) ? null : ptr;
                ++columnIndex;
            }
            this.hashCode = Arrays.hashCode((Object[])this.columnValues);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (o.getClass() != this.getClass()) {
                return false;
            }
            ResultEntry that = (ResultEntry)o;
            return Arrays.equals((Object[])this.columnValues, (Object[])that.columnValues);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

