/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.codec.binary.Hex;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.cache.ServerCacheClient;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.compile.GroupByCompiler;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.coprocessorclient.HashJoinCacheNotFoundException;
import org.apache.phoenix.coprocessorclient.UngroupedAggregateRegionObserverHelper;
import org.apache.phoenix.exception.PhoenixIOException;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.execute.ScanPlan;
import org.apache.phoenix.expression.OrderByExpression;
import org.apache.phoenix.filter.BooleanExpressionFilter;
import org.apache.phoenix.filter.ColumnProjectionFilter;
import org.apache.phoenix.filter.DistinctPrefixFilter;
import org.apache.phoenix.filter.EmptyColumnOnlyFilter;
import org.apache.phoenix.filter.EncodedQualifiersColumnProjectionFilter;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.hbase.index.util.VersionUtil;
import org.apache.phoenix.iterate.ConcatResultIterator;
import org.apache.phoenix.iterate.ExplainTable;
import org.apache.phoenix.iterate.ParallelScanGrouper;
import org.apache.phoenix.iterate.ParallelScansCollector;
import org.apache.phoenix.iterate.PeekingResultIterator;
import org.apache.phoenix.iterate.ResultIterators;
import org.apache.phoenix.iterate.ScansWithRegionLocations;
import org.apache.phoenix.iterate.TableSamplerPredicate;
import org.apache.phoenix.join.HashCacheClient;
import org.apache.phoenix.monitoring.GlobalClientMetrics;
import org.apache.phoenix.monitoring.OverAllQueryMetrics;
import org.apache.phoenix.parse.FilterableStatement;
import org.apache.phoenix.parse.HintNode;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.ColumnFamilyNotFoundException;
import org.apache.phoenix.schema.CompiledConditionalTTLExpression;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnFamily;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.RowKeySchema;
import org.apache.phoenix.schema.StaleRegionBoundaryCacheException;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.ValueSchema;
import org.apache.phoenix.schema.stats.GuidePostsInfo;
import org.apache.phoenix.schema.stats.GuidePostsKey;
import org.apache.phoenix.schema.stats.StatisticsUtil;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.thirdparty.com.google.common.base.Function;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.ClientUtil;
import org.apache.phoenix.util.Closeables;
import org.apache.phoenix.util.EncodedColumnsUtil;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.LogUtil;
import org.apache.phoenix.util.PrefixByteCodec;
import org.apache.phoenix.util.PrefixByteDecoder;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.SQLCloseables;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseResultIterators
extends ExplainTable
implements ResultIterators {
    public static final Logger LOGGER = LoggerFactory.getLogger(BaseResultIterators.class);
    private static final int ESTIMATED_GUIDEPOSTS_PER_REGION = 20;
    private static final int MIN_SEEK_TO_COLUMN_VERSION = VersionUtil.encodeVersion("0", "98", "12");
    private final List<List<Scan>> scans;
    private final List<HRegionLocation> regionLocations;
    private final List<KeyRange> splits;
    private final byte[] physicalTableName;
    protected final QueryPlan plan;
    protected final String scanId;
    protected final MutationState mutationState;
    protected final ParallelScanGrouper scanGrouper;
    private final List<List<List<Pair<Scan, Future<PeekingResultIterator>>>>> allFutures;
    private Long estimatedRows;
    private Long estimatedSize;
    private Long estimateInfoTimestamp;
    private boolean hasGuidePosts;
    private Scan scan;
    private final boolean useStatsForParallelization;
    protected Map<ImmutableBytesPtr, ServerCacheClient.ServerCache> caches;
    private final QueryPlan dataPlan;
    private static boolean forTestingSetTimeoutToMaxToLetQueryPassHere = false;
    private int numRegionLocationLookups = 0;
    static final Function<HRegionLocation, KeyRange> TO_KEY_RANGE = new Function<HRegionLocation, KeyRange>(){

        public KeyRange apply(HRegionLocation region) {
            return KeyRange.getKeyRange(region.getRegion().getStartKey(), region.getRegion().getEndKey());
        }
    };

    private PTable getTable() {
        return this.plan.getTableRef().getTable();
    }

    protected abstract boolean isSerial();

    protected boolean useStats() {
        if (ScanUtil.isAnalyzeTable(this.scan)) {
            return false;
        }
        return !this.isSerial();
    }

    private static void initializeScan(QueryPlan plan, Integer perScanLimit, Integer offset, Scan scan) throws SQLException {
        StatementContext context = plan.getContext();
        TableRef tableRef = plan.getTableRef();
        boolean wildcardIncludesDynamicCols = context.getConnection().getQueryServices().getConfiguration().getBoolean("phoenix.query.wildcard.dynamicColumns", false);
        PTable table = tableRef.getTable();
        if (table.hasConditionalTTL()) {
            CompiledConditionalTTLExpression ttlExpr = (CompiledConditionalTTLExpression)table.getCompiledTTLExpression(context.getConnection());
            Set<ColumnReference> colsReferenced = ttlExpr.getColumnsReferenced();
            for (ColumnReference colref : colsReferenced) {
                context.addWhereConditionColumn(colref.getFamily(), colref.getQualifier());
            }
        }
        Map familyMap = scan.getFamilyMap();
        if (context.getConnection().isDescVarLengthRowKeyUpgrade()) {
            familyMap.clear();
            scan.readAllVersions();
            scan.setFilter(null);
            scan.setRaw(true);
            scan.setAttribute("_UPGRADE_DESC_ROW_KEY", UngroupedAggregateRegionObserverHelper.serialize(table));
        } else {
            GroupByCompiler.GroupBy groupBy;
            int n;
            boolean keyOnlyFilter;
            FilterableStatement statement = plan.getStatement();
            RowProjector projector = plan.getProjector();
            boolean optimizeProjection = false;
            boolean bl = keyOnlyFilter = familyMap.isEmpty() && !wildcardIncludesDynamicCols && context.getWhereConditionColumns().isEmpty();
            if (!projector.projectEverything()) {
                if (keyOnlyFilter && table.getColumnFamilies().size() == 1) {
                    scan.addFamily(table.getColumnFamilies().get(0).getName().getBytes());
                } else {
                    optimizeProjection = true;
                    if (projector.projectEveryRow()) {
                        if (table.getViewType() == PTable.ViewType.MAPPED) {
                            context.getWhereConditionColumns().clear();
                            for (PColumnFamily pColumnFamily : table.getColumnFamilies()) {
                                context.addWhereConditionColumn(pColumnFamily.getName().getBytes(), null);
                            }
                        } else {
                            byte[] ecf = SchemaUtil.getEmptyColumnFamily(table);
                            if (!familyMap.containsKey(ecf) || familyMap.get(ecf) != null) {
                                scan.addColumn(ecf, (byte[])EncodedColumnsUtil.getEmptyKeyValueInfo(table).getFirst());
                            }
                        }
                    }
                }
            } else {
                byte[] byArray;
                boolean containsNullableGroubBy = false;
                if (!plan.getOrderBy().isEmpty()) {
                    for (OrderByExpression orderByExpression : plan.getOrderBy().getOrderByExpressions()) {
                        if (!orderByExpression.getExpression().isNullable()) continue;
                        containsNullableGroubBy = true;
                        break;
                    }
                }
                if (containsNullableGroubBy && (!familyMap.containsKey(byArray = SchemaUtil.getEmptyColumnFamily(table)) || familyMap.get(byArray) != null)) {
                    scan.addColumn(byArray, (byte[])EncodedColumnsUtil.getEmptyKeyValueInfo(table).getFirst());
                }
            }
            if (keyOnlyFilter) {
                byte[] byArray;
                byte[] ecf = SchemaUtil.getEmptyColumnFamily(table);
                byte[] byArray2 = byArray = table.getEncodingScheme() == PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS ? QueryConstants.EMPTY_COLUMN_BYTES : table.getEncodingScheme().encode(QueryConstants.ENCODED_EMPTY_COLUMN_NAME);
                if (table.getEncodingScheme() == PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS) {
                    ScanUtil.andFilterAtBeginning(scan, (Filter)new EmptyColumnOnlyFilter(ecf, byArray));
                } else if (table.getColumnFamilies().size() == 0) {
                    ScanUtil.andFilterAtBeginning(scan, (Filter)new FirstKeyOnlyFilter());
                } else {
                    ArrayList<byte[]> families = new ArrayList<byte[]>(table.getColumnFamilies().size());
                    for (PColumnFamily family : table.getColumnFamilies()) {
                        families.add(family.getName().getBytes());
                    }
                    Collections.sort(families, Bytes.BYTES_COMPARATOR);
                    byte[] firstFamily = (byte[])families.get(0);
                    if (Bytes.compareTo((byte[])ecf, (int)0, (int)ecf.length, (byte[])firstFamily, (int)0, (int)firstFamily.length) == 0) {
                        ScanUtil.andFilterAtBeginning(scan, (Filter)new FirstKeyOnlyFilter());
                    } else {
                        ScanUtil.andFilterAtBeginning(scan, (Filter)new EmptyColumnOnlyFilter(ecf, byArray));
                    }
                }
            }
            if (perScanLimit != null) {
                if (scan.getAttribute("_IndexFilter") == null) {
                    ScanUtil.andFilterAtEnd(scan, (Filter)new PageFilter((long)perScanLimit.intValue()));
                } else {
                    scan.setAttribute("_IndexLimit", Bytes.toBytes((long)perScanLimit.intValue()));
                }
            }
            if (offset != null) {
                ScanUtil.addOffsetAttribute(scan, offset);
            }
            if ((n = (groupBy = plan.getGroupBy()).getOrderPreservingColumnCount()) > 0 && keyOnlyFilter && !plan.getStatement().getHint().hasHint(HintNode.Hint.RANGE_SCAN) && n < plan.getTableRef().getTable().getRowKeySchema().getFieldCount() && groupBy.isOrderPreserving() && (context.getAggregationManager().isEmpty() || groupBy.isUngroupedAggregate())) {
                ScanUtil.andFilterAtEnd(scan, (Filter)new DistinctPrefixFilter(plan.getTableRef().getTable().getRowKeySchema(), n));
                if (!groupBy.isUngroupedAggregate() && plan.getLimit() != null) {
                    ScanUtil.andFilterAtEnd(scan, (Filter)new PageFilter((long)plan.getLimit().intValue()));
                }
            }
            scan.setAttribute("_QualifierEncodingScheme", new byte[]{table.getEncodingScheme().getSerializedMetadataValue()});
            scan.setAttribute("_ImmutableStorageEncodingScheme", new byte[]{table.getImmutableStorageScheme().getSerializedMetadataValue()});
            scan.setAttribute("_UseNewValueColumnQualifier", Bytes.toBytes((boolean)true));
            if (!ScanUtil.isAnalyzeTable(scan)) {
                BaseResultIterators.setQualifierRanges(keyOnlyFilter, table, scan, context);
            }
            if (optimizeProjection) {
                BaseResultIterators.optimizeProjection(context, scan, table, statement);
            }
        }
    }

    private static void setQualifierRanges(boolean keyOnlyFilter, PTable table, Scan scan, StatementContext context) throws SQLException {
        if (EncodedColumnsUtil.useEncodedQualifierListOptimization(table, scan)) {
            Pair minMaxQualifiers = new Pair();
            for (Pair<byte[], byte[]> whereCol : context.getWhereConditionColumns()) {
                byte[] cq = (byte[])whereCol.getSecond();
                if (cq == null) continue;
                int qualifier = table.getEncodingScheme().decode(cq);
                BaseResultIterators.adjustQualifierRange(qualifier, (Pair<Integer, Integer>)minMaxQualifiers);
            }
            Map familyMap = scan.getFamilyMap();
            for (Map.Entry entry : familyMap.entrySet()) {
                if (entry.getValue() != null) {
                    for (byte[] cq : (NavigableSet)entry.getValue()) {
                        if (cq == null) continue;
                        int qualifier = table.getEncodingScheme().decode(cq);
                        BaseResultIterators.adjustQualifierRange(qualifier, (Pair<Integer, Integer>)minMaxQualifiers);
                    }
                    continue;
                }
                byte[] cf = (byte[])entry.getKey();
                String family = Bytes.toString((byte[])cf);
                if (table.getType() == PTableType.INDEX && table.getIndexType() == PTable.IndexType.LOCAL && !IndexUtil.isLocalIndexFamily(family)) {
                    family = IndexUtil.getLocalIndexColumnFamily(family);
                }
                byte[] familyBytes = Bytes.toBytes((String)family);
                TreeSet<byte[]> qualifierSet = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
                if (Bytes.equals((byte[])familyBytes, (byte[])SchemaUtil.getEmptyColumnFamily(table))) {
                    Pair<byte[], byte[]> emptyKeyValueInfo = EncodedColumnsUtil.getEmptyKeyValueInfo(table);
                    qualifierSet.add((byte[])emptyKeyValueInfo.getFirst());
                }
                if (keyOnlyFilter) continue;
                Pair<Integer, Integer> qualifierRangeForFamily = EncodedColumnsUtil.setQualifiersForColumnsInFamily(table, family, qualifierSet);
                familyMap.put(familyBytes, qualifierSet);
                if (qualifierRangeForFamily == null) continue;
                BaseResultIterators.adjustQualifierRange((Integer)qualifierRangeForFamily.getFirst(), (Pair<Integer, Integer>)minMaxQualifiers);
                BaseResultIterators.adjustQualifierRange((Integer)qualifierRangeForFamily.getSecond(), (Pair<Integer, Integer>)minMaxQualifiers);
            }
            if (minMaxQualifiers.getFirst() != null) {
                scan.setAttribute("_MinQualifier", Bytes.toBytes((int)((Integer)minMaxQualifiers.getFirst())));
                scan.setAttribute("_MaxQualifier", Bytes.toBytes((int)((Integer)minMaxQualifiers.getSecond())));
                ScanUtil.setQualifierRangesOnFilter(scan, (Pair<Integer, Integer>)minMaxQualifiers);
            }
        }
    }

    private static void adjustQualifierRange(Integer qualifier, Pair<Integer, Integer> minMaxQualifiers) {
        if (minMaxQualifiers.getFirst() == null) {
            minMaxQualifiers.setFirst((Object)qualifier);
            minMaxQualifiers.setSecond((Object)qualifier);
        } else if ((Integer)minMaxQualifiers.getFirst() > qualifier) {
            minMaxQualifiers.setFirst((Object)qualifier);
        } else if ((Integer)minMaxQualifiers.getSecond() < qualifier) {
            minMaxQualifiers.setSecond((Object)qualifier);
        }
    }

    private static void optimizeProjection(StatementContext context, Scan scan, PTable table, FilterableStatement statement) {
        PTable.ImmutableStorageScheme storageScheme;
        Map familyMap = scan.getFamilyMap();
        TreeMap<ImmutableBytesPtr, NavigableSet<ImmutableBytesPtr>> columnsTracker = new TreeMap<ImmutableBytesPtr, NavigableSet<ImmutableBytesPtr>>();
        TreeSet<byte[]> conditionOnlyCfs = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        int referencedCfCount = familyMap.size();
        PTable.QualifierEncodingScheme encodingScheme = table.getEncodingScheme();
        BitSet trackedColumnsBitset = EncodedColumnsUtil.isPossibleToUseEncodedCQFilter(encodingScheme, storageScheme = table.getImmutableStorageScheme()) && !ScanUtil.hasDynamicColumns(table) ? new BitSet(10) : null;
        boolean filteredColumnNotInProjection = false;
        for (Pair<byte[], byte[]> whereCol : context.getWhereConditionColumns()) {
            NavigableSet projectedColumns;
            byte[] byArray = (byte[])whereCol.getFirst();
            if (!familyMap.containsKey(byArray)) {
                ++referencedCfCount;
                filteredColumnNotInProjection = true;
                continue;
            }
            if (filteredColumnNotInProjection || (projectedColumns = (NavigableSet)familyMap.get(byArray)) == null) continue;
            byte[] filteredColumn = (byte[])whereCol.getSecond();
            if (filteredColumn == null) {
                filteredColumnNotInProjection = true;
                continue;
            }
            filteredColumnNotInProjection = !projectedColumns.contains(filteredColumn);
        }
        boolean preventSeekToColumn = false;
        if (statement.getHint().hasHint(HintNode.Hint.SEEK_TO_COLUMN)) {
            preventSeekToColumn = false;
        } else if (!EncodedColumnsUtil.useEncodedQualifierListOptimization(table, scan)) {
            if (statement.getHint().hasHint(HintNode.Hint.NO_SEEK_TO_COLUMN)) {
                preventSeekToColumn = true;
            } else {
                int hbaseServerVersion = context.getConnection().getQueryServices().getLowestClusterHBaseVersion();
                preventSeekToColumn = referencedCfCount == 1 && hbaseServerVersion < MIN_SEEK_TO_COLUMN_VERSION;
            }
        }
        for (Pair<byte[], byte[]> pair : context.getWhereConditionColumns()) {
            byte[] family = (byte[])pair.getFirst();
            if (preventSeekToColumn) {
                if (!familyMap.containsKey(family)) {
                    conditionOnlyCfs.add(family);
                }
                scan.addFamily(family);
                continue;
            }
            if (familyMap.containsKey(family)) {
                NavigableSet cols = (NavigableSet)familyMap.get(family);
                if (cols == null) continue;
                if (pair.getSecond() == null) {
                    scan.addFamily(family);
                    continue;
                }
                scan.addColumn(family, (byte[])pair.getSecond());
                continue;
            }
            if (pair.getSecond() == null) {
                scan.addFamily(family);
                continue;
            }
            scan.addColumn(family, (byte[])pair.getSecond());
        }
        for (Map.Entry entry : familyMap.entrySet()) {
            ImmutableBytesPtr cf = new ImmutableBytesPtr((byte[])entry.getKey());
            NavigableSet qs = (NavigableSet)entry.getValue();
            TreeSet<ImmutableBytesPtr> cols = null;
            if (qs != null) {
                cols = new TreeSet<ImmutableBytesPtr>();
                for (byte[] q : qs) {
                    cols.add(new ImmutableBytesPtr(q));
                    if (trackedColumnsBitset == null) continue;
                    int qualifier = encodingScheme.decode(q);
                    trackedColumnsBitset.set(qualifier);
                }
            } else {
                trackedColumnsBitset = null;
            }
            columnsTracker.put(cf, cols);
        }
        if (!columnsTracker.isEmpty()) {
            if (preventSeekToColumn) {
                for (ImmutableBytesPtr immutableBytesPtr : columnsTracker.keySet()) {
                    scan.addFamily(immutableBytesPtr.get());
                }
            }
            if (!statement.isAggregate() && filteredColumnNotInProjection) {
                ScanUtil.andFilterAtEnd(scan, (Filter)(trackedColumnsBitset != null ? new EncodedQualifiersColumnProjectionFilter(SchemaUtil.getEmptyColumnFamily(table), trackedColumnsBitset, conditionOnlyCfs, table.getEncodingScheme()) : new ColumnProjectionFilter(SchemaUtil.getEmptyColumnFamily(table), columnsTracker, conditionOnlyCfs, EncodedColumnsUtil.usesEncodedColumnNames(table.getEncodingScheme()))));
            }
        }
    }

    public BaseResultIterators(QueryPlan plan, Integer perScanLimit, Integer offset, ParallelScanGrouper scanGrouper, Scan scan, Map<ImmutableBytesPtr, ServerCacheClient.ServerCache> caches, QueryPlan dataPlan) throws SQLException {
        super(plan.getContext(), plan.getTableRef(), plan.getGroupBy(), plan.getOrderBy(), plan.getStatement().getHint(), QueryUtil.getOffsetLimit(plan.getLimit(), plan.getOffset()), offset);
        this.plan = plan;
        this.scan = scan;
        this.caches = caches;
        this.scanGrouper = scanGrouper;
        this.dataPlan = dataPlan;
        StatementContext context = plan.getContext();
        this.mutationState = new MutationState(context.getConnection().getMutationState());
        TableRef tableRef = plan.getTableRef();
        PTable table = tableRef.getTable();
        this.physicalTableName = table.getPhysicalName().getBytes();
        Long currentSCN = context.getConnection().getSCN();
        if (null == currentSCN) {
            currentSCN = Long.MAX_VALUE;
        }
        this.scanId = new UUID(ThreadLocalRandom.current().nextLong(), ThreadLocalRandom.current().nextLong()).toString();
        BaseResultIterators.initializeScan(plan, perScanLimit, offset, scan);
        this.useStatsForParallelization = ScanUtil.getStatsForParallelizationProp(context.getConnection(), table);
        ScansWithRegionLocations scansWithRegionLocations = this.getParallelScans();
        this.scans = scansWithRegionLocations.getScans();
        this.regionLocations = scansWithRegionLocations.getRegionLocations();
        ArrayList splitRanges = Lists.newArrayListWithExpectedSize((int)(this.scans.size() * 20));
        for (List<Scan> scanList : this.scans) {
            for (Scan aScan : scanList) {
                splitRanges.add(KeyRange.getKeyRange(aScan.getStartRow(), aScan.getStopRow()));
            }
        }
        this.splits = ImmutableList.copyOf((Collection)splitRanges);
        this.allFutures = Lists.newArrayListWithExpectedSize((int)1);
    }

    @Override
    public List<KeyRange> getSplits() {
        if (this.splits == null) {
            return Collections.emptyList();
        }
        return this.splits;
    }

    @Override
    public List<List<Scan>> getScans() {
        if (this.scans == null) {
            return Collections.emptyList();
        }
        return this.scans;
    }

    private List<HRegionLocation> getRegionBoundaries(ParallelScanGrouper scanGrouper, byte[] startRegionBoundaryKey, byte[] stopRegionBoundaryKey) throws SQLException {
        return scanGrouper.getRegionBoundaries(this.context, this.physicalTableName, startRegionBoundaryKey, stopRegionBoundaryKey);
    }

    private static List<byte[]> toBoundaries(List<HRegionLocation> regionLocations) {
        int nBoundaries = regionLocations.size() - 1;
        ArrayList ranges = Lists.newArrayListWithExpectedSize((int)nBoundaries);
        for (int i = 0; i < nBoundaries; ++i) {
            RegionInfo regionInfo = regionLocations.get(i).getRegion();
            ranges.add(regionInfo.getEndKey());
        }
        return ranges;
    }

    private static int getIndexContainingInclusive(List<byte[]> boundaries, byte[] inclusiveKey) {
        int guideIndex = Collections.binarySearch(boundaries, inclusiveKey, Bytes.BYTES_COMPARATOR);
        guideIndex = guideIndex < 0 ? -(guideIndex + 1) : guideIndex + 1;
        return guideIndex;
    }

    private static int getIndexContainingExclusive(List<byte[]> boundaries, byte[] exclusiveKey) {
        int guideIndex = Collections.binarySearch(boundaries, exclusiveKey, Bytes.BYTES_COMPARATOR);
        guideIndex = guideIndex < 0 ? -(guideIndex + 1) : guideIndex;
        return guideIndex;
    }

    private GuidePostsInfo getGuidePosts() throws SQLException {
        byte[] cf;
        if (!this.useStats() || !StatisticsUtil.isStatsEnabled(TableName.valueOf((byte[])this.physicalTableName))) {
            return GuidePostsInfo.NO_GUIDEPOST;
        }
        TreeSet<byte[]> whereConditions = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        for (Pair<byte[], byte[]> where : this.context.getWhereConditionColumns()) {
            cf = (byte[])where.getFirst();
            if (cf == null) continue;
            whereConditions.add(cf);
        }
        PTable table = this.getTable();
        byte[] defaultCF = SchemaUtil.getEmptyColumnFamily(this.getTable());
        cf = null;
        if (!table.getColumnFamilies().isEmpty() && !whereConditions.isEmpty()) {
            for (Pair<byte[], byte[]> where : this.context.getWhereConditionColumns()) {
                byte[] whereCF = (byte[])where.getFirst();
                if (Bytes.compareTo((byte[])defaultCF, (byte[])whereCF) != 0) continue;
                cf = defaultCF;
                break;
            }
            if (cf == null) {
                cf = (byte[])this.context.getWhereConditionColumns().get(0).getFirst();
            }
        }
        if (cf == null) {
            cf = defaultCF;
        }
        GuidePostsKey key = new GuidePostsKey(this.physicalTableName, cf);
        return this.context.getConnection().getQueryServices().getTableStats(key);
    }

    private static void updateEstimates(GuidePostsInfo gps, int guideIndex, GuidePostEstimate estimate) {
        estimate.rowsEstimate += gps.getRowCounts()[guideIndex];
        estimate.bytesEstimate += gps.getByteCounts()[guideIndex];
        estimate.lastUpdated = Math.min(estimate.lastUpdated, gps.getGuidePostTimestamps()[guideIndex]);
    }

    private ScansWithRegionLocations getParallelScans() throws SQLException {
        if (!ScanUtil.isContextScan(this.scan, this.context)) {
            return this.getParallelScans(this.scan);
        }
        return this.getParallelScans(ByteUtil.EMPTY_BYTE_ARRAY, ByteUtil.EMPTY_BYTE_ARRAY);
    }

    private ScansWithRegionLocations getParallelScans(Scan scan) throws SQLException {
        List<HRegionLocation> regionLocations = this.getRegionBoundaries(this.scanGrouper, scan.getStartRow(), scan.getStopRow());
        this.numRegionLocationLookups = regionLocations.size();
        List<byte[]> regionBoundaries = BaseResultIterators.toBoundaries(regionLocations);
        int regionIndex = 0;
        int stopIndex = regionBoundaries.size();
        if (scan.getStartRow().length > 0) {
            regionIndex = BaseResultIterators.getIndexContainingInclusive(regionBoundaries, scan.getStartRow());
        }
        if (scan.getStopRow().length > 0) {
            stopIndex = Math.min(stopIndex, regionIndex + BaseResultIterators.getIndexContainingExclusive(regionBoundaries.subList(regionIndex, stopIndex), scan.getStopRow()));
        }
        ParallelScansCollector parallelScans = new ParallelScansCollector(this.scanGrouper);
        while (regionIndex <= stopIndex) {
            HRegionLocation regionLocation = regionLocations.get(regionIndex);
            RegionInfo regionInfo = regionLocation.getRegion();
            Scan newScan = ScanUtil.newScan(scan);
            if (ScanUtil.isLocalIndex(scan)) {
                ScanUtil.setLocalIndexAttributes(newScan, 0, regionInfo.getStartKey(), regionInfo.getEndKey(), newScan.getAttribute("_ScanStartRowSuffix"), newScan.getAttribute("_ScanStopRowSuffix"));
            } else {
                if (Bytes.compareTo((byte[])scan.getStartRow(), (byte[])regionInfo.getStartKey()) <= 0) {
                    newScan.setAttribute("_ScanActualStartRow", regionInfo.getStartKey());
                    newScan.withStartRow(regionInfo.getStartKey());
                }
                if (scan.getStopRow().length == 0 || regionInfo.getEndKey().length != 0 && Bytes.compareTo((byte[])scan.getStopRow(), (byte[])regionInfo.getEndKey()) > 0) {
                    newScan.withStopRow(regionInfo.getEndKey());
                }
            }
            if (regionLocation.getServerName() != null) {
                newScan.setAttribute("_SCAN_REGION_SERVER", regionLocation.getServerName().getVersionedBytes());
            }
            parallelScans.addNewScan(this.plan, newScan, true, regionLocation);
            ++regionIndex;
        }
        return new ScansWithRegionLocations(parallelScans.getParallelScans(), parallelScans.getRegionLocations());
    }

    private int computeColumnsInCommon() {
        PColumn indexColumn;
        String indexColumnName;
        String cf;
        int nColumnsOffset;
        PTable dataTable = this.dataPlan.getTableRef().getTable();
        if (dataTable.getBucketNum() != null) {
            return 0;
        }
        PTable table = this.getTable();
        int nColumnsInCommon = nColumnsOffset = dataTable.isMultiTenant() ? 1 : 0;
        List<PColumn> dataPKColumns = dataTable.getPKColumns();
        List<PColumn> indexPKColumns = table.getPKColumns();
        int nIndexPKColumns = indexPKColumns.size();
        int nDataPKColumns = dataPKColumns.size();
        for (int i = 1 + nColumnsInCommon; i < nIndexPKColumns && (cf = IndexUtil.getDataColumnFamilyName(indexColumnName = (indexColumn = indexPKColumns.get(i)).getName().getString())).length() == 0 && i <= nDataPKColumns; ++i) {
            PColumn dataColumn = dataPKColumns.get(i - 1);
            String dataColumnName = dataColumn.getName().getString();
            if (indexColumn.getDataType() != dataColumn.getDataType() || !dataColumnName.equals(IndexUtil.getDataColumnName(indexColumnName))) break;
            ++nColumnsInCommon;
        }
        return nColumnsInCommon;
    }

    public static ScanRanges computePrefixScanRanges(ScanRanges dataScanRanges, int nColumnsInCommon) {
        int rangeSpan;
        if (nColumnsInCommon == 0) {
            return ScanRanges.EVERYTHING;
        }
        ArrayList cnf = Lists.newArrayListWithExpectedSize((int)nColumnsInCommon);
        int[] slotSpan = new int[nColumnsInCommon];
        boolean useSkipScan = false;
        boolean hasRange = false;
        List<List<KeyRange>> rangesList = dataScanRanges.getRanges();
        int rangesListSize = rangesList.size();
        for (int offset = 0; offset < nColumnsInCommon && offset < rangesListSize; offset += rangeSpan) {
            ArrayList ranges = rangesList.get(offset);
            useSkipScan |= ranges.size() > 1 || hasRange;
            cnf.add(ranges);
            rangeSpan = 1 + dataScanRanges.getSlotSpans()[offset];
            if (offset + rangeSpan > nColumnsInCommon) {
                rangeSpan = nColumnsInCommon - offset;
                ranges = Lists.newArrayListWithExpectedSize((int)((List)cnf.get(cnf.size() - 1)).size());
                for (KeyRange range : (List)cnf.get(cnf.size() - 1)) {
                    range = BaseResultIterators.clipRange(dataScanRanges.getSchema(), offset, rangeSpan, range);
                    ranges.add(range);
                }
                cnf.set(cnf.size() - 1, ranges);
            }
            for (KeyRange range : ranges) {
                if (range.isSingleKey()) continue;
                hasRange = true;
                break;
            }
            slotSpan[offset] = rangeSpan - 1;
        }
        slotSpan = slotSpan.length == cnf.size() ? slotSpan : Arrays.copyOf(slotSpan, cnf.size());
        ScanRanges commonScanRanges = ScanRanges.create(dataScanRanges.getSchema(), cnf, slotSpan, null, useSkipScan &= dataScanRanges.useSkipScanFilter(), -1);
        return commonScanRanges;
    }

    public static KeyRange clipRange(RowKeySchema schema, int fieldIndex, int rangeSpan, KeyRange range) {
        if (range == KeyRange.EVERYTHING_RANGE) {
            return range;
        }
        if (range == KeyRange.EMPTY_RANGE) {
            return range;
        }
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        boolean newRange = false;
        boolean lowerUnbound = range.lowerUnbound();
        boolean lowerInclusive = range.isLowerInclusive();
        byte[] lowerRange = range.getLowerRange();
        if (!lowerUnbound && lowerRange.length > 0 && BaseResultIterators.clipKeyRangeBytes(schema, fieldIndex, rangeSpan, lowerRange, ptr, true)) {
            lowerInclusive = true;
            lowerRange = ptr.copyBytes();
            newRange = true;
        }
        boolean upperUnbound = range.upperUnbound();
        boolean upperInclusive = range.isUpperInclusive();
        byte[] upperRange = range.getUpperRange();
        if (!upperUnbound && upperRange.length > 0 && BaseResultIterators.clipKeyRangeBytes(schema, fieldIndex, rangeSpan, upperRange, ptr, false)) {
            upperInclusive = true;
            upperRange = ptr.copyBytes();
            newRange = true;
        }
        return newRange ? KeyRange.getKeyRange(lowerRange, lowerInclusive, upperRange, upperInclusive) : range;
    }

    private static boolean clipKeyRangeBytes(RowKeySchema schema, int fieldIndex, int rangeSpan, byte[] rowKey, ImmutableBytesWritable ptr, boolean trimTrailingNulls) {
        int position = 0;
        int maxOffset = schema.iterator(rowKey, ptr);
        byte[] newRowKey = new byte[rowKey.length];
        int offset = 0;
        int trailingNullsToTrim = 0;
        while (schema.next(ptr, fieldIndex, maxOffset) != null) {
            System.arraycopy(ptr.get(), ptr.getOffset(), newRowKey, offset, ptr.getLength());
            offset += ptr.getLength();
            ValueSchema.Field field = schema.getField(fieldIndex);
            if (field.getDataType().isFixedWidth()) {
                trailingNullsToTrim = 0;
            } else {
                byte[] sepBytes;
                boolean isNull = ptr.getLength() == 0;
                for (byte sepByte : sepBytes = SchemaUtil.getSeparatorBytes(field.getDataType(), true, isNull, field.getSortOrder())) {
                    newRowKey[offset++] = sepByte;
                }
                trailingNullsToTrim = isNull ? (trimTrailingNulls ? ++trailingNullsToTrim : 0) : 1;
            }
            ++fieldIndex;
            if (++position < rangeSpan) continue;
        }
        ptr.set(newRowKey, 0, offset - trailingNullsToTrim);
        return maxOffset != offset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ScansWithRegionLocations getParallelScans(byte[] startKey, byte[] stopKey) throws SQLException {
        boolean delayAddingEst;
        boolean gpsAvailableForAllRegions;
        long fallbackTs;
        boolean intersectWithGuidePosts;
        boolean gpsForFirstRegion;
        int guideIndex;
        PrefixByteDecoder decoder;
        DataInputStream input;
        ByteArrayInputStream stream;
        ImmutableBytesWritable currentGuidePost;
        int keyOffset;
        int gpsSize;
        ImmutableBytesWritable currentKey;
        ParallelScansCollector parallelScanCollector;
        int stopIndex;
        List<byte[]> regionBoundaries;
        List<HRegionLocation> regionLocations;
        int startRegionIndex;
        int regionIndex;
        ScanRanges prefixScanRanges;
        int columnsInCommon;
        boolean emptyGuidePost;
        GuidePostsInfo gps;
        byte[] splitPostfix;
        GuidePostEstimate estimates;
        boolean isLocalIndex;
        PTable table;
        ScanRanges scanRanges;
        block52: {
            int c;
            ImmutableBytesWritable firstRegionStartKey;
            byte[] stopRegionBoundaryKey;
            byte[] startRegionBoundaryKey;
            boolean isSalted;
            block55: {
                boolean traverseAllRegions;
                block54: {
                    scanRanges = this.context.getScanRanges();
                    table = this.getTable();
                    isLocalIndex = table.getIndexType() == PTable.IndexType.LOCAL;
                    estimates = new GuidePostEstimate();
                    if (!isLocalIndex && scanRanges.isPointLookup() && !scanRanges.useSkipScanFilter()) {
                        ArrayList parallelScans = Lists.newArrayListWithExpectedSize((int)1);
                        ArrayList scans = Lists.newArrayListWithExpectedSize((int)1);
                        Scan scanFromContext = this.context.getScan();
                        Integer limit = this.plan.getLimit();
                        boolean isAggregate = this.plan.getStatement().isAggregate();
                        if (scanRanges.getPointLookupCount() == 1 && limit == null && !isAggregate) {
                            try {
                                scanFromContext = new Scan(this.context.getScan());
                            }
                            catch (IOException e) {
                                LOGGER.error("Failure to construct point lookup scan", (Throwable)e);
                                throw new PhoenixIOException(e);
                            }
                            scanFromContext.withStopRow(scanFromContext.getStartRow(), scanFromContext.includeStartRow());
                        }
                        scans.add(scanFromContext);
                        parallelScans.add(scans);
                        this.generateEstimates(scanRanges, table, GuidePostsInfo.NO_GUIDEPOST, GuidePostsInfo.NO_GUIDEPOST.isEmptyGuidePost(), parallelScans, estimates, Long.MAX_VALUE, false);
                        return new ScansWithRegionLocations(parallelScans, null);
                    }
                    byte[] sampleProcessedSaltByte = SchemaUtil.processSplit(new byte[]{0}, table.getPKColumns());
                    splitPostfix = Arrays.copyOfRange(sampleProcessedSaltByte, 1, sampleProcessedSaltByte.length);
                    isSalted = table.getBucketNum() != null;
                    gps = this.getGuidePosts();
                    this.hasGuidePosts = gps != GuidePostsInfo.NO_GUIDEPOST;
                    emptyGuidePost = gps.isEmptyGuidePost();
                    startRegionBoundaryKey = startKey;
                    stopRegionBoundaryKey = stopKey;
                    columnsInCommon = 0;
                    prefixScanRanges = ScanRanges.EVERYTHING;
                    boolean bl = traverseAllRegions = isSalted || isLocalIndex;
                    if (!isLocalIndex) break block54;
                    if (this.dataPlan != null && this.dataPlan.getTableRef().getTable().getType() != PTableType.INDEX) {
                        columnsInCommon = this.computeColumnsInCommon();
                        prefixScanRanges = BaseResultIterators.computePrefixScanRanges(this.dataPlan.getContext().getScanRanges(), columnsInCommon);
                        KeyRange prefixRange = prefixScanRanges.getScanRange();
                        if (!prefixRange.lowerUnbound()) {
                            startRegionBoundaryKey = prefixRange.getLowerRange();
                        }
                        if (!prefixRange.upperUnbound()) {
                            stopRegionBoundaryKey = prefixRange.getUpperRange();
                        }
                    }
                    break block55;
                }
                if (!traverseAllRegions) {
                    byte[] scanStartRow = this.scan.getStartRow();
                    if (scanStartRow.length != 0 && Bytes.compareTo((byte[])scanStartRow, (byte[])startKey) > 0) {
                        startKey = scanStartRow;
                        startRegionBoundaryKey = scanStartRow;
                    }
                    byte[] scanStopRow = this.scan.getStopRow();
                    if (stopKey.length == 0 || scanStopRow.length != 0 && Bytes.compareTo((byte[])scanStopRow, (byte[])stopKey) < 0) {
                        stopKey = scanStopRow;
                        stopRegionBoundaryKey = scanStopRow;
                    }
                }
            }
            regionIndex = 0;
            startRegionIndex = 0;
            if (isSalted && !isLocalIndex) {
                if (this.scan.getStartRow().length > 0 && this.scan.getStopRow().length > 0) {
                    regionLocations = new ArrayList<HRegionLocation>();
                    for (int i = 0; i < this.getTable().getBucketNum(); ++i) {
                        byte[] saltStartRegionKey = new byte[this.scan.getStartRow().length];
                        saltStartRegionKey[0] = (byte)i;
                        System.arraycopy(this.scan.getStartRow(), 1, saltStartRegionKey, 1, this.scan.getStartRow().length - 1);
                        byte[] saltStopRegionKey = new byte[this.scan.getStopRow().length];
                        saltStopRegionKey[0] = (byte)i;
                        System.arraycopy(this.scan.getStopRow(), 1, saltStopRegionKey, 1, this.scan.getStopRow().length - 1);
                        regionLocations.addAll(this.getRegionBoundaries(this.scanGrouper, saltStartRegionKey, saltStopRegionKey));
                    }
                } else {
                    regionLocations = this.getRegionBoundaries(this.scanGrouper, startRegionBoundaryKey, stopRegionBoundaryKey);
                }
            } else {
                regionLocations = this.getRegionBoundaries(this.scanGrouper, startRegionBoundaryKey, stopRegionBoundaryKey);
            }
            this.numRegionLocationLookups = regionLocations.size();
            regionBoundaries = BaseResultIterators.toBoundaries(regionLocations);
            stopIndex = regionBoundaries.size();
            if (startRegionBoundaryKey.length > 0) {
                startRegionIndex = regionIndex = BaseResultIterators.getIndexContainingInclusive(regionBoundaries, startRegionBoundaryKey);
            }
            if (stopRegionBoundaryKey.length > 0) {
                stopIndex = Math.min(stopIndex, regionIndex + BaseResultIterators.getIndexContainingExclusive(regionBoundaries.subList(regionIndex, stopIndex), stopRegionBoundaryKey));
                if (isLocalIndex) {
                    stopKey = regionLocations.get(stopIndex).getRegion().getEndKey();
                }
            }
            parallelScanCollector = new ParallelScansCollector(this.scanGrouper);
            currentKey = new ImmutableBytesWritable(startKey);
            gpsSize = gps.getGuidePostsCount();
            keyOffset = 0;
            currentGuidePost = ByteUtil.EMPTY_IMMUTABLE_BYTE_ARRAY;
            ImmutableBytesWritable guidePosts = gps.getGuidePosts();
            stream = null;
            input = null;
            decoder = null;
            guideIndex = 0;
            gpsForFirstRegion = false;
            intersectWithGuidePosts = true;
            fallbackTs = Long.MAX_VALUE;
            gpsAvailableForAllRegions = true;
            try {
                delayAddingEst = false;
                firstRegionStartKey = null;
                if (gpsSize <= 0) break block52;
                stream = new ByteArrayInputStream(guidePosts.get(), guidePosts.getOffset(), guidePosts.getLength());
                input = new DataInputStream(stream);
                decoder = new PrefixByteDecoder(gps.getMaxLength());
                firstRegionStartKey = new ImmutableBytesWritable(regionLocations.get(regionIndex).getRegion().getStartKey());
                try {}
                catch (EOFException e) {
                    intersectWithGuidePosts = false;
                    break block52;
                }
            }
            catch (Throwable throwable) {
                if (stream != null) {
                    Closeables.closeQuietly(stream);
                }
                throw throwable;
            }
            while ((c = currentKey.compareTo(currentGuidePost = PrefixByteCodec.decode(decoder, input))) >= 0) {
                if (!gpsForFirstRegion && firstRegionStartKey.compareTo(currentGuidePost) <= 0) {
                    gpsForFirstRegion = true;
                }
                if (gpsForFirstRegion) {
                    fallbackTs = Math.min(fallbackTs, gps.getGuidePostTimestamps()[guideIndex]);
                }
                delayAddingEst = c == 0;
                ++guideIndex;
            }
        }
        byte[] endRegionKey = regionLocations.get(stopIndex).getRegion().getEndKey();
        byte[] currentKeyBytes = currentKey.copyBytes();
        intersectWithGuidePosts &= guideIndex < gpsSize;
        while (true) {
            List<Scan> newScans;
            boolean gpsInThisRegion;
            byte[] endKey;
            byte[] currentGuidePostBytes;
            RegionInfo regionInfo;
            HRegionLocation regionLocation;
            if (regionIndex <= stopIndex) {
                regionLocation = regionLocations.get(regionIndex);
                regionInfo = regionLocation.getRegion();
                currentGuidePostBytes = currentGuidePost.copyBytes();
                endKey = regionIndex == stopIndex ? stopKey : regionBoundaries.get(regionIndex);
                if (isLocalIndex) {
                    ScanRanges dataScanRanges;
                    if (this.dataPlan != null && this.dataPlan.getTableRef().getTable().getType() != PTableType.INDEX && !(dataScanRanges = this.dataPlan.getContext().getScanRanges()).intersectRegion(regionInfo.getStartKey(), regionInfo.getEndKey(), false)) {
                        currentKeyBytes = endKey;
                        ++regionIndex;
                        continue;
                    }
                    if (columnsInCommon > 0 && prefixScanRanges.useSkipScanFilter()) {
                        byte[] regionStartKey = regionInfo.getStartKey();
                        ImmutableBytesWritable ptr = this.context.getTempPtr();
                        BaseResultIterators.clipKeyRangeBytes(prefixScanRanges.getSchema(), 0, columnsInCommon, regionStartKey, ptr, false);
                        regionStartKey = ByteUtil.copyKeyBytesIfNecessary(ptr);
                        if (!prefixScanRanges.intersectRegion(regionStartKey, regionInfo.getEndKey(), false)) {
                            currentKeyBytes = endKey;
                            ++regionIndex;
                            continue;
                        }
                    }
                    keyOffset = ScanUtil.getRowKeyOffset(regionInfo.getStartKey(), regionInfo.getEndKey());
                }
            } else {
                this.generateEstimates(scanRanges, table, gps, emptyGuidePost, parallelScanCollector.getParallelScans(), estimates, fallbackTs, gpsAvailableForAllRegions);
                if (stream != null) {
                    Closeables.closeQuietly(stream);
                }
                this.sampleScans(parallelScanCollector.getParallelScans(), this.plan.getStatement().getTableSamplingRate());
                return new ScansWithRegionLocations(parallelScanCollector.getParallelScans(), parallelScanCollector.getRegionLocations());
            }
            byte[] initialKeyBytes = currentKeyBytes;
            int gpsComparedToEndKey = -1;
            boolean everNotDelayed = false;
            while (true) {
                List<Scan> newScans2;
                block57: {
                    block58: {
                        block56: {
                            if (!intersectWithGuidePosts || endKey.length != 0 && (gpsComparedToEndKey = currentGuidePost.compareTo(endKey)) > 0) break block56;
                            newScans2 = scanRanges.intersectScan(this.scan, currentKeyBytes, currentGuidePostBytes, keyOffset, splitPostfix, this.getTable().getBucketNum(), gpsComparedToEndKey == 0);
                            if (!this.useStatsForParallelization) break block57;
                            break block58;
                        }
                        boolean bl = gpsInThisRegion = initialKeyBytes != currentKeyBytes;
                        if (!this.useStatsForParallelization) {
                            currentKeyBytes = initialKeyBytes;
                        }
                        newScans = scanRanges.intersectScan(this.scan, currentKeyBytes, endKey, keyOffset, splitPostfix, this.getTable().getBucketNum(), true);
                        break;
                    }
                    for (int newScanIdx = 0; newScanIdx < newScans2.size(); ++newScanIdx) {
                        Scan newScan = newScans2.get(newScanIdx);
                        ScanUtil.setLocalIndexAttributes(newScan, keyOffset, regionInfo.getStartKey(), regionInfo.getEndKey(), newScan.getStartRow(), newScan.getStopRow());
                        if (regionLocation.getServerName() != null) {
                            newScan.setAttribute("_SCAN_REGION_SERVER", regionLocation.getServerName().getVersionedBytes());
                        }
                        boolean lastOfNew = newScanIdx == newScans2.size() - 1;
                        parallelScanCollector.addNewScan(this.plan, newScan, gpsComparedToEndKey == 0 && lastOfNew, regionLocation);
                    }
                }
                if (newScans2.size() > 0) {
                    if (delayAddingEst) {
                        BaseResultIterators.updateEstimates(gps, guideIndex - 1, estimates);
                    }
                    if (!(delayAddingEst = gpsComparedToEndKey == 0)) {
                        BaseResultIterators.updateEstimates(gps, guideIndex, estimates);
                    }
                } else {
                    delayAddingEst = false;
                }
                everNotDelayed |= !delayAddingEst;
                currentKeyBytes = currentGuidePostBytes;
                try {
                    currentGuidePost = PrefixByteCodec.decode(decoder, input);
                    currentGuidePostBytes = currentGuidePost.copyBytes();
                    ++guideIndex;
                }
                catch (EOFException e) {
                    intersectWithGuidePosts = false;
                }
            }
            for (int newScanIdx = 0; newScanIdx < newScans.size(); ++newScanIdx) {
                Scan newScan = newScans.get(newScanIdx);
                ScanUtil.setLocalIndexAttributes(newScan, keyOffset, regionInfo.getStartKey(), regionInfo.getEndKey(), newScan.getStartRow(), newScan.getStopRow());
                if (regionLocation.getServerName() != null) {
                    newScan.setAttribute("_SCAN_REGION_SERVER", regionLocation.getServerName().getVersionedBytes());
                }
                boolean lastOfNew = newScanIdx == newScans.size() - 1;
                parallelScanCollector.addNewScan(this.plan, newScan, lastOfNew, regionLocation);
            }
            if (newScans.size() > 0) {
                if (!gpsInThisRegion && delayAddingEst) {
                    BaseResultIterators.updateEstimates(gps, guideIndex - 1, estimates);
                    gpsInThisRegion = true;
                    delayAddingEst = false;
                }
            } else if (!gpsInThisRegion) {
                delayAddingEst = false;
            }
            currentKeyBytes = endKey;
            boolean gpsAfterStopKey = false;
            gpsAvailableForAllRegions &= gpsInThisRegion && everNotDelayed || regionIndex == startRegionIndex && gpsForFirstRegion || (gpsAfterStopKey = regionIndex == stopIndex && intersectWithGuidePosts && (endRegionKey.length == 0 || currentGuidePost.compareTo(endRegionKey) < 0));
            if (gpsAfterStopKey) {
                fallbackTs = Math.min(fallbackTs, gps.getGuidePostTimestamps()[guideIndex]);
            }
            ++regionIndex;
        }
    }

    private void generateEstimates(ScanRanges scanRanges, PTable table, GuidePostsInfo gps, boolean emptyGuidePost, List<List<Scan>> parallelScans, GuidePostEstimate estimates, long fallbackTs, boolean gpsAvailableForAllRegions) {
        Long pageLimit = BaseResultIterators.getUnfilteredPageLimit(this.scan);
        if (scanRanges.isPointLookup() || pageLimit != null) {
            int parallelFactor;
            int n = parallelFactor = this.isSerial() ? 1 : parallelScans.size();
            this.estimatedRows = scanRanges.isPointLookup() && pageLimit != null ? Long.valueOf(Math.min((long)scanRanges.getPointLookupCount(), pageLimit * (long)parallelFactor)) : (scanRanges.isPointLookup() ? Long.valueOf(scanRanges.getPointLookupCount()) : Long.valueOf(pageLimit * (long)parallelFactor));
            this.estimatedSize = this.estimatedRows * SchemaUtil.estimateRowSize(table);
            this.estimateInfoTimestamp = 0L;
        } else if (emptyGuidePost) {
            this.estimatedRows = gps.getByteCounts()[0] / SchemaUtil.estimateRowSize(table);
            this.estimatedSize = gps.getByteCounts()[0];
            this.estimateInfoTimestamp = gps.getGuidePostTimestamps()[0];
        } else if (this.hasGuidePosts) {
            this.estimatedRows = estimates.rowsEstimate;
            this.estimatedSize = estimates.bytesEstimate;
            this.estimateInfoTimestamp = BaseResultIterators.computeMinTimestamp(gpsAvailableForAllRegions, estimates, fallbackTs);
        } else {
            this.estimatedRows = null;
            this.estimatedSize = null;
            this.estimateInfoTimestamp = null;
        }
    }

    private static Long getUnfilteredPageLimit(Scan scan) {
        Long pageLimit = null;
        Iterator<Filter> filters = ScanUtil.getFilterIterator(scan);
        while (filters.hasNext()) {
            Filter filter = filters.next();
            if (filter instanceof BooleanExpressionFilter) {
                return null;
            }
            if (!(filter instanceof PageFilter)) continue;
            pageLimit = ((PageFilter)filter).getPageSize();
        }
        return pageLimit;
    }

    private static Long computeMinTimestamp(boolean gpsAvailableForAllRegions, GuidePostEstimate estimates, long fallbackTs) {
        if (gpsAvailableForAllRegions) {
            if (estimates.lastUpdated < Long.MAX_VALUE) {
                return estimates.lastUpdated;
            }
            if (fallbackTs < Long.MAX_VALUE) {
                return fallbackTs;
            }
        }
        return null;
    }

    private void sampleScans(List<List<Scan>> parallelScans, Double tableSamplingRate) {
        if (tableSamplingRate == null || tableSamplingRate == 100.0) {
            return;
        }
        TableSamplerPredicate tableSamplerPredicate = TableSamplerPredicate.of(tableSamplingRate);
        Iterator<List<Scan>> is = parallelScans.iterator();
        while (is.hasNext()) {
            Iterator<Scan> i = is.next().iterator();
            while (i.hasNext()) {
                Scan scan = i.next();
                if (tableSamplerPredicate.apply(scan.getStartRow())) continue;
                i.remove();
            }
        }
    }

    public static <T> List<T> reverseIfNecessary(List<T> list, boolean reverse) {
        if (!reverse) {
            return list;
        }
        return Lists.reverse(list);
    }

    @Override
    public List<PeekingResultIterator> getIterators() throws SQLException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(LogUtil.addCustomAnnotations("Getting iterators for " + this, ScanUtil.getCustomAnnotations(this.scan)) + "on table " + this.context.getCurrentTable().getTable().getName());
        }
        boolean isReverse = ScanUtil.isReversed(this.scan);
        boolean isLocalIndex = this.getTable().getIndexType() == PTable.IndexType.LOCAL;
        ConnectionQueryServices services = this.context.getConnection().getQueryServices();
        long startTime = EnvironmentEdgeManager.currentTimeMillis();
        long maxQueryEndTime = startTime + (long)this.context.getStatement().getQueryTimeoutInMillis();
        int numScans = this.size();
        ConcurrentLinkedQueue<PeekingResultIterator> allIterators = new ConcurrentLinkedQueue<PeekingResultIterator>();
        ArrayList<PeekingResultIterator> iterators = new ArrayList<PeekingResultIterator>(numScans);
        ScanWrapper previousScan = new ScanWrapper(null);
        return this.getIterators(this.scans, services, isLocalIndex, allIterators, iterators, isReverse, maxQueryEndTime, this.splits.size(), previousScan, this.context.getConnection().getQueryServices().getConfiguration().getInt("hashjoin.client.retries.number", 5));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Iterators could be improved
     * Loose catch block
     */
    private List<PeekingResultIterator> getIterators(List<List<Scan>> scan, ConnectionQueryServices services, boolean isLocalIndex, Queue<PeekingResultIterator> allIterators, List<PeekingResultIterator> iterators, boolean isReverse, long maxQueryEndTime, int splitSize, ScanWrapper previousScan, int retryCount) throws SQLException {
        block98: {
            boolean success = false;
            ArrayList futures = Lists.newArrayListWithExpectedSize((int)splitSize);
            this.allFutures.add(futures);
            SQLException toThrow = null;
            HashCacheClient hashCacheClient = new HashCacheClient(this.context.getConnection());
            int queryTimeOut = this.context.getStatement().getQueryTimeoutInMillis();
            try {
                this.submitWork(scan, futures, allIterators, splitSize, isReverse, this.scanGrouper, maxQueryEndTime);
                boolean clearedCache = false;
                for (List future : BaseResultIterators.reverseIfNecessary(futures, isReverse)) {
                    List<Object> concatIterators = Lists.newArrayListWithExpectedSize((int)future.size());
                    Iterator<Pair<Scan, Future<PeekingResultIterator>>> scanPairItr = BaseResultIterators.reverseIfNecessary(future, isReverse).iterator();
                    while (scanPairItr.hasNext()) {
                        Pair scanPair = (Pair)scanPairItr.next();
                        try {
                            long timeOutForScan = maxQueryEndTime - EnvironmentEdgeManager.currentTimeMillis();
                            if (forTestingSetTimeoutToMaxToLetQueryPassHere) {
                                timeOutForScan = Long.MAX_VALUE;
                            }
                            if (timeOutForScan < 0L) {
                                throw new SQLExceptionInfo.Builder(SQLExceptionCode.OPERATION_TIMED_OUT).setMessage(". Query couldn't be completed in the allotted time: " + queryTimeOut + " ms").build().buildException();
                            }
                            if (isLocalIndex && previousScan != null && previousScan.getScan() != null && (!isReverse && Bytes.compareTo((byte[])((Scan)scanPair.getFirst()).getAttribute("_ScanActualStartRow"), (byte[])previousScan.getScan().getStopRow()) < 0 || isReverse && previousScan.getScan().getStopRow().length > 0 && Bytes.compareTo((byte[])((Scan)scanPair.getFirst()).getAttribute("_ScanActualStartRow"), (byte[])previousScan.getScan().getStopRow()) > 0 || Bytes.compareTo((byte[])((Scan)scanPair.getFirst()).getStopRow(), (byte[])previousScan.getScan().getStopRow()) == 0) && Bytes.compareTo((byte[])((Scan)scanPair.getFirst()).getAttribute("_ScanStartRowSuffix"), (byte[])previousScan.getScan().getAttribute("_ScanStartRowSuffix")) == 0) continue;
                            PeekingResultIterator iterator = (PeekingResultIterator)((Future)scanPair.getSecond()).get(timeOutForScan, TimeUnit.MILLISECONDS);
                            concatIterators.add(iterator);
                            previousScan.setScan((Scan)scanPair.getFirst());
                        }
                        catch (ExecutionException e) {
                            LOGGER.warn("Getting iterators at BaseResultIterators encountered error for table {}", (Object)TableName.valueOf((byte[])this.physicalTableName), (Object)e);
                            try {
                                throw ClientUtil.parseServerException(e);
                            }
                            catch (HashJoinCacheNotFoundException | StaleRegionBoundaryCacheException e2) {
                                if (!clearedCache) {
                                    services.clearTableRegionCache(TableName.valueOf((byte[])this.physicalTableName));
                                    this.context.getOverallQueryMetrics().cacheRefreshedDueToSplits();
                                }
                                Scan oldScan = (Scan)scanPair.getFirst();
                                byte[] startKey = oldScan.getAttribute("_ScanActualStartRow");
                                if (e2 instanceof HashJoinCacheNotFoundException) {
                                    LOGGER.debug("Retrying when Hash Join cache is not found on the server ,by sending the cache again");
                                    if (retryCount <= 0) {
                                        throw e2;
                                    }
                                    Long cacheId = ((HashJoinCacheNotFoundException)e2).getCacheId();
                                    ServerCacheClient.ServerCache cache = this.caches.get((Object)new ImmutableBytesPtr(Bytes.toBytes((long)cacheId)));
                                    if (cache.getCachePtr() != null && !hashCacheClient.addHashCacheToServer(startKey, cache, this.plan.getTableRef().getTable())) {
                                        throw e2;
                                    }
                                }
                                concatIterators = this.recreateIterators(services, isLocalIndex, allIterators, iterators, isReverse, maxQueryEndTime, previousScan, clearedCache, concatIterators, scanPairItr, (Pair<Scan, Future<PeekingResultIterator>>)scanPair, retryCount - 1);
                            }
                            catch (ColumnFamilyNotFoundException cfnfe) {
                                if (((Scan)scanPair.getFirst()).getAttribute("_LocalIndexBuild") == null) continue;
                                Thread.sleep(1000L);
                                concatIterators = this.recreateIterators(services, isLocalIndex, allIterators, iterators, isReverse, maxQueryEndTime, previousScan, clearedCache, concatIterators, scanPairItr, (Pair<Scan, Future<PeekingResultIterator>>)scanPair, retryCount);
                            }
                        }
                        catch (CancellationException ce) {
                            LOGGER.warn("Iterator scheduled to be executed in Future was being cancelled", (Throwable)ce);
                        }
                    }
                    this.addIterator(iterators, concatIterators);
                }
                success = true;
                List<PeekingResultIterator> list = iterators;
                return list;
            }
            catch (TimeoutException e) {
                OverAllQueryMetrics overAllQueryMetrics = this.context.getOverallQueryMetrics();
                overAllQueryMetrics.queryTimedOut();
                if (this.context.getScanRanges().isPointLookup()) {
                    overAllQueryMetrics.queryPointLookupTimedOut();
                } else {
                    overAllQueryMetrics.queryScanTimedOut();
                }
                GlobalClientMetrics.GLOBAL_QUERY_TIMEOUT_COUNTER.increment();
                toThrow = new SQLExceptionInfo.Builder(SQLExceptionCode.OPERATION_TIMED_OUT).setMessage(". Query couldn't be completed in the allotted time: " + queryTimeOut + " ms").setRootCause(e).build().buildException();
                return toThrow;
            }
            catch (SQLException e) {
                if (e.getErrorCode() == SQLExceptionCode.OPERATION_TIMED_OUT.getErrorCode()) {
                    OverAllQueryMetrics overAllQueryMetrics = this.context.getOverallQueryMetrics();
                    overAllQueryMetrics.queryTimedOut();
                    if (this.context.getScanRanges().isPointLookup()) {
                        overAllQueryMetrics.queryPointLookupTimedOut();
                    } else {
                        overAllQueryMetrics.queryScanTimedOut();
                    }
                    GlobalClientMetrics.GLOBAL_QUERY_TIMEOUT_COUNTER.increment();
                }
                toThrow = e;
                return toThrow;
            }
            catch (Exception e) {
                toThrow = ClientUtil.parseServerException(e);
                return toThrow;
            }
            finally {
                try {
                    if (!success) {
                        this.close();
                        try {
                            SQLCloseables.closeAll(allIterators);
                        }
                        catch (Exception e) {
                            if (toThrow == null) {
                                toThrow = ClientUtil.parseServerException(e);
                            }
                            toThrow.setNextException(ClientUtil.parseServerException(e));
                        }
                        catch (Exception e) {
                            block96: {
                                try {
                                    if (toThrow == null) {
                                        toThrow = ClientUtil.parseServerException(e);
                                        break block96;
                                    }
                                    toThrow.setNextException(ClientUtil.parseServerException(e));
                                }
                                catch (Throwable throwable) {
                                    block97: {
                                        try {
                                            SQLCloseables.closeAll(allIterators);
                                        }
                                        catch (Exception e2) {
                                            if (toThrow == null) {
                                                toThrow = ClientUtil.parseServerException(e2);
                                                break block97;
                                            }
                                            toThrow.setNextException(ClientUtil.parseServerException(e2));
                                        }
                                    }
                                    throw throwable;
                                }
                            }
                            try {
                                SQLCloseables.closeAll(allIterators);
                            }
                            catch (Exception e3) {
                                if (toThrow == null) {
                                    toThrow = ClientUtil.parseServerException(e3);
                                }
                                toThrow.setNextException(ClientUtil.parseServerException(e3));
                            }
                        }
                    }
                }
                finally {
                    if (toThrow == null) break block98;
                    GlobalClientMetrics.GLOBAL_FAILED_QUERY_COUNTER.increment();
                    OverAllQueryMetrics overAllQueryMetrics = this.context.getOverallQueryMetrics();
                    overAllQueryMetrics.queryFailed();
                    if (this.context.getScanRanges().isPointLookup()) {
                        overAllQueryMetrics.queryPointLookupFailed();
                    } else {
                        overAllQueryMetrics.queryScanFailed();
                    }
                    throw toThrow;
                }
            }
        }
        return null;
    }

    private List<PeekingResultIterator> recreateIterators(ConnectionQueryServices services, boolean isLocalIndex, Queue<PeekingResultIterator> allIterators, List<PeekingResultIterator> iterators, boolean isReverse, long maxQueryEndTime, ScanWrapper previousScan, boolean clearedCache, List<PeekingResultIterator> concatIterators, Iterator<Pair<Scan, Future<PeekingResultIterator>>> scanPairItr, Pair<Scan, Future<PeekingResultIterator>> scanPair, int retryCount) throws SQLException {
        scanPairItr.remove();
        Scan oldScan = (Scan)scanPair.getFirst();
        byte[] startKey = oldScan.getAttribute("_ScanActualStartRow");
        byte[] endKey = oldScan.getStopRow();
        List<List<Scan>> newNestedScans = this.getParallelScans(startKey, endKey).getScans();
        this.addIterator(iterators, concatIterators);
        concatIterators = Lists.newArrayList();
        this.getIterators(newNestedScans, services, isLocalIndex, allIterators, iterators, isReverse, maxQueryEndTime, newNestedScans.size(), previousScan, retryCount);
        return concatIterators;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        boolean cancelledWork = false;
        try {
            if (this.allFutures.isEmpty()) {
                return;
            }
            ArrayList futuresToClose = Lists.newArrayListWithExpectedSize((int)this.getSplits().size());
            for (List<List<Pair<Scan, Future<PeekingResultIterator>>>> futures : this.allFutures) {
                for (List<Pair<Scan, Future<PeekingResultIterator>>> futureScans : futures) {
                    for (Pair<Scan, Future<PeekingResultIterator>> futurePair : futureScans) {
                        Future future;
                        if (futurePair == null || (future = (Future)futurePair.getSecond()) == null) continue;
                        if (future.cancel(false)) {
                            cancelledWork = true;
                            continue;
                        }
                        futuresToClose.add(future);
                    }
                }
            }
            for (Future future : futuresToClose) {
                try {
                    PeekingResultIterator iterator = (PeekingResultIterator)future.get();
                    iterator.close();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
                catch (ExecutionException e) {
                    LOGGER.info("Failed to execute task during cancel", (Throwable)e);
                }
            }
        }
        finally {
            SQLCloseables.closeAllQuietly(this.caches.values());
            this.caches.clear();
            if (cancelledWork) {
                this.context.getConnection().getQueryServices().getExecutor().purge();
            }
            this.allFutures.clear();
        }
    }

    private void addIterator(List<PeekingResultIterator> parentIterators, List<PeekingResultIterator> childIterators) throws SQLException {
        if (!childIterators.isEmpty()) {
            if (this.plan.useRoundRobinIterator()) {
                parentIterators.addAll(childIterators);
            } else {
                parentIterators.add(ConcatResultIterator.newIterator(childIterators));
            }
        }
    }

    protected abstract String getName();

    protected abstract void submitWork(List<List<Scan>> var1, List<List<Pair<Scan, Future<PeekingResultIterator>>>> var2, Queue<PeekingResultIterator> var3, int var4, boolean var5, ParallelScanGrouper var6, long var7) throws SQLException;

    @Override
    public int size() {
        return this.scans.size();
    }

    public int getNumRegionLocationLookups() {
        return this.numRegionLocationLookups;
    }

    @Override
    public void explain(List<String> planSteps) {
        this.explainUtil(planSteps, null);
    }

    private void explainUtil(List<String> planSteps, ExplainPlanAttributes.ExplainPlanAttributesBuilder explainPlanAttributesBuilder) {
        ScanPlan scanPlan;
        boolean displayChunkCount = this.context.getConnection().getQueryServices().getProps().getBoolean("phoenix.explain.displayChunkCount", true);
        StringBuilder buf = new StringBuilder();
        buf.append("CLIENT ");
        if (displayChunkCount) {
            boolean displayRowCount = this.context.getConnection().getQueryServices().getProps().getBoolean("phoenix.explain.displayRowCount", true);
            buf.append(this.splits.size()).append("-CHUNK ");
            if (explainPlanAttributesBuilder != null) {
                explainPlanAttributesBuilder.setSplitsChunk(this.splits.size());
            }
            if (displayRowCount && this.estimatedRows != null) {
                buf.append(this.estimatedRows).append(" ROWS ");
                buf.append(this.estimatedSize).append(" BYTES ");
                if (explainPlanAttributesBuilder != null) {
                    explainPlanAttributesBuilder.setEstimatedRows(this.estimatedRows);
                    explainPlanAttributesBuilder.setEstimatedSizeInBytes(this.estimatedSize);
                }
            }
        }
        String iteratorTypeAndScanSize = this.getName() + " " + this.size() + "-WAY";
        buf.append(iteratorTypeAndScanSize).append(" ");
        if (explainPlanAttributesBuilder != null) {
            explainPlanAttributesBuilder.setIteratorTypeAndScanSize(iteratorTypeAndScanSize);
            explainPlanAttributesBuilder.setNumRegionLocationLookups(this.getNumRegionLocationLookups());
        }
        if (this.plan.getStatement().getTableSamplingRate() != null) {
            Double samplingRate = this.plan.getStatement().getTableSamplingRate() / 100.0;
            buf.append(samplingRate).append("-").append("SAMPLED ");
            if (explainPlanAttributesBuilder != null) {
                explainPlanAttributesBuilder.setSamplingRate(samplingRate);
            }
        }
        try {
            if (this.plan.useRoundRobinIterator()) {
                buf.append("ROUND ROBIN ");
                if (explainPlanAttributesBuilder != null) {
                    explainPlanAttributesBuilder.setUseRoundRobinIterator(true);
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        if (this.plan instanceof ScanPlan && (scanPlan = (ScanPlan)this.plan).getRowOffset().isPresent()) {
            String rowOffset = Hex.encodeHexString((byte[])((byte[])scanPlan.getRowOffset().get()));
            buf.append("With RVC Offset 0x").append(rowOffset).append(" ");
            if (explainPlanAttributesBuilder != null) {
                explainPlanAttributesBuilder.setHexStringRVCOffset("0x" + rowOffset);
            }
        }
        this.explain(buf.toString(), planSteps, explainPlanAttributesBuilder, this.regionLocations);
    }

    @Override
    public void explain(List<String> planSteps, ExplainPlanAttributes.ExplainPlanAttributesBuilder explainPlanAttributesBuilder) {
        this.explainUtil(planSteps, explainPlanAttributesBuilder);
    }

    public Long getEstimatedRowCount() {
        return this.estimatedRows;
    }

    public Long getEstimatedByteCount() {
        return this.estimatedSize;
    }

    public String toString() {
        return "ResultIterators [name=" + this.getName() + ",id=" + this.scanId + ",scans=" + this.scans + "]";
    }

    public Long getEstimateInfoTimestamp() {
        return this.estimateInfoTimestamp;
    }

    @VisibleForTesting
    public static void setForTestingSetTimeoutToMaxToLetQueryPassHere(boolean setTimeoutToMax) {
        forTestingSetTimeoutToMaxToLetQueryPassHere = setTimeoutToMax;
    }

    private static class GuidePostEstimate {
        private long bytesEstimate;
        private long rowsEstimate;
        private long lastUpdated = Long.MAX_VALUE;

        private GuidePostEstimate() {
        }
    }

    private static class ScanWrapper {
        Scan scan;

        public Scan getScan() {
            return this.scan;
        }

        public void setScan(Scan scan) {
            this.scan = scan;
        }

        public ScanWrapper(Scan scan) {
            this.scan = scan;
        }
    }

    protected static final class ScanLocator {
        private final int outerListIndex;
        private final int innerListIndex;
        private final Scan scan;
        private final boolean isFirstScan;
        private final boolean isLastScan;

        public ScanLocator(Scan scan, int outerListIndex, int innerListIndex, boolean isFirstScan, boolean isLastScan) {
            this.outerListIndex = outerListIndex;
            this.innerListIndex = innerListIndex;
            this.scan = scan;
            this.isFirstScan = isFirstScan;
            this.isLastScan = isLastScan;
        }

        public int getOuterListIndex() {
            return this.outerListIndex;
        }

        public int getInnerListIndex() {
            return this.innerListIndex;
        }

        public Scan getScan() {
            return this.scan;
        }

        public boolean isFirstScan() {
            return this.isFirstScan;
        }

        public boolean isLastScan() {
            return this.isLastScan;
        }
    }
}

