/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.index;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.compat.hbase.ByteStringer;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.compile.FromCompiler;
import org.apache.phoenix.compile.IndexExpressionCompiler;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.coprocessor.generated.ServerCachingProtos;
import org.apache.phoenix.expression.CoerceExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.ExpressionType;
import org.apache.phoenix.expression.KeyValueColumnExpression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.SingleCellColumnExpression;
import org.apache.phoenix.expression.SingleCellConstructorExpression;
import org.apache.phoenix.expression.function.PartitionIdFunction;
import org.apache.phoenix.expression.visitor.KeyValueExpressionVisitor;
import org.apache.phoenix.hbase.index.AbstractValueGetter;
import org.apache.phoenix.hbase.index.ValueGetter;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.hbase.index.util.GenericKeyValueBuilder;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.hbase.index.util.KeyValueBuilder;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.SQLParser;
import org.apache.phoenix.parse.StatelessTraverseAllParseNodeVisitor;
import org.apache.phoenix.parse.UDFParseNode;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.AmbiguousColumnException;
import org.apache.phoenix.schema.ColumnFamilyNotFoundException;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnFamily;
import org.apache.phoenix.schema.PDatum;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.RowKeySchema;
import org.apache.phoenix.schema.SaltingUtil;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.ValueSchema;
import org.apache.phoenix.schema.transform.TransformMaintainer;
import org.apache.phoenix.schema.tuple.BaseTuple;
import org.apache.phoenix.schema.tuple.MultiKeyValueTuple;
import org.apache.phoenix.schema.tuple.ValueGetterTuple;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarbinaryEncoded;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.thirdparty.com.google.common.base.Predicate;
import org.apache.phoenix.thirdparty.com.google.common.collect.Iterators;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.thirdparty.com.google.common.collect.Sets;
import org.apache.phoenix.transaction.PhoenixTransactionProvider;
import org.apache.phoenix.util.BitSet;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.CDCUtil;
import org.apache.phoenix.util.EncodedColumnsUtil;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.ExpressionUtil;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TransactionUtil;
import org.apache.phoenix.util.TrustedByteArrayOutputStream;

public class IndexMaintainer
implements Writable,
Iterable<ColumnReference> {
    private static final int EXPRESSION_NOT_PRESENT = -1;
    private static final int ESTIMATED_EXPRESSION_SIZE = 8;
    private byte[] viewIndexId;
    private PDataType viewIndexIdType;
    private boolean isMultiTenant;
    private PTableType parentTableType;
    private List<Expression> indexedExpressions;
    private Set<ColumnReference> indexedColumns;
    private Set<ColumnReference> allColumns;
    private List<PDataType> indexedColumnTypes;
    private int indexDataColumnCount;
    private RowKeyMetaData rowKeyMetaData;
    private byte[] indexTableName;
    private int nIndexSaltBuckets;
    private int nDataTableSaltBuckets;
    private byte[] dataEmptyKeyValueCF;
    private ImmutableBytesPtr emptyKeyValueCFPtr;
    private int nDataCFs;
    private boolean indexWALDisabled;
    private boolean isLocalIndex;
    private boolean immutableRows;
    private final boolean isDataTableSalted;
    private final RowKeySchema dataRowKeySchema;
    private int estimatedIndexRowKeyBytes;
    private int estimatedExpressionSize;
    private int[] dataPkPosition;
    private int maxTrailingNulls;
    private ColumnReference indexEmptyKeyValueRef;
    private ColumnReference dataEmptyKeyValueRef;
    private boolean rowKeyOrderOptimizable;
    private PTable.QualifierEncodingScheme encodingScheme;
    private PTable.ImmutableStorageScheme immutableStorageScheme;
    private PTable.QualifierEncodingScheme dataEncodingScheme;
    private PTable.ImmutableStorageScheme dataImmutableStorageScheme;
    private Set<Pair<String, String>> indexedColumnsInfo;
    private Map<ColumnReference, ColumnReference> coveredColumnsMap;
    private String logicalIndexName;
    private boolean isUncovered;
    private Expression indexWhere;
    private Set<ColumnReference> indexWhereColumns;
    private boolean isCDCIndex;
    private volatile RowKeySchema indexRowKeySchema;
    private static int BYTE_OFFSET = 127;

    public static IndexMaintainer create(PTable dataTable, PTable index, PhoenixConnection connection) throws SQLException {
        return IndexMaintainer.create(dataTable, null, index, connection);
    }

    public static IndexMaintainer create(PTable dataTable, PTable cdcTable, PTable index, PhoenixConnection connection) throws SQLException {
        if (dataTable.getType() == PTableType.INDEX || index.getType() != PTableType.INDEX || !dataTable.getIndexes().contains(index)) {
            throw new IllegalArgumentException();
        }
        IndexMaintainer maintainer = new IndexMaintainer(dataTable, cdcTable, index, connection);
        return maintainer;
    }

    public static boolean sendIndexMaintainer(PTable index) {
        PIndexState indexState = index.getIndexState();
        return !indexState.isDisabled() && PIndexState.PENDING_ACTIVE != indexState;
    }

    public static Iterator<PTable> maintainedIndexes(Iterator<PTable> indexes) {
        return Iterators.filter(indexes, (Predicate)new Predicate<PTable>(){

            public boolean apply(PTable index) {
                return IndexMaintainer.sendIndexMaintainer(index);
            }
        });
    }

    public static Iterator<PTable> maintainedGlobalIndexesWithMatchingStorageScheme(final PTable dataTable, Iterator<PTable> indexes) {
        return Iterators.filter(indexes, (Predicate)new Predicate<PTable>(){

            public boolean apply(PTable index) {
                return IndexMaintainer.sendIndexMaintainer(index) && IndexUtil.isGlobalIndex(index) && dataTable.getImmutableStorageScheme() == index.getImmutableStorageScheme() && !CDCUtil.isCDCIndex(index);
            }
        });
    }

    public static Iterator<PTable> maintainedLocalOrGlobalIndexesWithoutMatchingStorageScheme(final PTable dataTable, Iterator<PTable> indexes) {
        return Iterators.filter(indexes, (Predicate)new Predicate<PTable>(){

            public boolean apply(PTable index) {
                return IndexMaintainer.sendIndexMaintainer(index) && (index.getIndexType() == PTable.IndexType.GLOBAL && dataTable.getImmutableStorageScheme() != index.getImmutableStorageScheme() || index.getIndexType() == PTable.IndexType.LOCAL || CDCUtil.isCDCIndex(index));
            }
        });
    }

    public static Iterator<PTable> maintainedLocalIndexes(Iterator<PTable> indexes) {
        return Iterators.filter(indexes, (Predicate)new Predicate<PTable>(){

            public boolean apply(PTable index) {
                return IndexMaintainer.sendIndexMaintainer(index) && index.getIndexType() == PTable.IndexType.LOCAL;
            }
        });
    }

    public static void serialize(PTable dataTable, ImmutableBytesWritable ptr, PhoenixConnection connection) throws SQLException {
        List<PTable> indexes = dataTable.getIndexes();
        IndexMaintainer.serializeServerMaintainedIndexes(dataTable, ptr, indexes, connection);
    }

    public static void serializeServerMaintainedIndexes(PTable dataTable, ImmutableBytesWritable ptr, List<PTable> indexes, PhoenixConnection connection) throws SQLException {
        boolean onlyLocalIndexes;
        Iterator<Object> indexesItr = Collections.emptyListIterator();
        boolean bl = onlyLocalIndexes = dataTable.isImmutableRows() || dataTable.isTransactional();
        if (onlyLocalIndexes) {
            if (!dataTable.isTransactional() || !dataTable.getTransactionProvider().getTransactionProvider().isUnsupported(PhoenixTransactionProvider.Feature.MAINTAIN_LOCAL_INDEX_ON_SERVER)) {
                indexesItr = IndexMaintainer.maintainedLocalOrGlobalIndexesWithoutMatchingStorageScheme(dataTable, indexes.iterator());
            }
        } else {
            indexesItr = IndexMaintainer.maintainedIndexes(indexes.iterator());
        }
        IndexMaintainer.serialize(dataTable, ptr, Lists.newArrayList(indexesItr), connection);
    }

    public static void serialize(PTable dataTable, ImmutableBytesWritable ptr, List<PTable> indexes, PhoenixConnection connection) throws SQLException {
        if (indexes.isEmpty() && dataTable.getTransformingNewTable() == null) {
            ptr.set(ByteUtil.EMPTY_BYTE_ARRAY);
            return;
        }
        int nIndexes = indexes.size();
        if (dataTable.getTransformingNewTable() != null) {
            boolean disabled = dataTable.getTransformingNewTable().isIndexStateDisabled();
            if (disabled && nIndexes == 0) {
                ptr.set(ByteUtil.EMPTY_BYTE_ARRAY);
                return;
            }
            if (!disabled) {
                ++nIndexes;
            }
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(stream);
        try {
            boolean disabled;
            WritableUtils.writeVInt((DataOutput)output, (int)(nIndexes * (dataTable.getBucketNum() == null ? 1 : -1)));
            dataTable.getRowKeySchema().write(output);
            for (PTable index : indexes) {
                ServerCachingProtos.IndexMaintainer proto = IndexMaintainer.toProto(index.getIndexMaintainer(dataTable, connection));
                byte[] protoBytes = proto.toByteArray();
                WritableUtils.writeVInt((DataOutput)output, (int)protoBytes.length);
                output.write(protoBytes);
            }
            if (dataTable.getTransformingNewTable() != null && !(disabled = dataTable.getTransformingNewTable().isIndexStateDisabled())) {
                ServerCachingProtos.TransformMaintainer proto = TransformMaintainer.toProto(dataTable.getTransformingNewTable().getTransformMaintainer(dataTable, connection));
                byte[] protoBytes = proto.toByteArray();
                WritableUtils.writeVInt((DataOutput)output, (int)protoBytes.length);
                output.write(protoBytes);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ptr.set(stream.toByteArray(), 0, stream.size());
    }

    public static void serializeAdditional(PTable table, ImmutableBytesWritable indexMetaDataPtr, List<PTable> keyValueIndexes, PhoenixConnection connection) throws SQLException {
        int nMutableIndexes = indexMetaDataPtr.getLength() == 0 ? 0 : ByteUtil.vintFromBytes(indexMetaDataPtr);
        int nIndexes = nMutableIndexes + keyValueIndexes.size();
        int estimatedSize = indexMetaDataPtr.getLength() + 1;
        if (indexMetaDataPtr.getLength() == 0) {
            estimatedSize += table.getRowKeySchema().getEstimatedByteSize();
        }
        for (PTable index : keyValueIndexes) {
            estimatedSize += index.getIndexMaintainer(table, connection).getEstimatedByteSize();
        }
        TrustedByteArrayOutputStream stream = new TrustedByteArrayOutputStream(estimatedSize + 1);
        DataOutputStream output = new DataOutputStream(stream);
        try {
            WritableUtils.writeVInt((DataOutput)output, (int)(nIndexes * (table.getBucketNum() == null ? 1 : -1)));
            if (indexMetaDataPtr.getLength() > 0) {
                output.write(indexMetaDataPtr.get(), indexMetaDataPtr.getOffset(), indexMetaDataPtr.getLength() - WritableUtils.getVIntSize((long)nMutableIndexes));
            } else {
                table.getRowKeySchema().write(output);
            }
            for (PTable index : keyValueIndexes) {
                IndexMaintainer maintainer = index.getIndexMaintainer(table, connection);
                byte[] protoBytes = IndexMaintainer.toProto(maintainer).toByteArray();
                WritableUtils.writeVInt((DataOutput)output, (int)protoBytes.length);
                output.write(protoBytes);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        indexMetaDataPtr.set(stream.getBuffer(), 0, stream.size());
    }

    public static List<IndexMaintainer> deserialize(ImmutableBytesWritable metaDataPtr, KeyValueBuilder builder, boolean useProtoForIndexMaintainer) {
        return IndexMaintainer.deserialize(metaDataPtr.get(), metaDataPtr.getOffset(), metaDataPtr.getLength(), useProtoForIndexMaintainer);
    }

    public static List<IndexMaintainer> deserialize(byte[] buf, boolean useProtoForIndexMaintainer) {
        return IndexMaintainer.deserialize(buf, 0, buf.length, useProtoForIndexMaintainer);
    }

    private static List<IndexMaintainer> deserialize(byte[] buf, int offset, int length, boolean useProtoForIndexMaintainer) {
        ArrayList maintainers = Collections.emptyList();
        if (length > 0) {
            ByteArrayInputStream stream = new ByteArrayInputStream(buf, offset, length);
            DataInputStream input = new DataInputStream(stream);
            try {
                int size = WritableUtils.readVInt((DataInput)input);
                boolean isDataTableSalted = size < 0;
                size = Math.abs(size);
                RowKeySchema rowKeySchema = new RowKeySchema();
                rowKeySchema.readFields(input);
                maintainers = Lists.newArrayListWithExpectedSize((int)size);
                for (int i = 0; i < size; ++i) {
                    if (useProtoForIndexMaintainer) {
                        int protoSize = WritableUtils.readVInt((DataInput)input);
                        byte[] b = new byte[protoSize];
                        input.readFully(b);
                        try {
                            ServerCachingProtos.IndexMaintainer proto = ServerCachingProtos.IndexMaintainer.parseFrom(b);
                            maintainers.add(IndexMaintainer.fromProto(proto, rowKeySchema, isDataTableSalted));
                        }
                        catch (InvalidProtocolBufferException e) {
                            ServerCachingProtos.TransformMaintainer proto = ServerCachingProtos.TransformMaintainer.parseFrom(b);
                            maintainers.add(TransformMaintainer.fromProto(proto, rowKeySchema, isDataTableSalted));
                        }
                        continue;
                    }
                    IndexMaintainer maintainer = new IndexMaintainer(rowKeySchema, isDataTableSalted);
                    maintainer.readFields(input);
                    maintainers.add(maintainer);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return maintainers;
    }

    public static IndexMaintainer getIndexMaintainer(List<IndexMaintainer> maintainers, byte[] indexTableName) {
        for (IndexMaintainer maintainer : maintainers) {
            if (Bytes.compareTo((byte[])indexTableName, (byte[])maintainer.getIndexTableName()) != 0) continue;
            return maintainer;
        }
        return null;
    }

    protected IndexMaintainer(RowKeySchema dataRowKeySchema, boolean isDataTableSalted) {
        this.dataRowKeySchema = dataRowKeySchema;
        this.isDataTableSalted = isDataTableSalted;
    }

    private IndexMaintainer(PTable dataTable, PTable index, PhoenixConnection connection) throws SQLException {
        this(dataTable, null, index, connection);
    }

    private IndexMaintainer(final PTable dataTable, PTable cdcTable, PTable index, PhoenixConnection connection) throws SQLException {
        this(dataTable.getRowKeySchema(), dataTable.getBucketNum() != null);
        int i;
        this.rowKeyOrderOptimizable = index.rowKeyOrderOptimizable();
        this.isMultiTenant = dataTable.isMultiTenant();
        this.viewIndexId = index.getViewIndexId() == null ? null : index.getviewIndexIdType().toBytes(index.getViewIndexId());
        this.viewIndexIdType = index.getviewIndexIdType();
        this.isLocalIndex = index.getIndexType() == PTable.IndexType.LOCAL;
        this.isUncovered = index.getIndexType() == PTable.IndexType.UNCOVERED_GLOBAL;
        this.encodingScheme = index.getEncodingScheme();
        this.isCDCIndex = CDCUtil.isCDCIndex(index);
        this.encodingScheme = index.getEncodingScheme() == null ? PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS : index.getEncodingScheme();
        this.immutableStorageScheme = index.getImmutableStorageScheme() == null ? PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN : index.getImmutableStorageScheme();
        this.dataEncodingScheme = dataTable.getEncodingScheme() == null ? PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS : dataTable.getEncodingScheme();
        this.dataImmutableStorageScheme = dataTable.getImmutableStorageScheme() == null ? PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN : dataTable.getImmutableStorageScheme();
        this.nDataTableSaltBuckets = this.isDataTableSalted ? dataTable.getBucketNum() : PTable.NO_SALTING;
        byte[] indexTableName = index.getPhysicalName().getBytes();
        Integer nIndexSaltBuckets = this.isLocalIndex ? dataTable.getBucketNum() : index.getBucketNum();
        boolean indexWALDisabled = index.isWALDisabled();
        int indexPosOffset = (index.getBucketNum() == null ? 0 : 1) + (this.isMultiTenant ? 1 : 0) + (this.viewIndexId == null ? 0 : 1);
        int nIndexColumns = index.getColumns().size() - indexPosOffset;
        int nIndexPKColumns = index.getPKColumns().size() - indexPosOffset;
        int indexedExpressionCount = 0;
        for (int i2 = indexPosOffset; i2 < index.getPKColumns().size(); ++i2) {
            PColumn indexColumn = index.getPKColumns().get(i2);
            String indexColumnName = indexColumn.getName().getString();
            String dataFamilyName = IndexUtil.getDataColumnFamilyName(indexColumnName);
            String dataColumnName = IndexUtil.getDataColumnName(indexColumnName);
            try {
                PColumn dataColumn;
                PColumn pColumn = dataColumn = dataFamilyName.equals("") ? dataTable.getColumnForColumnName(dataColumnName) : dataTable.getColumnFamily(dataFamilyName).getPColumnForColumnName(dataColumnName);
                if (SchemaUtil.isPKColumn(dataColumn)) {
                    continue;
                }
            }
            catch (ColumnNotFoundException dataColumn) {
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
            ++indexedExpressionCount;
        }
        int dataPosOffset = (this.isDataTableSalted ? 1 : 0) + (this.isMultiTenant ? 1 : 0);
        List<PColumn> dataPKColumns = dataTable.getPKColumns();
        this.indexDataColumnCount = dataPKColumns.size();
        PTable parentTable = dataTable;
        if (!dataTable.getName().equals(cdcTable != null ? cdcTable.getParentName() : index.getParentName())) {
            try {
                String tenantId = index.getTenantId() != null ? index.getTenantId().getString() : null;
                parentTable = connection.getTable(tenantId, index.getParentName().getString());
                this.indexDataColumnCount = parentTable.getPKColumns().size();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        this.parentTableType = parentTable.getType();
        int indexPkColumnCount = this.indexDataColumnCount + indexedExpressionCount - (this.isDataTableSalted ? 1 : 0) - (this.isMultiTenant ? 1 : 0);
        this.rowKeyMetaData = this.newRowKeyMetaData(indexPkColumnCount);
        BitSet bitSet = this.rowKeyMetaData.getViewConstantColumnBitSet();
        int nDataPKColumns = this.indexDataColumnCount - dataPosOffset;
        for (int i3 = dataPosOffset; i3 < dataPKColumns.size(); ++i3) {
            PColumn dataPKColumn = dataPKColumns.get(i3);
            if (dataPKColumn.getViewConstant() == null) continue;
            bitSet.set(i3);
            --nDataPKColumns;
        }
        this.indexTableName = indexTableName;
        this.indexedColumnTypes = Lists.newArrayListWithExpectedSize((int)(nIndexPKColumns - nDataPKColumns));
        this.indexedExpressions = Lists.newArrayListWithExpectedSize((int)(nIndexPKColumns - nDataPKColumns));
        this.coveredColumnsMap = Maps.newHashMapWithExpectedSize((int)(nIndexColumns - nIndexPKColumns));
        this.nIndexSaltBuckets = nIndexSaltBuckets == null ? PTable.NO_SALTING : nIndexSaltBuckets;
        this.dataEmptyKeyValueCF = SchemaUtil.getEmptyColumnFamily(dataTable);
        this.emptyKeyValueCFPtr = SchemaUtil.getEmptyColumnFamilyPtr(index);
        this.nDataCFs = dataTable.getColumnFamilies().size();
        this.indexWALDisabled = indexWALDisabled;
        this.immutableRows = dataTable.isImmutableRows();
        int indexColByteSize = 0;
        ColumnResolver resolver = null;
        ArrayList<ParseNode> parseNodes = new ArrayList<ParseNode>(1);
        UDFParseNodeVisitor visitor = new UDFParseNodeVisitor();
        for (int i4 = indexPosOffset; i4 < index.getPKColumns().size(); ++i4) {
            PColumn indexColumn = index.getPKColumns().get(i4);
            String expressionStr = IndexUtil.getIndexColumnExpressionStr(indexColumn);
            try {
                ParseNode parseNode = SQLParser.parseCondition(expressionStr);
                parseNode.accept(visitor);
                parseNodes.add(parseNode);
                continue;
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            resolver = FromCompiler.getResolver(connection, new TableRef(dataTable), visitor.getUdfParseNodes());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        StatementContext context = new StatementContext(new PhoenixStatement(connection), resolver);
        this.indexedColumnsInfo = Sets.newHashSetWithExpectedSize((int)(nIndexColumns - nIndexPKColumns));
        IndexExpressionCompiler expressionIndexCompiler = new IndexExpressionCompiler(context);
        for (i = indexPosOffset; i < index.getPKColumns().size(); ++i) {
            PColumn indexColumn = index.getPKColumns().get(i);
            int indexPos = i - indexPosOffset;
            Expression expression = null;
            try {
                expressionIndexCompiler.reset();
                expression = ((ParseNode)parseNodes.get(indexPos)).accept(expressionIndexCompiler);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            if (expressionIndexCompiler.getColumnRef() != null) {
                PColumn column = IndexUtil.getDataColumn(dataTable, indexColumn.getName().getString());
                boolean isPKColumn = SchemaUtil.isPKColumn(column);
                if (isPKColumn) {
                    int dataPkPos = dataTable.getPKColumns().indexOf(column) - (dataTable.getBucketNum() == null ? 0 : 1) - (this.isMultiTenant ? 1 : 0);
                    this.rowKeyMetaData.setIndexPkPosition(dataPkPos, indexPos);
                    this.indexedColumnsInfo.add((Pair<String, String>)new Pair((Object)null, (Object)column.getName().getString()));
                } else {
                    indexColByteSize += column.getDataType().isFixedWidth() ? SchemaUtil.getFixedByteSize(column) : 10;
                    try {
                        if (column.isNullable() && ExpressionUtil.isConstant(expression)) {
                            expression = CoerceExpression.create(expression, indexColumn.getDataType());
                        }
                        this.indexedExpressions.add(expression);
                        this.indexedColumnsInfo.add((Pair<String, String>)new Pair((Object)column.getFamilyName().getString(), (Object)column.getName().getString()));
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                }
            } else {
                indexColByteSize += expression.getDataType().isFixedWidth() ? SchemaUtil.getFixedByteSize(expression) : 10;
                this.indexedExpressions.add(expression);
                KeyValueExpressionVisitor kvVisitor = new KeyValueExpressionVisitor(){

                    @Override
                    public Void visit(KeyValueColumnExpression colExpression) {
                        return this.addDataColInfo(dataTable, colExpression);
                    }

                    @Override
                    public Void visit(SingleCellColumnExpression expression) {
                        return this.addDataColInfo(dataTable, expression);
                    }

                    private Void addDataColInfo(PTable dataTable2, Expression expression) {
                        Preconditions.checkArgument((expression instanceof SingleCellColumnExpression || expression instanceof KeyValueColumnExpression ? 1 : 0) != 0);
                        KeyValueColumnExpression colExpression = null;
                        colExpression = expression instanceof SingleCellColumnExpression ? ((SingleCellColumnExpression)expression).getKeyValueExpression() : (KeyValueColumnExpression)expression;
                        byte[] cf = colExpression.getColumnFamily();
                        byte[] cq = colExpression.getColumnQualifier();
                        try {
                            PColumn dataColumn;
                            PColumn pColumn = dataColumn = cf == null ? dataTable2.getColumnForColumnQualifier(null, cq) : dataTable2.getColumnFamily(cf).getPColumnForColumnQualifier(cq);
                            if (dataColumn == null) {
                                if (Bytes.compareTo((byte[])cf, (byte[])IndexMaintainer.this.dataEmptyKeyValueCF) == 0 && Bytes.compareTo((byte[])cq, (byte[])((byte[])EncodedColumnsUtil.getEmptyKeyValueInfo(IndexMaintainer.this.dataEncodingScheme).getFirst())) == 0) {
                                    return null;
                                }
                                throw new ColumnNotFoundException(dataTable2.getSchemaName().getString(), dataTable2.getTableName().getString(), Bytes.toString((byte[])cf), Bytes.toString((byte[])cq));
                            }
                            IndexMaintainer.this.indexedColumnsInfo.add((Pair<String, String>)new Pair((Object)dataColumn.getFamilyName().getString(), (Object)dataColumn.getName().getString()));
                        }
                        catch (AmbiguousColumnException | ColumnFamilyNotFoundException | ColumnNotFoundException e) {
                            if (dataTable2.hasOnlyPkColumns()) {
                                return null;
                            }
                            throw new RuntimeException(e);
                        }
                        return null;
                    }
                };
                expression.accept(kvVisitor);
            }
            if (indexColumn.getSortOrder() != SortOrder.DESC) continue;
            this.rowKeyMetaData.getDescIndexColumnBitSet().set(indexPos);
        }
        this.estimatedExpressionSize = expressionIndexCompiler.getTotalNodeCount() * 8;
        for (i = 0; i < index.getColumnFamilies().size(); ++i) {
            PColumnFamily family = index.getColumnFamilies().get(i);
            for (PColumn indexColumn : family.getColumns()) {
                PColumn dataColumn = IndexUtil.getDataColumnOrNull(dataTable, indexColumn.getName().getString());
                if (dataColumn == null) continue;
                byte[] dataColumnCq = dataColumn.getColumnQualifierBytes();
                byte[] indexColumnCq = indexColumn.getColumnQualifierBytes();
                this.coveredColumnsMap.put(new ColumnReference(dataColumn.getFamilyName().getBytes(), dataColumnCq), new ColumnReference(indexColumn.getFamilyName().getBytes(), indexColumnCq));
            }
        }
        this.estimatedIndexRowKeyBytes = this.estimateIndexRowKeyByteSize(indexColByteSize);
        this.logicalIndexName = index.getName().getString();
        if (index.getIndexWhere() != null) {
            this.indexWhere = index.getIndexWhereExpression(connection);
            this.indexWhereColumns = index.getIndexWhereColumns(connection);
        }
        this.initCachedState();
    }

    public void setDataImmutableStorageScheme(PTable.ImmutableStorageScheme sc) {
        this.dataImmutableStorageScheme = sc;
    }

    public void setDataEncodingScheme(PTable.QualifierEncodingScheme sc) {
        this.dataEncodingScheme = sc;
    }

    public byte[] buildRowKey(ValueGetter valueGetter, ImmutableBytesWritable rowKeyPtr, byte[] regionStartKey, byte[] regionEndKey, long ts) {
        return this.buildRowKey(valueGetter, rowKeyPtr, regionStartKey, regionEndKey, ts, null);
    }

    public byte[] buildRowKey(ValueGetter valueGetter, ImmutableBytesWritable rowKeyPtr, byte[] regionStartKey, byte[] regionEndKey, long ts, byte[] encodedRegionName) {
        boolean isIndexSalted;
        if (this.isCDCIndex && encodedRegionName == null) {
            throw new IllegalArgumentException("Encoded region name is required for a CDC index");
        }
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        boolean prependRegionStartKey = this.isLocalIndex && regionStartKey != null;
        boolean bl = isIndexSalted = !this.isLocalIndex && !this.isCDCIndex && this.nIndexSaltBuckets > 0;
        int prefixKeyLength = prependRegionStartKey ? (regionStartKey.length != 0 ? regionStartKey.length : regionEndKey.length) : 0;
        TrustedByteArrayOutputStream stream = new TrustedByteArrayOutputStream(this.estimatedIndexRowKeyBytes + (prependRegionStartKey ? prefixKeyLength : 0));
        DataOutputStream output = new DataOutputStream(stream);
        try {
            if (prependRegionStartKey) {
                if (regionStartKey.length == 0) {
                    output.write(new byte[prefixKeyLength]);
                } else {
                    output.write(regionStartKey);
                }
            }
            if (isIndexSalted) {
                output.write(0);
            }
            int dataPosOffset = this.isDataTableSalted ? 1 : 0;
            BitSet viewConstantColumnBitSet = this.rowKeyMetaData.getViewConstantColumnBitSet();
            int nIndexedColumns = this.getIndexPkColumnCount() - this.getNumViewConstants();
            int[][] dataRowKeyLocator = new int[2][nIndexedColumns];
            int maxRowKeyOffset = rowKeyPtr.getOffset() + rowKeyPtr.getLength();
            this.dataRowKeySchema.iterator(rowKeyPtr, ptr, dataPosOffset);
            if (this.viewIndexId != null) {
                output.write(this.viewIndexId);
            }
            if (this.isMultiTenant) {
                this.dataRowKeySchema.next(ptr, dataPosOffset, maxRowKeyOffset);
                output.write(ptr.get(), ptr.getOffset(), ptr.getLength());
                if (!this.dataRowKeySchema.getField(dataPosOffset).getDataType().isFixedWidth()) {
                    output.write(SchemaUtil.getSeparatorBytes(this.dataRowKeySchema.getField(dataPosOffset).getDataType(), this.rowKeyOrderOptimizable, ptr.getLength() == 0, this.dataRowKeySchema.getField(dataPosOffset).getSortOrder()));
                }
                ++dataPosOffset;
            }
            for (int i = dataPosOffset; i < this.indexDataColumnCount; ++i) {
                Boolean hasValue = this.dataRowKeySchema.next(ptr, i, maxRowKeyOffset);
                if (viewConstantColumnBitSet.get(i) && !this.isIndexOnBaseTable()) continue;
                int pos = this.rowKeyMetaData.getIndexPkPosition(i - dataPosOffset);
                if (Boolean.TRUE.equals(hasValue)) {
                    dataRowKeyLocator[0][pos] = ptr.getOffset();
                    dataRowKeyLocator[1][pos] = ptr.getLength();
                    continue;
                }
                dataRowKeyLocator[0][pos] = 0;
                dataRowKeyLocator[1][pos] = 0;
            }
            BitSet descIndexColumnBitSet = this.rowKeyMetaData.getDescIndexColumnBitSet();
            Iterator<Expression> expressionIterator = this.indexedExpressions.iterator();
            int trailingVariableWidthColumnNum = 0;
            PDataType[] indexedColumnDataTypes = new PDataType[nIndexedColumns];
            for (int i = 0; i < nIndexedColumns; ++i) {
                PDataType indexColumnType;
                boolean isNullable;
                SortOrder dataSortOrder;
                PDataType dataColumnType;
                if (this.dataPkPosition[i] == -1) {
                    Expression expression = expressionIterator.next();
                    dataColumnType = expression.getDataType();
                    dataSortOrder = expression.getSortOrder();
                    isNullable = expression.isNullable();
                    if (expression instanceof PartitionIdFunction) {
                        if (i != 0) {
                            throw new DoNotRetryIOException("PARTITION_ID() has to be the prefix of the index row key!");
                        }
                        if (!this.isCDCIndex) {
                            throw new DoNotRetryIOException("PARTITION_ID() should be used only for CDC Indexes!");
                        }
                        ptr.set(encodedRegionName);
                    } else {
                        expression.evaluate(new ValueGetterTuple(valueGetter, ts), ptr);
                    }
                } else {
                    ValueSchema.Field field = this.dataRowKeySchema.getField(this.dataPkPosition[i]);
                    dataColumnType = field.getDataType();
                    ptr.set(rowKeyPtr.get(), dataRowKeyLocator[0][i], dataRowKeyLocator[1][i]);
                    dataSortOrder = field.getSortOrder();
                    isNullable = field.isNullable();
                }
                boolean isDataColumnInverted = dataSortOrder != SortOrder.ASC;
                indexedColumnDataTypes[i] = indexColumnType = IndexUtil.getIndexColumnDataType(isNullable, dataColumnType);
                boolean isBytesComparable = dataColumnType.isBytesComparableWith(indexColumnType);
                boolean isIndexColumnDesc = descIndexColumnBitSet.get(i);
                if (isBytesComparable && isDataColumnInverted == isIndexColumnDesc) {
                    output.write(ptr.get(), ptr.getOffset(), ptr.getLength());
                } else {
                    if (!isBytesComparable) {
                        indexColumnType.coerceBytes(ptr, dataColumnType, dataSortOrder, SortOrder.getDefault());
                    }
                    if (isDataColumnInverted != isIndexColumnDesc) {
                        IndexMaintainer.writeInverted(ptr.get(), ptr.getOffset(), ptr.getLength(), output);
                    } else {
                        output.write(ptr.get(), ptr.getOffset(), ptr.getLength());
                    }
                }
                if (!indexColumnType.isFixedWidth()) {
                    output.write(SchemaUtil.getSeparatorBytes(indexColumnType, this.rowKeyOrderOptimizable, ptr.getLength() == 0, isIndexColumnDesc ? SortOrder.DESC : SortOrder.ASC));
                    ++trailingVariableWidthColumnNum;
                    continue;
                }
                trailingVariableWidthColumnNum = 0;
            }
            byte[] indexRowKey = stream.getBuffer();
            int length = stream.size();
            int minLength = length - this.maxTrailingNulls;
            for (int indexColumnIdx = nIndexedColumns - 1; trailingVariableWidthColumnNum > 0 && length > minLength && indexColumnIdx >= 0; --trailingVariableWidthColumnNum, --indexColumnIdx) {
                if (indexedColumnDataTypes[indexColumnIdx] != PVarbinaryEncoded.INSTANCE) {
                    if (indexRowKey[length - 1] != 0) break;
                    --length;
                    continue;
                }
                byte[] sepBytes = QueryConstants.VARBINARY_ENCODED_SEPARATOR_BYTES;
                if (length < 2 || indexRowKey[length - 1] != sepBytes[1] || indexRowKey[length - 2] != sepBytes[0]) break;
                length -= 2;
            }
            if (isIndexSalted) {
                byte saltByte;
                indexRowKey[0] = saltByte = SaltingUtil.getSaltingByte(indexRowKey, 1, length - 1, this.nIndexSaltBuckets);
            }
            byte[] byArray = indexRowKey.length == length ? indexRowKey : Arrays.copyOf(indexRowKey, length);
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public byte[] buildDataRowKey(ImmutableBytesWritable indexRowKeyPtr, byte[][] viewConstants) {
        RowKeySchema indexRowKeySchema = this.getIndexRowKeySchema();
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        TrustedByteArrayOutputStream stream = new TrustedByteArrayOutputStream(this.estimatedIndexRowKeyBytes);
        DataOutputStream output = new DataOutputStream(stream);
        int dataPosOffset = 0;
        int viewConstantsIndex = 0;
        try {
            int indexPosOffset = !this.isLocalIndex && !this.isCDCIndex && this.nIndexSaltBuckets > 0 ? 1 : 0;
            int maxRowKeyOffset = indexRowKeyPtr.getOffset() + indexRowKeyPtr.getLength();
            indexRowKeySchema.iterator(indexRowKeyPtr, ptr, indexPosOffset);
            if (this.isDataTableSalted) {
                ++dataPosOffset;
                output.write(0);
            }
            if (this.viewIndexId != null) {
                indexRowKeySchema.next(ptr, indexPosOffset++, maxRowKeyOffset);
            }
            if (this.isMultiTenant) {
                indexRowKeySchema.next(ptr, indexPosOffset, maxRowKeyOffset);
                output.write(ptr.get(), ptr.getOffset(), ptr.getLength());
                if (!this.dataRowKeySchema.getField(dataPosOffset).getDataType().isFixedWidth()) {
                    output.write(SchemaUtil.getSeparatorBytes(this.dataRowKeySchema.getField(dataPosOffset).getDataType(), this.rowKeyOrderOptimizable, ptr.getLength() == 0, this.dataRowKeySchema.getField(dataPosOffset).getSortOrder()));
                }
                ++indexPosOffset;
                ++dataPosOffset;
            }
            indexPosOffset = (!this.isLocalIndex && !this.isCDCIndex && this.nIndexSaltBuckets > 0 ? 1 : 0) + (this.isMultiTenant ? 1 : 0) + (this.viewIndexId == null ? 0 : 1);
            BitSet viewConstantColumnBitSet = this.rowKeyMetaData.getViewConstantColumnBitSet();
            BitSet descIndexColumnBitSet = this.rowKeyMetaData.getDescIndexColumnBitSet();
            int trailingVariableWidthColumnNum = 0;
            for (int i = dataPosOffset; i < this.dataRowKeySchema.getFieldCount(); ++i) {
                if (viewConstantColumnBitSet.get(i)) {
                    output.write(viewConstants[viewConstantsIndex++]);
                } else {
                    int pos = this.rowKeyMetaData.getIndexPkPosition(i - dataPosOffset);
                    Boolean hasValue = indexRowKeySchema.iterator(indexRowKeyPtr, ptr, pos + indexPosOffset + 1);
                    if (Boolean.TRUE.equals(hasValue)) {
                        ValueSchema.Field dataField = this.dataRowKeySchema.getField(i);
                        ValueSchema.Field indexField = indexRowKeySchema.getField(pos + indexPosOffset);
                        PDataType indexColumnType = indexField.getDataType();
                        PDataType dataColumnType = dataField.getDataType();
                        SortOrder dataSortOrder = dataField.getSortOrder();
                        SortOrder indexSortOrder = indexField.getSortOrder();
                        boolean isDataColumnInverted = dataSortOrder != SortOrder.ASC;
                        boolean isBytesComparable = dataColumnType.isBytesComparableWith(indexColumnType);
                        if (isBytesComparable && isDataColumnInverted == descIndexColumnBitSet.get(pos)) {
                            output.write(ptr.get(), ptr.getOffset(), ptr.getLength());
                        } else {
                            if (!isBytesComparable) {
                                dataColumnType.coerceBytes(ptr, indexColumnType, indexSortOrder, SortOrder.getDefault());
                            }
                            if (descIndexColumnBitSet.get(pos) != isDataColumnInverted) {
                                IndexMaintainer.writeInverted(ptr.get(), ptr.getOffset(), ptr.getLength(), output);
                            } else {
                                output.write(ptr.get(), ptr.getOffset(), ptr.getLength());
                            }
                        }
                    }
                }
                if (!this.dataRowKeySchema.getField(i).getDataType().isFixedWidth()) {
                    output.write(SchemaUtil.getSeparatorBytes(this.dataRowKeySchema.getField(i).getDataType(), this.rowKeyOrderOptimizable, ptr.getLength() == 0, this.dataRowKeySchema.getField(i).getSortOrder()));
                    ++trailingVariableWidthColumnNum;
                    continue;
                }
                trailingVariableWidthColumnNum = 0;
            }
            int length = stream.size();
            byte[] dataRowKey = stream.getBuffer();
            int indexColumnIdx = this.dataRowKeySchema.getFieldCount() - 1;
            while (trailingVariableWidthColumnNum > 0) {
                PDataType dataType = this.dataRowKeySchema.getField(indexColumnIdx).getDataType();
                if (dataType != PVarbinaryEncoded.INSTANCE) {
                    if (dataRowKey[length - 1] != 0) break;
                    --length;
                } else {
                    byte[] sepBytes = QueryConstants.VARBINARY_ENCODED_SEPARATOR_BYTES;
                    if (length < 2 || dataRowKey[length - 1] != sepBytes[1] || dataRowKey[length - 2] != sepBytes[0]) break;
                    length -= 2;
                }
                --trailingVariableWidthColumnNum;
                --indexColumnIdx;
            }
            if (this.isDataTableSalted) {
                byte saltByte;
                dataRowKey[0] = saltByte = SaltingUtil.getSaltingByte(dataRowKey, 1, length - 1, this.nDataTableSaltBuckets);
            }
            byte[] byArray = dataRowKey.length == length ? dataRowKey : Arrays.copyOf(dataRowKey, length);
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public byte[] getIndexRowKey(Put dataRow) {
        IndexUtil.SimpleValueGetter valueGetter = new IndexUtil.SimpleValueGetter(dataRow);
        return this.buildRowKey(valueGetter, new ImmutableBytesWritable(dataRow.getRow()), null, null, IndexUtil.getMaxTimestamp((Mutation)dataRow));
    }

    public boolean checkIndexRow(byte[] indexRowKey, Put dataRow) {
        if (!this.shouldPrepareIndexMutations(dataRow)) {
            return false;
        }
        byte[] builtIndexRowKey = this.getIndexRowKey(dataRow);
        return Bytes.compareTo((byte[])builtIndexRowKey, (int)0, (int)builtIndexRowKey.length, (byte[])indexRowKey, (int)0, (int)indexRowKey.length) == 0;
    }

    public byte[] getIndexRowKey(Put dataRow, byte[] encodedRegionName) {
        IndexUtil.SimpleValueGetter valueGetter = new IndexUtil.SimpleValueGetter(dataRow);
        return this.buildRowKey(valueGetter, new ImmutableBytesWritable(dataRow.getRow()), null, null, IndexUtil.getMaxTimestamp((Mutation)dataRow), encodedRegionName);
    }

    public boolean checkIndexRow(byte[] indexRowKey, byte[] dataRowKey, Put dataRow, byte[][] viewConstants) {
        if (!this.shouldPrepareIndexMutations(dataRow)) {
            return false;
        }
        byte[] builtDataRowKey = this.buildDataRowKey(new ImmutableBytesWritable(indexRowKey), viewConstants);
        return Bytes.compareTo((byte[])builtDataRowKey, (int)0, (int)builtDataRowKey.length, (byte[])dataRowKey, (int)0, (int)dataRowKey.length) == 0;
    }

    public boolean shouldPrepareIndexMutations(Put dataRowState) {
        if (this.getIndexWhere() == null) {
            return true;
        }
        List<Cell> cols = IndexUtil.readColumnsFromRow(dataRowState, this.getIndexWhereColumns());
        Collections.sort(cols, CellComparator.getInstance());
        MultiKeyValueTuple tuple = new MultiKeyValueTuple(cols);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        ptr.set(ByteUtil.EMPTY_BYTE_ARRAY);
        if (!this.getIndexWhere().evaluate(tuple, ptr)) {
            return false;
        }
        Object value = PBoolean.INSTANCE.toObject(ptr);
        return value.equals(Boolean.TRUE);
    }

    public Boolean isAgedEnough(long ts, long ageThreshold) {
        return EnvironmentEdgeManager.currentTimeMillis() - ts > ageThreshold;
    }

    public Delete createDelete(byte[] indexRowKey, long ts, boolean singleVersion) {
        if (singleVersion) {
            return this.buildRowDeleteMutation(indexRowKey, DeleteType.SINGLE_VERSION, ts);
        }
        return this.buildRowDeleteMutation(indexRowKey, DeleteType.ALL_VERSIONS, ts);
    }

    public byte[] getViewIndexIdFromIndexRowKey(ImmutableBytesWritable indexRowKeyPtr) {
        assert (this.isLocalIndex);
        ImmutableBytesPtr ptr = new ImmutableBytesPtr(indexRowKeyPtr.get(), indexRowKeyPtr.getOffset() + (!this.isLocalIndex && this.nIndexSaltBuckets > 0 ? 1 : 0), this.viewIndexId.length);
        return ptr.copyBytesIfNecessary();
    }

    private RowKeySchema generateIndexRowKeySchema() {
        int dataPosOffset;
        int nIndexedColumns = this.getIndexPkColumnCount() + (this.isMultiTenant ? 1 : 0) + (!this.isLocalIndex && this.nIndexSaltBuckets > 0 ? 1 : 0) + (this.viewIndexId != null ? 1 : 0) - this.getNumViewConstants();
        RowKeySchema.RowKeySchemaBuilder builder = new RowKeySchema.RowKeySchemaBuilder(nIndexedColumns);
        builder.rowKeyOrderOptimizable(this.rowKeyOrderOptimizable);
        if (!this.isLocalIndex && this.nIndexSaltBuckets > 0) {
            builder.addField(SaltingUtil.SALTING_COLUMN, false, SortOrder.ASC);
            --nIndexedColumns;
        }
        int n = dataPosOffset = this.isDataTableSalted ? 1 : 0;
        if (this.viewIndexId != null) {
            --nIndexedColumns;
            builder.addField(new PDatum(){

                @Override
                public boolean isNullable() {
                    return false;
                }

                @Override
                public PDataType getDataType() {
                    return IndexMaintainer.this.viewIndexIdType;
                }

                @Override
                public Integer getMaxLength() {
                    return null;
                }

                @Override
                public Integer getScale() {
                    return null;
                }

                @Override
                public SortOrder getSortOrder() {
                    return SortOrder.getDefault();
                }
            }, false, SortOrder.getDefault());
        }
        if (this.isMultiTenant) {
            ValueSchema.Field field = this.dataRowKeySchema.getField(dataPosOffset++);
            builder.addField(field, field.isNullable(), field.getSortOrder());
            --nIndexedColumns;
        }
        ValueSchema.Field[] indexFields = new ValueSchema.Field[nIndexedColumns];
        BitSet viewConstantColumnBitSet = this.rowKeyMetaData.getViewConstantColumnBitSet();
        for (int i = dataPosOffset; i < this.dataRowKeySchema.getFieldCount(); ++i) {
            if (viewConstantColumnBitSet.get(i)) continue;
            int pos = this.rowKeyMetaData.getIndexPkPosition(i - dataPosOffset);
            indexFields[pos] = this.dataRowKeySchema.getField(i);
        }
        BitSet descIndexColumnBitSet = this.rowKeyMetaData.getDescIndexColumnBitSet();
        Iterator<Expression> expressionItr = this.indexedExpressions.iterator();
        for (int i = 0; i < indexFields.length; ++i) {
            Integer scaleToBe;
            Integer maxLengthToBe;
            SortOrder sortOrderToBe;
            PDataType dataTypeToBe;
            boolean isNullableToBe;
            ValueSchema.Field indexField = indexFields[i];
            if (indexField == null) {
                Expression e = expressionItr.next();
                isNullableToBe = e.isNullable();
                dataTypeToBe = IndexUtil.getIndexColumnDataType(isNullableToBe, e.getDataType());
                sortOrderToBe = descIndexColumnBitSet.get(i) ? SortOrder.DESC : SortOrder.ASC;
                maxLengthToBe = e.getMaxLength();
                scaleToBe = e.getScale();
            } else {
                isNullableToBe = indexField.isNullable();
                dataTypeToBe = IndexUtil.getIndexColumnDataType(isNullableToBe, indexField.getDataType());
                sortOrderToBe = descIndexColumnBitSet.get(i) ? SortOrder.DESC : SortOrder.ASC;
                maxLengthToBe = indexField.getMaxLength();
                scaleToBe = indexField.getScale();
            }
            final PDataType dataType = dataTypeToBe;
            final SortOrder sortOrder = sortOrderToBe;
            final boolean isNullable = isNullableToBe;
            final Integer maxLength = maxLengthToBe;
            final Integer scale = scaleToBe;
            builder.addField(new PDatum(){

                @Override
                public boolean isNullable() {
                    return isNullable;
                }

                @Override
                public PDataType getDataType() {
                    return dataType;
                }

                @Override
                public Integer getMaxLength() {
                    return maxLength;
                }

                @Override
                public Integer getScale() {
                    return scale;
                }

                @Override
                public SortOrder getSortOrder() {
                    return sortOrder;
                }
            }, true, sortOrder);
        }
        return builder.build();
    }

    private int getNumViewConstants() {
        if (this.isIndexOnBaseTable()) {
            return 0;
        }
        BitSet bitSet = this.rowKeyMetaData.getViewConstantColumnBitSet();
        int num = 0;
        for (int i = 0; i < this.dataRowKeySchema.getFieldCount(); ++i) {
            if (!bitSet.get(i)) continue;
            ++num;
        }
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowKeySchema getIndexRowKeySchema() {
        if (this.indexRowKeySchema != null) {
            return this.indexRowKeySchema;
        }
        IndexMaintainer indexMaintainer = this;
        synchronized (indexMaintainer) {
            if (this.indexRowKeySchema == null) {
                this.indexRowKeySchema = this.generateIndexRowKeySchema();
            }
        }
        return this.indexRowKeySchema;
    }

    public Put buildUpdateMutation(KeyValueBuilder kvBuilder, ValueGetter valueGetter, ImmutableBytesWritable dataRowKeyPtr, long ts, byte[] regionStartKey, byte[] regionEndKey, boolean verified) throws IOException {
        return this.buildUpdateMutation(kvBuilder, valueGetter, dataRowKeyPtr, ts, regionStartKey, regionEndKey, verified, null);
    }

    public Put buildUpdateMutation(KeyValueBuilder kvBuilder, ValueGetter valueGetter, ImmutableBytesWritable dataRowKeyPtr, long ts, byte[] regionStartKey, byte[] regionEndKey, boolean verified, byte[] encodedRegionName) throws IOException {
        byte[] indexRowKey = this.buildRowKey(valueGetter, dataRowKeyPtr, regionStartKey, regionEndKey, ts, encodedRegionName);
        return IndexMaintainer.buildUpdateMutation(kvBuilder, valueGetter, dataRowKeyPtr, ts, regionStartKey, regionEndKey, indexRowKey, this.getEmptyKeyValueFamily(), this.coveredColumnsMap, this.indexEmptyKeyValueRef, this.indexWALDisabled, this.dataImmutableStorageScheme, this.immutableStorageScheme, this.encodingScheme, this.dataEncodingScheme, verified);
    }

    public static Put buildUpdateMutation(KeyValueBuilder kvBuilder, ValueGetter valueGetter, ImmutableBytesWritable dataRowKeyPtr, long ts, byte[] regionStartKey, byte[] regionEndKey, byte[] destRowKey, ImmutableBytesPtr emptyKeyValueCFPtr, Map<ColumnReference, ColumnReference> coveredColumnsMap, ColumnReference destEmptyKeyValueRef, boolean destWALDisabled, PTable.ImmutableStorageScheme srcImmutableStorageScheme, PTable.ImmutableStorageScheme destImmutableStorageScheme, PTable.QualifierEncodingScheme destEncodingScheme, PTable.QualifierEncodingScheme srcEncodingScheme, boolean verified) throws IOException {
        Set<ColumnReference> coveredColumns = coveredColumnsMap.keySet();
        Put put = null;
        ImmutableBytesWritable latestValue = null;
        if (valueGetter == null || coveredColumns.isEmpty() || (latestValue = valueGetter.getLatestValue(destEmptyKeyValueRef, ts)) == null || latestValue == ValueGetter.HIDDEN_BY_DELETE) {
            if (latestValue == ValueGetter.HIDDEN_BY_DELETE) {
                return null;
            }
            put = new Put(destRowKey);
            put.add((Cell)kvBuilder.buildPut(new ImmutableBytesPtr(destRowKey), emptyKeyValueCFPtr, destEmptyKeyValueRef.getQualifierWritable(), ts, verified ? QueryConstants.VERIFIED_BYTES_PTR : QueryConstants.EMPTY_COLUMN_VALUE_BYTES_PTR));
            put.setDurability(!destWALDisabled ? Durability.USE_DEFAULT : Durability.SKIP_WAL);
        }
        ImmutableBytesPtr rowKey = new ImmutableBytesPtr(destRowKey);
        if (destImmutableStorageScheme != PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN) {
            HashMap familyToColListMap = Maps.newHashMap();
            for (ColumnReference columnReference : coveredColumns) {
                ColumnReference indexColRef = coveredColumnsMap.get(columnReference);
                ImmutableBytesPtr cf = new ImmutableBytesPtr(indexColRef.getFamily());
                if (!familyToColListMap.containsKey((Object)cf)) {
                    familyToColListMap.put(cf, Lists.newArrayList());
                }
                ((List)familyToColListMap.get((Object)cf)).add(Pair.newPair((Object)indexColRef, (Object)columnReference));
            }
            for (Map.Entry entry : familyToColListMap.entrySet()) {
                Object colRefPair22;
                byte[] columnFamily = ((ImmutableBytesPtr)((Object)entry.getKey())).copyBytesIfNecessary();
                List colRefPairs = (List)entry.getValue();
                int maxEncodedColumnQualifier = Integer.MIN_VALUE;
                for (Object colRefPair22 : colRefPairs) {
                    maxEncodedColumnQualifier = Math.max(maxEncodedColumnQualifier, destEncodingScheme.decode(((ColumnReference)colRefPair22.getFirst()).getQualifier()));
                }
                Expression[] colValues = EncodedColumnsUtil.createColumnExpressionArray(maxEncodedColumnQualifier);
                colRefPair22 = colRefPairs.iterator();
                while (colRefPair22.hasNext()) {
                    Pair colRefPair3 = (Pair)colRefPair22.next();
                    ColumnReference indexColRef = (ColumnReference)colRefPair3.getFirst();
                    ColumnReference dataColRef = (ColumnReference)colRefPair3.getSecond();
                    byte[] value = null;
                    if (srcImmutableStorageScheme == PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS) {
                        SingleCellColumnExpression expression = new SingleCellColumnExpression(new PDatum(){

                            @Override
                            public boolean isNullable() {
                                return false;
                            }

                            @Override
                            public SortOrder getSortOrder() {
                                return null;
                            }

                            @Override
                            public Integer getScale() {
                                return null;
                            }

                            @Override
                            public Integer getMaxLength() {
                                return null;
                            }

                            @Override
                            public PDataType getDataType() {
                                return null;
                            }
                        }, dataColRef.getFamily(), dataColRef.getQualifier(), destEncodingScheme, destImmutableStorageScheme);
                        ImmutableBytesPtr ptr = new ImmutableBytesPtr();
                        expression.evaluate(new ValueGetterTuple(valueGetter, ts), ptr);
                        value = ptr.copyBytesIfNecessary();
                    } else {
                        ImmutableBytesWritable dataValue = valueGetter.getLatestValue(dataColRef, ts);
                        if (dataValue != null && dataValue != ValueGetter.HIDDEN_BY_DELETE) {
                            value = dataValue.copyBytes();
                        }
                    }
                    if (value == null) continue;
                    int indexArrayPos = destEncodingScheme.decode(indexColRef.getQualifier()) - 11 + 1;
                    colValues[indexArrayPos] = new LiteralExpression(value);
                }
                List<Expression> children = Arrays.asList(colValues);
                SingleCellConstructorExpression singleCellConstructorExpression = new SingleCellConstructorExpression(destImmutableStorageScheme, children);
                ImmutableBytesWritable ptr = new ImmutableBytesWritable();
                singleCellConstructorExpression.evaluate(new BaseTuple(){}, ptr);
                if (put == null) {
                    put = new Put(destRowKey);
                    put.setDurability(!destWALDisabled ? Durability.USE_DEFAULT : Durability.SKIP_WAL);
                }
                ImmutableBytesPtr colFamilyPtr = new ImmutableBytesPtr(columnFamily);
                put.add((Cell)kvBuilder.buildPut(rowKey, colFamilyPtr, QueryConstants.SINGLE_KEYVALUE_COLUMN_QUALIFIER_BYTES_PTR, ts, ptr));
            }
        } else if (srcImmutableStorageScheme == destImmutableStorageScheme) {
            for (ColumnReference ref : coveredColumns) {
                ColumnReference columnReference = coveredColumnsMap.get(ref);
                ImmutableBytesPtr cq = columnReference.getQualifierWritable();
                ImmutableBytesPtr cf = columnReference.getFamilyWritable();
                ImmutableBytesWritable value = valueGetter.getLatestValue(ref, ts);
                if (value == null || value == ValueGetter.HIDDEN_BY_DELETE) continue;
                if (put == null) {
                    put = new Put(destRowKey);
                    put.setDurability(!destWALDisabled ? Durability.USE_DEFAULT : Durability.SKIP_WAL);
                }
                put.add((Cell)kvBuilder.buildPut(rowKey, cf, cq, ts, value));
            }
        } else {
            HashMap familyToColListMap = Maps.newHashMap();
            for (ColumnReference columnReference : coveredColumns) {
                ColumnReference indexColRef = coveredColumnsMap.get(columnReference);
                ImmutableBytesPtr cf = new ImmutableBytesPtr(indexColRef.getFamily());
                if (!familyToColListMap.containsKey((Object)cf)) {
                    familyToColListMap.put(cf, Lists.newArrayList());
                }
                ((List)familyToColListMap.get((Object)cf)).add(Pair.newPair((Object)indexColRef, (Object)columnReference));
            }
            for (Map.Entry entry : familyToColListMap.entrySet()) {
                byte[] columnFamily = ((ImmutableBytesPtr)((Object)entry.getKey())).copyBytesIfNecessary();
                List colRefPairs = (List)entry.getValue();
                int maxEncodedColumnQualifier = Integer.MIN_VALUE;
                for (Pair colRefPair : colRefPairs) {
                    maxEncodedColumnQualifier = Math.max(maxEncodedColumnQualifier, srcEncodingScheme.decode(((ColumnReference)colRefPair.getSecond()).getQualifier()));
                }
                for (Pair colRefPair : colRefPairs) {
                    ColumnReference indexColRef = (ColumnReference)colRefPair.getFirst();
                    ColumnReference dataColRef = (ColumnReference)colRefPair.getSecond();
                    byte[] valueBytes = null;
                    SingleCellColumnExpression expression = new SingleCellColumnExpression(new PDatum(){

                        @Override
                        public boolean isNullable() {
                            return false;
                        }

                        @Override
                        public SortOrder getSortOrder() {
                            return null;
                        }

                        @Override
                        public Integer getScale() {
                            return null;
                        }

                        @Override
                        public Integer getMaxLength() {
                            return null;
                        }

                        @Override
                        public PDataType getDataType() {
                            return null;
                        }
                    }, dataColRef.getFamily(), dataColRef.getQualifier(), srcEncodingScheme, srcImmutableStorageScheme);
                    ImmutableBytesPtr ptr = new ImmutableBytesPtr();
                    expression.evaluate(new ValueGetterTuple(valueGetter, ts), ptr);
                    valueBytes = ptr.copyBytesIfNecessary();
                    if (valueBytes == null) continue;
                    ImmutableBytesPtr cq = indexColRef.getQualifierWritable();
                    ImmutableBytesPtr cf = indexColRef.getFamilyWritable();
                    if (put == null) {
                        put = new Put(destRowKey);
                        put.setDurability(!destWALDisabled ? Durability.USE_DEFAULT : Durability.SKIP_WAL);
                    }
                    put.add((Cell)kvBuilder.buildPut(rowKey, cf, cq, ts, new ImmutableBytesWritable(valueBytes)));
                }
            }
        }
        return put;
    }

    public Delete buildDeleteColumnMutation(Put indexUpdate, long ts) throws IOException {
        if (this.getIndexStorageScheme() == PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS) {
            return null;
        }
        if (this.coveredColumnsMap == null || this.coveredColumnsMap.isEmpty()) {
            return null;
        }
        int colsSet = indexUpdate.getFamilyCellMap().values().stream().mapToInt(elem -> elem.size()).sum();
        if (this.coveredColumnsMap.size() + 1 == colsSet) {
            return null;
        }
        ImmutableBytesPtr rowKey = new ImmutableBytesPtr(indexUpdate.getRow());
        Delete delete = new Delete(rowKey.get());
        for (Map.Entry<ColumnReference, ColumnReference> coveredCol : this.coveredColumnsMap.entrySet()) {
            ColumnReference indexCol = coveredCol.getValue();
            if (indexUpdate.has(indexCol.getFamily(), indexCol.getQualifier())) continue;
            KeyValue kv = GenericKeyValueBuilder.INSTANCE.buildDeleteColumns(rowKey, indexCol.getFamilyWritable(), indexCol.getQualifierWritable(), ts);
            delete.add((Cell)kv);
        }
        assert (!delete.isEmpty());
        return delete;
    }

    private DeleteType getDeleteTypeOrNull(Collection<? extends Cell> pendingUpdates) {
        return this.getDeleteTypeOrNull(pendingUpdates, this.nDataCFs);
    }

    private DeleteType getDeleteTypeOrNull(Collection<? extends Cell> pendingUpdates, int nCFs) {
        int nDeleteCF = 0;
        int nDeleteVersionCF = 0;
        for (Cell cell : pendingUpdates) {
            if (cell.getType() == Cell.Type.DeleteFamilyVersion) {
                ++nDeleteVersionCF;
                continue;
            }
            if (cell.getType() != Cell.Type.DeleteFamily && !TransactionUtil.isDeleteFamily(cell)) continue;
            ++nDeleteCF;
        }
        DeleteType deleteType = null;
        if (nDeleteVersionCF > 0 && nDeleteVersionCF >= nCFs) {
            deleteType = DeleteType.SINGLE_VERSION;
        } else {
            int n = nDeleteCF + nDeleteVersionCF;
            if (n > 0 && n >= nCFs) {
                deleteType = DeleteType.ALL_VERSIONS;
            }
        }
        return deleteType;
    }

    public boolean isRowDeleted(Collection<? extends Cell> pendingUpdates) {
        return this.getDeleteTypeOrNull(pendingUpdates) != null;
    }

    public boolean isRowDeleted(Mutation m) {
        if (m.getFamilyCellMap().size() < this.nDataCFs) {
            return false;
        }
        for (List cells : m.getFamilyCellMap().values()) {
            if (this.getDeleteTypeOrNull(cells, 1) != null) continue;
            return false;
        }
        return true;
    }

    private boolean hasIndexedColumnChanged(ValueGetter oldState, Collection<? extends Cell> pendingUpdates, long ts) throws IOException {
        if (pendingUpdates.isEmpty()) {
            return false;
        }
        HashMap newState = Maps.newHashMapWithExpectedSize((int)pendingUpdates.size());
        for (Cell cell : pendingUpdates) {
            newState.put(new ColumnReference(CellUtil.cloneFamily((Cell)cell), CellUtil.cloneQualifier((Cell)cell)), cell);
        }
        for (ColumnReference columnReference : this.indexedColumns) {
            boolean oldValueSetAsNull;
            Cell newValue = (Cell)newState.get(columnReference);
            if (newValue == null) continue;
            ImmutableBytesWritable oldValue = oldState.getLatestValue(columnReference, ts);
            boolean newValueSetAsNull = newValue.getType() == Cell.Type.DeleteColumn || newValue.getType() == Cell.Type.Delete || CellUtil.matchingValue((Cell)newValue, (byte[])HConstants.EMPTY_BYTE_ARRAY);
            boolean bl = oldValueSetAsNull = oldValue == null || oldValue.getLength() == 0;
            if (newValueSetAsNull && oldValueSetAsNull) continue;
            if (oldValueSetAsNull || newValueSetAsNull) {
                return true;
            }
            if (Bytes.compareTo((byte[])oldValue.get(), (int)oldValue.getOffset(), (int)oldValue.getLength(), (byte[])newValue.getValueArray(), (int)newValue.getValueOffset(), (int)newValue.getValueLength()) == 0) continue;
            return true;
        }
        return false;
    }

    public Delete buildRowDeleteMutation(byte[] indexRowKey, DeleteType deleteType, long ts) {
        byte[] emptyCF = this.emptyKeyValueCFPtr.copyBytesIfNecessary();
        Delete delete = new Delete(indexRowKey);
        for (ColumnReference ref : this.getCoveredColumns()) {
            ColumnReference indexColumn = this.coveredColumnsMap.get(ref);
            if (deleteType == DeleteType.SINGLE_VERSION) {
                delete.addFamilyVersion(indexColumn.getFamily(), ts);
                continue;
            }
            delete.addFamily(indexColumn.getFamily(), ts);
        }
        if (deleteType == DeleteType.SINGLE_VERSION) {
            delete.addFamilyVersion(emptyCF, ts);
        } else {
            delete.addFamily(emptyCF, ts);
        }
        delete.setDurability(!this.indexWALDisabled ? Durability.USE_DEFAULT : Durability.SKIP_WAL);
        return delete;
    }

    public Delete buildDeleteMutation(KeyValueBuilder kvBuilder, ImmutableBytesWritable dataRowKeyPtr, long ts, byte[] encodedRegionName) throws IOException {
        return this.buildDeleteMutation(kvBuilder, null, dataRowKeyPtr, Collections.emptyList(), ts, null, null, encodedRegionName);
    }

    public Delete buildDeleteMutation(KeyValueBuilder kvBuilder, ValueGetter oldState, ImmutableBytesWritable dataRowKeyPtr, Collection<Cell> pendingUpdates, long ts, byte[] regionStartKey, byte[] regionEndKey) throws IOException {
        return this.buildDeleteMutation(kvBuilder, oldState, dataRowKeyPtr, pendingUpdates, ts, regionStartKey, regionEndKey, null);
    }

    public Delete buildDeleteMutation(KeyValueBuilder kvBuilder, ValueGetter oldState, ImmutableBytesWritable dataRowKeyPtr, Collection<Cell> pendingUpdates, long ts, byte[] regionStartKey, byte[] regionEndKey, byte[] encodedRegionName) throws IOException {
        byte[] indexRowKey = this.buildRowKey(oldState, dataRowKeyPtr, regionStartKey, regionEndKey, ts, encodedRegionName);
        DeleteType deleteType = null;
        if (oldState == null || (deleteType = this.getDeleteTypeOrNull(pendingUpdates)) != null || this.hasIndexedColumnChanged(oldState, pendingUpdates, ts)) {
            return this.buildRowDeleteMutation(indexRowKey, deleteType, ts);
        }
        Delete delete = null;
        Set<ColumnReference> dataTableColRefs = this.coveredColumnsMap.keySet();
        for (Cell kv : pendingUpdates) {
            ColumnReference ref;
            if (kv.getType() == Cell.Type.Put || !dataTableColRefs.contains(ref = new ColumnReference(kv.getFamilyArray(), kv.getFamilyOffset(), kv.getFamilyLength(), kv.getQualifierArray(), kv.getQualifierOffset(), kv.getQualifierLength()))) continue;
            if (delete == null) {
                delete = new Delete(indexRowKey);
                delete.setDurability(!this.indexWALDisabled ? Durability.USE_DEFAULT : Durability.SKIP_WAL);
            }
            ColumnReference indexColumn = this.coveredColumnsMap.get(ref);
            if (kv.getType() == Cell.Type.Delete) {
                delete.addColumn(indexColumn.getFamily(), indexColumn.getQualifier(), ts);
                continue;
            }
            delete.addColumns(indexColumn.getFamily(), indexColumn.getQualifier(), ts);
        }
        return delete;
    }

    public byte[] getIndexTableName() {
        return this.indexTableName;
    }

    public Set<ColumnReference> getCoveredColumns() {
        return this.coveredColumnsMap.keySet();
    }

    public Set<ColumnReference> getAllColumns() {
        return this.allColumns;
    }

    private void addColumnRefForScan(Set<ColumnReference> from, Set<ColumnReference> to) {
        for (ColumnReference colRef : from) {
            if (this.getDataImmutableStorageScheme() == PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN) {
                to.add(colRef);
                continue;
            }
            to.add(new ColumnReference(colRef.getFamily(), QueryConstants.SINGLE_KEYVALUE_COLUMN_QUALIFIER_BYTES));
        }
    }

    public Set<ColumnReference> getAllColumnsForDataTable() {
        LinkedHashSet result = Sets.newLinkedHashSetWithExpectedSize((int)(this.indexedExpressions.size() + this.coveredColumnsMap.size() + (this.indexWhereColumns == null ? 0 : this.indexWhereColumns.size())));
        this.addColumnRefForScan(this.indexedColumns, result);
        this.addColumnRefForScan(this.coveredColumnsMap.keySet(), result);
        if (this.indexWhereColumns != null) {
            this.addColumnRefForScan(this.indexWhereColumns, result);
        }
        return result;
    }

    public ImmutableBytesPtr getEmptyKeyValueFamily() {
        return this.emptyKeyValueCFPtr;
    }

    public String getLogicalIndexName() {
        return this.logicalIndexName;
    }

    @Deprecated
    public void readFields(DataInput input) throws IOException {
        int i;
        boolean hasViewIndexId;
        int encodedIndexSaltBucketsAndMultiTenant = WritableUtils.readVInt((DataInput)input);
        this.isMultiTenant = encodedIndexSaltBucketsAndMultiTenant < 0;
        this.nIndexSaltBuckets = Math.abs(encodedIndexSaltBucketsAndMultiTenant) - 1;
        int encodedIndexedColumnsAndViewId = WritableUtils.readVInt((DataInput)input);
        boolean bl = hasViewIndexId = encodedIndexedColumnsAndViewId < 0;
        if (hasViewIndexId) {
            this.viewIndexId = new byte[MetaDataUtil.getLegacyViewIndexIdDataType().getByteSize().intValue()];
            this.viewIndexIdType = MetaDataUtil.getLegacyViewIndexIdDataType();
            input.readFully(this.viewIndexId);
        }
        int nIndexedColumns = Math.abs(encodedIndexedColumnsAndViewId) - 1;
        this.indexedColumns = Sets.newLinkedHashSetWithExpectedSize((int)nIndexedColumns);
        for (i = 0; i < nIndexedColumns; ++i) {
            byte[] cf = Bytes.readByteArray((DataInput)input);
            byte[] cq = Bytes.readByteArray((DataInput)input);
            this.indexedColumns.add(new ColumnReference(cf, cq));
        }
        this.indexedColumnTypes = Lists.newArrayListWithExpectedSize((int)nIndexedColumns);
        for (i = 0; i < nIndexedColumns; ++i) {
            PDataType type = PDataType.values()[WritableUtils.readVInt((DataInput)input)];
            this.indexedColumnTypes.add(type);
        }
        int encodedCoveredolumnsAndLocalIndex = WritableUtils.readVInt((DataInput)input);
        this.isLocalIndex = encodedCoveredolumnsAndLocalIndex < 0;
        int nCoveredColumns = Math.abs(encodedCoveredolumnsAndLocalIndex) - 1;
        this.coveredColumnsMap = Maps.newHashMapWithExpectedSize((int)nCoveredColumns);
        for (int i2 = 0; i2 < nCoveredColumns; ++i2) {
            byte[] dataTableCf = Bytes.readByteArray((DataInput)input);
            byte[] dataTableCq = Bytes.readByteArray((DataInput)input);
            ColumnReference dataTableRef = new ColumnReference(dataTableCf, dataTableCq);
            byte[] indexTableCf = this.isLocalIndex ? IndexUtil.getLocalIndexColumnFamily(dataTableCf) : dataTableCf;
            byte[] indexTableCq = IndexUtil.getIndexColumnName(dataTableCf, dataTableCq);
            ColumnReference indexTableRef = new ColumnReference(indexTableCf, indexTableCq);
            this.coveredColumnsMap.put(dataTableRef, indexTableRef);
        }
        int len = WritableUtils.readVInt((DataInput)input);
        if (len < 0) {
            this.rowKeyOrderOptimizable = false;
            len *= -1;
        } else {
            this.rowKeyOrderOptimizable = true;
        }
        this.indexTableName = new byte[len];
        input.readFully(this.indexTableName, 0, len);
        this.dataEmptyKeyValueCF = Bytes.readByteArray((DataInput)input);
        len = WritableUtils.readVInt((DataInput)input);
        boolean isNewClient = false;
        if (len < 0) {
            isNewClient = true;
            len = Math.abs(len);
        }
        byte[] emptyKeyValueCF = new byte[len];
        input.readFully(emptyKeyValueCF, 0, len);
        this.emptyKeyValueCFPtr = new ImmutableBytesPtr(emptyKeyValueCF);
        if (isNewClient) {
            int numIndexedExpressions = WritableUtils.readVInt((DataInput)input);
            this.indexedExpressions = Lists.newArrayListWithExpectedSize((int)numIndexedExpressions);
            for (int i3 = 0; i3 < numIndexedExpressions; ++i3) {
                Expression expression = ExpressionType.values()[WritableUtils.readVInt((DataInput)input)].newInstance();
                expression.readFields(input);
                this.indexedExpressions.add(expression);
            }
        } else {
            this.indexedExpressions = Lists.newArrayListWithExpectedSize((int)this.indexedColumns.size());
            Iterator<ColumnReference> colReferenceIter = this.indexedColumns.iterator();
            Iterator<PDataType> dataTypeIter = this.indexedColumnTypes.iterator();
            while (colReferenceIter.hasNext()) {
                ColumnReference colRef = colReferenceIter.next();
                final PDataType dataType = dataTypeIter.next();
                this.indexedExpressions.add(new KeyValueColumnExpression(new PDatum(){

                    @Override
                    public boolean isNullable() {
                        return true;
                    }

                    @Override
                    public SortOrder getSortOrder() {
                        return SortOrder.getDefault();
                    }

                    @Override
                    public Integer getScale() {
                        return null;
                    }

                    @Override
                    public Integer getMaxLength() {
                        return null;
                    }

                    @Override
                    public PDataType getDataType() {
                        return dataType;
                    }
                }, colRef.getFamily(), colRef.getQualifier()));
            }
        }
        this.rowKeyMetaData = this.newRowKeyMetaData();
        this.rowKeyMetaData.readFields(input);
        int nDataCFs = WritableUtils.readVInt((DataInput)input);
        this.indexWALDisabled = nDataCFs < 0;
        this.nDataCFs = Math.abs(nDataCFs) - 1;
        int encodedEstimatedIndexRowKeyBytesAndImmutableRows = WritableUtils.readVInt((DataInput)input);
        this.immutableRows = encodedEstimatedIndexRowKeyBytesAndImmutableRows < 0;
        this.estimatedIndexRowKeyBytes = Math.abs(encodedEstimatedIndexRowKeyBytesAndImmutableRows);
        this.immutableStorageScheme = PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN;
        this.encodingScheme = PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS;
        this.dataImmutableStorageScheme = PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN;
        this.dataEncodingScheme = PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS;
        this.initCachedState();
    }

    public static IndexMaintainer fromProto(ServerCachingProtos.IndexMaintainer proto, RowKeySchema dataTableRowKeySchema, boolean isDataTableSalted) throws IOException {
        Object input;
        IndexMaintainer maintainer = new IndexMaintainer(dataTableRowKeySchema, isDataTableSalted);
        maintainer.nIndexSaltBuckets = proto.getSaltBuckets();
        maintainer.isMultiTenant = proto.getIsMultiTenant();
        maintainer.viewIndexId = proto.hasViewIndexId() ? proto.getViewIndexId().toByteArray() : null;
        maintainer.viewIndexIdType = proto.hasViewIndexIdType() ? PDataType.fromTypeId(proto.getViewIndexIdType()) : MetaDataUtil.getLegacyViewIndexIdDataType();
        List<ServerCachingProtos.ColumnReference> indexedColumnsList = proto.getIndexedColumnsList();
        maintainer.indexedColumns = new HashSet<ColumnReference>(indexedColumnsList.size());
        for (ServerCachingProtos.ColumnReference columnReference : indexedColumnsList) {
            maintainer.indexedColumns.add(new ColumnReference(columnReference.getFamily().toByteArray(), columnReference.getQualifier().toByteArray()));
        }
        List<Integer> indexedColumnTypes = proto.getIndexedColumnTypeOrdinalList();
        maintainer.indexedColumnTypes = new ArrayList<PDataType>(indexedColumnTypes.size());
        for (Integer typeOrdinal : indexedColumnTypes) {
            maintainer.indexedColumnTypes.add(PDataType.values()[typeOrdinal]);
        }
        maintainer.indexTableName = proto.getIndexTableName().toByteArray();
        maintainer.indexDataColumnCount = dataTableRowKeySchema.getFieldCount();
        if (proto.getIndexDataColumnCount() != -1) {
            maintainer.indexDataColumnCount = proto.getIndexDataColumnCount();
        }
        maintainer.rowKeyOrderOptimizable = proto.getRowKeyOrderOptimizable();
        maintainer.dataEmptyKeyValueCF = proto.getDataTableEmptyKeyValueColFamily().toByteArray();
        ServerCachingProtos.ImmutableBytesWritable immutableBytesWritable = proto.getEmptyKeyValueColFamily();
        maintainer.emptyKeyValueCFPtr = new ImmutableBytesPtr(immutableBytesWritable.getByteArray().toByteArray(), immutableBytesWritable.getOffset(), immutableBytesWritable.getLength());
        maintainer.indexedExpressions = new ArrayList<Expression>();
        try (ByteArrayInputStream stream = new ByteArrayInputStream(proto.getIndexedExpressions().toByteArray());){
            input = new DataInputStream(stream);
            while (stream.available() > 0) {
                int expressionOrdinal = WritableUtils.readVInt((DataInput)input);
                Expression expression = ExpressionType.values()[expressionOrdinal].newInstance();
                expression.readFields((DataInput)input);
                maintainer.indexedExpressions.add(expression);
            }
        }
        maintainer.rowKeyMetaData = IndexMaintainer.newRowKeyMetaData(maintainer, dataTableRowKeySchema, maintainer.indexedExpressions.size(), isDataTableSalted, maintainer.isMultiTenant);
        stream = new ByteArrayInputStream(proto.getRowKeyMetadata().toByteArray());
        try {
            input = new DataInputStream(stream);
            maintainer.rowKeyMetaData.readFields((DataInput)input);
        }
        finally {
            stream.close();
        }
        maintainer.nDataCFs = proto.getNumDataTableColFamilies();
        maintainer.indexWALDisabled = proto.getIndexWalDisabled();
        maintainer.estimatedIndexRowKeyBytes = proto.getIndexRowKeyByteSize();
        maintainer.immutableRows = proto.getImmutable();
        List<ServerCachingProtos.ColumnInfo> indexedColumnInfoList = proto.getIndexedColumnInfoList();
        maintainer.indexedColumnsInfo = Sets.newHashSet();
        for (ServerCachingProtos.ColumnInfo info : indexedColumnInfoList) {
            maintainer.indexedColumnsInfo.add((Pair<String, String>)new Pair((Object)info.getFamilyName(), (Object)info.getColumnName()));
        }
        maintainer.encodingScheme = PTable.QualifierEncodingScheme.fromSerializedValue((byte)proto.getEncodingScheme());
        maintainer.immutableStorageScheme = PTable.ImmutableStorageScheme.fromSerializedValue((byte)proto.getImmutableStorageScheme());
        maintainer.dataEncodingScheme = PTable.QualifierEncodingScheme.fromSerializedValue((byte)proto.getDataEncodingScheme());
        maintainer.dataImmutableStorageScheme = PTable.ImmutableStorageScheme.fromSerializedValue((byte)proto.getDataImmutableStorageScheme());
        maintainer.isLocalIndex = proto.getIsLocalIndex();
        if (proto.hasParentTableType()) {
            maintainer.parentTableType = PTableType.fromValue(proto.getParentTableType());
        }
        List<ServerCachingProtos.ColumnReference> dataTableColRefsForCoveredColumnsList = proto.getDataTableColRefForCoveredColumnsList();
        List<ServerCachingProtos.ColumnReference> indexTableColRefsForCoveredColumnsList = proto.getIndexTableColRefForCoveredColumnsList();
        maintainer.coveredColumnsMap = Maps.newHashMapWithExpectedSize((int)dataTableColRefsForCoveredColumnsList.size());
        boolean encodedColumnNames = maintainer.encodingScheme != PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS;
        Iterator<ServerCachingProtos.ColumnReference> indexTableColRefItr = indexTableColRefsForCoveredColumnsList.iterator();
        for (ServerCachingProtos.ColumnReference colRefFromProto : dataTableColRefsForCoveredColumnsList) {
            ColumnReference indexTableColRef;
            ColumnReference dataTableColRef = new ColumnReference(colRefFromProto.getFamily().toByteArray(), colRefFromProto.getQualifier().toByteArray());
            if (encodedColumnNames) {
                ServerCachingProtos.ColumnReference fromProto = indexTableColRefItr.next();
                indexTableColRef = new ColumnReference(fromProto.getFamily().toByteArray(), fromProto.getQualifier().toByteArray());
            } else {
                byte[] cq = IndexUtil.getIndexColumnName(dataTableColRef.getFamily(), dataTableColRef.getQualifier());
                byte[] cf = maintainer.isLocalIndex ? IndexUtil.getLocalIndexColumnFamily(dataTableColRef.getFamily()) : dataTableColRef.getFamily();
                indexTableColRef = new ColumnReference(cf, cq);
            }
            maintainer.coveredColumnsMap.put(dataTableColRef, indexTableColRef);
        }
        maintainer.logicalIndexName = proto.getLogicalIndexName();
        maintainer.isUncovered = proto.hasIsUncovered() ? proto.getIsUncovered() : false;
        if (proto.hasIndexWhere()) {
            try (ByteArrayInputStream stream = new ByteArrayInputStream(proto.getIndexWhere().toByteArray());){
                DataInputStream input2 = new DataInputStream(stream);
                int expressionOrdinal = WritableUtils.readVInt((DataInput)input2);
                Expression expression = ExpressionType.values()[expressionOrdinal].newInstance();
                expression.readFields(input2);
                maintainer.indexWhere = expression;
                List<ServerCachingProtos.ColumnReference> indexWhereColumnsList = proto.getIndexWhereColumnsList();
                maintainer.indexWhereColumns = new HashSet<ColumnReference>(indexWhereColumnsList.size());
                for (ServerCachingProtos.ColumnReference colRefFromProto : indexWhereColumnsList) {
                    maintainer.indexWhereColumns.add(new ColumnReference(colRefFromProto.getFamily().toByteArray(), colRefFromProto.getQualifier().toByteArray()));
                }
            }
        } else {
            maintainer.indexWhere = null;
            maintainer.indexWhereColumns = null;
        }
        maintainer.isCDCIndex = proto.hasIsCDCIndex() ? proto.getIsCDCIndex() : false;
        maintainer.nDataTableSaltBuckets = proto.hasDataTableSaltBuckets() ? proto.getDataTableSaltBuckets() : -1;
        maintainer.initCachedState();
        return maintainer;
    }

    @Deprecated
    public void write(DataOutput output) throws IOException {
        WritableUtils.writeVInt((DataOutput)output, (int)((this.nIndexSaltBuckets + 1) * (this.isMultiTenant ? -1 : 1)));
        WritableUtils.writeVInt((DataOutput)output, (int)((this.indexedColumns.size() + 1) * (this.viewIndexId != null ? -1 : 1)));
        if (this.viewIndexId != null) {
            output.write(this.viewIndexId);
        }
        for (ColumnReference ref : this.indexedColumns) {
            Bytes.writeByteArray((DataOutput)output, (byte[])ref.getFamily());
            Bytes.writeByteArray((DataOutput)output, (byte[])ref.getQualifier());
        }
        for (int i = 0; i < this.indexedColumnTypes.size(); ++i) {
            PDataType type = this.indexedColumnTypes.get(i);
            WritableUtils.writeVInt((DataOutput)output, (int)type.ordinal());
        }
        WritableUtils.writeVInt((DataOutput)output, (int)((this.coveredColumnsMap.size() + 1) * (this.isLocalIndex ? -1 : 1)));
        for (ColumnReference ref : this.coveredColumnsMap.keySet()) {
            Bytes.writeByteArray((DataOutput)output, (byte[])ref.getFamily());
            Bytes.writeByteArray((DataOutput)output, (byte[])ref.getQualifier());
        }
        WritableUtils.writeVInt((DataOutput)output, (int)(this.indexTableName.length * (this.rowKeyOrderOptimizable ? 1 : -1)));
        output.write(this.indexTableName, 0, this.indexTableName.length);
        Bytes.writeByteArray((DataOutput)output, (byte[])this.dataEmptyKeyValueCF);
        WritableUtils.writeVInt((DataOutput)output, (int)(-this.emptyKeyValueCFPtr.getLength()));
        output.write(this.emptyKeyValueCFPtr.get(), this.emptyKeyValueCFPtr.getOffset(), this.emptyKeyValueCFPtr.getLength());
        WritableUtils.writeVInt((DataOutput)output, (int)this.indexedExpressions.size());
        for (Expression expression : this.indexedExpressions) {
            WritableUtils.writeVInt((DataOutput)output, (int)ExpressionType.valueOf(expression).ordinal());
            expression.write(output);
        }
        this.rowKeyMetaData.write(output);
        WritableUtils.writeVInt((DataOutput)output, (int)((this.nDataCFs + 1) * (this.indexWALDisabled ? -1 : 1)));
        WritableUtils.writeVInt((DataOutput)output, (int)(this.estimatedIndexRowKeyBytes * (this.immutableRows ? -1 : 1)));
    }

    public static ServerCachingProtos.IndexMaintainer toProto(IndexMaintainer maintainer) throws IOException {
        ServerCachingProtos.IndexMaintainer.Builder builder = ServerCachingProtos.IndexMaintainer.newBuilder();
        builder.setSaltBuckets(maintainer.nIndexSaltBuckets);
        builder.setIsMultiTenant(maintainer.isMultiTenant);
        if (maintainer.viewIndexId != null) {
            builder.setViewIndexId(ByteStringer.wrap((byte[])maintainer.viewIndexId));
            builder.setViewIndexIdType(maintainer.viewIndexIdType.getSqlType());
        }
        for (ColumnReference columnReference : maintainer.indexedColumns) {
            ServerCachingProtos.ColumnReference.Builder builder2 = ServerCachingProtos.ColumnReference.newBuilder();
            builder2.setFamily(ByteStringer.wrap((byte[])columnReference.getFamily()));
            builder2.setQualifier(ByteStringer.wrap((byte[])columnReference.getQualifier()));
            builder.addIndexedColumns(builder2.build());
        }
        for (PDataType pDataType : maintainer.indexedColumnTypes) {
            builder.addIndexedColumnTypeOrdinal(pDataType.ordinal());
        }
        for (Map.Entry entry : maintainer.coveredColumnsMap.entrySet()) {
            ServerCachingProtos.ColumnReference.Builder builder3 = ServerCachingProtos.ColumnReference.newBuilder();
            ColumnReference dataTableColRef = (ColumnReference)entry.getKey();
            builder3.setFamily(ByteStringer.wrap((byte[])dataTableColRef.getFamily()));
            builder3.setQualifier(ByteStringer.wrap((byte[])dataTableColRef.getQualifier()));
            builder.addDataTableColRefForCoveredColumns(builder3.build());
            if (maintainer.encodingScheme == PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS) continue;
            ColumnReference indexTableColRef = (ColumnReference)entry.getValue();
            ServerCachingProtos.ColumnReference.Builder builder4 = ServerCachingProtos.ColumnReference.newBuilder();
            builder4.setFamily(ByteStringer.wrap((byte[])indexTableColRef.getFamily()));
            builder4.setQualifier(ByteStringer.wrap((byte[])indexTableColRef.getQualifier()));
            builder.addIndexTableColRefForCoveredColumns(builder4.build());
        }
        builder.setIsLocalIndex(maintainer.isLocalIndex);
        if (maintainer.parentTableType != null) {
            builder.setParentTableType(maintainer.parentTableType.toString());
        }
        builder.setIndexDataColumnCount(maintainer.indexDataColumnCount);
        builder.setIndexTableName(ByteStringer.wrap((byte[])maintainer.indexTableName));
        builder.setRowKeyOrderOptimizable(maintainer.rowKeyOrderOptimizable);
        builder.setDataTableEmptyKeyValueColFamily(ByteStringer.wrap((byte[])maintainer.dataEmptyKeyValueCF));
        ServerCachingProtos.ImmutableBytesWritable.Builder ibwBuilder = ServerCachingProtos.ImmutableBytesWritable.newBuilder();
        ibwBuilder.setByteArray(ByteStringer.wrap((byte[])maintainer.emptyKeyValueCFPtr.get()));
        ibwBuilder.setLength(maintainer.emptyKeyValueCFPtr.getLength());
        ibwBuilder.setOffset(maintainer.emptyKeyValueCFPtr.getOffset());
        builder.setEmptyKeyValueColFamily(ibwBuilder.build());
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            for (Expression expression : maintainer.indexedExpressions) {
                WritableUtils.writeVInt((DataOutput)dataOutputStream, (int)ExpressionType.valueOf(expression).ordinal());
                expression.write(dataOutputStream);
            }
            builder.setIndexedExpressions(ByteStringer.wrap((byte[])byteArrayOutputStream.toByteArray()));
        }
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            maintainer.rowKeyMetaData.write(dataOutputStream);
            builder.setRowKeyMetadata(ByteStringer.wrap((byte[])byteArrayOutputStream.toByteArray()));
        }
        builder.setNumDataTableColFamilies(maintainer.nDataCFs);
        builder.setIndexWalDisabled(maintainer.indexWALDisabled);
        builder.setIndexRowKeyByteSize(maintainer.estimatedIndexRowKeyBytes);
        builder.setImmutable(maintainer.immutableRows);
        for (Pair<String, String> pair : maintainer.indexedColumnsInfo) {
            ServerCachingProtos.ColumnInfo.Builder ciBuilder = ServerCachingProtos.ColumnInfo.newBuilder();
            if (pair.getFirst() != null) {
                ciBuilder.setFamilyName((String)pair.getFirst());
            }
            ciBuilder.setColumnName((String)pair.getSecond());
            builder.addIndexedColumnInfo(ciBuilder.build());
        }
        builder.setEncodingScheme(maintainer.encodingScheme.getSerializedMetadataValue());
        builder.setImmutableStorageScheme(maintainer.immutableStorageScheme.getSerializedMetadataValue());
        builder.setLogicalIndexName(maintainer.logicalIndexName);
        builder.setDataEncodingScheme(maintainer.dataEncodingScheme.getSerializedMetadataValue());
        builder.setDataImmutableStorageScheme(maintainer.dataImmutableStorageScheme.getSerializedMetadataValue());
        builder.setIsUncovered(maintainer.isUncovered);
        if (maintainer.indexWhere != null) {
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                WritableUtils.writeVInt((DataOutput)dataOutputStream, (int)ExpressionType.valueOf(maintainer.indexWhere).ordinal());
                maintainer.indexWhere.write(dataOutputStream);
                builder.setIndexWhere(ByteStringer.wrap((byte[])byteArrayOutputStream.toByteArray()));
                for (ColumnReference colRef : maintainer.indexWhereColumns) {
                    ServerCachingProtos.ColumnReference.Builder cRefBuilder2 = ServerCachingProtos.ColumnReference.newBuilder();
                    cRefBuilder2.setFamily(ByteStringer.wrap((byte[])colRef.getFamily()));
                    cRefBuilder2.setQualifier(ByteStringer.wrap((byte[])colRef.getQualifier()));
                    builder.addIndexWhereColumns(cRefBuilder2.build());
                }
            }
        }
        builder.setIsCDCIndex(maintainer.isCDCIndex);
        if (maintainer.isDataTableSalted) {
            builder.setDataTableSaltBuckets(maintainer.nDataTableSaltBuckets);
        }
        return builder.build();
    }

    public int getEstimatedByteSize() {
        int size = WritableUtils.getVIntSize((long)this.nIndexSaltBuckets);
        size += WritableUtils.getVIntSize((long)this.estimatedIndexRowKeyBytes);
        size += WritableUtils.getVIntSize((long)this.indexedColumns.size());
        size += this.viewIndexId == null ? 0 : this.viewIndexId.length;
        for (ColumnReference ref : this.indexedColumns) {
            size += WritableUtils.getVIntSize((long)ref.getFamily().length);
            size += ref.getFamily().length;
            size += WritableUtils.getVIntSize((long)ref.getQualifier().length);
            size += ref.getQualifier().length;
        }
        for (int i = 0; i < this.indexedColumnTypes.size(); ++i) {
            PDataType type = this.indexedColumnTypes.get(i);
            size += WritableUtils.getVIntSize((long)type.ordinal());
        }
        Set<ColumnReference> dataTableColRefs = this.coveredColumnsMap.keySet();
        size += WritableUtils.getVIntSize((long)dataTableColRefs.size());
        for (ColumnReference ref : dataTableColRefs) {
            size += WritableUtils.getVIntSize((long)ref.getFamilyWritable().getLength());
            size += ref.getFamily().length;
            size += WritableUtils.getVIntSize((long)ref.getQualifierWritable().getLength());
            size += ref.getQualifier().length;
        }
        size += this.indexTableName.length + WritableUtils.getVIntSize((long)this.indexTableName.length);
        size += this.rowKeyMetaData.getByteSize();
        size += this.dataEmptyKeyValueCF.length + WritableUtils.getVIntSize((long)this.dataEmptyKeyValueCF.length);
        size += this.emptyKeyValueCFPtr.getLength() + WritableUtils.getVIntSize((long)this.emptyKeyValueCFPtr.getLength());
        size += WritableUtils.getVIntSize((long)(this.nDataCFs + 1));
        size += WritableUtils.getVIntSize((long)this.indexedExpressions.size());
        for (Expression expression : this.indexedExpressions) {
            size += WritableUtils.getVIntSize((long)ExpressionType.valueOf(expression).ordinal());
        }
        return size += this.estimatedExpressionSize;
    }

    public Expression getIndexWhere() {
        return this.indexWhere;
    }

    public Set<ColumnReference> getIndexWhereColumns() {
        return this.indexWhereColumns;
    }

    private int estimateIndexRowKeyByteSize(int indexColByteSize) {
        int estimatedIndexRowKeyBytes = indexColByteSize + this.dataRowKeySchema.getEstimatedValueLength() + (this.nIndexSaltBuckets == 0 || this.isLocalIndex || this.isDataTableSalted ? 0 : 1);
        return estimatedIndexRowKeyBytes;
    }

    private void initCachedState() {
        int indexPkPos;
        byte[] indexEmptyKvQualifier = (byte[])EncodedColumnsUtil.getEmptyKeyValueInfo(this.encodingScheme).getFirst();
        byte[] dataEmptyKvQualifier = (byte[])EncodedColumnsUtil.getEmptyKeyValueInfo(this.dataEncodingScheme).getFirst();
        this.indexEmptyKeyValueRef = new ColumnReference(this.dataEmptyKeyValueCF, indexEmptyKvQualifier);
        this.dataEmptyKeyValueRef = new ColumnReference(this.dataEmptyKeyValueCF, dataEmptyKvQualifier);
        this.allColumns = Sets.newLinkedHashSetWithExpectedSize((int)(this.indexedExpressions.size() + this.coveredColumnsMap.size()));
        this.indexedColumns = Sets.newLinkedHashSetWithExpectedSize((int)this.indexedExpressions.size());
        for (Expression expression : this.indexedExpressions) {
            KeyValueExpressionVisitor visitor = new KeyValueExpressionVisitor(){

                @Override
                public Void visit(KeyValueColumnExpression expression) {
                    if (IndexMaintainer.this.indexedColumns.add(new ColumnReference(expression.getColumnFamily(), expression.getColumnQualifier()))) {
                        IndexMaintainer.this.indexedColumnTypes.add(expression.getDataType());
                    }
                    return null;
                }
            };
            expression.accept(visitor);
        }
        this.allColumns.addAll(this.indexedColumns);
        for (ColumnReference colRef : this.coveredColumnsMap.keySet()) {
            if (this.immutableStorageScheme == PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN) {
                this.allColumns.add(colRef);
                continue;
            }
            this.allColumns.add(new ColumnReference(colRef.getFamily(), QueryConstants.SINGLE_KEYVALUE_COLUMN_QUALIFIER_BYTES));
        }
        int dataPkOffset = (this.isDataTableSalted ? 1 : 0) + (this.isMultiTenant ? 1 : 0);
        int nIndexPkColumns = this.getIndexPkColumnCount();
        this.dataPkPosition = new int[nIndexPkColumns];
        Arrays.fill(this.dataPkPosition, -1);
        int numViewConstantColumns = 0;
        BitSet viewConstantColumnBitSet = this.rowKeyMetaData.getViewConstantColumnBitSet();
        for (int i = dataPkOffset; i < this.indexDataColumnCount; ++i) {
            if (!viewConstantColumnBitSet.get(i) || this.isIndexOnBaseTable()) {
                int indexPkPosition = this.rowKeyMetaData.getIndexPkPosition(i - dataPkOffset);
                this.dataPkPosition[indexPkPosition] = i;
                continue;
            }
            ++numViewConstantColumns;
        }
        int expressionsPos = this.indexedExpressions.size();
        for (indexPkPos = nIndexPkColumns - numViewConstantColumns - 1; indexPkPos >= 0; --indexPkPos) {
            PDataType dataType;
            boolean isDataNullable;
            int dataPkPos = this.dataPkPosition[indexPkPos];
            if (dataPkPos == -1) {
                isDataNullable = true;
                dataType = this.indexedExpressions.get(--expressionsPos).getDataType();
            } else {
                ValueSchema.Field dataField = this.dataRowKeySchema.getField(dataPkPos);
                dataType = dataField.getDataType();
                isDataNullable = dataField.isNullable();
            }
            PDataType indexDataType = IndexUtil.getIndexColumnDataType(isDataNullable, dataType);
            if (indexDataType.isFixedWidth()) break;
        }
        this.maxTrailingNulls = nIndexPkColumns - indexPkPos - 1;
    }

    private int getIndexPkColumnCount() {
        return IndexMaintainer.getIndexPkColumnCount(this.indexDataColumnCount, this.indexedExpressions.size(), this.isDataTableSalted, this.isMultiTenant);
    }

    private static int getIndexPkColumnCount(int indexDataColumnCount, int numIndexExpressions, boolean isDataTableSalted, boolean isMultiTenant) {
        return indexDataColumnCount + numIndexExpressions - (isDataTableSalted ? 1 : 0) - (isMultiTenant ? 1 : 0);
    }

    private RowKeyMetaData newRowKeyMetaData() {
        return this.getIndexPkColumnCount() < 255 ? new ByteSizeRowKeyMetaData() : new IntSizedRowKeyMetaData();
    }

    private static RowKeyMetaData newRowKeyMetaData(IndexMaintainer i, RowKeySchema rowKeySchema, int numIndexExpressions, boolean isDataTableSalted, boolean isMultiTenant) {
        int indexPkColumnCount = IndexMaintainer.getIndexPkColumnCount(i.indexDataColumnCount, numIndexExpressions, isDataTableSalted, isMultiTenant);
        return indexPkColumnCount < 255 ? i.new ByteSizeRowKeyMetaData() : i.new IntSizedRowKeyMetaData();
    }

    private RowKeyMetaData newRowKeyMetaData(int capacity) {
        return capacity < 255 ? new ByteSizeRowKeyMetaData(capacity) : new IntSizedRowKeyMetaData(capacity);
    }

    private static void writeInverted(byte[] buf, int offset, int length, DataOutput output) throws IOException {
        for (int i = offset; i < offset + length; ++i) {
            byte b = SortOrder.invert(buf[i]);
            output.write(b);
        }
    }

    @Override
    public Iterator<ColumnReference> iterator() {
        return this.allColumns.iterator();
    }

    public ValueGetter createGetterFromKeyValues(final byte[] rowKey, Collection<? extends Cell> pendingUpdates) {
        final HashMap valueMap = Maps.newHashMapWithExpectedSize((int)pendingUpdates.size());
        for (Cell cell : pendingUpdates) {
            ImmutableBytesPtr value = new ImmutableBytesPtr(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
            valueMap.put(new ColumnReference(cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength(), cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength()), value);
        }
        return new AbstractValueGetter(){

            @Override
            public ImmutableBytesWritable getLatestValue(ColumnReference ref, long ts) {
                if (ref.equals(IndexMaintainer.this.indexEmptyKeyValueRef)) {
                    return null;
                }
                return (ImmutableBytesWritable)valueMap.get(ref);
            }

            @Override
            public byte[] getRowKey() {
                return rowKey;
            }
        };
    }

    public byte[] getDataEmptyKeyValueCF() {
        return this.dataEmptyKeyValueCF;
    }

    public boolean isLocalIndex() {
        return this.isLocalIndex;
    }

    public boolean isUncovered() {
        return this.isUncovered;
    }

    public boolean isCDCIndex() {
        return this.isCDCIndex;
    }

    public boolean isMultiTenant() {
        return this.isMultiTenant;
    }

    public boolean isImmutableRows() {
        return this.immutableRows;
    }

    public boolean isIndexOnBaseTable() {
        if (this.parentTableType == null) {
            return false;
        }
        return this.parentTableType == PTableType.TABLE;
    }

    public Set<ColumnReference> getIndexedColumns() {
        return this.indexedColumns;
    }

    public byte[] getEmptyKeyValueQualifier() {
        return this.indexEmptyKeyValueRef.getQualifier();
    }

    public byte[] getEmptyKeyValueQualifierForDataTable() {
        return this.dataEmptyKeyValueRef.getQualifier();
    }

    public Set<Pair<String, String>> getIndexedColumnInfo() {
        return this.indexedColumnsInfo;
    }

    public PTable.ImmutableStorageScheme getIndexStorageScheme() {
        return this.immutableStorageScheme;
    }

    public PTable.ImmutableStorageScheme getDataImmutableStorageScheme() {
        return this.dataImmutableStorageScheme;
    }

    public PTable.QualifierEncodingScheme getDataEncodingScheme() {
        return this.dataEncodingScheme;
    }

    public byte[] getViewIndexId() {
        return this.viewIndexId;
    }

    private abstract class RowKeyMetaData
    implements Writable {
        private BitSet descIndexColumnBitSet;
        private BitSet viewConstantColumnBitSet;

        private RowKeyMetaData() {
        }

        private RowKeyMetaData(int nIndexedColumns) {
            this.descIndexColumnBitSet = BitSet.withCapacity(nIndexedColumns);
            this.viewConstantColumnBitSet = BitSet.withCapacity(IndexMaintainer.this.dataRowKeySchema.getMaxFields());
        }

        protected int getByteSize() {
            return BitSet.getByteSize(IndexMaintainer.this.getIndexPkColumnCount()) * 3 + BitSet.getByteSize(IndexMaintainer.this.dataRowKeySchema.getMaxFields());
        }

        protected abstract int getIndexPkPosition(int var1);

        protected abstract int setIndexPkPosition(int var1, int var2);

        public void readFields(DataInput input) throws IOException {
            int length = IndexMaintainer.this.getIndexPkColumnCount();
            this.descIndexColumnBitSet = BitSet.read(input, length);
            int vclength = IndexMaintainer.this.dataRowKeySchema.getMaxFields();
            this.viewConstantColumnBitSet = BitSet.read(input, vclength);
        }

        public void write(DataOutput output) throws IOException {
            int length = IndexMaintainer.this.getIndexPkColumnCount();
            BitSet.write(output, this.descIndexColumnBitSet, length);
            int vclength = IndexMaintainer.this.dataRowKeySchema.getMaxFields();
            BitSet.write(output, this.viewConstantColumnBitSet, vclength);
        }

        private BitSet getDescIndexColumnBitSet() {
            return this.descIndexColumnBitSet;
        }

        private BitSet getViewConstantColumnBitSet() {
            return this.viewConstantColumnBitSet;
        }
    }

    public static class UDFParseNodeVisitor
    extends StatelessTraverseAllParseNodeVisitor {
        private Map<String, UDFParseNode> udfParseNodes = new HashMap<String, UDFParseNode>(1);

        @Override
        public boolean visitEnter(FunctionParseNode node) throws SQLException {
            if (node instanceof UDFParseNode) {
                this.udfParseNodes.put(node.getName(), (UDFParseNode)node);
            }
            return super.visitEnter(node);
        }

        public Map<String, UDFParseNode> getUdfParseNodes() {
            return this.udfParseNodes;
        }
    }

    public static enum DeleteType {
        SINGLE_VERSION,
        ALL_VERSIONS;

    }

    private class ByteSizeRowKeyMetaData
    extends RowKeyMetaData {
        private byte[] indexPkPosition;

        private ByteSizeRowKeyMetaData() {
        }

        private ByteSizeRowKeyMetaData(int nIndexedColumns) {
            super(nIndexedColumns);
            this.indexPkPosition = new byte[nIndexedColumns];
        }

        @Override
        protected int getIndexPkPosition(int dataPkPosition) {
            return this.indexPkPosition[dataPkPosition] + BYTE_OFFSET;
        }

        @Override
        protected int setIndexPkPosition(int dataPkPosition, int indexPkPosition) {
            this.indexPkPosition[dataPkPosition] = (byte)(indexPkPosition - BYTE_OFFSET);
            return this.indexPkPosition[dataPkPosition];
        }

        @Override
        public void write(DataOutput output) throws IOException {
            super.write(output);
            output.write(this.indexPkPosition);
        }

        @Override
        protected int getByteSize() {
            return super.getByteSize() + this.indexPkPosition.length;
        }

        @Override
        public void readFields(DataInput input) throws IOException {
            super.readFields(input);
            this.indexPkPosition = new byte[IndexMaintainer.this.getIndexPkColumnCount()];
            input.readFully(this.indexPkPosition);
        }
    }

    private class IntSizedRowKeyMetaData
    extends RowKeyMetaData {
        private int[] indexPkPosition;

        private IntSizedRowKeyMetaData() {
        }

        private IntSizedRowKeyMetaData(int nIndexedColumns) {
            super(nIndexedColumns);
            this.indexPkPosition = new int[nIndexedColumns];
        }

        @Override
        protected int getIndexPkPosition(int dataPkPosition) {
            return this.indexPkPosition[dataPkPosition];
        }

        @Override
        protected int setIndexPkPosition(int dataPkPosition, int indexPkPosition) {
            this.indexPkPosition[dataPkPosition] = indexPkPosition;
            return this.indexPkPosition[dataPkPosition];
        }

        @Override
        public void write(DataOutput output) throws IOException {
            super.write(output);
            for (int i = 0; i < this.indexPkPosition.length; ++i) {
                output.writeInt(this.indexPkPosition[i]);
            }
        }

        @Override
        protected int getByteSize() {
            return super.getByteSize() + this.indexPkPosition.length * 4;
        }

        @Override
        public void readFields(DataInput input) throws IOException {
            super.readFields(input);
            this.indexPkPosition = new int[IndexMaintainer.this.getIndexPkColumnCount()];
            for (int i = 0; i < this.indexPkPosition.length; ++i) {
                this.indexPkPosition[i] = input.readInt();
            }
        }
    }
}

