/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.index;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.phoenix.compat.hbase.ByteStringer;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.compile.TupleProjectionCompiler;
import org.apache.phoenix.coprocessor.generated.CDCInfoProtos;
import org.apache.phoenix.execute.TupleProjector;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.ColumnRef;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.CDCUtil;
import org.apache.phoenix.util.SchemaUtil;

public class CDCTableInfo {
    private List<CDCColumnInfo> columnInfoList;
    private byte[] defaultColumnFamily;
    private final Set<PTable.CDCChangeScope> includeScopes;
    private PTable.QualifierEncodingScheme qualifierEncodingScheme;
    private final byte[] cdcJsonColQualBytes;
    private final TupleProjector dataTableProjector;

    private CDCTableInfo(List<CDCColumnInfo> columnInfoList, Set<PTable.CDCChangeScope> includeScopes, byte[] cdcJsonColQualBytes, TupleProjector dataTableProjector) {
        Collections.sort(columnInfoList);
        this.columnInfoList = columnInfoList;
        this.includeScopes = includeScopes;
        this.cdcJsonColQualBytes = cdcJsonColQualBytes;
        this.dataTableProjector = dataTableProjector;
    }

    public CDCTableInfo(byte[] defaultColumnFamily, List<CDCColumnInfo> columnInfoList, Set<PTable.CDCChangeScope> includeScopes, PTable.QualifierEncodingScheme qualifierEncodingScheme, byte[] cdcJsonColQualBytes, TupleProjector dataTableProjector) {
        this(columnInfoList, includeScopes, cdcJsonColQualBytes, dataTableProjector);
        this.defaultColumnFamily = defaultColumnFamily;
        this.qualifierEncodingScheme = qualifierEncodingScheme;
    }

    public List<CDCColumnInfo> getColumnInfoList() {
        return this.columnInfoList;
    }

    public byte[] getDefaultColumnFamily() {
        return this.defaultColumnFamily;
    }

    public PTable.QualifierEncodingScheme getQualifierEncodingScheme() {
        return this.qualifierEncodingScheme;
    }

    public Set<PTable.CDCChangeScope> getIncludeScopes() {
        return this.includeScopes;
    }

    public byte[] getCdcJsonColQualBytes() {
        return this.cdcJsonColQualBytes;
    }

    public TupleProjector getDataTableProjector() {
        return this.dataTableProjector;
    }

    public static CDCTableInfo createFromProto(CDCInfoProtos.CDCTableDef table) {
        Set<PTable.CDCChangeScope> changeScopeSet;
        byte[] defaultColumnFamily = QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES;
        if (table.hasDefaultFamilyName()) {
            defaultColumnFamily = table.getDefaultFamilyName().toByteArray();
        }
        PTable.QualifierEncodingScheme qualifierEncodingScheme = PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS;
        if (table.hasQualifierEncodingScheme()) {
            qualifierEncodingScheme = PTable.QualifierEncodingScheme.fromSerializedValue(table.getQualifierEncodingScheme().toByteArray()[0]);
        }
        ArrayList columns = Lists.newArrayListWithExpectedSize((int)table.getColumnsCount());
        for (CDCInfoProtos.CDCColumnDef curColumnProto : table.getColumnsList()) {
            columns.add(CDCColumnInfo.createFromProto(curColumnProto));
        }
        String includeScopesStr = table.getCdcIncludeScopes();
        try {
            changeScopeSet = CDCUtil.makeChangeScopeEnumsFromString(includeScopesStr);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        TupleProjector dataTableProjector = null;
        if (table.hasDataTableProjectorBytes()) {
            dataTableProjector = TupleProjector.deserializeProjectorFromBytes(table.getDataTableProjectorBytes().toByteArray());
        }
        return new CDCTableInfo(defaultColumnFamily, columns, changeScopeSet, qualifierEncodingScheme, table.getCdcJsonColQualBytes().toByteArray(), dataTableProjector);
    }

    public static CDCInfoProtos.CDCTableDef toProto(StatementContext context) throws SQLException {
        String cdcIncludeScopes;
        PTable cdcTable = context.getCDCTableRef().getTable();
        PTable dataTable = context.getCDCDataTableRef().getTable();
        CDCInfoProtos.CDCTableDef.Builder builder = CDCInfoProtos.CDCTableDef.newBuilder();
        if (dataTable.getDefaultFamilyName() != null) {
            builder.setDefaultFamilyName(ByteStringer.wrap((byte[])dataTable.getDefaultFamilyName().getBytes()));
        }
        if ((cdcIncludeScopes = context.getEncodedCdcIncludeScopes()) != null) {
            builder.setCdcIncludeScopes(cdcIncludeScopes);
        }
        if (dataTable.getEncodingScheme() != null) {
            builder.setQualifierEncodingScheme(ByteStringer.wrap((byte[])new byte[]{dataTable.getEncodingScheme().getSerializedMetadataValue()}));
        }
        for (PColumn column : dataTable.getColumns()) {
            if (column.getFamilyName() == null) continue;
            builder.addColumns(CDCColumnInfo.toProto(column));
        }
        PColumn cdcJsonCol = cdcTable.getColumnForColumnName("CDC JSON");
        builder.setCdcJsonColQualBytes(ByteStringer.wrap((byte[])cdcJsonCol.getColumnQualifierBytes()));
        TableRef cdcDataTableRef = context.getCDCDataTableRef();
        if (cdcDataTableRef.getTable().isImmutableRows() && cdcDataTableRef.getTable().getImmutableStorageScheme() == PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS) {
            ArrayList<ColumnRef> dataColumns = new ArrayList<ColumnRef>();
            PTable table = cdcDataTableRef.getTable();
            for (PColumn column : table.getColumns()) {
                if (SchemaUtil.isPKColumn(column)) continue;
                dataColumns.add(new ColumnRef(cdcDataTableRef, column.getPosition()));
            }
            PTable projectedDataTable = TupleProjectionCompiler.createProjectedTable(cdcDataTableRef, dataColumns, false);
            TupleProjector dataTableProjector = new TupleProjector(projectedDataTable);
            builder.setDataTableProjectorBytes(ByteStringer.wrap((byte[])TupleProjector.serializeProjectorIntoBytes(dataTableProjector)));
        }
        return builder.build();
    }

    public static class CDCColumnInfo
    implements Comparable<CDCColumnInfo> {
        private final byte[] columnFamily;
        private final byte[] columnQualifier;
        private final String columnName;
        private final PDataType columnType;
        private final String columnFamilyName;
        private String columnDisplayName;

        public CDCColumnInfo(byte[] columnFamily, byte[] columnQualifier, String columnName, PDataType columnType, String columnFamilyName) {
            this.columnFamily = columnFamily;
            this.columnQualifier = columnQualifier;
            this.columnName = columnName;
            this.columnType = columnType;
            this.columnFamilyName = columnFamilyName;
        }

        public byte[] getColumnFamily() {
            return this.columnFamily;
        }

        public byte[] getColumnQualifier() {
            return this.columnQualifier;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public PDataType getColumnType() {
            return this.columnType;
        }

        public String getColumnFamilyName() {
            return this.columnFamilyName;
        }

        @Override
        public int compareTo(CDCColumnInfo columnInfo) {
            return CDCUtil.compareCellFamilyAndQualifier(this.getColumnFamily(), this.getColumnQualifier(), columnInfo.getColumnFamily(), columnInfo.getColumnQualifier());
        }

        public static CDCColumnInfo createFromProto(CDCInfoProtos.CDCColumnDef column) {
            String columnName = column.getColumnName();
            byte[] familyNameBytes = column.getFamilyNameBytes().toByteArray();
            PDataType dataType = PDataType.fromSqlTypeName(column.getDataType());
            byte[] columnQualifierBytes = column.getColumnQualifierBytes().toByteArray();
            String columnFamilyName = StandardCharsets.UTF_8.decode(ByteBuffer.wrap(familyNameBytes)).toString();
            return new CDCColumnInfo(familyNameBytes, columnQualifierBytes, columnName, dataType, columnFamilyName);
        }

        public static CDCInfoProtos.CDCColumnDef toProto(PColumn column) {
            CDCInfoProtos.CDCColumnDef.Builder builder = CDCInfoProtos.CDCColumnDef.newBuilder();
            builder.setColumnName(column.getName().toString());
            if (column.getFamilyName() != null) {
                builder.setFamilyNameBytes(ByteStringer.wrap((byte[])column.getFamilyName().getBytes()));
            }
            if (column.getDataType() != null) {
                builder.setDataType(column.getDataType().getSqlTypeName());
            }
            if (column.getColumnQualifierBytes() != null) {
                builder.setColumnQualifierBytes(ByteStringer.wrap((byte[])column.getColumnQualifierBytes()));
            }
            return builder.build();
        }

        public String getColumnDisplayName(CDCTableInfo tableInfo) {
            if (this.columnDisplayName == null) {
                this.columnDisplayName = Arrays.equals(this.getColumnFamily(), tableInfo.getDefaultColumnFamily()) ? this.getColumnName() : this.getColumnFamilyName() + "." + this.getColumnName();
            }
            return this.columnDisplayName;
        }
    }
}

