/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.util;

import java.io.DataInput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;

public class ImmutableBytesPtr
extends ImmutableBytesWritable {
    private int hashCode;

    public ImmutableBytesPtr() {
    }

    public ImmutableBytesPtr(byte[] bytes) {
        super(bytes);
        this.hashCode = super.hashCode();
    }

    public ImmutableBytesPtr(ImmutableBytesWritable ibw) {
        super(ibw.get(), ibw.getOffset(), ibw.getLength());
        this.hashCode = super.hashCode();
    }

    public ImmutableBytesPtr(ImmutableBytesPtr ibp) {
        super(ibp.get(), ibp.getOffset(), ibp.getLength());
        this.hashCode = ibp.hashCode;
    }

    public ImmutableBytesPtr(byte[] bytes, int offset, int length) {
        super(bytes, offset, length);
        this.hashCode = super.hashCode();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ImmutableBytesPtr that = (ImmutableBytesPtr)((Object)obj);
        if (this.hashCode != that.hashCode) {
            return false;
        }
        return Bytes.compareTo((byte[])this.get(), (int)this.getOffset(), (int)this.getLength(), (byte[])that.get(), (int)that.getOffset(), (int)that.getLength()) == 0;
    }

    public void set(ImmutableBytesWritable ptr) {
        this.set(ptr.get(), ptr.getOffset(), ptr.getLength());
    }

    public void set(byte[] b) {
        super.set(b);
        this.hashCode = super.hashCode();
    }

    public void set(byte[] b, int offset, int length) {
        super.set(b, offset, length);
        this.hashCode = super.hashCode();
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.hashCode = super.hashCode();
    }

    public byte[] copyBytesIfNecessary() {
        return ImmutableBytesPtr.copyBytesIfNecessary(this);
    }

    public static byte[] copyBytesIfNecessary(ImmutableBytesWritable ptr) {
        return ImmutableBytesPtr.copyBytesIfNecessary(ptr.get(), ptr.getOffset(), ptr.getLength());
    }

    public static byte[] copyBytesIfNecessary(byte[] bytes, int offset, int length) {
        if (offset == 0 && length == bytes.length) {
            return bytes;
        }
        return Arrays.copyOfRange(bytes, offset, offset + length);
    }

    public static byte[] cloneCellRowIfNecessary(Cell cell) {
        return ImmutableBytesPtr.copyBytesIfNecessary(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength());
    }

    public static byte[] cloneCellFamilyIfNecessary(Cell cell) {
        return ImmutableBytesPtr.copyBytesIfNecessary(cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength());
    }

    public static byte[] cloneCellQualifierIfNecessary(Cell cell) {
        return ImmutableBytesPtr.copyBytesIfNecessary(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
    }

    public static byte[] cloneCellValueIfNecessary(Cell cell) {
        return ImmutableBytesPtr.copyBytesIfNecessary(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
    }
}

