/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.exception;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.phoenix.thirdparty.com.google.common.base.MoreObjects;

public class IndexWriteException
extends HBaseIOException {
    private static final String DISABLE_INDEX_ON_FAILURE_MSG = "disableIndexOnFailure=";
    private boolean disableIndexOnFailure = true;

    public IndexWriteException() {
    }

    public IndexWriteException(String message, Throwable cause) {
        super(message, cause);
    }

    public IndexWriteException(Throwable cause, boolean disableIndexOnFailure) {
        super(cause);
        this.disableIndexOnFailure = disableIndexOnFailure;
    }

    public IndexWriteException(boolean disableIndexOnFailure) {
        this.disableIndexOnFailure = disableIndexOnFailure;
    }

    public IndexWriteException(Throwable cause) {
        super(cause);
    }

    public static boolean parseDisableIndexOnFailure(String message) {
        Pattern p = Pattern.compile("disableIndexOnFailure=(true|false)", 2);
        Matcher m = p.matcher(message);
        if (m.find()) {
            boolean disableIndexOnFailure = Boolean.parseBoolean(m.group(1));
            return disableIndexOnFailure;
        }
        return true;
    }

    public boolean isDisableIndexOnFailure() {
        return this.disableIndexOnFailure;
    }

    public String getMessage() {
        return (String)MoreObjects.firstNonNull((Object)super.getMessage(), (Object)"") + " disableIndexOnFailure=" + this.disableIndexOnFailure + ",";
    }
}

