/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.covered.filter;

import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.phoenix.util.PhoenixKeyValueUtil;

public class MaxTimestampFilter
extends FilterBase {
    private long ts;

    public MaxTimestampFilter(long maxTime) {
        this.ts = maxTime;
    }

    public Cell getNextCellHint(Cell currentKV) {
        KeyValue kv = null;
        try {
            kv = PhoenixKeyValueUtil.maybeCopyCell(currentKV).clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalArgumentException(e);
        }
        kv.setTimestamp(this.ts);
        return kv;
    }

    public Filter.ReturnCode filterKeyValue(Cell v) {
        return this.filterCell(v);
    }

    public Filter.ReturnCode filterCell(Cell v) {
        long timestamp = v.getTimestamp();
        if (timestamp > this.ts) {
            return Filter.ReturnCode.SEEK_NEXT_USING_HINT;
        }
        return Filter.ReturnCode.INCLUDE;
    }
}

