/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.covered.filter;

import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.phoenix.hbase.index.covered.update.ColumnTracker;

public class ColumnTrackingNextLargestTimestampFilter
extends FilterBase {
    private long ts;
    private ColumnTracker column;

    public ColumnTrackingNextLargestTimestampFilter(long maxTime, ColumnTracker toTrack) {
        this.ts = maxTime;
        this.column = toTrack;
    }

    public Filter.ReturnCode filterKeyValue(Cell v) {
        return this.filterCell(v);
    }

    public Filter.ReturnCode filterCell(Cell v) {
        long timestamp = v.getTimestamp();
        if (timestamp > this.ts) {
            this.column.setTs(timestamp);
            return Filter.ReturnCode.SKIP;
        }
        return Filter.ReturnCode.INCLUDE;
    }
}

