/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.filter;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.Writable;
import org.apache.phoenix.coprocessorclient.MetaDataProtocol;
import org.apache.phoenix.hbase.index.util.GenericKeyValueBuilder;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.util.PhoenixKeyValueUtil;
import org.apache.phoenix.util.ViewIndexIdRetrieveUtil;

public class SystemCatalogViewIndexIdFilter
extends FilterBase
implements Writable {
    private int clientVersion;

    public SystemCatalogViewIndexIdFilter() {
    }

    public SystemCatalogViewIndexIdFilter(int clientVersion) {
        this.clientVersion = clientVersion;
    }

    public Filter.ReturnCode filterKeyValue(Cell keyValue) {
        return this.filterCell(keyValue);
    }

    public Filter.ReturnCode filterCell(Cell keyValue) {
        return Filter.ReturnCode.INCLUDE_AND_NEXT_COL;
    }

    public boolean hasFilterRow() {
        return true;
    }

    public void filterRowCells(List<Cell> kvs) throws IOException {
        Cell viewIndexIdCell = PhoenixKeyValueUtil.getColumnLatest(GenericKeyValueBuilder.INSTANCE, kvs, QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, PhoenixDatabaseMetaData.VIEW_INDEX_ID_BYTES);
        if (viewIndexIdCell != null) {
            int type = 0;
            Cell viewIndexIdDataTypeCell = PhoenixKeyValueUtil.getColumnLatest(GenericKeyValueBuilder.INSTANCE, kvs, QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, PhoenixDatabaseMetaData.VIEW_INDEX_ID_DATA_TYPE_BYTES);
            if (viewIndexIdDataTypeCell != null) {
                type = (Integer)PInteger.INSTANCE.toObject(viewIndexIdDataTypeCell.getValueArray(), viewIndexIdDataTypeCell.getValueOffset(), viewIndexIdDataTypeCell.getValueLength(), PInteger.INSTANCE, SortOrder.ASC);
            }
            if (this.clientVersion < MetaDataProtocol.MIN_SPLITTABLE_SYSTEM_CATALOG) {
                if (type == 0 && viewIndexIdCell.getValueLength() > 3) {
                    Cell keyValue = ViewIndexIdRetrieveUtil.getRetrievedViewIndexIdCell(viewIndexIdCell, false);
                    Collections.replaceAll(kvs, viewIndexIdCell, keyValue);
                }
            } else if (type != -5 && viewIndexIdCell.getValueLength() < 9) {
                Cell keyValue = ViewIndexIdRetrieveUtil.getRetrievedViewIndexIdCell(viewIndexIdCell, true);
                Collections.replaceAll(kvs, viewIndexIdCell, keyValue);
            }
        }
    }

    public static SystemCatalogViewIndexIdFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        try {
            SystemCatalogViewIndexIdFilter writable = (SystemCatalogViewIndexIdFilter)Writables.getWritable((byte[])pbBytes, (Writable)new SystemCatalogViewIndexIdFilter());
            return writable;
        }
        catch (IOException e) {
            throw new DeserializationException((Throwable)e);
        }
    }

    public byte[] toByteArray() throws IOException {
        return Writables.getBytes((Writable)this);
    }

    public void readFields(DataInput input) throws IOException {
        this.clientVersion = input.readInt();
    }

    public void write(DataOutput output) throws IOException {
        output.writeInt(this.clientVersion);
    }
}

