/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.filter;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.Writable;
import org.apache.phoenix.compat.hbase.CompatPagingFilter;
import org.apache.phoenix.util.EnvironmentEdgeManager;

public class PagingFilter
extends CompatPagingFilter
implements Writable {
    private long pageSizeMs;
    private long startTime;
    private Cell currentCell;
    private boolean isStopped;

    public PagingFilter() {
        super(null);
    }

    public PagingFilter(Filter delegate, long pageSizeMs) {
        super(delegate);
        this.pageSizeMs = pageSizeMs;
    }

    public Filter getDelegateFilter() {
        return this.delegate;
    }

    public void setDelegateFilter(Filter delegate) {
        this.delegate = delegate;
    }

    public byte[] getCurrentRowKeyToBeExcluded() {
        byte[] rowKeyAtStop = null;
        if (this.currentCell != null) {
            rowKeyAtStop = CellUtil.cloneRow((Cell)this.currentCell);
        }
        return rowKeyAtStop;
    }

    public boolean isStopped() {
        return this.isStopped;
    }

    public void init() {
        this.isStopped = false;
        this.currentCell = null;
        this.startTime = EnvironmentEdgeManager.currentTimeMillis();
    }

    public boolean hasFilterRow() {
        if (this.currentCell != null && EnvironmentEdgeManager.currentTimeMillis() - this.startTime >= this.pageSizeMs) {
            this.isStopped = true;
        }
        return true;
    }

    public boolean filterAllRemaining() throws IOException {
        if (this.isStopped) {
            return true;
        }
        if (this.delegate != null) {
            return this.delegate.filterAllRemaining();
        }
        return super.filterAllRemaining();
    }

    public boolean filterRowKey(Cell cell) throws IOException {
        this.currentCell = cell;
        if (this.delegate != null) {
            return this.delegate.filterRowKey(cell);
        }
        return super.filterRowKey(cell);
    }

    public void reset() throws IOException {
        if (this.delegate != null) {
            this.delegate.reset();
            return;
        }
        super.reset();
    }

    public Cell getNextCellHint(Cell currentKV) throws IOException {
        if (this.delegate != null) {
            return this.delegate.getNextCellHint(currentKV);
        }
        return super.getNextCellHint(currentKV);
    }

    public boolean filterRow() throws IOException {
        if (this.delegate != null) {
            return this.delegate.filterRow();
        }
        return super.filterRow();
    }

    public Cell transformCell(Cell v) throws IOException {
        if (this.delegate != null) {
            return this.delegate.transformCell(v);
        }
        return super.transformCell(v);
    }

    public void filterRowCells(List<Cell> kvs) throws IOException {
        if (this.delegate != null) {
            this.delegate.filterRowCells(kvs);
            return;
        }
        super.filterRowCells(kvs);
    }

    public void setReversed(boolean reversed) {
        if (this.delegate != null) {
            this.delegate.setReversed(reversed);
        }
        super.setReversed(reversed);
    }

    public boolean isReversed() {
        if (this.delegate != null) {
            return this.delegate.isReversed();
        }
        return super.isReversed();
    }

    public boolean isFamilyEssential(byte[] name) throws IOException {
        if (this.delegate != null) {
            return this.delegate.isFamilyEssential(name);
        }
        return super.isFamilyEssential(name);
    }

    public Filter.ReturnCode filterCell(Cell c) throws IOException {
        if (this.delegate != null) {
            return this.delegate.filterCell(c);
        }
        return super.filterCell(c);
    }

    public static PagingFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        try {
            return (PagingFilter)Writables.getWritable((byte[])pbBytes, (Writable)new PagingFilter());
        }
        catch (IOException e) {
            throw new DeserializationException((Throwable)e);
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.pageSizeMs);
        if (this.delegate != null) {
            out.writeUTF(this.delegate.getClass().getName());
            byte[] b = this.delegate.toByteArray();
            out.writeInt(b.length);
            out.write(b);
        } else {
            out.writeUTF("");
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.pageSizeMs = in.readLong();
        String className = in.readUTF();
        if (className.length() == 0) {
            return;
        }
        Class<?> cls = null;
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new DoNotRetryIOException((Throwable)e);
        }
        Method m = null;
        try {
            m = cls.getDeclaredMethod("parseFrom", byte[].class);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new DoNotRetryIOException((Throwable)e);
        }
        int length = in.readInt();
        byte[] b = new byte[length];
        in.readFully(b);
        try {
            this.delegate = (Filter)m.invoke(null, new Object[]{b});
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new DoNotRetryIOException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            throw new DoNotRetryIOException((Throwable)e);
        }
    }

    public byte[] toByteArray() throws IOException {
        return Writables.getBytes((Writable)this);
    }
}

