/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.filter;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.Writable;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.util.ScanUtil;

public class EmptyColumnOnlyFilter
extends FilterBase
implements Writable {
    private byte[] emptyCF;
    private byte[] emptyCQ;
    private boolean found = false;
    private boolean first = true;

    public EmptyColumnOnlyFilter() {
    }

    public EmptyColumnOnlyFilter(byte[] emptyCF, byte[] emptyCQ) {
        Preconditions.checkArgument((emptyCF != null ? 1 : 0) != 0, (Object)"Column family must not be null");
        Preconditions.checkArgument((emptyCQ != null ? 1 : 0) != 0, (Object)"Column qualifier must not be null");
        this.emptyCF = emptyCF;
        this.emptyCQ = emptyCQ;
    }

    public void reset() throws IOException {
        this.found = false;
        this.first = true;
    }

    public Filter.ReturnCode filterKeyValue(Cell c) throws IOException {
        return this.filterCell(c);
    }

    public Filter.ReturnCode filterCell(Cell cell) throws IOException {
        if (this.found) {
            return Filter.ReturnCode.NEXT_ROW;
        }
        if (ScanUtil.isEmptyColumn(cell, this.emptyCF, this.emptyCQ)) {
            this.found = true;
            return Filter.ReturnCode.INCLUDE;
        }
        if (this.first) {
            this.first = false;
            return Filter.ReturnCode.INCLUDE;
        }
        return Filter.ReturnCode.NEXT_COL;
    }

    public void filterRowCells(List<Cell> kvs) throws IOException {
        if (kvs.size() > 1) {
            kvs.remove(0);
        }
    }

    public static EmptyColumnOnlyFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        try {
            return (EmptyColumnOnlyFilter)Writables.getWritable((byte[])pbBytes, (Writable)new EmptyColumnOnlyFilter());
        }
        catch (IOException e) {
            throw new DeserializationException((Throwable)e);
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.emptyCF.length);
        out.write(this.emptyCF);
        out.writeInt(this.emptyCQ.length);
        out.write(this.emptyCQ);
    }

    public void readFields(DataInput in) throws IOException {
        int length = in.readInt();
        this.emptyCF = new byte[length];
        in.readFully(this.emptyCF, 0, length);
        length = in.readInt();
        this.emptyCQ = new byte[length];
        in.readFully(this.emptyCQ, 0, length);
    }

    public byte[] toByteArray() throws IOException {
        return Writables.getBytes((Writable)this);
    }
}

