/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.filter;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.ExpressionType;
import org.apache.phoenix.schema.IllegalDataException;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.ClientUtil;

public abstract class BooleanExpressionFilter
extends FilterBase
implements Writable {
    protected Expression expression;
    private ImmutableBytesWritable tempPtr = new ImmutableBytesWritable();

    public BooleanExpressionFilter() {
    }

    public BooleanExpressionFilter(Expression expression) {
        this.expression = expression;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public boolean hasFilterRow() {
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.expression.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        BooleanExpressionFilter other = (BooleanExpressionFilter)((Object)obj);
        return this.expression.equals(other.expression);
    }

    public String toString() {
        return this.expression.toString();
    }

    @SuppressWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="Returns null by design.")
    protected Boolean evaluate(Tuple input) {
        try {
            if (!this.expression.evaluate(input, this.tempPtr)) {
                return null;
            }
        }
        catch (IllegalDataException e) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE.equals(this.expression.getDataType().toObject(this.tempPtr));
    }

    public void readFields(DataInput input) throws IOException {
        try {
            this.expression = ExpressionType.values()[WritableUtils.readVInt((DataInput)input)].newInstance();
            this.expression.readFields(input);
            this.expression.reset();
        }
        catch (Throwable t) {
            ClientUtil.throwIOException("BooleanExpressionFilter failed during reading", t);
        }
    }

    public void write(DataOutput output) throws IOException {
        try {
            WritableUtils.writeVInt((DataOutput)output, (int)ExpressionType.valueOf(this.expression).ordinal());
            this.expression.write(output);
        }
        catch (Throwable t) {
            ClientUtil.throwIOException("BooleanExpressionFilter failed during writing", t);
        }
    }

    public byte[] toByteArray() throws IOException {
        return Writables.getBytes((Writable)this);
    }

    public void reset() {
        this.expression.reset();
    }
}

