/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.util.bson;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.phoenix.expression.util.bson.BsonConditionInvalidArgumentException;
import org.apache.phoenix.expression.util.bson.CommonComparisonExpressionUtils;
import org.apache.phoenix.parse.AndParseNode;
import org.apache.phoenix.parse.BetweenParseNode;
import org.apache.phoenix.parse.BsonExpressionParser;
import org.apache.phoenix.parse.DocumentFieldBeginsWithParseNode;
import org.apache.phoenix.parse.DocumentFieldContainsParseNode;
import org.apache.phoenix.parse.DocumentFieldExistsParseNode;
import org.apache.phoenix.parse.DocumentFieldSizeParseNode;
import org.apache.phoenix.parse.DocumentFieldTypeParseNode;
import org.apache.phoenix.parse.EqualParseNode;
import org.apache.phoenix.parse.GreaterThanOrEqualParseNode;
import org.apache.phoenix.parse.GreaterThanParseNode;
import org.apache.phoenix.parse.InListParseNode;
import org.apache.phoenix.parse.LessThanOrEqualParseNode;
import org.apache.phoenix.parse.LessThanParseNode;
import org.apache.phoenix.parse.LiteralParseNode;
import org.apache.phoenix.parse.NotEqualParseNode;
import org.apache.phoenix.parse.NotParseNode;
import org.apache.phoenix.parse.OrParseNode;
import org.apache.phoenix.parse.ParseNode;
import org.bson.BsonArray;
import org.bson.BsonBinary;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonNumber;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.RawBsonDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SQLComparisonExpressionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SQLComparisonExpressionUtils.class);

    private SQLComparisonExpressionUtils() {
    }

    public static boolean evaluateConditionExpression(String conditionExpression, RawBsonDocument rawBsonDocument, BsonDocument comparisonValuesDocument) {
        if (rawBsonDocument == null || conditionExpression == null) {
            LOGGER.warn("Document and/or Condition Expression document are empty. Document: {}, conditionExpression: {}", (Object)rawBsonDocument, (Object)conditionExpression);
            return false;
        }
        return SQLComparisonExpressionUtils.evaluateExpression(conditionExpression, rawBsonDocument, comparisonValuesDocument, null);
    }

    public static boolean evaluateConditionExpression(String conditionExpression, RawBsonDocument rawBsonDocument, BsonDocument comparisonValuesDocument, BsonDocument keyAliasDocument) {
        if (rawBsonDocument == null || conditionExpression == null) {
            LOGGER.warn("Document and/or Condition Expression document are empty. Document: {}, conditionExpression: {}", (Object)rawBsonDocument, (Object)conditionExpression);
            return false;
        }
        return SQLComparisonExpressionUtils.evaluateExpression(conditionExpression, rawBsonDocument, comparisonValuesDocument, keyAliasDocument);
    }

    private static boolean evaluateExpression(String conditionExpression, RawBsonDocument rawBsonDocument, BsonDocument comparisonValuesDocument, BsonDocument keyAliasDocument) {
        List<String> sortedKeyNames;
        ParseNode parseNode;
        BsonExpressionParser bsonExpressionParser = new BsonExpressionParser(conditionExpression);
        try {
            parseNode = bsonExpressionParser.parseExpression();
        }
        catch (SQLException e) {
            LOGGER.error("Expression {} could not be evaluated.", (Object)conditionExpression, (Object)e);
            throw new RuntimeException("Expression could not be evaluated: " + conditionExpression, e);
        }
        if (keyAliasDocument == null || keyAliasDocument.isEmpty()) {
            sortedKeyNames = Collections.emptyList();
        } else {
            sortedKeyNames = new ArrayList(keyAliasDocument.keySet());
            sortedKeyNames.sort((a, b) -> Integer.compare(b.length(), a.length()));
        }
        return SQLComparisonExpressionUtils.evaluateExpression(parseNode, rawBsonDocument, comparisonValuesDocument, keyAliasDocument, sortedKeyNames);
    }

    private static boolean evaluateExpression(ParseNode parseNode, RawBsonDocument rawBsonDocument, BsonDocument comparisonValuesDocument, BsonDocument keyAliasDocument, List<String> sortedKeyNames) {
        if (parseNode instanceof DocumentFieldExistsParseNode) {
            DocumentFieldExistsParseNode documentFieldExistsParseNode = (DocumentFieldExistsParseNode)parseNode;
            LiteralParseNode fieldKey = (LiteralParseNode)documentFieldExistsParseNode.getChildren().get(0);
            String fieldName = (String)fieldKey.getValue();
            fieldName = SQLComparisonExpressionUtils.replaceExpressionFieldNames(fieldName, keyAliasDocument, sortedKeyNames);
            return documentFieldExistsParseNode.isExists() == SQLComparisonExpressionUtils.exists(fieldName, rawBsonDocument);
        }
        if (parseNode instanceof DocumentFieldBeginsWithParseNode) {
            DocumentFieldBeginsWithParseNode documentFieldBeginsWithParseNode = (DocumentFieldBeginsWithParseNode)parseNode;
            LiteralParseNode fieldKey = (LiteralParseNode)documentFieldBeginsWithParseNode.getFieldKey();
            LiteralParseNode value = (LiteralParseNode)documentFieldBeginsWithParseNode.getValue();
            String fieldName = (String)fieldKey.getValue();
            fieldName = SQLComparisonExpressionUtils.replaceExpressionFieldNames(fieldName, keyAliasDocument, sortedKeyNames);
            String prefixValue = (String)value.getValue();
            return SQLComparisonExpressionUtils.beginsWith(fieldName, prefixValue, rawBsonDocument, comparisonValuesDocument);
        }
        if (parseNode instanceof DocumentFieldContainsParseNode) {
            DocumentFieldContainsParseNode documentFieldContainsParseNode = (DocumentFieldContainsParseNode)parseNode;
            LiteralParseNode fieldKey = (LiteralParseNode)documentFieldContainsParseNode.getFieldKey();
            LiteralParseNode value = (LiteralParseNode)documentFieldContainsParseNode.getValue();
            String fieldName = (String)fieldKey.getValue();
            fieldName = SQLComparisonExpressionUtils.replaceExpressionFieldNames(fieldName, keyAliasDocument, sortedKeyNames);
            String containsValue = (String)value.getValue();
            return SQLComparisonExpressionUtils.contains(fieldName, containsValue, rawBsonDocument, comparisonValuesDocument);
        }
        if (parseNode instanceof DocumentFieldTypeParseNode) {
            DocumentFieldTypeParseNode documentFieldTypeParseNode = (DocumentFieldTypeParseNode)parseNode;
            LiteralParseNode fieldKey = (LiteralParseNode)documentFieldTypeParseNode.getFieldKey();
            LiteralParseNode value = (LiteralParseNode)documentFieldTypeParseNode.getValue();
            String fieldName = (String)fieldKey.getValue();
            fieldName = SQLComparisonExpressionUtils.replaceExpressionFieldNames(fieldName, keyAliasDocument, sortedKeyNames);
            String type = (String)value.getValue();
            return SQLComparisonExpressionUtils.isFieldOfType(fieldName, type, rawBsonDocument, comparisonValuesDocument);
        }
        if (parseNode instanceof EqualParseNode) {
            EqualParseNode equalParseNode = (EqualParseNode)parseNode;
            Object lhs = SQLComparisonExpressionUtils.getLHS(rawBsonDocument, keyAliasDocument, sortedKeyNames, equalParseNode.getLHS());
            LiteralParseNode rhs = (LiteralParseNode)equalParseNode.getRHS();
            String expectedFieldValue = (String)rhs.getValue();
            return SQLComparisonExpressionUtils.isEquals(lhs, expectedFieldValue, rawBsonDocument, comparisonValuesDocument);
        }
        if (parseNode instanceof NotEqualParseNode) {
            LiteralParseNode rhs;
            String expectedFieldValue;
            NotEqualParseNode notEqualParseNode = (NotEqualParseNode)parseNode;
            Object lhs = SQLComparisonExpressionUtils.getLHS(rawBsonDocument, keyAliasDocument, sortedKeyNames, notEqualParseNode.getLHS());
            return !SQLComparisonExpressionUtils.isEquals(lhs, expectedFieldValue = (String)(rhs = (LiteralParseNode)notEqualParseNode.getRHS()).getValue(), rawBsonDocument, comparisonValuesDocument);
        }
        if (parseNode instanceof LessThanParseNode) {
            LessThanParseNode lessThanParseNode = (LessThanParseNode)parseNode;
            Object lhs = SQLComparisonExpressionUtils.getLHS(rawBsonDocument, keyAliasDocument, sortedKeyNames, lessThanParseNode.getLHS());
            LiteralParseNode rhs = (LiteralParseNode)lessThanParseNode.getRHS();
            String expectedFieldValue = (String)rhs.getValue();
            return SQLComparisonExpressionUtils.lessThan(lhs, expectedFieldValue, rawBsonDocument, comparisonValuesDocument);
        }
        if (parseNode instanceof LessThanOrEqualParseNode) {
            LessThanOrEqualParseNode lessThanOrEqualParseNode = (LessThanOrEqualParseNode)parseNode;
            Object lhs = SQLComparisonExpressionUtils.getLHS(rawBsonDocument, keyAliasDocument, sortedKeyNames, lessThanOrEqualParseNode.getLHS());
            LiteralParseNode rhs = (LiteralParseNode)lessThanOrEqualParseNode.getRHS();
            String expectedFieldValue = (String)rhs.getValue();
            return SQLComparisonExpressionUtils.lessThanOrEquals(lhs, expectedFieldValue, rawBsonDocument, comparisonValuesDocument);
        }
        if (parseNode instanceof GreaterThanParseNode) {
            GreaterThanParseNode greaterThanParseNode = (GreaterThanParseNode)parseNode;
            Object lhs = SQLComparisonExpressionUtils.getLHS(rawBsonDocument, keyAliasDocument, sortedKeyNames, greaterThanParseNode.getLHS());
            LiteralParseNode rhs = (LiteralParseNode)greaterThanParseNode.getRHS();
            String expectedFieldValue = (String)rhs.getValue();
            return SQLComparisonExpressionUtils.greaterThan(lhs, expectedFieldValue, rawBsonDocument, comparisonValuesDocument);
        }
        if (parseNode instanceof GreaterThanOrEqualParseNode) {
            GreaterThanOrEqualParseNode greaterThanOrEqualParseNode = (GreaterThanOrEqualParseNode)parseNode;
            Object lhs = SQLComparisonExpressionUtils.getLHS(rawBsonDocument, keyAliasDocument, sortedKeyNames, greaterThanOrEqualParseNode.getLHS());
            LiteralParseNode rhs = (LiteralParseNode)greaterThanOrEqualParseNode.getRHS();
            String expectedFieldValue = (String)rhs.getValue();
            return SQLComparisonExpressionUtils.greaterThanOrEquals(lhs, expectedFieldValue, rawBsonDocument, comparisonValuesDocument);
        }
        if (parseNode instanceof BetweenParseNode) {
            BetweenParseNode betweenParseNode = (BetweenParseNode)parseNode;
            Object lhs = SQLComparisonExpressionUtils.getLHS(rawBsonDocument, keyAliasDocument, sortedKeyNames, betweenParseNode.getChildren().get(0));
            LiteralParseNode betweenParseNode1 = (LiteralParseNode)betweenParseNode.getChildren().get(1);
            LiteralParseNode betweenParseNode2 = (LiteralParseNode)betweenParseNode.getChildren().get(2);
            String expectedFieldValue1 = (String)betweenParseNode1.getValue();
            String expectedFieldValue2 = (String)betweenParseNode2.getValue();
            return betweenParseNode.isNegate() != SQLComparisonExpressionUtils.between(lhs, expectedFieldValue1, expectedFieldValue2, rawBsonDocument, comparisonValuesDocument);
        }
        if (parseNode instanceof InListParseNode) {
            InListParseNode inListParseNode = (InListParseNode)parseNode;
            List<ParseNode> childrenNodes = inListParseNode.getChildren();
            Object lhs = SQLComparisonExpressionUtils.getLHS(rawBsonDocument, keyAliasDocument, sortedKeyNames, childrenNodes.get(0));
            String[] inList = new String[childrenNodes.size() - 1];
            for (int i = 1; i < childrenNodes.size(); ++i) {
                LiteralParseNode literalParseNode = (LiteralParseNode)childrenNodes.get(i);
                inList[i - 1] = (String)literalParseNode.getValue();
            }
            return inListParseNode.isNegate() != SQLComparisonExpressionUtils.in(rawBsonDocument, comparisonValuesDocument, lhs, inList);
        }
        if (parseNode instanceof AndParseNode) {
            AndParseNode andParseNode = (AndParseNode)parseNode;
            List<ParseNode> children = andParseNode.getChildren();
            for (ParseNode node : children) {
                if (SQLComparisonExpressionUtils.evaluateExpression(node, rawBsonDocument, comparisonValuesDocument, keyAliasDocument, sortedKeyNames)) continue;
                return false;
            }
            return true;
        }
        if (parseNode instanceof OrParseNode) {
            OrParseNode orParseNode = (OrParseNode)parseNode;
            List<ParseNode> children = orParseNode.getChildren();
            for (ParseNode node : children) {
                if (!SQLComparisonExpressionUtils.evaluateExpression(node, rawBsonDocument, comparisonValuesDocument, keyAliasDocument, sortedKeyNames)) continue;
                return true;
            }
            return false;
        }
        if (parseNode instanceof NotParseNode) {
            NotParseNode notParseNode = (NotParseNode)parseNode;
            return !SQLComparisonExpressionUtils.evaluateExpression(notParseNode.getChildren().get(0), rawBsonDocument, comparisonValuesDocument, keyAliasDocument, sortedKeyNames);
        }
        throw new IllegalArgumentException("ParseNode " + parseNode + " is not recognized for document comparison");
    }

    private static Object getLHS(RawBsonDocument doc, BsonDocument keyAliasDocument, List<String> sortedKeyNames, ParseNode parseNode) {
        if (parseNode instanceof LiteralParseNode) {
            String fieldKey = (String)((LiteralParseNode)parseNode).getValue();
            return SQLComparisonExpressionUtils.replaceExpressionFieldNames(fieldKey, keyAliasDocument, sortedKeyNames);
        }
        if (parseNode instanceof DocumentFieldSizeParseNode) {
            String fieldKey = (String)((DocumentFieldSizeParseNode)parseNode).getValue();
            fieldKey = SQLComparisonExpressionUtils.replaceExpressionFieldNames(fieldKey, keyAliasDocument, sortedKeyNames);
            return new BsonInt32(SQLComparisonExpressionUtils.getSizeOfBsonValue(fieldKey, doc).intValue());
        }
        return null;
    }

    private static Integer getSizeOfBsonValue(String fieldKey, RawBsonDocument rawBsonDocument) {
        BsonValue fieldValue;
        BsonValue topLevelValue = rawBsonDocument.get((Object)fieldKey);
        BsonValue bsonValue = fieldValue = topLevelValue != null ? topLevelValue : CommonComparisonExpressionUtils.getFieldFromDocument(fieldKey, (BsonDocument)rawBsonDocument);
        if (fieldValue == null) {
            return 0;
        }
        if (fieldValue instanceof BsonString) {
            return ((BsonString)fieldValue).getValue().length();
        }
        if (fieldValue instanceof BsonBinary) {
            return ((BsonBinary)fieldValue).getData().length;
        }
        if (fieldValue instanceof BsonArray) {
            return ((BsonArray)fieldValue).size();
        }
        if (CommonComparisonExpressionUtils.isBsonSet(fieldValue)) {
            return ((BsonArray)((BsonDocument)fieldValue).get((Object)"$set")).size();
        }
        if (fieldValue instanceof BsonDocument) {
            return ((BsonDocument)fieldValue).size();
        }
        throw new BsonConditionInvalidArgumentException("Unsupported type for size() function. " + fieldValue.getClass() + ", supported types: String, Binary, Set, Array, Document.");
    }

    private static String replaceExpressionFieldNames(String fieldKey, BsonDocument keyAliasDocument, List<String> sortedKeys) {
        String tmpFieldKey = fieldKey;
        for (String expressionAttributeName : sortedKeys) {
            if (!tmpFieldKey.contains(expressionAttributeName)) continue;
            String actualFieldName = ((BsonString)keyAliasDocument.get((Object)expressionAttributeName)).getValue();
            tmpFieldKey = tmpFieldKey.replace(expressionAttributeName, actualFieldName);
        }
        return tmpFieldKey;
    }

    private static boolean compare(Object fieldKey, String expectedFieldValue, CommonComparisonExpressionUtils.CompareOp compareOp, RawBsonDocument rawBsonDocument, BsonDocument comparisonValuesDocument) {
        BsonNumber value;
        if (fieldKey instanceof BsonNumber) {
            value = (BsonNumber)fieldKey;
        } else {
            BsonValue topLevelValue = rawBsonDocument.get((Object)((String)fieldKey));
            BsonValue bsonValue = value = topLevelValue != null ? topLevelValue : CommonComparisonExpressionUtils.getFieldFromDocument((String)fieldKey, (BsonDocument)rawBsonDocument);
        }
        if (value != null) {
            BsonValue compareValue = comparisonValuesDocument.get((Object)expectedFieldValue);
            return CommonComparisonExpressionUtils.compareValues((BsonValue)value, compareValue, compareOp);
        }
        return false;
    }

    private static boolean exists(String documentField, RawBsonDocument rawBsonDocument) {
        BsonValue topLevelValue = rawBsonDocument.get((Object)documentField);
        if (topLevelValue != null) {
            return true;
        }
        return CommonComparisonExpressionUtils.getFieldFromDocument(documentField, (BsonDocument)rawBsonDocument) != null;
    }

    private static boolean lessThan(Object lhs, String expectedFieldValue, RawBsonDocument rawBsonDocument, BsonDocument comparisonValuesDocument) {
        return SQLComparisonExpressionUtils.compare(lhs, expectedFieldValue, CommonComparisonExpressionUtils.CompareOp.LESS, rawBsonDocument, comparisonValuesDocument);
    }

    private static boolean lessThanOrEquals(Object lhs, String expectedFieldValue, RawBsonDocument rawBsonDocument, BsonDocument comparisonValuesDocument) {
        return SQLComparisonExpressionUtils.compare(lhs, expectedFieldValue, CommonComparisonExpressionUtils.CompareOp.LESS_OR_EQUAL, rawBsonDocument, comparisonValuesDocument);
    }

    private static boolean greaterThan(Object lhs, String expectedFieldValue, RawBsonDocument rawBsonDocument, BsonDocument comparisonValuesDocument) {
        return SQLComparisonExpressionUtils.compare(lhs, expectedFieldValue, CommonComparisonExpressionUtils.CompareOp.GREATER, rawBsonDocument, comparisonValuesDocument);
    }

    private static boolean greaterThanOrEquals(Object lhs, String expectedFieldValue, RawBsonDocument rawBsonDocument, BsonDocument comparisonValuesDocument) {
        return SQLComparisonExpressionUtils.compare(lhs, expectedFieldValue, CommonComparisonExpressionUtils.CompareOp.GREATER_OR_EQUAL, rawBsonDocument, comparisonValuesDocument);
    }

    private static boolean between(Object lhs, String expectedFieldValue1, String expectedFieldValue2, RawBsonDocument rawBsonDocument, BsonDocument comparisonValuesDocument) {
        return SQLComparisonExpressionUtils.greaterThanOrEquals(lhs, expectedFieldValue1, rawBsonDocument, comparisonValuesDocument) && SQLComparisonExpressionUtils.lessThanOrEquals(lhs, expectedFieldValue2, rawBsonDocument, comparisonValuesDocument);
    }

    private static boolean in(RawBsonDocument rawBsonDocument, BsonDocument comparisonValuesDocument, Object lhs, String ... expectedInValues) {
        BsonNumber value;
        if (lhs instanceof BsonNumber) {
            value = (BsonNumber)lhs;
        } else {
            BsonValue topLevelValue = rawBsonDocument.get((Object)((String)lhs));
            BsonValue bsonValue = value = topLevelValue != null ? topLevelValue : CommonComparisonExpressionUtils.getFieldFromDocument((String)lhs, (BsonDocument)rawBsonDocument);
        }
        if (value != null) {
            for (String expectedInVal : expectedInValues) {
                if (!SQLComparisonExpressionUtils.isEquals(lhs, expectedInVal, rawBsonDocument, comparisonValuesDocument)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isEquals(Object lhs, String expectedFieldValue, RawBsonDocument rawBsonDocument, BsonDocument comparisonValuesDocument) {
        return SQLComparisonExpressionUtils.compare(lhs, expectedFieldValue, CommonComparisonExpressionUtils.CompareOp.EQUALS, rawBsonDocument, comparisonValuesDocument);
    }

    private static boolean beginsWith(String fieldKey, String prefixValue, RawBsonDocument rawBsonDocument, BsonDocument comparisonValuesDocument) throws BsonConditionInvalidArgumentException {
        BsonValue fieldValue;
        BsonValue topLevelValue = rawBsonDocument.get((Object)fieldKey);
        BsonValue bsonValue = fieldValue = topLevelValue != null ? topLevelValue : CommonComparisonExpressionUtils.getFieldFromDocument(fieldKey, (BsonDocument)rawBsonDocument);
        if (fieldValue == null) {
            return false;
        }
        BsonValue prefixBsonValue = comparisonValuesDocument.get((Object)prefixValue);
        if (prefixBsonValue == null) {
            return false;
        }
        if (!prefixBsonValue.isString() && !prefixBsonValue.isBinary()) {
            throw new BsonConditionInvalidArgumentException("begins_with function only supports String and Binary data types.");
        }
        if (fieldValue.isString() && prefixBsonValue.isString()) {
            String fieldStr = ((BsonString)fieldValue).getValue();
            String prefixStr = ((BsonString)prefixBsonValue).getValue();
            return fieldStr.startsWith(prefixStr);
        }
        if (fieldValue.isBinary() && prefixBsonValue.isBinary()) {
            byte[] fieldBytes = fieldValue.asBinary().getData();
            byte[] prefixBytes = prefixBsonValue.asBinary().getData();
            if (prefixBytes.length > fieldBytes.length) {
                return false;
            }
            return IntStream.range(0, prefixBytes.length).noneMatch(i -> fieldBytes[i] != prefixBytes[i]);
        }
        return false;
    }

    private static boolean contains(String fieldKey, String containsValue, RawBsonDocument rawBsonDocument, BsonDocument comparisonValuesDocument) {
        BsonValue fieldValue;
        BsonValue topLevelValue = rawBsonDocument.get((Object)fieldKey);
        BsonValue bsonValue = fieldValue = topLevelValue != null ? topLevelValue : CommonComparisonExpressionUtils.getFieldFromDocument(fieldKey, (BsonDocument)rawBsonDocument);
        if (fieldValue == null) {
            return false;
        }
        BsonValue containsBsonValue = comparisonValuesDocument.get((Object)containsValue);
        if (containsBsonValue == null) {
            return false;
        }
        if (fieldValue.isString()) {
            if (!containsBsonValue.isString()) {
                return false;
            }
            String fieldStr = ((BsonString)fieldValue).getValue();
            String containsStr = ((BsonString)containsBsonValue).getValue();
            return fieldStr.contains(containsStr);
        }
        if (fieldValue.isArray()) {
            List fieldValues = ((BsonArray)fieldValue).getValues();
            return fieldValues.stream().anyMatch(element -> SQLComparisonExpressionUtils.areEqual(element, containsBsonValue));
        }
        if (CommonComparisonExpressionUtils.isBsonSet(fieldValue)) {
            List fieldValues = ((BsonArray)((BsonDocument)fieldValue).get((Object)"$set")).getValues();
            return fieldValues.stream().anyMatch(element -> SQLComparisonExpressionUtils.areEqual(element, containsBsonValue));
        }
        return false;
    }

    private static boolean isFieldOfType(String fieldKey, String type, RawBsonDocument rawBsonDocument, BsonDocument comparisonValuesDocument) {
        BsonValue fieldValue;
        BsonValue topLevelValue = rawBsonDocument.get((Object)fieldKey);
        BsonValue bsonValue = fieldValue = topLevelValue != null ? topLevelValue : CommonComparisonExpressionUtils.getFieldFromDocument(fieldKey, (BsonDocument)rawBsonDocument);
        if (fieldValue == null) {
            return false;
        }
        BsonValue typeBsonVal = comparisonValuesDocument.get((Object)type);
        if (typeBsonVal == null) {
            throw new BsonConditionInvalidArgumentException("Value for type was not found in the comparison values document.");
        }
        switch (((BsonString)typeBsonVal).getValue()) {
            case "S": {
                return fieldValue.isString();
            }
            case "N": {
                return fieldValue.isNumber();
            }
            case "B": {
                return fieldValue.isBinary();
            }
            case "BOOL": {
                return fieldValue.isBoolean();
            }
            case "NULL": {
                return fieldValue.isNull();
            }
            case "L": {
                return fieldValue.isArray();
            }
            case "M": {
                return fieldValue.isDocument();
            }
            case "SS": {
                return CommonComparisonExpressionUtils.isBsonStringSet(fieldValue);
            }
            case "NS": {
                return CommonComparisonExpressionUtils.isBsonNumberSet(fieldValue);
            }
            case "BS": {
                return CommonComparisonExpressionUtils.isBsonBinarySet(fieldValue);
            }
        }
        throw new BsonConditionInvalidArgumentException("Unsupported type in field_type() for BsonConditionExpression: " + type + ", valid types: valid types: {N,BS,L,B,NULL,M,S,SS,NS,BOOL}");
    }

    private static boolean areEqual(BsonValue value1, BsonValue value2) {
        if (value1 == null && value2 == null) {
            return true;
        }
        if (value1 == null || value2 == null) {
            return false;
        }
        return value1.equals(value2);
    }
}

