/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.parse.ToDateParseNode;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.util.DateUtil;

@FunctionParseNode.BuiltInFunction(name="TO_DATE", nodeClass=ToDateParseNode.class, args={@FunctionParseNode.Argument(allowedTypes={PVarchar.class}), @FunctionParseNode.Argument(allowedTypes={PVarchar.class}, isConstant=true, defaultValue="null"), @FunctionParseNode.Argument(allowedTypes={PVarchar.class}, isConstant=true, defaultValue="null")})
public class ToDateFunction
extends ScalarFunction {
    public static final String NAME = "TO_DATE";
    private DateUtil.DateTimeParser dateParser;
    private PDataType.PDataCodec codec;
    protected String dateFormat;
    protected String timeZoneId;

    public ToDateFunction() {
    }

    public ToDateFunction(List<Expression> children, StatementContext context) throws SQLException {
        super(children);
        String dateFormat = (String)((LiteralExpression)children.get(1)).getValue();
        String timeZoneId = (String)((LiteralExpression)children.get(2)).getValue();
        if (dateFormat == null) {
            dateFormat = context.getDateFormat();
        }
        if (timeZoneId == null) {
            timeZoneId = context.getDateFormatTimeZoneId();
        }
        this.init(dateFormat, timeZoneId);
    }

    public ToDateFunction(List<Expression> children, String dateFormat, String timeZoneId) throws SQLException {
        super(children);
        this.init(dateFormat, timeZoneId);
    }

    @Override
    public ToDateFunction clone(List<Expression> children) {
        try {
            return new ToDateFunction(children, this.dateFormat, this.timeZoneId);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void init(String dateFormat, String timeZoneId) {
        this.dateFormat = dateFormat;
        this.dateParser = DateUtil.getDateTimeParser(dateFormat, this.getDataType(), timeZoneId);
        this.timeZoneId = this.dateParser.getTimeZone().getID();
        this.codec = DateUtil.getCodecFor(this.getDataType());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.dateFormat == null ? 0 : this.dateFormat.hashCode());
        result = 31 * result + (this.timeZoneId == null ? 0 : this.timeZoneId.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ToDateFunction other = (ToDateFunction)obj;
        if (!this.getChildren().get(0).equals(other.getChildren().get(0))) {
            return false;
        }
        if (this.dateFormat == null ? other.dateFormat != null : !this.dateFormat.equals(other.dateFormat)) {
            return false;
        }
        return !(this.timeZoneId == null ? other.timeZoneId != null : !this.timeZoneId.equals(other.timeZoneId));
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        Expression expression = this.getExpression();
        if (!expression.evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.getLength() == 0) {
            return true;
        }
        PDataType type = expression.getDataType();
        String dateStr = (String)type.toObject(ptr, expression.getSortOrder());
        long epochTime = this.dateParser.parseDateTime(dateStr);
        PDataType returnType = this.getDataType();
        byte[] byteValue = new byte[returnType.getByteSize().intValue()];
        this.codec.encodeLong(epochTime, byteValue, 0);
        ptr.set(byteValue);
        return true;
    }

    @Override
    public PDataType getDataType() {
        return PDate.INSTANCE;
    }

    @Override
    public boolean isNullable() {
        return this.getExpression().isNullable();
    }

    private String getTimeZoneIdArg() {
        return this.children.size() < 3 ? null : (String)((LiteralExpression)this.children.get(2)).getValue();
    }

    private String getDateFormatArg() {
        return this.children.size() < 2 ? null : (String)((LiteralExpression)this.children.get(1)).getValue();
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        String timeZoneId;
        super.readFields(input);
        String dateFormat = WritableUtils.readString((DataInput)input);
        if (dateFormat.length() != 0) {
            timeZoneId = "GMT";
        } else {
            int nChildren = this.children.size();
            if (nChildren == 1) {
                dateFormat = WritableUtils.readString((DataInput)input);
                timeZoneId = WritableUtils.readString((DataInput)input);
            } else if (nChildren == 2 || "LOCAL".equalsIgnoreCase(this.getTimeZoneIdArg())) {
                dateFormat = this.getDateFormatArg();
                timeZoneId = WritableUtils.readString((DataInput)input);
            } else {
                dateFormat = this.getDateFormatArg();
                timeZoneId = this.getTimeZoneIdArg();
            }
        }
        this.init(dateFormat, timeZoneId);
    }

    @Override
    public void write(DataOutput output) throws IOException {
        super.write(output);
        WritableUtils.writeString((DataOutput)output, (String)"");
        int nChildren = this.children.size();
        if (nChildren == 1) {
            WritableUtils.writeString((DataOutput)output, (String)this.dateFormat);
            WritableUtils.writeString((DataOutput)output, (String)this.timeZoneId);
        } else if (nChildren == 2 || "LOCAL".equalsIgnoreCase(this.getTimeZoneIdArg())) {
            WritableUtils.writeString((DataOutput)output, (String)this.timeZoneId);
        }
    }

    private Expression getExpression() {
        return (Expression)this.children.get(0);
    }

    @Override
    public String getName() {
        return NAME;
    }
}

