/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.compile.KeyPart;
import org.apache.phoenix.expression.Determinism;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.function.FunctionExpression;
import org.apache.phoenix.expression.function.RoundMonthExpression;
import org.apache.phoenix.expression.function.RoundWeekExpression;
import org.apache.phoenix.expression.function.RoundYearExpression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.expression.function.TimeUnit;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.ByteUtil;

@FunctionParseNode.BuiltInFunction(name="ROUND", args={@FunctionParseNode.Argument(allowedTypes={PDate.class}), @FunctionParseNode.Argument(allowedTypes={PVarchar.class, PInteger.class}, defaultValue="null", isConstant=true), @FunctionParseNode.Argument(allowedTypes={PInteger.class}, defaultValue="1", isConstant=true)}, classType=FunctionParseNode.FunctionClassType.DERIVED)
public class RoundDateExpression
extends ScalarFunction {
    long divBy;
    public static final String NAME = "ROUND";
    private static final long[] TIME_UNIT_MS = new long[]{86400000L, 3600000L, 60000L, 1000L, 1L};

    public RoundDateExpression() {
    }

    public static Expression create(Expression expr, TimeUnit timeUnit) throws SQLException {
        return RoundDateExpression.create(expr, timeUnit, 1);
    }

    public static Expression create(Expression expr, TimeUnit timeUnit, int multiplier) throws SQLException {
        Expression timeUnitExpr = RoundDateExpression.getTimeUnitExpr(timeUnit);
        Expression defaultMultiplierExpr = RoundDateExpression.getMultiplierExpr(multiplier);
        ArrayList expressions = Lists.newArrayList((Object[])new Expression[]{expr, timeUnitExpr, defaultMultiplierExpr});
        return RoundDateExpression.create(expressions);
    }

    public static Expression create(List<Expression> children) throws SQLException {
        int numChildren = children.size();
        if (numChildren < 2 || numChildren > 3) {
            throw new IllegalArgumentException("Wrong number of arguments : " + numChildren);
        }
        Object timeUnitValue = ((LiteralExpression)children.get(1)).getValue();
        TimeUnit timeUnit = TimeUnit.getTimeUnit(timeUnitValue != null ? timeUnitValue.toString() : null);
        switch (timeUnit) {
            case WEEK: {
                return new RoundWeekExpression(children);
            }
            case MONTH: {
                return new RoundMonthExpression(children);
            }
            case YEAR: {
                return new RoundYearExpression(children);
            }
        }
        return new RoundDateExpression(children);
    }

    static Expression getTimeUnitExpr(TimeUnit timeUnit) throws SQLException {
        return LiteralExpression.newConstant((Object)timeUnit.name(), (PDataType)PVarchar.INSTANCE, Determinism.ALWAYS);
    }

    static Expression getMultiplierExpr(int multiplier) throws SQLException {
        return LiteralExpression.newConstant((Object)multiplier, (PDataType)PInteger.INSTANCE, Determinism.ALWAYS);
    }

    public RoundDateExpression(List<Expression> children) {
        super(children.subList(0, 1));
        int numChildren = children.size();
        Object timeUnitValue = ((LiteralExpression)children.get(1)).getValue();
        Object multiplierValue = numChildren > 2 ? ((LiteralExpression)children.get(2)).getValue() : null;
        int multiplier = multiplierValue == null ? 1 : ((Number)multiplierValue).intValue();
        TimeUnit timeUnit = TimeUnit.getTimeUnit(timeUnitValue != null ? timeUnitValue.toString() : null);
        if (timeUnit.ordinal() < TIME_UNIT_MS.length) {
            this.divBy = (long)multiplier * TIME_UNIT_MS[timeUnit.ordinal()];
        }
    }

    protected long getRoundUpAmount() {
        return this.divBy / 2L;
    }

    @VisibleForTesting
    public long roundTime(long time) {
        long roundUpAmount = this.getRoundUpAmount();
        long value = time <= Long.MAX_VALUE - roundUpAmount ? (time + roundUpAmount) / this.divBy : (time - roundUpAmount) / this.divBy + 1L;
        return value * this.divBy;
    }

    @VisibleForTesting
    public long rangeLower(long time) {
        return this.roundTime(time) - this.getRoundUpAmount();
    }

    @VisibleForTesting
    public long rangeUpper(long time) {
        return this.roundTime(time) + (this.divBy - this.getRoundUpAmount()) - 1L;
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        if (((Expression)this.children.get(0)).evaluate(tuple, ptr)) {
            if (ptr.getLength() == 0) {
                return true;
            }
            PDataType dataType = this.getDataType();
            long time = dataType.getCodec().decodeLong(ptr, ((Expression)this.children.get(0)).getSortOrder());
            long value = this.roundTime(time);
            Date d = new Date(value);
            byte[] byteValue = dataType.toBytes(d);
            ptr.set(byteValue);
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        long roundUpAmount = this.getRoundUpAmount();
        result = 31 * result + (int)(this.divBy ^ this.divBy >>> 32);
        result = 31 * result + (int)(roundUpAmount ^ roundUpAmount >>> 32);
        result = 31 * result + ((Expression)this.children.get(0)).hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RoundDateExpression other = (RoundDateExpression)obj;
        if (this.divBy != other.divBy) {
            return false;
        }
        if (this.getRoundUpAmount() != other.getRoundUpAmount()) {
            return false;
        }
        return ((Expression)this.children.get(0)).equals(other.children.get(0));
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        super.readFields(input);
        this.divBy = WritableUtils.readVLong((DataInput)input);
    }

    @Override
    public void write(DataOutput output) throws IOException {
        super.write(output);
        WritableUtils.writeVLong((DataOutput)output, (long)this.divBy);
    }

    @Override
    public Integer getMaxLength() {
        return ((Expression)this.children.get(0)).getMaxLength();
    }

    @Override
    public PDataType getDataType() {
        return ((Expression)this.children.get(0)).getDataType();
    }

    @Override
    public boolean isNullable() {
        return ((Expression)this.children.get(0)).isNullable() || this.divBy == 0L;
    }

    protected PDataType.PDataCodec getKeyRangeCodec(PDataType columnDataType) {
        return columnDataType.getCodec();
    }

    @Override
    public KeyPart newKeyPart(final KeyPart childPart) {
        return new KeyPart(){
            private final Set<Expression> extractNodes;
            {
                this.extractNodes = new LinkedHashSet<RoundDateExpression>(Collections.singleton(RoundDateExpression.this));
            }

            @Override
            public PColumn getColumn() {
                return childPart.getColumn();
            }

            @Override
            public Set<Expression> getExtractNodes() {
                return this.extractNodes;
            }

            @Override
            public KeyRange getKeyRange(CompareOperator op, Expression rhs) {
                KeyRange range;
                PDataType type = this.getColumn().getDataType();
                ImmutableBytesWritable ptr = new ImmutableBytesWritable();
                rhs.evaluate(null, ptr);
                byte[] key = ByteUtil.copyKeyBytesIfNecessary(ptr);
                PDataType.PDataCodec codec = RoundDateExpression.this.getKeyRangeCodec(type);
                boolean offset = ByteUtil.isInclusive(op);
                long value = codec.decodeLong(key, 0, SortOrder.getDefault());
                byte[] lowerKey = new byte[type.getByteSize().intValue()];
                byte[] upperKey = new byte[type.getByteSize().intValue()];
                SortOrder order = this.getColumn().getSortOrder();
                switch (op) {
                    case EQUAL: {
                        if (value != RoundDateExpression.this.roundTime(value)) {
                            return KeyRange.EMPTY_RANGE;
                        }
                        codec.encodeLong(RoundDateExpression.this.rangeLower(value), lowerKey, 0);
                        codec.encodeLong(RoundDateExpression.this.rangeUpper(value), upperKey, 0);
                        range = type.getKeyRange(lowerKey, true, upperKey, true, order);
                        break;
                    }
                    case GREATER: {
                        if (value == RoundDateExpression.this.roundTime(value)) {
                            codec.encodeLong(RoundDateExpression.this.rangeUpper(value), lowerKey, 0);
                            range = type.getKeyRange(lowerKey, false, KeyRange.UNBOUND, false, order);
                            break;
                        }
                    }
                    case GREATER_OR_EQUAL: {
                        codec.encodeLong(RoundDateExpression.this.rangeLower(value), lowerKey, 0);
                        range = type.getKeyRange(lowerKey, true, KeyRange.UNBOUND, false, order);
                        if (value <= RoundDateExpression.this.roundTime(value)) {
                            codec.encodeLong(RoundDateExpression.this.rangeLower(value), lowerKey, 0);
                            range = type.getKeyRange(lowerKey, true, KeyRange.UNBOUND, false, order);
                            break;
                        }
                        codec.encodeLong(RoundDateExpression.this.rangeUpper(value), lowerKey, 0);
                        range = type.getKeyRange(lowerKey, false, KeyRange.UNBOUND, false, order);
                        break;
                    }
                    case LESS: {
                        if (value == RoundDateExpression.this.roundTime(value)) {
                            codec.encodeLong(RoundDateExpression.this.rangeLower(value), upperKey, 0);
                            range = type.getKeyRange(KeyRange.UNBOUND, false, upperKey, false, order);
                            break;
                        }
                    }
                    case LESS_OR_EQUAL: {
                        codec.encodeLong(RoundDateExpression.this.rangeUpper(value), upperKey, 0);
                        range = type.getKeyRange(KeyRange.UNBOUND, false, upperKey, true, order);
                        if (value >= RoundDateExpression.this.roundTime(value)) {
                            codec.encodeLong(RoundDateExpression.this.rangeUpper(value), upperKey, 0);
                            range = type.getKeyRange(KeyRange.UNBOUND, false, upperKey, true, order);
                            break;
                        }
                        codec.encodeLong(RoundDateExpression.this.rangeLower(value), upperKey, 0);
                        range = type.getKeyRange(KeyRange.UNBOUND, false, upperKey, false, order);
                        break;
                    }
                    default: {
                        return childPart.getKeyRange(op, rhs);
                    }
                }
                if (this.getColumn().getSortOrder() == SortOrder.DESC) {
                    range = range.invert();
                }
                return range;
            }

            @Override
            public PTable getTable() {
                return childPart.getTable();
            }
        };
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public FunctionExpression.OrderPreserving preservesOrder() {
        return FunctionExpression.OrderPreserving.YES;
    }

    @Override
    public int getKeyFormationTraversalIndex() {
        return 0;
    }
}

