/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.phoenix.compile.KeyPart;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.FunctionExpression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.util.ByteUtil;

public abstract class PrefixFunction
extends ScalarFunction {
    public PrefixFunction() {
    }

    public PrefixFunction(List<Expression> children) {
        super(children);
    }

    @Override
    public int getKeyFormationTraversalIndex() {
        return this.preservesOrder() == FunctionExpression.OrderPreserving.NO ? -1 : 0;
    }

    protected boolean extractNode() {
        return false;
    }

    @Override
    public KeyPart newKeyPart(KeyPart childPart) {
        return new PrefixKeyPart(childPart);
    }

    private class PrefixKeyPart
    implements KeyPart {
        private final Set<Expression> extractNodes;
        private final KeyPart childPart;

        PrefixKeyPart(KeyPart childPart) {
            this.extractNodes = PrefixFunction.this.extractNode() ? new LinkedHashSet<PrefixFunction>(Collections.singleton(PrefixFunction.this)) : Collections.emptySet();
            this.childPart = childPart;
        }

        @Override
        public PColumn getColumn() {
            return this.childPart.getColumn();
        }

        @Override
        public Set<Expression> getExtractNodes() {
            return this.extractNodes;
        }

        @Override
        public KeyRange getKeyRange(CompareOperator op, Expression rhs) {
            byte[] lowerRange = KeyRange.UNBOUND;
            byte[] upperRange = KeyRange.UNBOUND;
            boolean lowerInclusive = true;
            PDataType type = this.getColumn().getDataType();
            switch (op) {
                case EQUAL: {
                    lowerRange = ScalarFunction.evaluateExpression(rhs);
                    upperRange = ByteUtil.nextKey(lowerRange);
                    break;
                }
                case GREATER: {
                    lowerRange = ByteUtil.nextKey(ScalarFunction.evaluateExpression(rhs));
                    break;
                }
                case LESS_OR_EQUAL: {
                    upperRange = ByteUtil.nextKey(ScalarFunction.evaluateExpression(rhs));
                    lowerInclusive = false;
                    break;
                }
                default: {
                    return this.childPart.getKeyRange(op, rhs);
                }
            }
            PColumn column = this.getColumn();
            Integer length = column.getMaxLength();
            if (type.isFixedWidth()) {
                if (length != null) {
                    if (lowerRange != KeyRange.UNBOUND) {
                        lowerRange = type.pad(lowerRange, length, SortOrder.ASC);
                    }
                    if (upperRange != KeyRange.UNBOUND) {
                        upperRange = type.pad(upperRange, length, SortOrder.ASC);
                    }
                }
            } else if (column.getSortOrder() == SortOrder.DESC && this.getTable().rowKeyOrderOptimizable() && lowerRange != KeyRange.UNBOUND) {
                lowerRange = Arrays.copyOf(lowerRange, lowerRange.length + 1);
                lowerRange[lowerRange.length - 1] = 0;
            }
            KeyRange range = KeyRange.getKeyRange(lowerRange, lowerInclusive, upperRange, false);
            if (column.getSortOrder() == SortOrder.DESC) {
                range = range.invert();
            }
            return range;
        }

        @Override
        public PTable getTable() {
            return this.childPart.getTable();
        }
    }
}

