/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Determinism;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.RowKeyColumnExpression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.parse.PartitionIdParseNode;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PChar;
import org.apache.phoenix.schema.types.PDataType;

@FunctionParseNode.BuiltInFunction(name="PARTITION_ID", nodeClass=PartitionIdParseNode.class, args={})
public class PartitionIdFunction
extends ScalarFunction {
    public static final String NAME = "PARTITION_ID";
    public static final int PARTITION_ID_LENGTH = 32;

    public PartitionIdFunction() {
    }

    public PartitionIdFunction(List<Expression> children) {
        super(children);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        if (tuple == null) {
            return false;
        }
        tuple.getKey(ptr);
        if (ptr.getLength() < 32) {
            return false;
        }
        RowKeyColumnExpression partitionIdColumnExpression = (RowKeyColumnExpression)this.children.get(0);
        return partitionIdColumnExpression.evaluate(tuple, ptr);
    }

    @Override
    public PDataType getDataType() {
        return PChar.INSTANCE;
    }

    @Override
    public Integer getMaxLength() {
        return 32;
    }

    @Override
    public boolean isStateless() {
        return false;
    }

    @Override
    public Determinism getDeterminism() {
        return Determinism.PER_ROW;
    }
}

