/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.parse.JsonValueParseNode;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PBson;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PJson;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.util.json.JsonDataFormat;
import org.apache.phoenix.util.json.JsonDataFormatFactory;

@FunctionParseNode.BuiltInFunction(name="JSON_VALUE", nodeClass=JsonValueParseNode.class, args={@FunctionParseNode.Argument(allowedTypes={PJson.class, PBson.class, PVarbinary.class}), @FunctionParseNode.Argument(allowedTypes={PVarchar.class})})
public class JsonValueFunction
extends ScalarFunction {
    public static final String NAME = "JSON_VALUE";
    private final JsonDataFormat jsonDataFormat = JsonDataFormatFactory.getJsonDataFormat(JsonDataFormatFactory.DataFormat.BSON);

    public JsonValueFunction() {
    }

    public JsonValueFunction(List<Expression> children) {
        super(children);
        Preconditions.checkNotNull((Object)this.getJSONPathExpr());
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        block9: {
            block8: {
                if (!this.getColValExpr().evaluate(tuple, ptr)) {
                    return false;
                }
                if (ptr == null || ptr.getLength() == 0) {
                    return false;
                }
                Object top = PJson.INSTANCE.toObject(ptr, this.getColValExpr().getSortOrder());
                if (!this.getJSONPathExpr().evaluate(tuple, ptr)) {
                    return false;
                }
                if (ptr.getLength() == 0) {
                    return false;
                }
                String jsonPathExprStr = (String)PVarchar.INSTANCE.toObject(ptr, this.getJSONPathExpr().getSortOrder());
                if (jsonPathExprStr == null) {
                    return false;
                }
                Object value = this.jsonDataFormat.getValue(top, jsonPathExprStr);
                int valueType = this.jsonDataFormat.getValueType(top, jsonPathExprStr);
                if (value == null) break block8;
                switch (valueType) {
                    case -5: 
                    case -2: 
                    case 4: 
                    case 8: 
                    case 12: 
                    case 16: 
                    case 91: {
                        ptr.set(PVarchar.INSTANCE.toBytes(String.valueOf(value)));
                        break block9;
                    }
                    default: {
                        return false;
                    }
                }
            }
            ptr.set(PVarchar.INSTANCE.toBytes(null));
        }
        return true;
    }

    private Expression getColValExpr() {
        return this.getChildren().get(0);
    }

    private Expression getJSONPathExpr() {
        return this.getChildren().get(1);
    }

    @Override
    public PDataType getDataType() {
        return PVarchar.INSTANCE;
    }
}

