/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.parse.JsonModifyParseNode;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PJson;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.util.json.JsonDataFormat;
import org.apache.phoenix.util.json.JsonDataFormatFactory;

@FunctionParseNode.BuiltInFunction(name="JSON_MODIFY", nodeClass=JsonModifyParseNode.class, args={@FunctionParseNode.Argument(allowedTypes={PJson.class, PVarchar.class}), @FunctionParseNode.Argument(allowedTypes={PVarchar.class}), @FunctionParseNode.Argument(allowedTypes={PVarchar.class})})
public class JsonModifyFunction
extends ScalarFunction {
    public static final String NAME = "JSON_MODIFY";
    private final JsonDataFormat jsonDataFormat = JsonDataFormatFactory.getJsonDataFormat(JsonDataFormatFactory.DataFormat.BSON);

    public JsonModifyFunction() {
    }

    public JsonModifyFunction(List<Expression> children) {
        super(children);
        Preconditions.checkNotNull((Object)this.getJSONPathExpr());
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        if (!this.getColValExpr().evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr == null || ptr.getLength() == 0) {
            return false;
        }
        Object top = PJson.INSTANCE.toObject(ptr, this.getColValExpr().getSortOrder());
        if (!this.getJSONPathExpr().evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.getLength() == 0) {
            return false;
        }
        String jsonPathExprStr = (String)PVarchar.INSTANCE.toObject(ptr, this.getJSONPathExpr().getSortOrder());
        if (jsonPathExprStr == null) {
            return false;
        }
        if (!this.getNewValueExpr().evaluate(tuple, ptr)) {
            return false;
        }
        String newVal = (String)PVarchar.INSTANCE.toObject(ptr, this.getNewValueExpr().getSortOrder());
        ByteBuffer buffer = this.jsonDataFormat.updateValue(top, jsonPathExprStr, newVal);
        ptr.set(buffer.array(), buffer.arrayOffset(), buffer.limit());
        return true;
    }

    private Expression getNewValueExpr() {
        return this.getChildren().get(2);
    }

    private Expression getColValExpr() {
        return this.getChildren().get(0);
    }

    private Expression getJSONPathExpr() {
        return this.getChildren().get(1);
    }

    @Override
    public PDataType getDataType() {
        return PJson.INSTANCE;
    }
}

