/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.sql.SQLException;
import java.util.Base64;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.EncodeFormat;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.schema.IllegalDataException;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.schema.types.PVarchar;

@FunctionParseNode.BuiltInFunction(name="ENCODE_BINARY", args={@FunctionParseNode.Argument(allowedTypes={PVarbinary.class}), @FunctionParseNode.Argument(enumeration="EncodeFormat")})
public class EncodeBinaryFunction
extends ScalarFunction {
    public static final String NAME = "ENCODE_BINARY";

    public EncodeBinaryFunction() {
    }

    public EncodeBinaryFunction(List<Expression> children) throws SQLException {
        super(children);
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        Expression expression = this.getExpression();
        if (!expression.evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.getLength() == 0) {
            return true;
        }
        byte[] bytesToEncode = ptr.copyBytes();
        Expression encodingExpression = this.getEncodingExpression();
        if (!encodingExpression.evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.getLength() == 0) {
            throw new IllegalDataException(EncodeBinaryFunction.getMissingEncodeFormatMsg());
        }
        PDataType type = encodingExpression.getDataType();
        String encodingFormat = ((String)type.toObject(ptr)).toUpperCase();
        EncodeFormat format = EncodeFormat.valueOf(encodingFormat);
        ptr.set(PVarchar.INSTANCE.toBytes(switch (format) {
            case EncodeFormat.HEX -> Bytes.toHex((byte[])bytesToEncode);
            case EncodeFormat.BASE64 -> Base64.getEncoder().encodeToString(bytesToEncode);
            case EncodeFormat.HBASE -> Bytes.toStringBinary((byte[])bytesToEncode);
            default -> throw new IllegalDataException(EncodeBinaryFunction.getUnsupportedEncodeFormatMsg(encodingFormat));
        }));
        return true;
    }

    public static String getMissingEncodeFormatMsg() {
        return "Missing Encode Format";
    }

    public static String getUnsupportedEncodeFormatMsg(String encodeFormat) {
        return "Unsupported Encode Format : " + encodeFormat;
    }

    @Override
    public PDataType getDataType() {
        return PVarchar.INSTANCE;
    }

    @Override
    public String getName() {
        return NAME;
    }

    private Expression getExpression() {
        return (Expression)this.children.get(0);
    }

    private Expression getEncodingExpression() {
        return (Expression)this.children.get(1);
    }
}

