/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Determinism;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.KeyValueColumnExpression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.parse.DecodeViewIndexIdParseNode;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PSmallint;
import org.apache.phoenix.util.ByteUtil;

@FunctionParseNode.BuiltInFunction(name="DECODE_VIEW_INDEX_ID", nodeClass=DecodeViewIndexIdParseNode.class, args={@FunctionParseNode.Argument(allowedTypes={PLong.class}), @FunctionParseNode.Argument(allowedTypes={PInteger.class})})
public class DecodeViewIndexIdFunction
extends ScalarFunction {
    public static final String NAME = "DECODE_VIEW_INDEX_ID";

    public DecodeViewIndexIdFunction() {
    }

    public DecodeViewIndexIdFunction(List<Expression> children) {
        super(children);
        if (children.size() != 2 || !children.get(0).getClass().isAssignableFrom(KeyValueColumnExpression.class) || !children.get(1).getClass().isAssignableFrom(KeyValueColumnExpression.class)) {
            throw new IllegalArgumentException("DecodeViewIndexIdFunction should only have a VIEW_INDEX_ID and a VIEW_INDEX_ID_DATA_TYPE key value expression.");
        }
        if (!children.get(0).getDataType().equals(PLong.INSTANCE)) {
            throw new IllegalArgumentException("DecodeViewIndexIdFunction should have an VIEW_INDEX_ID key value expression of type PLong");
        }
        if (!children.get(1).getDataType().equals(PInteger.INSTANCE)) {
            throw new IllegalArgumentException("DecodeViewIndexIdFunction should have an VIEW_INDEX_ID_DATA_TYPE key value expression of type PLong");
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        if (tuple == null) {
            return false;
        }
        byte[] viewIndexIdCF = ((KeyValueColumnExpression)this.children.get(0)).getColumnFamily();
        byte[] viewIndexIdCQ = ((KeyValueColumnExpression)this.children.get(0)).getColumnQualifier();
        byte[] viewIndexIdTypeCF = ((KeyValueColumnExpression)this.children.get(1)).getColumnFamily();
        byte[] viewIndexIdTypeCQ = ((KeyValueColumnExpression)this.children.get(1)).getColumnQualifier();
        Cell viewIndexIdCell = tuple.getValue(viewIndexIdCF, viewIndexIdCQ);
        Cell viewIndexIdDataTypeCell = tuple.getValue(viewIndexIdTypeCF, viewIndexIdTypeCQ);
        if (viewIndexIdCell != null && viewIndexIdCell.getValueLength() == 0) {
            ptr.set(ByteUtil.EMPTY_BYTE_ARRAY);
            return true;
        }
        if (viewIndexIdCell != null) {
            Object typeObject;
            int type = 0;
            if (viewIndexIdDataTypeCell != null && (typeObject = PInteger.INSTANCE.toObject(viewIndexIdDataTypeCell.getValueArray(), viewIndexIdDataTypeCell.getValueOffset(), viewIndexIdDataTypeCell.getValueLength(), PInteger.INSTANCE, SortOrder.ASC)) != null) {
                type = (Integer)typeObject;
            }
            ImmutableBytesWritable columnValue = new ImmutableBytesWritable(CellUtil.cloneValue((Cell)viewIndexIdCell));
            if ((type == 0 || type == 5) && viewIndexIdCell.getValueLength() < 9) {
                byte[] newBytes = PLong.INSTANCE.toBytes(PSmallint.INSTANCE.toObject(columnValue.get()));
                ptr.set(newBytes, 0, newBytes.length);
            } else {
                ptr.set(columnValue.get(), columnValue.getOffset(), columnValue.getLength());
            }
        }
        return true;
    }

    @Override
    public PDataType getDataType() {
        return PLong.INSTANCE;
    }

    @Override
    public boolean isStateless() {
        return false;
    }

    @Override
    public Determinism getDeterminism() {
        return Determinism.PER_ROW;
    }
}

