/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.expression.util.bson.UpdateExpressionUtils;
import org.apache.phoenix.parse.BsonUpdateExpressionParseNode;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PBson;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.bson.BsonBinaryReader;
import org.bson.BsonDocument;
import org.bson.BsonReader;
import org.bson.RawBsonDocument;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.io.BsonInput;
import org.bson.io.ByteBufferBsonInput;

@FunctionParseNode.BuiltInFunction(name="BSON_UPDATE_EXPRESSION", nodeClass=BsonUpdateExpressionParseNode.class, args={@FunctionParseNode.Argument(allowedTypes={PBson.class, PVarbinary.class}), @FunctionParseNode.Argument(allowedTypes={PBson.class, PVarbinary.class}, isConstant=true)})
public class BsonUpdateExpressionFunction
extends ScalarFunction {
    public static final String NAME = "BSON_UPDATE_EXPRESSION";

    public BsonUpdateExpressionFunction() {
    }

    public BsonUpdateExpressionFunction(List<Expression> children) {
        super(children);
        Preconditions.checkNotNull((Object)this.getChildren().get(1));
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        RawBsonDocument updateExpressionBsonDoc;
        BsonDocument bsonDocument;
        if (!this.getChildren().get(0).evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr == null || ptr.getLength() == 0) {
            return false;
        }
        RawBsonDocument rawBsonDocument = (RawBsonDocument)PBson.INSTANCE.toObject(ptr);
        try (BsonBinaryReader bsonReader = new BsonBinaryReader((BsonInput)new ByteBufferBsonInput(rawBsonDocument.getByteBuffer()));){
            bsonDocument = new BsonDocumentCodec().decode((BsonReader)bsonReader, DecoderContext.builder().build());
        }
        if (!this.getChildren().get(1).evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.getLength() == 0) {
            return false;
        }
        if (this.getChildren().get(1).getDataType() == PVarchar.INSTANCE) {
            String updateExpression = (String)PVarchar.INSTANCE.toObject(ptr, this.getChildren().get(1).getSortOrder());
            if (updateExpression == null || updateExpression.isEmpty()) {
                return true;
            }
            updateExpressionBsonDoc = RawBsonDocument.parse((String)updateExpression);
        } else {
            updateExpressionBsonDoc = (RawBsonDocument)PBson.INSTANCE.toObject(ptr);
            if (updateExpressionBsonDoc == null) {
                return true;
            }
        }
        UpdateExpressionUtils.updateExpression((BsonDocument)updateExpressionBsonDoc, bsonDocument);
        RawBsonDocument updatedDocument = new RawBsonDocument((Object)bsonDocument, (Codec)new BsonDocumentCodec());
        ByteBuffer buffer = updatedDocument.getByteBuffer().asNIO();
        ptr.set(buffer.array(), buffer.arrayOffset(), buffer.limit());
        return true;
    }

    @Override
    public PDataType getDataType() {
        return PBson.INSTANCE;
    }
}

