/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.BaseCompoundExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.visitor.ExpressionVisitor;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.schema.types.PVarbinaryEncoded;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TrustedByteArrayOutputStream;

public class RowValueConstructorExpression
extends BaseCompoundExpression {
    private ImmutableBytesWritable[] ptrs;
    private ImmutableBytesWritable literalExprPtr;
    private int partialEvalIndex = -1;
    private int estimatedByteSize;
    private BitSet extraFields;

    public RowValueConstructorExpression() {
    }

    public RowValueConstructorExpression(List<Expression> children, boolean isConstant) {
        super(children);
        this.extraFields = new BitSet(8);
        this.extraFields.set(ExtraFieldPosition.STRIP_TRAILING_SEPARATOR_BYTE.getBitPosition());
        if (isConstant) {
            this.extraFields.set(ExtraFieldPosition.LITERAL_CONSTANT.getBitPosition());
        }
        this.estimatedByteSize = 0;
        this.init();
    }

    public RowValueConstructorExpression clone(List<Expression> children) {
        return new RowValueConstructorExpression(children, this.literalExprPtr != null);
    }

    public int getEstimatedSize() {
        return this.estimatedByteSize;
    }

    @Override
    public boolean isStateless() {
        return this.literalExprPtr != null;
    }

    @Override
    public final <T> T accept(ExpressionVisitor<T> visitor) {
        List<T> l = this.acceptChildren(visitor, visitor.visitEnter(this));
        T t = visitor.visitLeave(this, l);
        if (t == null) {
            t = visitor.defaultReturn(this, l);
        }
        return t;
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        super.readFields(input);
        this.extraFields = BitSet.valueOf(new byte[]{input.readByte()});
        this.init();
    }

    @Override
    public void write(DataOutput output) throws IOException {
        super.write(output);
        byte[] b = this.extraFields.toByteArray();
        output.writeByte(b.length > 0 ? b[0] & 0xFF : 0);
    }

    private void init() {
        this.ptrs = new ImmutableBytesWritable[this.children.size()];
        if (this.isConstant()) {
            ImmutableBytesWritable ptr = new ImmutableBytesWritable();
            this.evaluate(null, ptr);
            this.literalExprPtr = ptr;
        }
    }

    private boolean isConstant() {
        return this.extraFields.get(ExtraFieldPosition.LITERAL_CONSTANT.getBitPosition());
    }

    private boolean isStripTrailingSepByte() {
        return this.extraFields.get(ExtraFieldPosition.STRIP_TRAILING_SEPARATOR_BYTE.getBitPosition());
    }

    @Override
    public PDataType getDataType() {
        return PVarbinary.INSTANCE;
    }

    @Override
    public void reset() {
        this.partialEvalIndex = 0;
        this.estimatedByteSize = 0;
        Arrays.fill(this.ptrs, null);
        super.reset();
    }

    private static int getExpressionByteCount(Expression e) {
        PDataType childType = e.getDataType();
        if (childType != null && !childType.isFixedWidth()) {
            return childType != PVarbinaryEncoded.INSTANCE ? 1 : 2;
        }
        return childType == null ? 1 : SchemaUtil.getFixedByteSize(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        boolean bl;
        int evalIndex;
        if (this.literalExprPtr != null) {
            ptr.set(this.literalExprPtr.get(), this.literalExprPtr.getOffset(), this.literalExprPtr.getLength());
            return true;
        }
        boolean isPartialEval = this.partialEvalIndex >= 0;
        int expressionCount = evalIndex = isPartialEval ? this.partialEvalIndex : 0;
        while (evalIndex < this.ptrs.length) {
            Expression expression = (Expression)this.children.get(evalIndex);
            if (expression.evaluate(tuple, ptr)) {
                if (ptr.getLength() == 0) {
                    this.estimatedByteSize += RowValueConstructorExpression.getExpressionByteCount(expression);
                } else {
                    expressionCount = evalIndex + 1;
                    this.ptrs[evalIndex] = new ImmutableBytesWritable();
                    this.ptrs[evalIndex].set(ptr.get(), ptr.getOffset(), ptr.getLength());
                    this.estimatedByteSize += ptr.getLength() + (expression.getDataType().isFixedWidth() ? 0 : RowValueConstructorExpression.getSeparatorBytesLength(expression));
                }
            } else {
                if (tuple != null && !tuple.isImmutable()) return false;
                this.estimatedByteSize += RowValueConstructorExpression.getExpressionByteCount(expression);
            }
            ++evalIndex;
        }
        if (isPartialEval) {
            this.partialEvalIndex = evalIndex;
        }
        if (evalIndex != this.ptrs.length) return false;
        if (expressionCount == 0) {
            ptr.set(ByteUtil.EMPTY_BYTE_ARRAY);
            return true;
        }
        if (expressionCount == 1) {
            ptr.set(this.ptrs[0].get(), this.ptrs[0].getOffset(), this.ptrs[0].getLength());
            return true;
        }
        TrustedByteArrayOutputStream output = new TrustedByteArrayOutputStream(this.estimatedByteSize);
        try {
            boolean previousCarryOver = false;
            for (int i = 0; i < expressionCount; ++i) {
                Expression child = this.getChildren().get(i);
                PDataType childType = child.getDataType();
                ImmutableBytesWritable tempPtr = this.ptrs[i];
                if (tempPtr == null) {
                    boolean bl2 = previousCarryOver = childType == null || childType.isFixedWidth();
                    if (childType == PVarbinaryEncoded.INSTANCE) {
                        output.write(QueryConstants.VARBINARY_ENCODED_SEPARATOR_BYTES);
                        continue;
                    }
                    int bytesToWrite = RowValueConstructorExpression.getExpressionByteCount(child);
                    for (int m = 0; m < bytesToWrite; ++m) {
                        output.write(0);
                    }
                    continue;
                }
                output.write(tempPtr.get(), tempPtr.getOffset(), tempPtr.getLength());
                if (!childType.isFixedWidth()) {
                    output.write(SchemaUtil.getSeparatorBytes(childType, true, false, child.getSortOrder()));
                }
                if (!previousCarryOver) continue;
                previousCarryOver = !ByteUtil.previousKey(output.getBuffer(), output.size());
            }
            int outputSize = output.size();
            byte[] outputBytes = output.getBuffer();
            for (int k = expressionCount - 1; k >= 0 && this.getChildren().get(k).getDataType() != null && !this.getChildren().get(k).getDataType().isFixedWidth() && this.hasSeparatorBytes(outputBytes, outputSize, k) && (this.getChildren().get(k).getSortOrder() == SortOrder.ASC || this.isStripTrailingSepByte()); --k) {
                --outputSize;
                if (this.getChildren().get(k).getDataType() != PVarbinaryEncoded.INSTANCE) continue;
                --outputSize;
            }
            ptr.set(outputBytes, 0, outputSize);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                output.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        output.close();
        return bl;
    }

    private boolean hasSeparatorBytes(byte[] outputBytes, int outputSize, int k) {
        if (this.getChildren().get(k).getDataType() != PVarbinaryEncoded.INSTANCE) {
            return outputBytes[outputSize - 1] == SchemaUtil.getSeparatorByte(true, false, this.getChildren().get(k));
        }
        byte[] sepBytes = SchemaUtil.getSeparatorBytesForVarBinaryEncoded(true, false, this.getChildren().get(k).getSortOrder());
        return outputSize >= 2 && outputBytes[outputSize - 1] == sepBytes[1] && outputBytes[outputSize - 2] == sepBytes[0];
    }

    private static int getSeparatorBytesLength(Expression expression) {
        return expression.getDataType() != PVarbinaryEncoded.INSTANCE ? 1 : 2;
    }

    @Override
    public final String toString() {
        StringBuilder buf = new StringBuilder("(");
        for (int i = 0; i < this.children.size() - 1; ++i) {
            buf.append(this.children.get(i) + ", ");
        }
        buf.append(this.children.get(this.children.size() - 1) + ")");
        return buf.toString();
    }

    @Override
    public boolean requiresFinalEvaluation() {
        return true;
    }

    private static enum ExtraFieldPosition {
        LITERAL_CONSTANT(0),
        STRIP_TRAILING_SEPARATOR_BYTE(1);

        private int bitPosition;

        private ExtraFieldPosition(int position) {
            this.bitPosition = position;
        }

        private int getBitPosition() {
            return this.bitPosition;
        }
    }
}

