/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.expression.BaseExpression;
import org.apache.phoenix.expression.BaseSingleExpression;
import org.apache.phoenix.expression.ComparisonExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.NotExpression;
import org.apache.phoenix.expression.RowKeyColumnExpression;
import org.apache.phoenix.expression.RowValueConstructorExpression;
import org.apache.phoenix.expression.visitor.ExpressionVisitor;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Sets;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.ExpressionUtil;
import org.apache.phoenix.util.StringUtil;

public class InListExpression
extends BaseSingleExpression {
    private Set<ImmutableBytesPtr> values;
    private ImmutableBytesPtr minValue;
    private ImmutableBytesPtr maxValue;
    private int valuesByteLength;
    private int fixedWidth = -1;
    private List<Expression> keyExpressions;
    private boolean rowKeyOrderOptimizable;
    private int hashCode = -1;
    private boolean hashCodeSet = false;

    public static Expression create(List<Expression> children, boolean isNegate, ImmutableBytesWritable ptr, boolean rowKeyOrderOptimizable) throws SQLException {
        boolean nullInList;
        List<InListColumnKeyValuePair> inListColumnKeyValuePairList;
        if (children.size() == 1) {
            throw new SQLException("No element in the IN list");
        }
        Expression firstChild = children.get(0);
        if (firstChild.isStateless() && (!firstChild.evaluate(null, ptr) || ptr.getLength() == 0)) {
            return LiteralExpression.newConstant(null, (PDataType)PBoolean.INSTANCE, firstChild.getDeterminism());
        }
        List<Object> childrenWithoutNulls = Lists.newArrayList();
        for (Expression child : children) {
            if (child.equals(LiteralExpression.newConstant(null))) continue;
            childrenWithoutNulls.add(child);
        }
        if (childrenWithoutNulls.size() <= 1) {
            return LiteralExpression.newConstant(false);
        }
        if (firstChild instanceof RowValueConstructorExpression && (inListColumnKeyValuePairList = InListExpression.getSortedInListColumnKeyValuePair((List<Expression>)childrenWithoutNulls)) != null) {
            childrenWithoutNulls = InListExpression.getSortedRowValueConstructorExpressionList(inListColumnKeyValuePairList, firstChild.isStateless(), children.size() - 1);
            firstChild = (Expression)childrenWithoutNulls.get(0);
        }
        boolean bl = nullInList = children.size() != childrenWithoutNulls.size();
        if (childrenWithoutNulls.size() == 2 && !nullInList) {
            return ComparisonExpression.create(isNegate ? CompareOperator.NOT_EQUAL : CompareOperator.EQUAL, childrenWithoutNulls, ptr, rowKeyOrderOptimizable);
        }
        SQLException sqlE = null;
        ArrayList coercedKeyExpressions = Lists.newArrayListWithExpectedSize((int)childrenWithoutNulls.size());
        coercedKeyExpressions.add(firstChild);
        for (int i = 1; i < childrenWithoutNulls.size(); ++i) {
            try {
                Expression rhs = BaseExpression.coerce(firstChild, (Expression)childrenWithoutNulls.get(i), CompareOperator.EQUAL, rowKeyOrderOptimizable);
                coercedKeyExpressions.add(rhs);
                continue;
            }
            catch (SQLException e) {
                sqlE = e;
            }
        }
        if (coercedKeyExpressions.size() <= 1) {
            if (nullInList || sqlE == null) {
                return LiteralExpression.newConstant(false);
            }
            throw sqlE;
        }
        if (coercedKeyExpressions.size() == 2) {
            return ComparisonExpression.create(isNegate ? CompareOperator.NOT_EQUAL : CompareOperator.EQUAL, coercedKeyExpressions, ptr, rowKeyOrderOptimizable);
        }
        Expression expression = new InListExpression(coercedKeyExpressions, rowKeyOrderOptimizable);
        if (isNegate) {
            expression = NotExpression.create(expression, ptr);
        }
        if (ExpressionUtil.isConstant(expression)) {
            return ExpressionUtil.getConstantExpression(expression, ptr);
        }
        return expression;
    }

    public InListExpression() {
    }

    @VisibleForTesting
    protected InListExpression(List<ImmutableBytesPtr> values) {
        this.children = Collections.emptyList();
        this.values = Sets.newHashSet(values);
    }

    public InListExpression(List<Expression> keyExpressions, boolean rowKeyOrderOptimizable) {
        super(keyExpressions.get(0));
        this.rowKeyOrderOptimizable = rowKeyOrderOptimizable;
        Expression firstChild = keyExpressions.get(0);
        this.keyExpressions = keyExpressions.subList(1, keyExpressions.size());
        HashSet values = Sets.newHashSetWithExpectedSize((int)(keyExpressions.size() - 1));
        Integer maxLength = firstChild.getDataType().isFixedWidth() ? firstChild.getMaxLength() : null;
        int fixedWidth = -1;
        boolean isFixedLength = true;
        for (int i = 1; i < keyExpressions.size(); ++i) {
            ImmutableBytesPtr ptr = new ImmutableBytesPtr();
            Expression child = keyExpressions.get(i);
            child.evaluate(null, ptr);
            if (ptr.getLength() <= 0) continue;
            if (rowKeyOrderOptimizable) {
                firstChild.getDataType().pad(ptr, maxLength, firstChild.getSortOrder());
            } else if (maxLength != null) {
                byte[] paddedBytes = StringUtil.padChar(ByteUtil.copyKeyBytesIfNecessary(ptr), maxLength);
                ptr.set(paddedBytes);
            }
            if (!values.add(ptr)) continue;
            int length = ptr.getLength();
            if (fixedWidth == -1) {
                fixedWidth = length;
            } else {
                isFixedLength &= fixedWidth == length;
            }
            this.valuesByteLength += ptr.getLength();
        }
        this.fixedWidth = isFixedLength ? fixedWidth : -1;
        ImmutableBytesPtr[] valuesArray = values.toArray(new ImmutableBytesPtr[values.size()]);
        Arrays.sort(valuesArray, ByteUtil.BYTES_PTR_COMPARATOR);
        if (values.isEmpty()) {
            this.minValue = ByteUtil.EMPTY_BYTE_ARRAY_PTR;
            this.maxValue = ByteUtil.EMPTY_BYTE_ARRAY_PTR;
            this.values = Collections.emptySet();
        } else {
            this.minValue = valuesArray[0];
            this.maxValue = valuesArray[valuesArray.length - 1];
            this.values = new LinkedHashSet<ImmutableBytesPtr>(Arrays.asList(valuesArray));
        }
        this.hashCodeSet = false;
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        if (!this.getChild().evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.getLength() == 0) {
            ptr.set(ByteUtil.EMPTY_BYTE_ARRAY);
            return true;
        }
        if (this.values.contains(ptr)) {
            ptr.set(PDataType.TRUE_BYTES);
            return true;
        }
        ptr.set(PDataType.FALSE_BYTES);
        return true;
    }

    @Override
    public int hashCode() {
        if (!this.hashCodeSet) {
            int prime = 31;
            int result = 1;
            this.hashCode = result = 31 * result + this.children.hashCode() + this.values.hashCode();
            this.hashCodeSet = true;
        }
        return this.hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InListExpression other = (InListExpression)obj;
        return this.children.equals(other.children) && this.values.equals(other.values);
    }

    @Override
    public PDataType getDataType() {
        return PBoolean.INSTANCE;
    }

    private int readValue(DataInput input, byte[] valuesBytes, int offset, ImmutableBytesPtr ptr) throws IOException {
        int valueLen = this.fixedWidth == -1 ? WritableUtils.readVInt((DataInput)input) : this.fixedWidth;
        this.values.add(new ImmutableBytesPtr(valuesBytes, offset, valueLen));
        return offset + valueLen;
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        super.readFields(input);
        input.readBoolean();
        this.fixedWidth = WritableUtils.readVInt((DataInput)input);
        byte[] valuesBytes = Bytes.readByteArray((DataInput)input);
        this.valuesByteLength = valuesBytes.length;
        int len = this.fixedWidth == -1 ? WritableUtils.readVInt((DataInput)input) : this.valuesByteLength / this.fixedWidth;
        this.values = Sets.newLinkedHashSetWithExpectedSize((int)len);
        this.hashCodeSet = false;
        int offset = 0;
        int i = 0;
        if (i < len) {
            this.minValue = new ImmutableBytesPtr();
            offset = this.readValue(input, valuesBytes, offset, this.minValue);
            while (++i < len - 1) {
                offset = this.readValue(input, valuesBytes, offset, new ImmutableBytesPtr());
            }
            if (i < len) {
                this.maxValue = new ImmutableBytesPtr();
                offset = this.readValue(input, valuesBytes, offset, this.maxValue);
            } else {
                this.maxValue = this.minValue;
            }
        } else {
            this.minValue = this.maxValue = new ImmutableBytesPtr(ByteUtil.EMPTY_BYTE_ARRAY);
        }
    }

    @Override
    public void write(DataOutput output) throws IOException {
        super.write(output);
        output.writeBoolean(false);
        WritableUtils.writeVInt((DataOutput)output, (int)this.fixedWidth);
        WritableUtils.writeVInt((DataOutput)output, (int)this.valuesByteLength);
        for (ImmutableBytesPtr ptr : this.values) {
            output.write(ptr.get(), ptr.getOffset(), ptr.getLength());
        }
        if (this.fixedWidth == -1) {
            WritableUtils.writeVInt((DataOutput)output, (int)this.values.size());
            for (ImmutableBytesPtr ptr : this.values) {
                WritableUtils.writeVInt((DataOutput)output, (int)ptr.getLength());
            }
        }
    }

    @Override
    public final <T> T accept(ExpressionVisitor<T> visitor) {
        List<T> l = this.acceptChildren(visitor, visitor.visitEnter(this));
        T t = visitor.visitLeave(this, l);
        if (t == null) {
            t = visitor.defaultReturn(this, l);
        }
        return t;
    }

    public List<Expression> getKeyExpressions() {
        return this.keyExpressions;
    }

    public ImmutableBytesWritable getMinKey() {
        return this.minValue;
    }

    public ImmutableBytesWritable getMaxKey() {
        return this.maxValue;
    }

    public String toString() {
        int maxToStringLen = 200;
        Expression firstChild = (Expression)this.children.get(0);
        PDataType type = firstChild.getDataType();
        StringBuilder buf = new StringBuilder(firstChild + " IN (");
        Iterator<ImmutableBytesPtr> iterator = this.values.iterator();
        while (iterator.hasNext()) {
            ImmutableBytesPtr value;
            ImmutableBytesPtr currValue = value = iterator.next();
            if (firstChild.getSortOrder() != null && !firstChild.getSortOrder().equals((Object)SortOrder.getDefault())) {
                currValue = new ImmutableBytesWritable((ImmutableBytesWritable)value);
                type.coerceBytes(currValue, type, firstChild.getSortOrder(), SortOrder.getDefault());
            }
            buf.append(type.toStringLiteral(currValue, null));
            buf.append(',');
            if (buf.length() < maxToStringLen) continue;
            buf.append("... ");
            break;
        }
        buf.setCharAt(buf.length() - 1, ')');
        return buf.toString();
    }

    public InListExpression clone(List<Expression> l) {
        return new InListExpression(l, this.rowKeyOrderOptimizable);
    }

    public static List<InListColumnKeyValuePair> getSortedInListColumnKeyValuePair(List<Expression> children) {
        ArrayList<InListColumnKeyValuePair> inListColumnKeyValuePairList = new ArrayList<InListColumnKeyValuePair>();
        int numberOfColumns = 0;
        for (int i = 0; i < children.size(); ++i) {
            int j;
            Expression child = children.get(i);
            if (i == 0) {
                numberOfColumns = child.getChildren().size();
                for (j = 0; j < child.getChildren().size(); ++j) {
                    if (!(child.getChildren().get(j) instanceof RowKeyColumnExpression)) {
                        return null;
                    }
                    RowKeyColumnExpression rowKeyColumnExpression = (RowKeyColumnExpression)child.getChildren().get(j);
                    InListColumnKeyValuePair inListColumnKeyValuePair = new InListColumnKeyValuePair(rowKeyColumnExpression);
                    inListColumnKeyValuePairList.add(inListColumnKeyValuePair);
                }
                continue;
            }
            if (numberOfColumns != child.getChildren().size()) {
                return null;
            }
            for (j = 0; j < child.getChildren().size(); ++j) {
                LiteralExpression literalExpression = (LiteralExpression)child.getChildren().get(j);
                ((InListColumnKeyValuePair)inListColumnKeyValuePairList.get(j)).addToLiteralExpressionList(literalExpression);
            }
        }
        Collections.sort(inListColumnKeyValuePairList);
        return inListColumnKeyValuePairList;
    }

    public static List<Expression> getSortedRowValueConstructorExpressionList(List<InListColumnKeyValuePair> inListColumnKeyValuePairList, boolean isStateless, int numberOfRows) {
        ArrayList<Expression> l = new ArrayList<Expression>();
        ArrayList<Expression> keyExpressions = new ArrayList<Expression>();
        for (int i = 0; i < inListColumnKeyValuePairList.size(); ++i) {
            keyExpressions.add(inListColumnKeyValuePairList.get(i).getRowKeyColumnExpression());
        }
        l.add(new RowValueConstructorExpression(keyExpressions, isStateless));
        ArrayList valueExpressionsList = new ArrayList();
        for (int j = 0; j < inListColumnKeyValuePairList.size(); ++j) {
            List<LiteralExpression> list = inListColumnKeyValuePairList.get(j).getLiteralExpressionList();
            for (int i = 0; i < numberOfRows; ++i) {
                if (j == 0) {
                    valueExpressionsList.add(new ArrayList());
                }
                ((List)valueExpressionsList.get(i)).add((Expression)list.get(i));
            }
        }
        for (List list : valueExpressionsList) {
            l.add(new RowValueConstructorExpression(list, isStateless));
        }
        return l;
    }

    public static class InListColumnKeyValuePair
    implements Comparable<InListColumnKeyValuePair> {
        RowKeyColumnExpression rowKeyColumnExpression;
        List<LiteralExpression> literalExpressionList;

        public InListColumnKeyValuePair(RowKeyColumnExpression rowKeyColumnExpression) {
            this.rowKeyColumnExpression = rowKeyColumnExpression;
            this.literalExpressionList = new ArrayList<LiteralExpression>();
        }

        public RowKeyColumnExpression getRowKeyColumnExpression() {
            return this.rowKeyColumnExpression;
        }

        public void addToLiteralExpressionList(LiteralExpression literalExpression) {
            this.literalExpressionList.add(literalExpression);
        }

        public List<LiteralExpression> getLiteralExpressionList() {
            return this.literalExpressionList;
        }

        @Override
        public int compareTo(InListColumnKeyValuePair o) {
            return this.rowKeyColumnExpression.getPosition() - o.getRowKeyColumnExpression().getPosition();
        }
    }
}

