/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.compile.WhereCompiler;
import org.apache.phoenix.expression.AndExpression;
import org.apache.phoenix.expression.BaseCompoundExpression;
import org.apache.phoenix.expression.BaseTerminalExpression;
import org.apache.phoenix.expression.ColumnExpression;
import org.apache.phoenix.expression.Determinism;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.IsNullExpression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.NotExpression;
import org.apache.phoenix.expression.RowValueConstructorExpression;
import org.apache.phoenix.expression.function.ArrayElemRefExpression;
import org.apache.phoenix.expression.rewrite.RowValueConstructorExpressionRewriter;
import org.apache.phoenix.expression.visitor.ExpressionVisitor;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TypeMismatchException;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PChar;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PUnsignedInt;
import org.apache.phoenix.schema.types.PUnsignedLong;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.ExpressionUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.StringUtil;

public class ComparisonExpression
extends BaseCompoundExpression {
    private CompareOperator op;

    private static void addEqualityExpression(Expression lhs, Expression rhs, List<Expression> andNodes, ImmutableBytesWritable ptr, boolean rowKeyOrderOptimizable) throws SQLException {
        boolean isLHSNull = ExpressionUtil.isNull(lhs, ptr);
        boolean isRHSNull = ExpressionUtil.isNull(rhs, ptr);
        if (isLHSNull && isRHSNull) {
            andNodes.add(LiteralExpression.newConstant((Object)false, PBoolean.INSTANCE));
        } else if (isLHSNull) {
            andNodes.add(IsNullExpression.create(rhs, false, ptr));
        } else if (isRHSNull) {
            andNodes.add(IsNullExpression.create(lhs, false, ptr));
        } else {
            andNodes.add(ComparisonExpression.create(CompareOperator.EQUAL, Arrays.asList(lhs, rhs), ptr, rowKeyOrderOptimizable));
        }
    }

    private static void rewriteRVCAsEqualityExpression(Expression lhs, Expression rhs, List<Expression> andNodes, ImmutableBytesWritable ptr, boolean rowKeyOrderOptimizable) throws SQLException {
        block6: {
            block7: {
                block5: {
                    int i;
                    if (!(lhs instanceof RowValueConstructorExpression) || !(rhs instanceof RowValueConstructorExpression)) break block5;
                    for (i = 0; i < Math.min(lhs.getChildren().size(), rhs.getChildren().size()); ++i) {
                        ComparisonExpression.addEqualityExpression(lhs.getChildren().get(i), rhs.getChildren().get(i), andNodes, ptr, rowKeyOrderOptimizable);
                    }
                    while (i < lhs.getChildren().size()) {
                        ComparisonExpression.addEqualityExpression(lhs.getChildren().get(i), LiteralExpression.newConstant(null, lhs.getChildren().get(i).getDataType()), andNodes, ptr, rowKeyOrderOptimizable);
                        ++i;
                    }
                    while (i < rhs.getChildren().size()) {
                        ComparisonExpression.addEqualityExpression(LiteralExpression.newConstant(null, rhs.getChildren().get(i).getDataType()), rhs.getChildren().get(i), andNodes, ptr, rowKeyOrderOptimizable);
                        ++i;
                    }
                    break block6;
                }
                if (!(lhs instanceof RowValueConstructorExpression)) break block7;
                ComparisonExpression.addEqualityExpression(lhs.getChildren().get(0), rhs, andNodes, ptr, rowKeyOrderOptimizable);
                for (int i = 1; i < lhs.getChildren().size(); ++i) {
                    ComparisonExpression.addEqualityExpression(lhs.getChildren().get(i), LiteralExpression.newConstant(null, lhs.getChildren().get(i).getDataType()), andNodes, ptr, rowKeyOrderOptimizable);
                }
                break block6;
            }
            if (!(rhs instanceof RowValueConstructorExpression)) break block6;
            ComparisonExpression.addEqualityExpression(lhs, rhs.getChildren().get(0), andNodes, ptr, rowKeyOrderOptimizable);
            for (int i = 1; i < rhs.getChildren().size(); ++i) {
                ComparisonExpression.addEqualityExpression(LiteralExpression.newConstant(null, rhs.getChildren().get(i).getDataType()), rhs.getChildren().get(i), andNodes, ptr, rowKeyOrderOptimizable);
            }
        }
    }

    public static Expression create(CompareOperator op, List<Expression> children, ImmutableBytesWritable ptr, boolean rowKeyOrderOptimizable) throws SQLException {
        Expression lhsExpr = children.get(0);
        Expression rhsExpr = children.get(1);
        PDataType lhsExprDataType = lhsExpr.getDataType();
        PDataType rhsExprDataType = rhsExpr.getDataType();
        if ((lhsExpr instanceof RowValueConstructorExpression || rhsExpr instanceof RowValueConstructorExpression) && !(lhsExpr instanceof ArrayElemRefExpression) && !(rhsExpr instanceof ArrayElemRefExpression)) {
            if (op == CompareOperator.EQUAL || op == CompareOperator.NOT_EQUAL) {
                ArrayList andNodes = Lists.newArrayListWithExpectedSize((int)Math.max(lhsExpr.getChildren().size(), rhsExpr.getChildren().size()));
                ComparisonExpression.rewriteRVCAsEqualityExpression(lhsExpr, rhsExpr, andNodes, ptr, rowKeyOrderOptimizable);
                Expression expr = AndExpression.create(andNodes);
                if (op == CompareOperator.NOT_EQUAL) {
                    expr = NotExpression.create(expr, ptr);
                }
                return expr;
            }
            rhsExpr = RowValueConstructorExpression.coerce(lhsExpr, rhsExpr, op, rowKeyOrderOptimizable);
            if (!(lhsExpr instanceof RowValueConstructorExpression)) {
                lhsExpr = new RowValueConstructorExpression(Collections.singletonList(lhsExpr), lhsExpr.isStateless());
            }
            RowValueConstructorExpressionRewriter rvcRewriter = RowValueConstructorExpressionRewriter.getSingleton();
            lhsExpr = rvcRewriter.rewriteAllChildrenAsc((RowValueConstructorExpression)lhsExpr);
            rhsExpr = rvcRewriter.rewriteAllChildrenAsc((RowValueConstructorExpression)rhsExpr);
            children = Arrays.asList(lhsExpr, rhsExpr);
        } else if (lhsExprDataType != null && rhsExprDataType != null && !lhsExprDataType.isComparableTo(rhsExprDataType)) {
            throw TypeMismatchException.newException(lhsExprDataType, rhsExprDataType, ComparisonExpression.toString(op, children));
        }
        Determinism determinism = lhsExpr.getDeterminism().combine(rhsExpr.getDeterminism());
        Object lhsValue = null;
        if (lhsExpr instanceof LiteralExpression && (lhsValue = ((LiteralExpression)lhsExpr).getValue()) == null) {
            return LiteralExpression.newConstant(null, (PDataType)PBoolean.INSTANCE, lhsExpr.getDeterminism());
        }
        Object rhsValue = null;
        if (rhsExpr instanceof LiteralExpression && (rhsValue = ((LiteralExpression)rhsExpr).getValue()) == null) {
            return LiteralExpression.newConstant(null, (PDataType)PBoolean.INSTANCE, rhsExpr.getDeterminism());
        }
        if (lhsValue != null && rhsValue != null) {
            return LiteralExpression.newConstant((Object)ByteUtil.compare(op, lhsExprDataType.compareTo(lhsValue, rhsValue, rhsExprDataType)), determinism);
        }
        if (rhsValue != null) {
            if (rhsExprDataType != lhsExprDataType || rhsExpr.getSortOrder() != lhsExpr.getSortOrder() || rhsExprDataType.isFixedWidth() && rhsExpr.getMaxLength() != null && lhsExprDataType.isFixedWidth() && lhsExpr.getMaxLength() != null && rhsExpr.getMaxLength() < lhsExpr.getMaxLength()) {
                if (rhsExprDataType.isCoercibleTo(lhsExprDataType, rhsValue)) {
                    children = Arrays.asList(children.get(0), LiteralExpression.newConstant(rhsValue, lhsExprDataType, lhsExpr.getMaxLength(), null, lhsExpr.getSortOrder(), determinism, rowKeyOrderOptimizable));
                } else {
                    if (op == CompareOperator.EQUAL) {
                        return LiteralExpression.newConstant((Object)false, (PDataType)PBoolean.INSTANCE, Determinism.ALWAYS);
                    }
                    if (op == CompareOperator.NOT_EQUAL) {
                        return LiteralExpression.newConstant((Object)true, (PDataType)PBoolean.INSTANCE, Determinism.ALWAYS);
                    }
                    if (rhsExprDataType == PDecimal.INSTANCE) {
                        int increment = 0;
                        switch (op) {
                            case GREATER_OR_EQUAL: 
                            case LESS: {
                                increment = 1;
                            }
                        }
                        BigDecimal bd = (BigDecimal)rhsValue;
                        rhsValue = bd.longValue() + (long)increment;
                        children = Arrays.asList(lhsExpr, LiteralExpression.newConstant(rhsValue, lhsExprDataType, lhsExpr.getSortOrder(), rhsExpr.getDeterminism()));
                    } else if (rhsExprDataType == PLong.INSTANCE) {
                        if (lhsExprDataType == PInteger.INSTANCE || lhsExprDataType == PUnsignedInt.INSTANCE) {
                            switch (op) {
                                case LESS: 
                                case LESS_OR_EQUAL: {
                                    if ((Long)rhsValue > 0L) {
                                        return LiteralExpression.newConstant((Object)true, (PDataType)PBoolean.INSTANCE, determinism);
                                    }
                                    return LiteralExpression.newConstant((Object)false, (PDataType)PBoolean.INSTANCE, determinism);
                                }
                                case GREATER_OR_EQUAL: 
                                case GREATER: {
                                    if ((Long)rhsValue > 0L) {
                                        return LiteralExpression.newConstant((Object)false, (PDataType)PBoolean.INSTANCE, determinism);
                                    }
                                    return LiteralExpression.newConstant((Object)true, (PDataType)PBoolean.INSTANCE, determinism);
                                }
                            }
                        } else if (lhsExprDataType == PUnsignedLong.INSTANCE) {
                            switch (op) {
                                case LESS: 
                                case LESS_OR_EQUAL: {
                                    return LiteralExpression.newConstant((Object)false, (PDataType)PBoolean.INSTANCE, determinism);
                                }
                                case GREATER_OR_EQUAL: 
                                case GREATER: {
                                    return LiteralExpression.newConstant((Object)true, (PDataType)PBoolean.INSTANCE, determinism);
                                }
                            }
                        }
                        children = Arrays.asList(lhsExpr, LiteralExpression.newConstant(rhsValue, rhsExprDataType, lhsExpr.getSortOrder(), determinism));
                    }
                }
            }
            if (children.get(1).getMaxLength() != null && lhsExpr.getMaxLength() != null && lhsExpr.getMaxLength() < children.get(1).getMaxLength()) {
                switch (op) {
                    case EQUAL: {
                        return LiteralExpression.newConstant((Object)false, (PDataType)PBoolean.INSTANCE, determinism);
                    }
                    case NOT_EQUAL: {
                        return LiteralExpression.newConstant((Object)true, (PDataType)PBoolean.INSTANCE, determinism);
                    }
                }
            }
        }
        return new ComparisonExpression(children, op);
    }

    public ComparisonExpression() {
    }

    public ComparisonExpression(List<Expression> children, CompareOperator op) {
        super(children);
        if (op == null) {
            throw new NullPointerException();
        }
        this.op = op;
    }

    public ComparisonExpression clone(List<Expression> children) {
        return new ComparisonExpression(children, this.getFilterOp());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.op.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComparisonExpression other = (ComparisonExpression)obj;
        return this.op == other.op;
    }

    @Override
    public PDataType getDataType() {
        return PBoolean.INSTANCE;
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        int comparisonResult;
        if (!((Expression)this.children.get(0)).evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.getLength() == 0) {
            return true;
        }
        byte[] lhsBytes = ptr.get();
        int lhsOffset = ptr.getOffset();
        int lhsLength = ptr.getLength();
        PDataType lhsDataType = ((Expression)this.children.get(0)).getDataType();
        SortOrder lhsSortOrder = ((Expression)this.children.get(0)).getSortOrder();
        if (!((Expression)this.children.get(1)).evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.getLength() == 0) {
            return true;
        }
        byte[] rhsBytes = ptr.get();
        int rhsOffset = ptr.getOffset();
        int rhsLength = ptr.getLength();
        PDataType rhsDataType = ((Expression)this.children.get(1)).getDataType();
        SortOrder rhsSortOrder = ((Expression)this.children.get(1)).getSortOrder();
        if (rhsDataType == PChar.INSTANCE) {
            rhsLength = StringUtil.getUnpaddedCharLength(rhsBytes, rhsOffset, rhsLength, rhsSortOrder);
        }
        if (lhsDataType == PChar.INSTANCE) {
            lhsLength = StringUtil.getUnpaddedCharLength(lhsBytes, lhsOffset, lhsLength, lhsSortOrder);
        }
        ptr.set(ByteUtil.compare(this.op, comparisonResult = lhsDataType.compareTo(lhsBytes, lhsOffset, lhsLength, lhsSortOrder, rhsBytes, rhsOffset, rhsLength, rhsSortOrder, rhsDataType)) ? PDataType.TRUE_BYTES : PDataType.FALSE_BYTES);
        return true;
    }

    @Override
    public boolean contains(Expression other) {
        BaseTerminalExpression lhsB;
        if (!(other instanceof ComparisonExpression) && !(other instanceof IsNullExpression)) {
            return false;
        }
        if (other instanceof IsNullExpression) {
            return !((IsNullExpression)other).isNegate();
        }
        BaseTerminalExpression lhsA = WhereCompiler.getBaseTerminalExpression(this.getChildren().get(0));
        if (!lhsA.equals(lhsB = WhereCompiler.getBaseTerminalExpression(other.getChildren().get(0)))) {
            return false;
        }
        CompareOperator opA = this.getFilterOp();
        CompareOperator opB = ((ComparisonExpression)other).getFilterOp();
        BaseTerminalExpression rhs = WhereCompiler.getBaseTerminalExpression(this.getChildren().get(1));
        if (rhs instanceof ColumnExpression) {
            BaseTerminalExpression rhsB = WhereCompiler.getBaseTerminalExpression(other.getChildren().get(1));
            if (!rhs.equals(rhsB)) {
                return false;
            }
            switch (opA) {
                case LESS_OR_EQUAL: {
                    return opB == CompareOperator.LESS || opB == CompareOperator.LESS_OR_EQUAL || opB == CompareOperator.EQUAL;
                }
                case LESS: 
                case GREATER: 
                case EQUAL: 
                case NOT_EQUAL: {
                    return opA == opB;
                }
                case GREATER_OR_EQUAL: {
                    return opB == CompareOperator.GREATER || opB == CompareOperator.GREATER_OR_EQUAL || opB == CompareOperator.EQUAL;
                }
            }
            throw new IllegalArgumentException("Unexpected CompareOp " + opA);
        }
        LiteralExpression rhsA = WhereCompiler.getLiteralExpression(this.getChildren().get(1));
        LiteralExpression rhsB = WhereCompiler.getLiteralExpression(other.getChildren().get(1));
        Object valA = rhsA.getValue();
        Object valB = rhsB.getValue();
        PDataType typeA = rhsA.getDataType();
        PDataType typeB = rhsB.getDataType();
        switch (opA) {
            case LESS: {
                if (opB == CompareOperator.GREATER_OR_EQUAL || opB == CompareOperator.GREATER || opB == CompareOperator.NOT_EQUAL) {
                    return false;
                }
                if (opB == CompareOperator.LESS) {
                    return typeA.compareTo(valA, valB, typeB) >= 0;
                }
                if (opB == CompareOperator.LESS_OR_EQUAL || opB == CompareOperator.EQUAL) {
                    return typeA.compareTo(valA, valB, typeB) > 0;
                }
                return false;
            }
            case LESS_OR_EQUAL: {
                if (opB == CompareOperator.GREATER_OR_EQUAL || opB == CompareOperator.GREATER || opB == CompareOperator.NOT_EQUAL) {
                    return false;
                }
                if (opB == CompareOperator.LESS_OR_EQUAL || opB == CompareOperator.LESS || opB == CompareOperator.EQUAL) {
                    return typeA.compareTo(valA, valB, typeB) >= 0;
                }
                return false;
            }
            case EQUAL: 
            case NOT_EQUAL: {
                if (opA != opB) {
                    return false;
                }
                return typeA.compareTo(valA, valB, typeB) == 0;
            }
            case GREATER_OR_EQUAL: {
                if (opB == CompareOperator.LESS_OR_EQUAL || opB == CompareOperator.LESS || opB == CompareOperator.NOT_EQUAL) {
                    return false;
                }
                if (opB == CompareOperator.GREATER_OR_EQUAL || opB == CompareOperator.GREATER || opB == CompareOperator.EQUAL) {
                    return typeA.compareTo(valA, valB, typeB) <= 0;
                }
                return false;
            }
            case GREATER: {
                if (opB == CompareOperator.LESS_OR_EQUAL || opB == CompareOperator.LESS || opB == CompareOperator.NOT_EQUAL) {
                    return false;
                }
                if (opB == CompareOperator.GREATER) {
                    return typeA.compareTo(valA, valB, typeB) <= 0;
                }
                if (opB == CompareOperator.GREATER_OR_EQUAL || opB == CompareOperator.EQUAL) {
                    return typeA.compareTo(valA, valB, typeB) < 0;
                }
                return false;
            }
        }
        throw new IllegalArgumentException("Unexpected CompareOp of " + opA);
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        this.op = CompareOperator.values()[WritableUtils.readVInt((DataInput)input)];
        super.readFields(input);
    }

    @Override
    public void write(DataOutput output) throws IOException {
        WritableUtils.writeVInt((DataOutput)output, (int)this.op.ordinal());
        super.write(output);
    }

    @Override
    public final <T> T accept(ExpressionVisitor<T> visitor) {
        List<T> l = this.acceptChildren(visitor, visitor.visitEnter(this));
        T t = visitor.visitLeave(this, l);
        if (t == null) {
            t = visitor.defaultReturn(this, l);
        }
        return t;
    }

    public CompareOperator getFilterOp() {
        return this.op;
    }

    public static String toString(CompareOperator op, List<Expression> children) {
        return children.get(0) + " " + QueryUtil.toSQL(op) + " " + children.get(1);
    }

    @Override
    public String toString() {
        return ComparisonExpression.toString(this.getFilterOp(), this.children);
    }
}

