/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.execute.visitor;

import java.sql.SQLException;
import org.apache.phoenix.compile.ListJarsQueryPlan;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.TraceQueryPlan;
import org.apache.phoenix.execute.AggregatePlan;
import org.apache.phoenix.execute.ClientAggregatePlan;
import org.apache.phoenix.execute.ClientScanPlan;
import org.apache.phoenix.execute.CursorFetchPlan;
import org.apache.phoenix.execute.HashJoinPlan;
import org.apache.phoenix.execute.LiteralResultIterationPlan;
import org.apache.phoenix.execute.ScanPlan;
import org.apache.phoenix.execute.SortMergeJoinPlan;
import org.apache.phoenix.execute.TupleProjectionPlan;
import org.apache.phoenix.execute.UnionPlan;
import org.apache.phoenix.execute.UnnestArrayPlan;
import org.apache.phoenix.execute.visitor.QueryPlanVisitor;
import org.apache.phoenix.parse.JoinTableNode;

public class AvgRowWidthVisitor
implements QueryPlanVisitor<Double> {
    @Override
    public Double defaultReturn(QueryPlan plan) {
        return null;
    }

    @Override
    public Double visit(AggregatePlan plan) {
        try {
            Long byteCount = plan.getEstimatedBytesToScan();
            Long rowCount = plan.getEstimatedRowsToScan();
            if (byteCount != null && rowCount != null) {
                if (byteCount == 0L) {
                    return 0.0;
                }
                if (rowCount != 0L) {
                    return (double)byteCount.longValue() / (double)rowCount.longValue();
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Double visit(ScanPlan plan) {
        try {
            Long byteCount = plan.getEstimatedBytesToScan();
            Long rowCount = plan.getEstimatedRowsToScan();
            if (byteCount != null && rowCount != null) {
                if (byteCount == 0L) {
                    return 0.0;
                }
                if (rowCount != 0L) {
                    return (double)byteCount.longValue() / (double)rowCount.longValue();
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Double visit(ClientAggregatePlan plan) {
        return plan.getDelegate().accept(this);
    }

    @Override
    public Double visit(ClientScanPlan plan) {
        return plan.getDelegate().accept(this);
    }

    @Override
    public Double visit(LiteralResultIterationPlan plan) {
        return plan.getEstimatedSize();
    }

    @Override
    public Double visit(TupleProjectionPlan plan) {
        return plan.getDelegate().accept(this);
    }

    @Override
    public Double visit(HashJoinPlan plan) {
        Double lhsWidth = plan.getDelegate().accept(this);
        if (lhsWidth == null) {
            return null;
        }
        JoinTableNode.JoinType[] joinTypes = plan.getJoinInfo().getJoinTypes();
        HashJoinPlan.SubPlan[] subPlans = plan.getSubPlans();
        Double width = lhsWidth;
        for (int i = 0; i < joinTypes.length; ++i) {
            Double rhsWidth = subPlans[i].getInnerPlan().accept(this);
            if (rhsWidth == null) {
                return null;
            }
            width = AvgRowWidthVisitor.join(width, rhsWidth, joinTypes[i]);
        }
        return width;
    }

    @Override
    public Double visit(SortMergeJoinPlan plan) {
        Double lhsWidth = plan.getLhsPlan().accept(this);
        Double rhsWidth = plan.getRhsPlan().accept(this);
        if (lhsWidth == null || rhsWidth == null) {
            return null;
        }
        return AvgRowWidthVisitor.join(lhsWidth, rhsWidth, plan.getJoinType());
    }

    @Override
    public Double visit(UnionPlan plan) {
        Double sum = 0.0;
        for (QueryPlan subPlan : plan.getSubPlans()) {
            Double avgWidth = subPlan.accept(this);
            if (avgWidth == null) {
                return null;
            }
            sum = sum + avgWidth;
        }
        return sum / (double)plan.getSubPlans().size();
    }

    @Override
    public Double visit(UnnestArrayPlan plan) {
        return plan.getDelegate().accept(this);
    }

    @Override
    public Double visit(CursorFetchPlan plan) {
        return plan.getDelegate().accept(this);
    }

    @Override
    public Double visit(ListJarsQueryPlan plan) {
        return plan.getEstimatedSize();
    }

    @Override
    public Double visit(TraceQueryPlan plan) {
        return plan.getEstimatedSize();
    }

    public static double join(double lhsWidth, double rhsWidth, JoinTableNode.JoinType type) {
        return switch (type) {
            case JoinTableNode.JoinType.Inner, JoinTableNode.JoinType.Left, JoinTableNode.JoinType.Right, JoinTableNode.JoinType.Full -> lhsWidth + rhsWidth;
            case JoinTableNode.JoinType.Semi, JoinTableNode.JoinType.Anti -> lhsWidth;
            default -> throw new IllegalArgumentException("Invalid join type: " + type);
        };
    }
}

