/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.execute;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.codec.binary.Hex;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.cache.ServerCacheClient;
import org.apache.phoenix.compile.ColumnProjector;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.FromCompiler;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.compile.WhereCompiler;
import org.apache.phoenix.coprocessorclient.HashJoinCacheNotFoundException;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.execute.AggregatePlan;
import org.apache.phoenix.execute.BaseQueryPlan;
import org.apache.phoenix.execute.DelegateQueryPlan;
import org.apache.phoenix.execute.visitor.AvgRowWidthVisitor;
import org.apache.phoenix.execute.visitor.QueryPlanVisitor;
import org.apache.phoenix.execute.visitor.RowCountVisitor;
import org.apache.phoenix.expression.Determinism;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.InListExpression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.RowValueConstructorExpression;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.iterate.FilterResultIterator;
import org.apache.phoenix.iterate.LookAheadResultIterator;
import org.apache.phoenix.iterate.ParallelScanGrouper;
import org.apache.phoenix.iterate.PeekingResultIterator;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.job.JobManager;
import org.apache.phoenix.join.HashCacheClient;
import org.apache.phoenix.join.HashJoinInfo;
import org.apache.phoenix.monitoring.TaskExecutionMetricsHolder;
import org.apache.phoenix.optimize.Cost;
import org.apache.phoenix.parse.FilterableStatement;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.SQLParser;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PArrayDataType;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.schema.types.PhoenixArray;
import org.apache.phoenix.thirdparty.com.google.common.base.Optional;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.thirdparty.com.google.common.collect.Sets;
import org.apache.phoenix.util.ClientUtil;
import org.apache.phoenix.util.CostUtil;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.LogUtil;
import org.apache.phoenix.util.NumberUtil;
import org.apache.phoenix.util.SQLCloseables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashJoinPlan
extends DelegateQueryPlan {
    private static final Logger LOGGER = LoggerFactory.getLogger(HashJoinPlan.class);
    private static final Random RANDOM = new Random();
    private final SelectStatement statement;
    private final HashJoinInfo joinInfo;
    private final SubPlan[] subPlans;
    private final boolean recompileWhereClause;
    private final Set<TableRef> tableRefs;
    private final int maxServerCacheTimeToLive;
    private final long serverCacheLimit;
    private final Map<ImmutableBytesPtr, ServerCacheClient.ServerCache> dependencies = Maps.newHashMap();
    private HashCacheClient hashClient;
    private AtomicLong firstJobEndTime;
    private List<Expression> keyRangeExpressions;
    private Long estimatedRows;
    private Long estimatedBytes;
    private Long estimateInfoTs;
    private boolean getEstimatesCalled;
    private boolean hasSubPlansWithPersistentCache;

    public static HashJoinPlan create(SelectStatement statement, QueryPlan plan, HashJoinInfo joinInfo, SubPlan[] subPlans) throws SQLException {
        if (!(plan instanceof HashJoinPlan)) {
            return new HashJoinPlan(statement, plan, joinInfo, subPlans, joinInfo == null, Collections.emptyMap());
        }
        HashJoinPlan hashJoinPlan = (HashJoinPlan)plan;
        assert (hashJoinPlan.joinInfo == null && hashJoinPlan.delegate instanceof BaseQueryPlan);
        SubPlan[] mergedSubPlans = new SubPlan[hashJoinPlan.subPlans.length + subPlans.length];
        int i = 0;
        for (SubPlan subPlan : hashJoinPlan.subPlans) {
            mergedSubPlans[i++] = subPlan;
        }
        for (SubPlan subPlan : subPlans) {
            mergedSubPlans[i++] = subPlan;
        }
        return new HashJoinPlan(statement, hashJoinPlan.delegate, joinInfo, mergedSubPlans, true, hashJoinPlan.dependencies);
    }

    private HashJoinPlan(SelectStatement statement, QueryPlan plan, HashJoinInfo joinInfo, SubPlan[] subPlans, boolean recompileWhereClause, Map<ImmutableBytesPtr, ServerCacheClient.ServerCache> dependencies) throws SQLException {
        super(plan);
        this.dependencies.putAll(dependencies);
        this.statement = statement;
        this.joinInfo = joinInfo;
        this.subPlans = subPlans;
        this.recompileWhereClause = recompileWhereClause;
        this.tableRefs = Sets.newHashSetWithExpectedSize((int)(subPlans.length + plan.getSourceRefs().size()));
        this.tableRefs.addAll(plan.getSourceRefs());
        this.hasSubPlansWithPersistentCache = false;
        for (SubPlan subPlan : subPlans) {
            this.tableRefs.addAll(subPlan.getInnerPlan().getSourceRefs());
            if (!(subPlan instanceof HashSubPlan) || !((HashSubPlan)subPlan).usePersistentCache) continue;
            this.hasSubPlansWithPersistentCache = true;
        }
        ConnectionQueryServices services = plan.getContext().getConnection().getQueryServices();
        this.maxServerCacheTimeToLive = services.getProps().getInt("phoenix.coprocessor.maxServerCacheTimeToLiveMs", 30000);
        this.serverCacheLimit = services.getProps().getLongBytes("phoenix.query.maxServerCacheBytes", 0x6400000L);
        for (SubPlan subPlan : subPlans) {
            this.getContext().addSubStatementContext(subPlan.getInnerPlan().getContext());
        }
    }

    @Override
    public Set<TableRef> getSourceRefs() {
        return this.tableRefs;
    }

    @Override
    public ResultIterator iterator(ParallelScanGrouper scanGrouper, Scan scan) throws SQLException {
        ResultIterator iterator;
        boolean hasKeyRangeExpressions;
        if (scan == null) {
            scan = this.delegate.getContext().getScan();
        }
        int count = this.subPlans.length;
        PhoenixConnection connection = this.getContext().getConnection();
        ConnectionQueryServices services = connection.getQueryServices();
        ThreadPoolExecutor executor = services.getExecutor();
        ArrayList futures = Lists.newArrayListWithExpectedSize((int)count);
        if (this.joinInfo != null) {
            this.hashClient = this.hashClient != null ? this.hashClient : new HashCacheClient(this.delegate.getContext().getConnection());
            this.firstJobEndTime = new AtomicLong(0L);
            this.keyRangeExpressions = new CopyOnWriteArrayList<Expression>();
        }
        int i = 0;
        while (i < count) {
            final int index = i++;
            futures.add(executor.submit(new JobManager.JobCallable<ServerCacheClient.ServerCache>(){

                @Override
                public ServerCacheClient.ServerCache call() throws Exception {
                    ServerCacheClient.ServerCache cache = HashJoinPlan.this.subPlans[index].execute(HashJoinPlan.this);
                    return cache;
                }

                @Override
                public Object getJobId() {
                    return HashJoinPlan.this;
                }

                @Override
                public TaskExecutionMetricsHolder getTaskExecutionMetric() {
                    return TaskExecutionMetricsHolder.NO_OP_INSTANCE;
                }
            }));
        }
        SQLException firstException = null;
        for (int i2 = 0; i2 < count; ++i2) {
            try {
                ServerCacheClient.ServerCache result = (ServerCacheClient.ServerCache)((Future)futures.get(i2)).get();
                if (result != null) {
                    this.dependencies.put(new ImmutableBytesPtr(result.getId()), result);
                }
                this.subPlans[i2].postProcess(result, this);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                if (firstException != null) continue;
                firstException = new SQLExceptionInfo.Builder(SQLExceptionCode.INTERRUPTED_EXCEPTION).setRootCause(e).setMessage("Sub plan [" + i2 + "] execution interrupted.").build().buildException();
                continue;
            }
            catch (ExecutionException e) {
                if (firstException != null) continue;
                firstException = new SQLException("Encountered exception in sub plan [" + i2 + "] execution.", e.getCause());
            }
        }
        if (firstException != null) {
            SQLCloseables.closeAllQuietly(this.dependencies.values());
            this.dependencies.clear();
            throw firstException;
        }
        Expression postFilter = null;
        boolean bl = hasKeyRangeExpressions = this.keyRangeExpressions != null && !this.keyRangeExpressions.isEmpty();
        if (this.recompileWhereClause || hasKeyRangeExpressions) {
            StatementContext context = this.delegate.getContext();
            context.getScan().setFilter(null);
            PTable table = context.getCurrentTable().getTable();
            ParseNode viewWhere = table.getViewStatement() == null ? null : new SQLParser(table.getViewStatement()).parseQuery().getWhere();
            context.setResolver(FromCompiler.getResolverForQuery((SelectStatement)this.delegate.getStatement(), this.delegate.getContext().getConnection()));
            if (this.recompileWhereClause) {
                postFilter = WhereCompiler.compile(this.delegate.getContext(), this.delegate.getStatement(), viewWhere, null, (Optional<byte[]>)Optional.absent());
            }
            if (hasKeyRangeExpressions) {
                WhereCompiler.compile(this.delegate.getContext(), this.delegate.getStatement(), viewWhere, this.keyRangeExpressions, null, (Optional<byte[]>)Optional.absent());
            }
        }
        if (this.joinInfo != null) {
            HashJoinInfo.serializeHashJoinIntoScan(scan, this.joinInfo);
        }
        ResultIterator resultIterator = iterator = this.joinInfo == null ? this.delegate.iterator(scanGrouper, scan) : ((BaseQueryPlan)this.delegate).iterator(this.dependencies, scanGrouper, scan);
        if (this.statement.getInnerSelectStatement() != null && postFilter != null) {
            iterator = new FilterResultIterator(iterator, postFilter);
        }
        if (this.hasSubPlansWithPersistentCache) {
            return this.peekForPersistentCache(iterator, scanGrouper, scan);
        }
        return iterator;
    }

    private ResultIterator peekForPersistentCache(ResultIterator iterator, ParallelScanGrouper scanGrouper, Scan scan) throws SQLException {
        PeekingResultIterator peeking = LookAheadResultIterator.wrap(iterator);
        try {
            peeking.peek();
        }
        catch (Exception e) {
            try {
                throw ClientUtil.parseServerException(e);
            }
            catch (HashJoinCacheNotFoundException e2) {
                Long cacheId = e2.getCacheId();
                if (this.delegate.getContext().getRetryingPersistentCache(cacheId)) {
                    throw e2;
                }
                this.delegate.getContext().setRetryingPersistentCache(cacheId);
                return this.iterator(scanGrouper, scan);
            }
        }
        return peeking;
    }

    private Expression createKeyRangeExpression(Expression lhsExpression, Expression rhsExpression, List<Expression> rhsValues, ImmutableBytesWritable ptr, boolean rowKeyOrderOptimizable) throws SQLException {
        if (rhsValues.isEmpty()) {
            return LiteralExpression.newConstant((Object)false, (PDataType)PBoolean.INSTANCE, Determinism.ALWAYS);
        }
        rhsValues.add(0, lhsExpression);
        return InListExpression.create(rhsValues, false, ptr, rowKeyOrderOptimizable);
    }

    @Override
    public ExplainPlan getExplainPlan() throws SQLException {
        int i;
        ArrayList planSteps = Lists.newArrayList(this.delegate.getExplainPlan().getPlanSteps());
        int count = this.subPlans.length;
        for (i = 0; i < count; ++i) {
            planSteps.addAll(this.subPlans[i].getPreSteps(this));
        }
        for (i = 0; i < count; ++i) {
            planSteps.addAll(this.subPlans[i].getPostSteps(this));
        }
        if (this.joinInfo != null && this.joinInfo.getPostJoinFilterExpression() != null) {
            planSteps.add("    AFTER-JOIN SERVER FILTER BY " + this.joinInfo.getPostJoinFilterExpression().toString());
        }
        if (this.joinInfo != null && this.joinInfo.getLimit() != null) {
            planSteps.add("    JOIN-SCANNER " + this.joinInfo.getLimit() + " ROW LIMIT");
        }
        return new ExplainPlan(planSteps);
    }

    @Override
    public FilterableStatement getStatement() {
        return this.statement;
    }

    public HashJoinInfo getJoinInfo() {
        return this.joinInfo;
    }

    public SubPlan[] getSubPlans() {
        return this.subPlans;
    }

    @Override
    public <T> T accept(QueryPlanVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public Cost getCost() {
        try {
            Long r = this.delegate.getEstimatedRowsToScan();
            Double w = this.delegate.accept(new AvgRowWidthVisitor());
            if (r == null || w == null) {
                return Cost.UNKNOWN;
            }
            int parallelLevel = CostUtil.estimateParallelLevel(true, this.getContext().getConnection().getQueryServices());
            double rowWidth = w;
            double rows = RowCountVisitor.filter(r.doubleValue(), RowCountVisitor.stripSkipScanFilter(this.delegate.getContext().getScan().getFilter()));
            double bytes = rowWidth * rows;
            Cost cost = Cost.ZERO;
            double rhsByteSum = 0.0;
            for (int i = 0; i < this.subPlans.length; ++i) {
                double lhsBytes = bytes;
                Double rhsRows = this.subPlans[i].getInnerPlan().accept(new RowCountVisitor());
                Double rhsWidth = this.subPlans[i].getInnerPlan().accept(new AvgRowWidthVisitor());
                if (rhsRows == null || rhsWidth == null) {
                    return Cost.UNKNOWN;
                }
                double rhsBytes = rhsWidth * rhsRows;
                rows = RowCountVisitor.join(rows, rhsRows, this.joinInfo.getJoinTypes()[i]);
                rowWidth = AvgRowWidthVisitor.join(rowWidth, rhsWidth, this.joinInfo.getJoinTypes()[i]);
                bytes = rowWidth * rows;
                cost = cost.plus(CostUtil.estimateHashJoinCost(lhsBytes, rhsBytes, bytes, this.subPlans[i].hasKeyRangeExpression(), parallelLevel));
                rhsByteSum += rhsBytes;
            }
            if (rhsByteSum > (double)this.serverCacheLimit) {
                return Cost.UNKNOWN;
            }
            if (this.delegate instanceof AggregatePlan) {
                AggregatePlan aggPlan = (AggregatePlan)this.delegate;
                double rowsBeforeHaving = RowCountVisitor.aggregate(rows, aggPlan.getGroupBy());
                double rowsAfterHaving = RowCountVisitor.filter(rowsBeforeHaving, aggPlan.getHaving());
                double bytesBeforeHaving = rowWidth * rowsBeforeHaving;
                double bytesAfterHaving = rowWidth * rowsAfterHaving;
                Cost aggCost = CostUtil.estimateAggregateCost(bytes, bytesBeforeHaving, aggPlan.getGroupBy(), parallelLevel);
                cost = cost.plus(aggCost);
                rows = rowsAfterHaving;
                bytes = bytesAfterHaving;
            }
            double outputRows = RowCountVisitor.limit(rows, this.delegate.getLimit());
            double outputBytes = rowWidth * outputRows;
            if (!this.delegate.getOrderBy().getOrderByExpressions().isEmpty()) {
                Cost orderByCost = CostUtil.estimateOrderByCost(bytes, outputBytes, parallelLevel);
                cost = cost.plus(orderByCost);
            }
            Cost lhsCost = new Cost(0.0, 0.0, r.doubleValue() * w);
            Cost rhsCost = Cost.ZERO;
            for (SubPlan subPlan : this.subPlans) {
                rhsCost = rhsCost.plus(subPlan.getInnerPlan().getCost());
            }
            return cost.plus(lhsCost).plus(rhsCost);
        }
        catch (SQLException sQLException) {
            return Cost.UNKNOWN;
        }
    }

    @Override
    public Long getEstimatedRowsToScan() throws SQLException {
        if (!this.getEstimatesCalled) {
            this.getEstimates();
        }
        return this.estimatedRows;
    }

    @Override
    public Long getEstimatedBytesToScan() throws SQLException {
        if (!this.getEstimatesCalled) {
            this.getEstimates();
        }
        return this.estimatedBytes;
    }

    @Override
    public Long getEstimateInfoTimestamp() throws SQLException {
        if (!this.getEstimatesCalled) {
            this.getEstimates();
        }
        return this.estimateInfoTs;
    }

    private void getEstimates() throws SQLException {
        this.getEstimatesCalled = true;
        for (SubPlan subPlan : this.subPlans) {
            if (subPlan.getInnerPlan().getEstimatedBytesToScan() == null || subPlan.getInnerPlan().getEstimatedRowsToScan() == null || subPlan.getInnerPlan().getEstimateInfoTimestamp() == null) {
                this.estimatedBytes = null;
                this.estimatedRows = null;
                this.estimateInfoTs = null;
                break;
            }
            this.estimatedBytes = NumberUtil.add(this.estimatedBytes, subPlan.getInnerPlan().getEstimatedBytesToScan());
            this.estimatedRows = NumberUtil.add(this.estimatedRows, subPlan.getInnerPlan().getEstimatedRowsToScan());
            this.estimateInfoTs = NumberUtil.getMin(this.estimateInfoTs, subPlan.getInnerPlan().getEstimateInfoTimestamp());
        }
    }

    public static interface SubPlan {
        public ServerCacheClient.ServerCache execute(HashJoinPlan var1) throws SQLException;

        public void postProcess(ServerCacheClient.ServerCache var1, HashJoinPlan var2) throws SQLException;

        public List<String> getPreSteps(HashJoinPlan var1) throws SQLException;

        public List<String> getPostSteps(HashJoinPlan var1) throws SQLException;

        public QueryPlan getInnerPlan();

        public boolean hasKeyRangeExpression();
    }

    public static class HashSubPlan
    implements SubPlan {
        private final int index;
        private final QueryPlan plan;
        private final List<Expression> hashExpressions;
        private final boolean singleValueOnly;
        private final boolean usePersistentCache;
        private final Expression keyRangeLhsExpression;
        private final Expression keyRangeRhsExpression;
        private final MessageDigest digest;

        public HashSubPlan(int index, QueryPlan subPlan, List<Expression> hashExpressions, boolean singleValueOnly, boolean usePersistentCache, Expression keyRangeLhsExpression, Expression keyRangeRhsExpression) {
            this.index = index;
            this.plan = subPlan;
            this.hashExpressions = hashExpressions;
            this.singleValueOnly = singleValueOnly;
            this.usePersistentCache = usePersistentCache;
            this.keyRangeLhsExpression = keyRangeLhsExpression;
            this.keyRangeRhsExpression = keyRangeRhsExpression;
            try {
                this.digest = MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public ServerCacheClient.ServerCache execute(HashJoinPlan parent) throws SQLException {
            ranges = parent.delegate.getContext().getScanRanges();
            keyRangeRhsValues = null;
            if (this.keyRangeRhsExpression != null) {
                keyRangeRhsValues = Lists.newArrayList();
            }
            cache = null;
            if (this.hashExpressions != null) {
                iterator = this.plan.iterator();
                try {
                    queryString = this.plan.getStatement().toString().replaceAll("\\$[0-9]+", "\\$");
                    if (this.usePersistentCache) {
                        cacheId = Arrays.copyOfRange(this.digest.digest(queryString.getBytes(StandardCharsets.UTF_8)), 0, 8);
                        retrying = parent.delegate.getContext().getRetryingPersistentCache(Bytes.toLong((byte[])cacheId));
                        if (!retrying) {
                            try {
                                cache = parent.hashClient.createServerCache(cacheId, parent.delegate);
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    } else {
                        cacheId = Bytes.toBytes((long)HashJoinPlan.RANDOM.nextLong());
                    }
                    HashJoinPlan.LOGGER.debug("Using cache ID " + Hex.encodeHexString((byte[])cacheId) + " for " + queryString);
                    if (cache != null) ** GOTO lbl47
                    HashJoinPlan.LOGGER.debug("Making RPC to add cache " + Hex.encodeHexString((byte[])cacheId));
                    cache = parent.hashClient.addHashCache(ranges, cacheId, iterator, this.plan.getEstimatedSize(), this.hashExpressions, this.singleValueOnly, this.usePersistentCache, parent.delegate.getTableRef().getTable(), this.keyRangeRhsExpression, keyRangeRhsValues);
                    endTime = EnvironmentEdgeManager.currentTimeMillis();
                    isSet = parent.firstJobEndTime.compareAndSet(0L, endTime);
                    if (isSet || endTime - parent.firstJobEndTime.get() <= (long)parent.maxServerCacheTimeToLive) ** GOTO lbl47
                    HashJoinPlan.LOGGER.warn(LogUtil.addCustomAnnotations("Hash plan [" + this.index + "] execution seems too slow. Earlier hash cache(s) might have expired on servers.", parent.delegate.getContext().getConnection()));
                }
                finally {
                    iterator.close();
                }
            } else {
                if (!HashSubPlan.$assertionsDisabled && this.keyRangeRhsExpression == null) {
                    throw new AssertionError();
                }
                iterator = this.plan.iterator();
                try {
                    result = iterator.next();
                    while (result != null) {
                        keyRangeRhsValues.add(HashCacheClient.evaluateKeyExpression(this.keyRangeRhsExpression, result, this.plan.getContext().getTempPtr()));
                        result = iterator.next();
                    }
                }
                finally {
                    iterator.close();
                }
            }
            if (keyRangeRhsValues != null) {
                parent.keyRangeExpressions.add(parent.createKeyRangeExpression(this.keyRangeLhsExpression, this.keyRangeRhsExpression, keyRangeRhsValues, this.plan.getContext().getTempPtr(), this.plan.getContext().getCurrentTable().getTable().rowKeyOrderOptimizable()));
            }
            return cache;
        }

        @Override
        public void postProcess(ServerCacheClient.ServerCache result, HashJoinPlan parent) throws SQLException {
            ServerCacheClient.ServerCache cache = result;
            if (cache != null) {
                parent.joinInfo.getJoinIds()[this.index].set(cache.getId());
            }
        }

        @Override
        public List<String> getPreSteps(HashJoinPlan parent) throws SQLException {
            boolean skipMerge;
            ArrayList steps = Lists.newArrayList();
            boolean earlyEvaluation = parent.joinInfo.earlyEvaluation()[this.index];
            boolean bl = skipMerge = parent.joinInfo.getSchemas()[this.index].getFieldCount() == 0;
            if (this.hashExpressions != null) {
                steps.add("    PARALLEL " + parent.joinInfo.getJoinTypes()[this.index].toString().toUpperCase() + "-JOIN TABLE " + this.index + (earlyEvaluation ? "" : "(DELAYED EVALUATION)") + (skipMerge ? " (SKIP MERGE)" : ""));
            } else {
                steps.add("    SKIP-SCAN-JOIN TABLE " + this.index);
            }
            for (String step : this.plan.getExplainPlan().getPlanSteps()) {
                steps.add("        " + step);
            }
            return steps;
        }

        @Override
        public List<String> getPostSteps(HashJoinPlan parent) throws SQLException {
            if (this.keyRangeLhsExpression == null) {
                return Collections.emptyList();
            }
            String step = "    DYNAMIC SERVER FILTER BY " + this.keyRangeLhsExpression.toString() + " IN (" + this.keyRangeRhsExpression.toString() + ")";
            return Collections.singletonList(step);
        }

        @Override
        public QueryPlan getInnerPlan() {
            return this.plan;
        }

        @Override
        public boolean hasKeyRangeExpression() {
            return this.keyRangeLhsExpression != null;
        }
    }

    public static class WhereClauseSubPlan
    implements SubPlan {
        private final QueryPlan plan;
        private final SelectStatement select;
        private final boolean expectSingleRow;

        public WhereClauseSubPlan(QueryPlan plan, SelectStatement select, boolean expectSingleRow) {
            this.plan = plan;
            this.select = select;
            this.expectSingleRow = expectSingleRow;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ServerCacheClient.ServerCache execute(HashJoinPlan parent) throws SQLException {
            ArrayList values = Lists.newArrayList();
            try (ResultIterator iterator = this.plan.iterator();){
                PhoenixArray result;
                RowProjector projector = this.plan.getProjector();
                ImmutableBytesWritable ptr = new ImmutableBytesWritable();
                int columnCount = projector.getColumnCount();
                int rowCount = 0;
                PDataType baseType = PVarbinary.INSTANCE;
                Tuple tuple = iterator.next();
                while (tuple != null) {
                    if (this.expectSingleRow && rowCount >= 1) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.SINGLE_ROW_SUBQUERY_RETURNS_MULTIPLE_ROWS).build().buildException();
                    }
                    if (columnCount == 1) {
                        ColumnProjector columnProjector = projector.getColumnProjector(0);
                        baseType = columnProjector.getExpression().getDataType();
                        Object value = columnProjector.getValue(tuple, baseType, ptr);
                        values.add(value);
                    } else {
                        ArrayList expressions = Lists.newArrayListWithExpectedSize((int)columnCount);
                        for (int i = 0; i < columnCount; ++i) {
                            ColumnProjector columnProjector = projector.getColumnProjector(i);
                            PDataType type = columnProjector.getExpression().getDataType();
                            Object value = columnProjector.getValue(tuple, type, ptr);
                            expressions.add(LiteralExpression.newConstant(value, type));
                        }
                        RowValueConstructorExpression expression = new RowValueConstructorExpression(expressions, true);
                        baseType = expression.getDataType();
                        expression.evaluate(null, ptr);
                        values.add(baseType.toObject(ptr));
                    }
                    ++rowCount;
                    tuple = iterator.next();
                }
                PhoenixArray phoenixArray = this.expectSingleRow ? (values.isEmpty() ? null : values.get(0)) : (result = PArrayDataType.instantiatePhoenixArray(baseType, values.toArray()));
                if (result != null) {
                    parent.getContext().setSubqueryResult(this.select, result);
                }
                ServerCacheClient.ServerCache serverCache = null;
                return serverCache;
            }
        }

        @Override
        public void postProcess(ServerCacheClient.ServerCache result, HashJoinPlan parent) throws SQLException {
        }

        @Override
        public List<String> getPreSteps(HashJoinPlan parent) throws SQLException {
            ArrayList steps = Lists.newArrayList();
            steps.add("    EXECUTE " + (this.expectSingleRow ? "SINGLE" : "MULTIPLE") + "-ROW SUBQUERY");
            for (String step : this.plan.getExplainPlan().getPlanSteps()) {
                steps.add("        " + step);
            }
            return steps;
        }

        @Override
        public List<String> getPostSteps(HashJoinPlan parent) throws SQLException {
            return Collections.emptyList();
        }

        @Override
        public QueryPlan getInnerPlan() {
            return this.plan;
        }

        @Override
        public boolean hasKeyRangeExpression() {
            return false;
        }
    }
}

